/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.PackageVerificationResult;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.zzac;
import com.google.android.gms.common.zzad;
import com.google.android.gms.common.zzae;
import com.google.android.gms.common.zzn;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.RestrictedInheritance;

@CheckReturnValue
@RestrictedInheritance(allowedOnPath=".*javatests.*/com/google/android/gms/common/.*", explanation="Sub classing of GMS Core's APIs are restricted to testing fakes.", link="go/gmscore-restrictedinheritance")
public class PackageSignatureVerifier {
    private static zzad zza;
    private volatile zzac zzb;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static zzad zza() {
        synchronized (zzad.class) {
            zzad zzad2;
            if (zza != null) return zza;
            zza = zzad2 = new zzad();
            return zza;
        }
    }

    public PackageVerificationResult queryPackageSignatureVerified(Context object, String string2) {
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(object);
        PackageSignatureVerifier.zza();
        if (zzn.zzf()) {
            object = true != bl ? "-0" : "-1";
            String string3 = String.valueOf(string2).concat((String)object);
            if (this.zzb != null && zzac.zzb(this.zzb).equals(string3)) {
                object = zzac.zza(this.zzb);
            } else {
                PackageSignatureVerifier.zza();
                object = zzn.zzc(string2, bl, false, false);
                if (object.zza) {
                    this.zzb = new zzac(string3, PackageVerificationResult.zzd(string2, object.zzd));
                    object = zzac.zza(this.zzb);
                } else {
                    Preconditions.checkNotNull(object.zzb);
                    object = PackageVerificationResult.zza(string2, object.zzb, object.zzc);
                }
            }
            return object;
        }
        throw new zzae();
    }

    public PackageVerificationResult queryPackageSignatureVerifiedWithRetry(Context object, String string2) {
        block2: {
            try {
                PackageVerificationResult packageVerificationResult = this.queryPackageSignatureVerified((Context)object, string2);
                packageVerificationResult.zzb();
                object = packageVerificationResult;
            }
            catch (SecurityException securityException) {
                object = this.queryPackageSignatureVerified((Context)object, string2);
                if (!object.zzc()) break block2;
                Log.e((String)"PkgSignatureVerifier", (String)"Got flaky result during package signature verification", (Throwable)securityException);
                return object;
            }
        }
        return object;
    }
}

