/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ConnectionTelemetryConfiguration;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.RootTelemetryConfigManager;
import com.google.android.gms.common.internal.RootTelemetryConfiguration;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzu;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseGmsClient<T extends IInterface> {
    public static final int CONNECT_STATE_CONNECTED = 4;
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES;
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    private static final Feature[] zze;
    private volatile String zzA;
    private ConnectionResult zzB;
    private boolean zzC;
    private volatile zzj zzD;
    zzu zza;
    final Handler zzb;
    protected ConnectionProgressReportCallbacks zzc;
    protected AtomicInteger zzd;
    private int zzf;
    private long zzg;
    private long zzh;
    private int zzi;
    private long zzj;
    private volatile String zzk;
    private final Context zzl;
    private final Looper zzm;
    private final GmsClientSupervisor zzn;
    private final GoogleApiAvailabilityLight zzo;
    private final Object zzp;
    private final Object zzq;
    private IGmsServiceBroker zzr;
    private IInterface zzs;
    private final ArrayList zzt;
    private zze zzu;
    private int zzv;
    private final BaseConnectionCallbacks zzw;
    private final BaseOnConnectionFailedListener zzx;
    private final int zzy;
    private final String zzz;

    static {
        zze = new Feature[0];
        GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{"service_esmobile", "service_googleme"};
    }

    protected BaseGmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener) {
        this.zzk = null;
        this.zzp = new Object();
        this.zzq = new Object();
        this.zzt = new ArrayList();
        this.zzv = 1;
        this.zzB = null;
        this.zzC = false;
        this.zzD = null;
        this.zzd = new AtomicInteger(0);
        Preconditions.checkNotNull(context, "Context must not be null");
        this.zzl = context;
        Preconditions.checkNotNull(handler, "Handler must not be null");
        this.zzb = handler;
        this.zzm = handler.getLooper();
        Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzn = gmsClientSupervisor;
        Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzo = googleApiAvailabilityLight;
        this.zzy = n;
        this.zzw = baseConnectionCallbacks;
        this.zzx = baseOnConnectionFailedListener;
        this.zzz = null;
    }

    protected BaseGmsClient(Context context, Looper looper, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        GmsClientSupervisor gmsClientSupervisor = GmsClientSupervisor.getInstance(context);
        GoogleApiAvailabilityLight googleApiAvailabilityLight = GoogleApiAvailabilityLight.getInstance();
        Preconditions.checkNotNull(baseConnectionCallbacks);
        Preconditions.checkNotNull(baseOnConnectionFailedListener);
        this(context, looper, gmsClientSupervisor, googleApiAvailabilityLight, n, baseConnectionCallbacks, baseOnConnectionFailedListener, string2);
    }

    protected BaseGmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this.zzk = null;
        this.zzp = new Object();
        this.zzq = new Object();
        this.zzt = new ArrayList();
        this.zzv = 1;
        this.zzB = null;
        this.zzC = false;
        this.zzD = null;
        this.zzd = new AtomicInteger(0);
        Preconditions.checkNotNull(context, "Context must not be null");
        this.zzl = context;
        Preconditions.checkNotNull(looper, "Looper must not be null");
        this.zzm = looper;
        Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzn = gmsClientSupervisor;
        Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzo = googleApiAvailabilityLight;
        this.zzb = new zzb(this, looper);
        this.zzy = n;
        this.zzw = baseConnectionCallbacks;
        this.zzx = baseOnConnectionFailedListener;
        this.zzz = string2;
    }

    static /* bridge */ /* synthetic */ ConnectionResult zza(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzB;
    }

    static /* bridge */ /* synthetic */ BaseConnectionCallbacks zzb(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzw;
    }

    static /* bridge */ /* synthetic */ Object zzd(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzq;
    }

    static /* bridge */ /* synthetic */ ArrayList zzf(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzt;
    }

    static /* bridge */ /* synthetic */ void zzg(BaseGmsClient baseGmsClient, ConnectionResult connectionResult) {
        baseGmsClient.zzB = connectionResult;
    }

    static /* bridge */ /* synthetic */ void zzh(BaseGmsClient baseGmsClient, IGmsServiceBroker iGmsServiceBroker) {
        baseGmsClient.zzr = iGmsServiceBroker;
    }

    static /* bridge */ /* synthetic */ void zzi(BaseGmsClient baseGmsClient, int n, IInterface iInterface) {
        baseGmsClient.zzp(n, null);
    }

    static /* bridge */ /* synthetic */ void zzj(BaseGmsClient object, zzj object2) {
        ((BaseGmsClient)object).zzD = object2;
        if (((BaseGmsClient)object).usesClientTelemetry()) {
            object = ((zzj)object2).zzd;
            object2 = RootTelemetryConfigManager.getInstance();
            object = object == null ? null : ((ConnectionTelemetryConfiguration)object).zza();
            ((RootTelemetryConfigManager)object2).zza((RootTelemetryConfiguration)object);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ void zzk(BaseGmsClient baseGmsClient, int n) {
        Object object = baseGmsClient.zzp;
        // MONITORENTER : object
        n = baseGmsClient.zzv;
        // MONITOREXIT : object
        if (n == 3) {
            baseGmsClient.zzC = true;
            n = 5;
        } else {
            n = 4;
        }
        object = baseGmsClient.zzb;
        object.sendMessage(object.obtainMessage(n, baseGmsClient.zzd.get(), 16));
    }

    static /* bridge */ /* synthetic */ boolean zzm(BaseGmsClient baseGmsClient) {
        return baseGmsClient.zzC;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ boolean zzn(BaseGmsClient baseGmsClient, int n, int n2, IInterface iInterface) {
        Object object = baseGmsClient.zzp;
        synchronized (object) {
            if (baseGmsClient.zzv != n) {
                return false;
            }
            baseGmsClient.zzp(n2, iInterface);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* bridge */ /* synthetic */ boolean zzo(BaseGmsClient baseGmsClient) {
        boolean bl = baseGmsClient.zzC;
        boolean bl2 = false;
        if (bl) {
            return bl2;
        }
        if (TextUtils.isEmpty((CharSequence)baseGmsClient.getServiceDescriptor())) {
            return bl2;
        }
        if (TextUtils.isEmpty((CharSequence)baseGmsClient.getLocalStartServiceAction())) {
            return bl2;
        }
        try {
            Class.forName(baseGmsClient.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzp(int n, IInterface object) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = n == 4;
        if (bl3 == (bl = object != null)) {
            bl2 = true;
        }
        Preconditions.checkArgument(bl2);
        Object object2 = this.zzp;
        synchronized (object2) {
            block11: {
                block10: {
                    this.zzv = n;
                    this.zzs = object;
                    if (n == 1) break block10;
                    if (n != 2 && n != 3) {
                        if (n == 4) {
                            Preconditions.checkNotNull(object);
                            this.onConnectedLocked(object);
                        }
                        break block11;
                    } else {
                        Object object3;
                        Object object4;
                        Object object5;
                        object = this.zzu;
                        if (object != null && (object5 = this.zza) != null) {
                            object4 = ((zzu)object5).zzc();
                            object5 = ((zzu)object5).zzb();
                            object3 = new StringBuilder();
                            ((StringBuilder)object3).append("Calling connect() while still connected, missing disconnect() for ");
                            ((StringBuilder)object3).append((String)object4);
                            ((StringBuilder)object3).append(" on ");
                            ((StringBuilder)object3).append((String)object5);
                            Log.e((String)"GmsClient", (String)((StringBuilder)object3).toString());
                            object5 = this.zzn;
                            object4 = this.zza.zzc();
                            Preconditions.checkNotNull(object4);
                            ((GmsClientSupervisor)object5).zzb((String)object4, this.zza.zzb(), this.zza.zza(), (ServiceConnection)object, this.zze(), this.zza.zzd());
                            this.zzd.incrementAndGet();
                        }
                        this.zzu = object4 = new zze(this, this.zzd.get());
                        object = this.zzv == 3 && this.getLocalStartServiceAction() != null ? new zzu(this.getContext().getPackageName(), this.getLocalStartServiceAction(), true, GmsClientSupervisor.getDefaultBindFlags(), false) : new zzu(this.getStartServicePackage(), this.getStartServiceAction(), false, GmsClientSupervisor.getDefaultBindFlags(), this.getUseDynamicLookup());
                        this.zza = object;
                        if (((zzu)object).zzd() && this.getMinApkVersion() < 17895000) {
                            object = new IllegalStateException("Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: ".concat(String.valueOf(this.zza.zzc())));
                            throw object;
                        }
                        object5 = this.zzn;
                        String string2 = this.zza.zzc();
                        Preconditions.checkNotNull(string2);
                        String string3 = this.zza.zzb();
                        n = this.zza.zza();
                        String string4 = this.zze();
                        bl2 = this.zza.zzd();
                        object = this.getBindServiceExecutor();
                        object3 = new zzn(string2, string3, n, bl2);
                        if (!((GmsClientSupervisor)object5).zzc((zzn)object3, (ServiceConnection)object4, string4, (Executor)object)) {
                            object5 = this.zza.zzc();
                            object4 = this.zza.zzb();
                            object = new StringBuilder();
                            ((StringBuilder)object).append("unable to connect to service: ");
                            ((StringBuilder)object).append((String)object5);
                            ((StringBuilder)object).append(" on ");
                            ((StringBuilder)object).append((String)object4);
                            Log.w((String)"GmsClient", (String)((StringBuilder)object).toString());
                            this.zzl(16, null, this.zzd.get());
                        }
                    }
                    break block11;
                }
                object = this.zzu;
                if (object != null) {
                    GmsClientSupervisor gmsClientSupervisor = this.zzn;
                    String string5 = this.zza.zzc();
                    Preconditions.checkNotNull(string5);
                    gmsClientSupervisor.zzb(string5, this.zza.zzb(), this.zza.zza(), (ServiceConnection)object, this.zze(), this.zza.zzd());
                    this.zzu = null;
                }
            }
            return;
        }
    }

    public void checkAvailabilityAndConnect() {
        int n = this.zzo.isGooglePlayServicesAvailable(this.zzl, this.getMinApkVersion());
        if (n != 0) {
            this.zzp(1, null);
            this.triggerNotAvailable(new LegacyClientCallbackAdapter(), n, null);
            return;
        }
        this.connect(new LegacyClientCallbackAdapter());
    }

    protected final void checkConnected() {
        if (this.isConnected()) {
            return;
        }
        throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
    }

    public void connect(ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zzc = connectionProgressReportCallbacks;
        this.zzp(2, null);
    }

    protected abstract T createServiceInterface(IBinder var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        this.zzd.incrementAndGet();
        ArrayList arrayList = this.zzt;
        synchronized (arrayList) {
            int n = this.zzt.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.zzt.clear();
                    // MONITOREXIT @DISABLED, blocks:[5, 7, 8] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                    Object object = this.zzq;
                    synchronized (object) {
                        this.zzr = null;
                    }
                    this.zzp(1, null);
                    return;
                }
                ((zzc)this.zzt.get(n2)).zzf();
                ++n2;
            }
        }
    }

    public void disconnect(String string2) {
        this.zzk = string2;
        this.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(String object, FileDescriptor object2, PrintWriter appendable, String[] object3) {
        long l;
        block25: {
            CharSequence charSequence;
            Object object4;
            block21: {
                block26: {
                    int n;
                    block20: {
                        block22: {
                            block23: {
                                block24: {
                                    object3 = this.zzp;
                                    synchronized (object3) {
                                        n = this.zzv;
                                        object2 = this.zzs;
                                    }
                                    object3 = this.zzq;
                                    synchronized (object3) {
                                        object4 = this.zzr;
                                    }
                                    ((PrintWriter)appendable).append((CharSequence)object).append("mConnectState=");
                                    if (n == 1) break block22;
                                    if (n == 2) break block23;
                                    if (n == 3) break block24;
                                    if (n != 4) {
                                        if (n != 5) {
                                            ((PrintWriter)appendable).print("UNKNOWN");
                                            break block20;
                                        } else {
                                            ((PrintWriter)appendable).print("DISCONNECTING");
                                        }
                                        break block20;
                                    } else {
                                        ((PrintWriter)appendable).print("CONNECTED");
                                    }
                                    break block20;
                                }
                                ((PrintWriter)appendable).print("LOCAL_CONNECTING");
                                break block20;
                            }
                            ((PrintWriter)appendable).print("REMOTE_CONNECTING");
                            break block20;
                        }
                        ((PrintWriter)appendable).print("DISCONNECTED");
                    }
                    ((PrintWriter)appendable).append(" mService=");
                    if (object2 == null) {
                        ((PrintWriter)appendable).append("null");
                    } else {
                        ((PrintWriter)appendable).append(this.getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(object2.asBinder())));
                    }
                    ((PrintWriter)appendable).append(" mServiceBroker=");
                    if (object4 == null) {
                        ((PrintWriter)appendable).println("null");
                    } else {
                        ((PrintWriter)appendable).append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(object4.asBinder())));
                    }
                    object2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
                    if (this.zzh > 0L) {
                        object4 = ((PrintWriter)appendable).append((CharSequence)object).append("lastConnectedTime=");
                        l = this.zzh;
                        object3 = ((DateFormat)object2).format(new Date(l));
                        charSequence = new StringBuilder();
                        charSequence.append(l);
                        charSequence.append(" ");
                        charSequence.append((String)object3);
                        ((PrintWriter)object4).println(charSequence.toString());
                    }
                    if (this.zzg <= 0L) break block25;
                    ((PrintWriter)appendable).append((CharSequence)object).append("lastSuspendedCause=");
                    n = this.zzf;
                    if (n == 1) break block26;
                    if (n != 2) {
                        if (n != 3) {
                            ((PrintWriter)appendable).append(String.valueOf(n));
                            break block21;
                        } else {
                            ((PrintWriter)appendable).append("CAUSE_DEAD_OBJECT_EXCEPTION");
                        }
                        break block21;
                    } else {
                        ((PrintWriter)appendable).append("CAUSE_NETWORK_LOST");
                    }
                    break block21;
                }
                ((PrintWriter)appendable).append("CAUSE_SERVICE_DISCONNECTED");
            }
            object4 = ((PrintWriter)appendable).append(" lastSuspendedTime=");
            l = this.zzg;
            charSequence = ((DateFormat)object2).format(new Date(l));
            object3 = new StringBuilder();
            ((StringBuilder)object3).append(l);
            ((StringBuilder)object3).append(" ");
            ((StringBuilder)object3).append((String)charSequence);
            ((PrintWriter)object4).println(((StringBuilder)object3).toString());
        }
        if (this.zzj > 0L) {
            ((PrintWriter)appendable).append((CharSequence)object).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzi));
            object = ((PrintWriter)appendable).append(" lastFailedTime=");
            l = this.zzj;
            object2 = ((DateFormat)object2).format(new Date(l));
            appendable = new StringBuilder();
            ((StringBuilder)appendable).append(l);
            ((StringBuilder)appendable).append(" ");
            ((StringBuilder)appendable).append((String)object2);
            ((PrintWriter)object).println(((StringBuilder)appendable).toString());
        }
    }

    protected boolean enableLocalFallback() {
        return false;
    }

    public Account getAccount() {
        return null;
    }

    public Feature[] getApiFeatures() {
        return zze;
    }

    public final Feature[] getAvailableFeatures() {
        zzj zzj2 = this.zzD;
        if (zzj2 == null) {
            return null;
        }
        return zzj2.zzb;
    }

    protected Executor getBindServiceExecutor() {
        return null;
    }

    public Bundle getConnectionHint() {
        return null;
    }

    public final Context getContext() {
        return this.zzl;
    }

    public String getEndpointPackageName() {
        zzu zzu2;
        if (this.isConnected() && (zzu2 = this.zza) != null) {
            return zzu2.zzb();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    public int getGCoreServiceId() {
        return this.zzy;
    }

    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    public String getLastDisconnectMessage() {
        return this.zzk;
    }

    protected String getLocalStartServiceAction() {
        return null;
    }

    public final Looper getLooper() {
        return this.zzm;
    }

    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getRemoteService(IAccountAccessor object, Set<Scope> object2) {
        void var1_4;
        block16: {
            Object object3 = this.getGetServiceRequestExtraArgs();
            int n = this.zzy;
            Object object4 = this.zzA;
            int n2 = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
            Scope[] scopeArray = GetServiceRequest.zza;
            Bundle bundle = new Bundle();
            Feature[] featureArray = GetServiceRequest.zzb;
            object4 = new GetServiceRequest(6, n, n2, null, null, scopeArray, bundle, null, featureArray, featureArray, true, 0, false, (String)object4);
            ((GetServiceRequest)object4).zzf = this.zzl.getPackageName();
            ((GetServiceRequest)object4).zzi = object3;
            if (object2 != null) {
                ((GetServiceRequest)object4).zzh = object2.toArray(new Scope[0]);
            }
            if (this.requiresSignIn()) {
                object3 = this.getAccount();
                object2 = object3;
                if (object3 == null) {
                    object2 = new Account(DEFAULT_ACCOUNT, "com.google");
                }
                ((GetServiceRequest)object4).zzj = object2;
                if (object != null) {
                    ((GetServiceRequest)object4).zzg = object.asBinder();
                }
            } else if (this.requiresAccount()) {
                ((GetServiceRequest)object4).zzj = this.getAccount();
            }
            ((GetServiceRequest)object4).zzk = zze;
            ((GetServiceRequest)object4).zzl = this.getApiFeatures();
            if (this.usesClientTelemetry()) {
                ((GetServiceRequest)object4).zzo = true;
            }
            try {
                object = this.zzq;
                synchronized (object) {
                    object2 = this.zzr;
                    if (object2 == null) break block15;
                }
            }
            catch (RuntimeException runtimeException) {
                break block16;
            }
            catch (RemoteException remoteException) {
                // empty catch block
                break block16;
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (DeadObjectException deadObjectException) {
                Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
                this.triggerConnectionSuspended(3);
                return;
            }
            {
                block17: {
                    block15: {
                        object3 = new zzd(this, this.zzd.get());
                        object2.getService((IGmsCallbacks)object3, (GetServiceRequest)object4);
                        break block17;
                    }
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)var1_4);
        this.onPostInitHandler(8, null, null, this.zzd.get());
    }

    protected Set<Scope> getScopes() {
        return Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final T getService() throws DeadObjectException {
        Object object = this.zzp;
        synchronized (object) {
            if (this.zzv != 5) {
                this.checkConnected();
                IInterface iInterface = this.zzs;
                Preconditions.checkNotNull(iInterface, "Client is connected but service is null");
                return (T)iInterface;
            }
            DeadObjectException deadObjectException = new DeadObjectException();
            throw deadObjectException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBinder getServiceBrokerBinder() {
        Object object = this.zzq;
        synchronized (object) {
            IGmsServiceBroker iGmsServiceBroker = this.zzr;
            if (iGmsServiceBroker != null) return iGmsServiceBroker.asBinder();
            return null;
        }
    }

    protected abstract String getServiceDescriptor();

    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected abstract String getStartServiceAction();

    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    public ConnectionTelemetryConfiguration getTelemetryConfiguration() {
        zzj zzj2 = this.zzD;
        if (zzj2 == null) {
            return null;
        }
        return zzj2.zzd;
    }

    protected boolean getUseDynamicLookup() {
        return this.getMinApkVersion() >= 211700000;
    }

    public boolean hasConnectionInfo() {
        return this.zzD != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected() {
        Object object = this.zzp;
        synchronized (object) {
            if (this.zzv != 4) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnecting() {
        Object object = this.zzp;
        synchronized (object) {
            boolean bl;
            int n = this.zzv;
            boolean bl2 = bl = true;
            if (n == 2) return bl2;
            if (n != 3) return false;
            return bl;
        }
    }

    protected void onConnectedLocked(T t) {
        this.zzh = System.currentTimeMillis();
    }

    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzi = connectionResult.getErrorCode();
        this.zzj = System.currentTimeMillis();
    }

    protected void onConnectionSuspended(int n) {
        this.zzf = n;
        this.zzg = System.currentTimeMillis();
    }

    protected void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(1, n2, -1, (Object)new zzf(this, n, iBinder, bundle)));
    }

    public void onUserSignOut(SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    public boolean providesSignIn() {
        return false;
    }

    public boolean requiresAccount() {
        return false;
    }

    public boolean requiresGooglePlayServices() {
        return true;
    }

    public boolean requiresSignIn() {
        return false;
    }

    public void setAttributionTag(String string2) {
        this.zzA = string2;
    }

    public void triggerConnectionSuspended(int n) {
        Handler handler = this.zzb;
        handler.sendMessage(handler.obtainMessage(6, this.zzd.get(), n));
    }

    protected void triggerNotAvailable(ConnectionProgressReportCallbacks connectionProgressReportCallbacks, int n, PendingIntent pendingIntent) {
        Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zzc = connectionProgressReportCallbacks;
        connectionProgressReportCallbacks = this.zzb;
        connectionProgressReportCallbacks.sendMessage(connectionProgressReportCallbacks.obtainMessage(3, this.zzd.get(), n, pendingIntent));
    }

    public boolean usesClientTelemetry() {
        return false;
    }

    protected final String zze() {
        String string2;
        String string3 = string2 = this.zzz;
        if (string2 == null) {
            string3 = this.zzl.getClass().getName();
        }
        return string3;
    }

    protected final void zzl(int n, Bundle bundle, int n2) {
        bundle = this.zzb;
        bundle.sendMessage(bundle.obtainMessage(7, n2, -1, (Object)new zzg(this, n, null)));
    }

    public static interface BaseConnectionCallbacks {
        public static final int CAUSE_DEAD_OBJECT_EXCEPTION = 3;
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    public static interface BaseOnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionProgressReportCallbacks {
        public void onReportServiceBinding(ConnectionResult var1);
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        @Override
        public final void onReportServiceBinding(ConnectionResult object) {
            if (((ConnectionResult)object).isSuccess()) {
                object = BaseGmsClient.this;
                ((BaseGmsClient)object).getRemoteService(null, ((BaseGmsClient)object).getScopes());
                return;
            }
            if (BaseGmsClient.this.zzx != null) {
                BaseGmsClient.this.zzx.onConnectionFailed((ConnectionResult)object);
            }
        }
    }

    public static interface SignOutCallbacks {
        public void onSignOutComplete();
    }
}

