/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.zzb;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class Preconditions {
    private Preconditions() {
        throw new AssertionError((Object)"Uninstantiable");
    }

    public static void checkArgument(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void checkArgument(boolean bl, Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static void checkArgument(boolean bl, String string2, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.format(string2, objectArray));
    }

    public static void checkHandlerThread(Handler object) {
        Object object2 = Looper.myLooper();
        if (object2 != object.getLooper()) {
            object2 = object2 != null ? object2.getThread().getName() : "null current looper";
            String string2 = object.getLooper().getThread().getName();
            object = new StringBuilder();
            ((StringBuilder)object).append("Must be called on ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" thread, but got ");
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(".");
            throw new IllegalStateException(((StringBuilder)object).toString());
        }
    }

    public static void checkHandlerThread(Handler handler, String string2) {
        if (Looper.myLooper() == handler.getLooper()) {
            return;
        }
        throw new IllegalStateException(string2);
    }

    public static void checkMainThread() {
        Preconditions.checkMainThread("Must be called on the main application thread");
    }

    public static void checkMainThread(String string2) {
        if (zzb.zza()) {
            return;
        }
        throw new IllegalStateException(string2);
    }

    @EnsuresNonNull(value={"#1"})
    public static String checkNotEmpty(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        throw new IllegalArgumentException("Given String is empty or null");
    }

    @EnsuresNonNull(value={"#1"})
    public static String checkNotEmpty(String string2, Object object) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static void checkNotMainThread() {
        Preconditions.checkNotMainThread("Must not be called on the main application thread");
    }

    public static void checkNotMainThread(String string2) {
        if (!zzb.zza()) {
            return;
        }
        throw new IllegalStateException(string2);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T checkNotNull(T t) {
        Objects.requireNonNull(t, "null reference");
        return t;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T checkNotNull(T t, Object object) {
        if (t != null) {
            return t;
        }
        throw new NullPointerException(String.valueOf(object));
    }

    public static int checkNotZero(int n) {
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Given Integer is zero");
    }

    public static int checkNotZero(int n, Object object) {
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static long checkNotZero(long l) {
        if (l != 0L) {
            return l;
        }
        throw new IllegalArgumentException("Given Long is zero");
    }

    public static long checkNotZero(long l, Object object) {
        if (l != 0L) {
            return l;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public static void checkState(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalStateException();
    }

    public static void checkState(boolean bl, Object object) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(String.valueOf(object));
    }

    public static void checkState(boolean bl, String string2, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(String.format(string2, objectArray));
    }
}

