/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.WorkSource;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.wrappers.Wrappers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class WorkSourceUtil {
    private static final int zza;
    private static final Method zzb;
    private static final Method zzc;
    private static final Method zzd;
    private static final Method zze;
    private static final Method zzf;
    private static final Method zzg;
    private static final Method zzh;
    private static final Method zzi;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Method method;
        Object var1_2;
        Method method2;
        block22: {
            block21: {
                zza = Process.myUid();
                method2 = null;
                var1_2 = null;
                try {
                    method = WorkSource.class.getMethod("add", Integer.TYPE);
                }
                catch (Exception exception) {
                    method = null;
                }
                zzb = method;
                if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                    try {
                        method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
                    }
                    catch (Exception exception) {}
                }
                method = null;
                zzc = method;
                try {
                    method = WorkSource.class.getMethod("size", new Class[0]);
                }
                catch (Exception exception) {
                    method = null;
                }
                zzd = method;
                try {
                    method = WorkSource.class.getMethod("get", Integer.TYPE);
                }
                catch (Exception exception) {
                    method = null;
                }
                zze = method;
                if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                    try {
                        method = WorkSource.class.getMethod("getName", Integer.TYPE);
                    }
                    catch (Exception exception) {}
                }
                method = null;
                zzf = method;
                if (PlatformVersion.isAtLeastP()) {
                    try {
                        method = WorkSource.class.getMethod("createWorkChain", new Class[0]);
                        break block21;
                    }
                    catch (Exception exception) {
                        Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain API createWorkChain", (Throwable)exception);
                    }
                }
                method = null;
            }
            zzg = method;
            if (PlatformVersion.isAtLeastP()) {
                try {
                    method = Class.forName("android.os.WorkSource$WorkChain").getMethod("addNode", Integer.TYPE, String.class);
                    break block22;
                }
                catch (Exception exception) {
                    Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain class", (Throwable)exception);
                }
            }
            method = null;
        }
        zzh = method;
        method = var1_2;
        if (PlatformVersion.isAtLeastP()) {
            method = method2;
            try {
                method = method2 = WorkSource.class.getMethod("isEmpty", new Class[0]);
                method2.setAccessible(true);
                method = method2;
            }
            catch (Exception exception) {}
        }
        zzi = method;
    }

    private WorkSourceUtil() {
    }

    public static void add(WorkSource workSource, int n, String object) {
        Method method = zzc;
        if (method != null) {
            String string2 = object;
            if (object == null) {
                string2 = "";
            }
            try {
                method.invoke((Object)workSource, n, string2);
                return;
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
                return;
            }
        }
        object = zzb;
        if (object != null) {
            try {
                ((Method)object).invoke((Object)workSource, n);
                return;
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
    }

    public static WorkSource fromPackage(Context context, String string2) {
        if (context != null && context.getPackageManager() != null && string2 != null) {
            block3: {
                try {
                    context = Wrappers.packageManager(context).getApplicationInfo(string2, 0);
                    if (context != null) break block3;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    Log.e((String)"WorkSourceUtil", (String)"Could not find package: ".concat(string2));
                }
                Log.e((String)"WorkSourceUtil", (String)"Could not get applicationInfo from package: ".concat(string2));
                return null;
            }
            int n = context.uid;
            context = new WorkSource();
            WorkSourceUtil.add((WorkSource)context, n, string2);
            return context;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WorkSource fromPackageAndModuleExperimentalPi(Context context, String string2, String string3) {
        block9: {
            Method method;
            int n;
            block8: {
                block7: {
                    if (context == null || context.getPackageManager() == null || string3 == null || string2 == null) break block9;
                    n = -1;
                    try {
                        context = Wrappers.packageManager(context).getApplicationInfo(string2, 0);
                        if (context != null) break block7;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"WorkSourceUtil", (String)"Could not find package: ".concat(string2));
                        break block8;
                    }
                    Log.e((String)"WorkSourceUtil", (String)"Could not get applicationInfo from package: ".concat(string2));
                    break block8;
                }
                n = context.uid;
            }
            if (n < 0) {
                return null;
            }
            context = new WorkSource();
            Object object = zzg;
            if (object != null && (method = zzh) != null) {
                try {
                    object = ((Method)object).invoke((Object)context, new Object[0]);
                    int n2 = zza;
                    if (n != n2) {
                        method.invoke(object, n, string2);
                    }
                    method.invoke(object, n2, string3);
                    return context;
                }
                catch (Exception exception) {
                    Log.w((String)"WorkSourceUtil", (String)"Unable to assign chained blame through WorkSource", (Throwable)exception);
                    return context;
                }
            }
            WorkSourceUtil.add((WorkSource)context, n, string2);
            return context;
        }
        Log.w((String)"WorkSourceUtil", (String)"Unexpected null arguments");
        return null;
    }

    public static int get(WorkSource object, int n) {
        Method method = zze;
        if (method != null) {
            try {
                object = method.invoke(object, n);
                Preconditions.checkNotNull(object);
                n = (Integer)object;
                return n;
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    public static String getName(WorkSource object, int n) {
        Method method = zzf;
        if (method != null) {
            try {
                object = (String)method.invoke(object, n);
                return object;
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    public static List<String> getNames(WorkSource workSource) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = workSource == null ? 0 : WorkSourceUtil.size(workSource);
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                String string2 = WorkSourceUtil.getName(workSource, i);
                if (Strings.isEmptyOrWhitespace(string2)) continue;
                Preconditions.checkNotNull(string2);
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static boolean hasWorkSourcePermission(Context context) {
        if (context == null) {
            return false;
        }
        if (context.getPackageManager() == null) {
            return false;
        }
        return Wrappers.packageManager(context).checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName()) == 0;
    }

    public static boolean isEmpty(WorkSource workSource) {
        Object object = zzi;
        if (object != null) {
            try {
                object = ((Method)object).invoke((Object)workSource, new Object[0]);
                Preconditions.checkNotNull(object);
                boolean bl = (Boolean)object;
                return bl;
            }
            catch (Exception exception) {
                Log.e((String)"WorkSourceUtil", (String)"Unable to check WorkSource emptiness", (Throwable)exception);
            }
        }
        return WorkSourceUtil.size(workSource) == 0;
    }

    public static int size(WorkSource object) {
        Method method = zzd;
        if (method != null) {
            try {
                object = method.invoke(object, new Object[0]);
                Preconditions.checkNotNull(object);
                int n = (Integer)object;
                return n;
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }
}

