/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.os.IBinder;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

public final class ObjectWrapper<T>
extends IObjectWrapper.Stub {
    private final Object zza;

    private ObjectWrapper(Object object) {
        this.zza = object;
    }

    public static <T> T unwrap(IObjectWrapper object) {
        int n;
        if (object instanceof ObjectWrapper) {
            return (T)((ObjectWrapper)object).zza;
        }
        IBinder iBinder = object.asBinder();
        Field[] fieldArray = iBinder.getClass().getDeclaredFields();
        int n2 = fieldArray.length;
        object = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Field field = fieldArray[i];
            n = n3;
            if (!field.isSynthetic()) {
                n = n3 + 1;
                object = field;
            }
            n3 = n;
        }
        if (n3 == 1) {
            Preconditions.checkNotNull(object);
            if (!((AccessibleObject)object).isAccessible()) {
                ((Field)object).setAccessible(true);
                try {
                    object = ((Field)object).get(iBinder);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Could not access the field in remoteBinder.", illegalAccessException);
                }
                catch (NullPointerException nullPointerException) {
                    throw new IllegalArgumentException("Binder object is null.", nullPointerException);
                }
                return (T)object;
            }
            throw new IllegalArgumentException("IObjectWrapper declared field not private!");
        }
        n = fieldArray.length;
        object = new StringBuilder();
        ((StringBuilder)object).append("Unexpected number of IObjectWrapper declared fields: ");
        ((StringBuilder)object).append(n);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public static <T> IObjectWrapper wrap(T t) {
        return new ObjectWrapper<T>(t);
    }
}

