/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzem;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzlt;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzag
extends zzhd {
    private Boolean zza;
    private zzaf zzb = zzae.zza;
    private Boolean zzc;

    zzag(zzgk zzgk2) {
        super(zzgk2);
    }

    public static final long zzA() {
        return (Long)zzen.zzC.zza(null);
    }

    private final String zzB(String string2, String string3) {
        try {
            string2 = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string2, "");
            Preconditions.checkNotNull(string2);
            return string2;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzs.zzay().zzd().zzb("SystemProperties.get() threw an exception", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzs.zzay().zzd().zzb("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzs.zzay().zzd().zzb("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzs.zzay().zzd().zzb("Could not find SystemProperties class", classNotFoundException);
        }
        return "";
    }

    public static final long zzz() {
        return (Long)zzen.zzc.zza(null);
    }

    public final double zza(String string2, zzem zzem2) {
        if (string2 == null) {
            return (Double)zzem2.zza(null);
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = this.zzb.zza(string2, zzem2.zzb())))) {
            return (Double)zzem2.zza(null);
        }
        try {
            double d = (Double)zzem2.zza(Double.parseDouble(string2));
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return (Double)zzem2.zza(null);
        }
    }

    final int zzb(String string2) {
        return this.zzf(string2, zzen.zzG, 500, 2000);
    }

    public final int zzc() {
        zzlt zzlt2 = this.zzs.zzv();
        Boolean bl = zzlt2.zzs.zzt().zzj();
        if (zzlt2.zzm() < 201500 && (bl == null || bl.booleanValue())) {
            return 25;
        }
        return 100;
    }

    public final int zzd(String string2) {
        return this.zzf(string2, zzen.zzH, 25, 100);
    }

    public final int zze(String string2, zzem zzem2) {
        if (string2 == null) {
            return (Integer)zzem2.zza(null);
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = this.zzb.zza(string2, zzem2.zzb())))) {
            return (Integer)zzem2.zza(null);
        }
        try {
            int n = (Integer)zzem2.zza(Integer.parseInt(string2));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return (Integer)zzem2.zza(null);
        }
    }

    public final int zzf(String string2, zzem zzem2, int n, int n2) {
        return Math.max(Math.min(this.zze(string2, zzem2), n2), n);
    }

    public final long zzh() {
        this.zzs.zzaw();
        return 64000L;
    }

    public final long zzi(String string2, zzem zzem2) {
        if (string2 == null) {
            return (Long)zzem2.zza(null);
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = this.zzb.zza(string2, zzem2.zzb())))) {
            return (Long)zzem2.zza(null);
        }
        try {
            long l = (Long)zzem2.zza(Long.parseLong(string2));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return (Long)zzem2.zza(null);
        }
    }

    final Bundle zzj() {
        ApplicationInfo applicationInfo;
        block6: {
            block5: {
                try {
                    if (this.zzs.zzau().getPackageManager() != null) break block5;
                    this.zzs.zzay().zzd().zza("Failed to load metadata: PackageManager is null");
                    return null;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    this.zzs.zzay().zzd().zzb("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
                    return null;
                }
            }
            applicationInfo = Wrappers.packageManager(this.zzs.zzau()).getApplicationInfo(this.zzs.zzau().getPackageName(), 128);
            if (applicationInfo != null) break block6;
            this.zzs.zzay().zzd().zza("Failed to load metadata: ApplicationInfo is null");
            return null;
        }
        applicationInfo = applicationInfo.metaData;
        return applicationInfo;
    }

    final Boolean zzk(String string2) {
        Preconditions.checkNotEmpty(string2);
        Bundle bundle = this.zzj();
        if (bundle == null) {
            this.zzs.zzay().zzd().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string2)) {
            return null;
        }
        return bundle.getBoolean(string2);
    }

    public final String zzl() {
        return this.zzB("debug.firebase.analytics.app", "");
    }

    public final String zzm() {
        return this.zzB("debug.deferred.deeplink", "");
    }

    final String zzn() {
        this.zzs.zzaw();
        return "FA";
    }

    public final String zzo(String string2, zzem zzem2) {
        if (string2 == null) {
            return (String)zzem2.zza(null);
        }
        return (String)zzem2.zza(this.zzb.zza(string2, zzem2.zzb()));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final List zzp(String var1_1) {
        Preconditions.checkNotEmpty("analytics.safelisted_events");
        var1_1 /* !! */  = this.zzj();
        if (var1_1 /* !! */  == null) {
            this.zzs.zzay().zzd().zza("Failed to load metadata: Metadata bundle is null");
            while (true) {
                var1_1 /* !! */  = null;
                break;
            }
        } else {
            if (!var1_1 /* !! */ .containsKey("analytics.safelisted_events")) ** continue;
            var1_1 /* !! */  = var1_1 /* !! */ .getInt("analytics.safelisted_events");
        }
        if (var1_1 /* !! */  != null) {
            block7: {
                var1_1 /* !! */  = this.zzs.zzau().getResources().getStringArray(var1_1 /* !! */ .intValue());
                if (var1_1 /* !! */  != null) break block7;
                return null;
            }
            try {
                var1_1 /* !! */  = Arrays.asList(var1_1 /* !! */ );
                return var1_1 /* !! */ ;
            }
            catch (Resources.NotFoundException var1_2) {
                this.zzs.zzay().zzd().zzb("Failed to load string array from metadata: resource not found", (Object)var1_2);
            }
        }
        return null;
    }

    final void zzq(zzaf zzaf2) {
        this.zzb = zzaf2;
    }

    public final boolean zzr() {
        Boolean bl = this.zzk("google_analytics_adid_collection_enabled");
        return bl == null || bl.booleanValue();
        {
        }
    }

    public final boolean zzs(String string2, zzem zzem2) {
        if (string2 == null) {
            return (Boolean)zzem2.zza(null);
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = this.zzb.zza(string2, zzem2.zzb())))) {
            return (Boolean)zzem2.zza(null);
        }
        return (Boolean)zzem2.zza("1".equals(string2));
    }

    public final boolean zzt(String string2) {
        return "1".equals(this.zzb.zza(string2, "gaia_collection_enabled"));
    }

    public final boolean zzu() {
        Boolean bl = this.zzk("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl.booleanValue();
        {
        }
    }

    public final boolean zzv() {
        this.zzs.zzaw();
        Boolean bl = this.zzk("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzw(String string2) {
        return "1".equals(this.zzb.zza(string2, "measurement.event_sampling_enabled"));
    }

    final boolean zzx() {
        if (this.zza == null) {
            Boolean bl;
            this.zza = bl = this.zzk("app_measurement_lite");
            if (bl == null) {
                this.zza = false;
            }
        }
        return this.zza.booleanValue() || !this.zzs.zzN();
        {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzy() {
        if (this.zzc != null) return this.zzc;
        synchronized (this) {
            if (this.zzc != null) return this.zzc;
            Object object = this.zzs.zzau().getApplicationInfo();
            String string2 = ProcessUtils.getMyProcessName();
            if (object != null) {
                boolean bl;
                object = ((ApplicationInfo)object).processName;
                boolean bl2 = bl = false;
                if (object != null) {
                    bl2 = bl;
                    if (((String)object).equals(string2)) {
                        bl2 = true;
                    }
                }
                this.zzc = bl2;
            }
            if (this.zzc != null) return this.zzc;
            this.zzc = Boolean.TRUE;
            this.zzs.zzay().zzd().zza("My process not in the list of running processes");
            return this.zzc;
        }
    }
}

