/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzof;
import com.google.android.gms.internal.measurement.zzps;
import com.google.android.gms.internal.measurement.zzpy;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzq;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzer
extends zzf {
    private String zza;
    private String zzb;
    private int zzc;
    private String zzd;
    private String zze;
    private long zzf;
    private final long zzg;
    private List zzh;
    private String zzi;
    private int zzj;
    private String zzk;
    private String zzl;
    private String zzm;
    private long zzn = 0L;
    private String zzo = null;

    zzer(zzgk zzgk2, long l) {
        super(zzgk2);
        this.zzg = l;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @EnsuresNonNull(value={"appId", "appStore", "appName", "gmpAppId", "gaAppId"})
    protected final void zzd() {
        block38: {
            block37: {
                block36: {
                    block35: {
                        block39: {
                            var1_1 = this.zzs.zzau().getPackageName();
                            var2_2 = this.zzs.zzau().getPackageManager();
                            var3_3 = "Unknown";
                            var4_4 = -2147483648;
                            var5_5 = "";
                            var6_6 = "unknown";
                            if (var2_2 == null) {
                                this.zzs.zzay().zzd().zzb("PackageManager is null, app identity information might be inaccurate. appId", zzfa.zzn(var1_1));
                                while (true) {
                                    var7_12 = "Unknown";
                                    var8_8 = var6_6;
                                    var6_6 = var7_12;
                                    break block35;
                                    break;
                                }
                            }
                            try {
                                var6_6 = var8_8 = var2_2.getInstallerPackageName(var1_1);
                            }
                            catch (IllegalArgumentException var8_9) {
                                this.zzs.zzay().zzd().zzb("Error retrieving app installer package name. appId", zzfa.zzn(var1_1));
                            }
                            if (var6_6 == null) {
                                var8_8 = "manual_install";
                            } else {
                                var8_8 = var6_6;
                                if ("com.android.vending".equals(var6_6)) {
                                    var8_8 = "";
                                }
                            }
                            var9_11 = var2_2.getPackageInfo(this.zzs.zzau().getPackageName(), 0);
                            var6_6 = var8_8;
                            if (var9_11 == null) ** continue;
                            var6_6 = var2_2.getApplicationLabel(var9_11.applicationInfo);
                            var6_6 = TextUtils.isEmpty((CharSequence)var6_6) == false ? var6_6.toString() : "Unknown";
                            var7_12 = var9_11.versionName;
                            var3_3 = var7_12;
                            try {
                                var10_14 = var9_11.versionCode;
                                var3_3 = var7_12;
                                var4_4 = var10_14;
                                break block35;
                            }
                            catch (PackageManager.NameNotFoundException var7_13) {
                                var7_12 = var3_3;
                                var3_3 = var6_6;
                                var6_6 = var7_12;
                            }
                            break block39;
                            catch (PackageManager.NameNotFoundException var6_7) {
                                var6_6 = "Unknown";
                            }
                        }
                        this.zzs.zzay().zzd().zzc("Error retrieving package info. appId, appName", zzfa.zzn(var1_1), var3_3);
                        var7_12 = var3_3;
                        var3_3 = var6_6;
                        var6_6 = var7_12;
                    }
                    this.zza = var1_1;
                    this.zzd = var8_8;
                    this.zzb = var3_3;
                    this.zzc = var4_4;
                    this.zze = var6_6;
                    this.zzf = 0L;
                    var4_4 = TextUtils.isEmpty((CharSequence)this.zzs.zzw()) == false && "am".equals(this.zzs.zzx()) != false ? 1 : 0;
                    var10_14 = this.zzs.zza();
                    switch (var10_14) {
                        default: {
                            this.zzs.zzay().zzi().zza("App measurement disabled due to denied storage consent");
                            break;
                        }
                        case 7: {
                            this.zzs.zzay().zzi().zza("App measurement disabled via the global data collection setting");
                            break;
                        }
                        case 6: {
                            this.zzs.zzay().zzl().zza("App measurement deactivated via resources. This method is being deprecated. Please refer to https://firebase.google.com/support/guides/disable-analytics");
                            break;
                        }
                        case 5: {
                            this.zzs.zzay().zzj().zza("App measurement disabled via the init parameters");
                            break;
                        }
                        case 4: {
                            this.zzs.zzay().zzi().zza("App measurement disabled via the manifest");
                            break;
                        }
                        case 3: {
                            this.zzs.zzay().zzi().zza("App measurement disabled by setAnalyticsCollectionEnabled(false)");
                            break;
                        }
                        case 2: {
                            this.zzs.zzay().zzj().zza("App measurement deactivated via the init parameters");
                            break;
                        }
                        case 1: {
                            this.zzs.zzay().zzi().zza("App measurement deactivated via the manifest");
                            break;
                        }
                        case 0: {
                            this.zzs.zzay().zzj().zza("App measurement collection enabled");
                        }
                    }
                    this.zzk = "";
                    this.zzl = "";
                    this.zzs.zzaw();
                    if (var4_4 != 0) {
                        this.zzl = this.zzs.zzw();
                    }
                    var6_6 = zziv.zzc(this.zzs.zzau(), "google_app_id", this.zzs.zzz());
                    var8_8 = var5_5;
                    if (TextUtils.isEmpty((CharSequence)var6_6)) break block36;
                    var8_8 = var6_6;
                }
                this.zzk = var8_8;
                if (!TextUtils.isEmpty((CharSequence)var6_6)) {
                    var3_3 = this.zzs.zzau();
                    var8_8 = this.zzs.zzz();
                    Preconditions.checkNotNull(var3_3);
                    var6_6 = var3_3.getResources();
                    if (TextUtils.isEmpty((CharSequence)var8_8)) {
                        var8_8 = zzgc.zza((Context)var3_3);
                    }
                    this.zzl = zzgc.zzb("admob_app_id", (Resources)var6_6, (String)var8_8);
                }
                if (var10_14 != 0) break block37;
                try {
                    var6_6 = this.zzs.zzay().zzj();
                    var3_3 = this.zza;
                    var8_8 = TextUtils.isEmpty((CharSequence)this.zzk) != false ? this.zzl : this.zzk;
                    var6_6.zzc("App measurement enabled for app package, google app id", var3_3, var8_8);
                }
                catch (IllegalStateException var8_10) {
                    this.zzs.zzay().zzd().zzc("Fetching Google App Id failed with exception. appId", zzfa.zzn(var1_1), var8_10);
                }
            }
            this.zzh = null;
            this.zzs.zzaw();
            var8_8 = this.zzs.zzf().zzp("analytics.safelisted_events");
            if (var8_8 == null) ** GOTO lbl135
            if (var8_8.isEmpty()) {
                this.zzs.zzay().zzl().zza("Safelisted event list is empty. Ignoring");
            } else {
                var3_3 = var8_8.iterator();
                while (var3_3.hasNext()) {
                    var6_6 = (String)var3_3.next();
                    if (this.zzs.zzv().zzab("safelisted event", (String)var6_6)) continue;
                    break block38;
                }
lbl135:
                // 2 sources

                this.zzh = var8_8;
            }
        }
        if (var2_2 != null) {
            this.zzj = (int)InstantApps.isInstantApp(this.zzs.zzau());
            return;
        }
        this.zzj = 0;
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    final int zzh() {
        this.zza();
        return this.zzj;
    }

    final int zzi() {
        this.zza();
        return this.zzc;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final zzq zzj(String string2) {
        void var15_21;
        boolean bl;
        boolean bl2;
        Object object;
        String string3;
        Object object2;
        long l;
        long l2;
        String string4;
        long l3;
        String string5;
        String string6;
        String string7;
        block27: {
            block25: {
                block26: {
                    block24: {
                        ((zzhd)this).zzg();
                        string7 = this.zzl();
                        string6 = this.zzm();
                        this.zza();
                        string5 = this.zzb;
                        this.zza();
                        l3 = this.zzc;
                        this.zza();
                        Preconditions.checkNotNull(this.zzd);
                        string4 = this.zzd;
                        this.zzs.zzf().zzh();
                        this.zza();
                        ((zzhd)this).zzg();
                        l = l2 = this.zzf;
                        if (l2 == 0L) {
                            block23: {
                                object2 = this.zzs.zzv();
                                Context context = this.zzs.zzau();
                                string3 = this.zzs.zzau().getPackageName();
                                ((zzhd)object2).zzg();
                                Preconditions.checkNotNull(context);
                                Preconditions.checkNotEmpty(string3);
                                PackageManager packageManager = context.getPackageManager();
                                object = zzlt.zzF();
                                l = -1L;
                                if (object == null) {
                                    ((zzhd)object2).zzs.zzay().zzd().zza("Could not get MD5 instance");
                                } else {
                                    if (packageManager != null) {
                                        try {
                                            if (!((zzlt)object2).zzag(context, string3)) {
                                                PackageInfo packageInfo = Wrappers.packageManager(context).getPackageInfo(((zzhd)object2).zzs.zzau().getPackageName(), 64);
                                                if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                                                    l = zzlt.zzp(((MessageDigest)object).digest(packageInfo.signatures[0].toByteArray()));
                                                    break block23;
                                                } else {
                                                    ((zzhd)object2).zzs.zzay().zzk().zza("Could not get signatures");
                                                }
                                                break block23;
                                            }
                                            l = 0L;
                                            break block23;
                                        }
                                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                                            ((zzhd)object2).zzs.zzay().zzd().zzb("Package name not found", (Object)nameNotFoundException);
                                        }
                                    }
                                    l = 0L;
                                }
                            }
                            this.zzf = l;
                        }
                        bl2 = this.zzs.zzJ();
                        bl = this.zzs.zzm().zzk;
                        ((zzhd)this).zzg();
                        if (this.zzs.zzJ()) {
                            zzpy.zzc();
                            if (this.zzs.zzf().zzs(null, zzen.zzab)) {
                                this.zzs.zzay().zzj().zza("Disabled IID for tests.");
                            } else {
                                try {
                                    object = this.zzs.zzau().getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
                                    if (object != null) break block24;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    break block25;
                                }
                            }
                        }
                        object2 = null;
                        break block27;
                    }
                    try {
                        object2 = ((Class)object).getDeclaredMethod("getInstance", Context.class).invoke(null, this.zzs.zzau());
                        if (object2 == null) {
                        }
                        break block26;
                    }
                    catch (Exception exception) {
                        this.zzs.zzay().zzm().zza("Failed to obtain Firebase Analytics instance");
                    }
                    break block25;
                }
                try {
                    object2 = (String)((Class)object).getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object2, new Object[0]);
                    break block27;
                }
                catch (Exception exception) {
                    this.zzs.zzay().zzl().zza("Failed to retrieve Firebase Instance Id");
                }
            }
            object2 = null;
        }
        object = this.zzs;
        l2 = ((zzgk)object).zzm().zzc.zza();
        l2 = l2 == 0L ? ((zzgk)object).zzc : Math.min(((zzgk)object).zzc, l2);
        this.zza();
        int n = this.zzj;
        boolean bl3 = this.zzs.zzf().zzr();
        object = this.zzs.zzm();
        ((zzhd)object).zzg();
        boolean bl4 = ((zzfp)object).zza().getBoolean("deferred_analytics_collection", false);
        this.zza();
        String string8 = this.zzl;
        object = this.zzs.zzf().zzk("google_analytics_default_allow_ad_personalization_signals");
        object = object == null ? null : Boolean.valueOf((Boolean)object ^ true);
        long l4 = this.zzg;
        List list = this.zzh;
        string3 = this.zzs.zzm().zzc().zzh();
        if (this.zzi == null) {
            this.zzi = this.zzs.zzf().zzs(null, zzen.zzaN) ? this.zzs.zzv().zzC() : "";
        }
        String string9 = this.zzi;
        zzps.zzc();
        if (!this.zzs.zzf().zzs(null, zzen.zzaI)) return new zzq(string7, string6, string5, l3, string4, 64000L, l, string2, bl2, bl ^ true, (String)object2, 0L, l2, n, bl3, bl4, string8, (Boolean)object, l4, list, null, string3, string9, (String)var15_21);
        ((zzhd)this).zzg();
        if (this.zzn != 0L) {
            long l5 = this.zzs.zzav().currentTimeMillis();
            long l6 = this.zzn;
            if (this.zzm != null && l5 - l6 > 86400000L && this.zzo == null) {
                this.zzo();
            }
        }
        if (this.zzm == null) {
            this.zzo();
        }
        String string10 = this.zzm;
        return new zzq(string7, string6, string5, l3, string4, 64000L, l, string2, bl2, bl ^ true, (String)object2, 0L, l2, n, bl3, bl4, string8, (Boolean)object, l4, list, null, string3, string9, (String)var15_21);
    }

    final String zzk() {
        this.zza();
        return this.zzl;
    }

    final String zzl() {
        this.zza();
        Preconditions.checkNotNull(this.zza);
        return this.zza;
    }

    final String zzm() {
        zzof.zzc();
        if (this.zzs.zzf().zzs(null, zzen.zzal)) {
            ((zzhd)this).zzg();
        }
        this.zza();
        Preconditions.checkNotNull(this.zzk);
        return this.zzk;
    }

    final List zzn() {
        return this.zzh;
    }

    final void zzo() {
        Object object;
        ((zzhd)this).zzg();
        if (!this.zzs.zzm().zzc().zzi(zzah.zzb)) {
            this.zzs.zzay().zzc().zza("Analytics Storage consent is not granted");
            object = null;
        } else {
            object = new byte[16];
            this.zzs.zzv().zzG().nextBytes((byte[])object);
            object = String.format(Locale.US, "%032x", new BigInteger(1, (byte[])object));
        }
        zzey zzey2 = this.zzs.zzay().zzc();
        String string2 = object == null ? "null" : "not null";
        zzey2.zza(String.format("Resetting session stitching token to %s", string2));
        this.zzm = object;
        this.zzn = this.zzs.zzav().currentTimeMillis();
    }

    final boolean zzp(String string2) {
        boolean bl;
        String string3 = this.zzo;
        boolean bl2 = bl = false;
        if (string3 != null) {
            bl2 = bl;
            if (!string3.equals(string2)) {
                bl2 = true;
            }
        }
        this.zzo = string2;
        return bl2;
    }
}

