/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzhy;
import com.google.android.gms.internal.measurement.zzoc;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzlt;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzgk
implements zzhf {
    private static volatile zzgk zzd;
    private zzer zzA;
    private boolean zzB;
    private Boolean zzC;
    private long zzD;
    private volatile Boolean zzE;
    private volatile boolean zzF;
    private int zzG;
    private final AtomicInteger zzH;
    protected Boolean zza;
    protected Boolean zzb;
    final long zzc;
    private final Context zze;
    private final String zzf;
    private final String zzg;
    private final String zzh;
    private final boolean zzi;
    private final zzab zzj;
    private final zzag zzk;
    private final zzfp zzl;
    private final zzfa zzm;
    private final zzgh zzn;
    private final zzku zzo;
    private final zzlt zzp;
    private final zzev zzq;
    private final Clock zzr;
    private final zzje zzs;
    private final zzip zzt;
    private final zzd zzu;
    private final zzit zzv;
    private final String zzw;
    private zzet zzx;
    private zzke zzy;
    private zzaq zzz;

    zzgk(zzhn zzhn2) {
        Object object;
        boolean bl = false;
        this.zzB = false;
        this.zzH = new AtomicInteger(0);
        Preconditions.checkNotNull(zzhn2);
        Object object2 = zzhn2.zza;
        Object object3 = new zzab((Context)object2);
        this.zzj = object3;
        zzek.zza = object3;
        this.zze = object2;
        this.zzf = zzhn2.zzb;
        this.zzg = zzhn2.zzc;
        this.zzh = zzhn2.zzd;
        this.zzi = zzhn2.zzh;
        this.zzE = zzhn2.zze;
        this.zzw = zzhn2.zzj;
        this.zzF = true;
        object3 = zzhn2.zzg;
        if (object3 != null && (object = ((zzcl)object3).zzg) != null) {
            if ((object = object.get("measurementEnabled")) instanceof Boolean) {
                this.zza = (Boolean)object;
            }
            if ((object3 = ((zzcl)object3).zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzb = (Boolean)object3;
            }
        }
        zzhy.zze(object2);
        object = DefaultClock.getInstance();
        this.zzr = object;
        object3 = zzhn2.zzi;
        long l = object3 != null ? ((Long)object3).longValue() : object.currentTimeMillis();
        this.zzc = l;
        this.zzk = new zzag(this);
        object3 = new zzfp(this);
        ((zzhe)object3).zzv();
        this.zzl = object3;
        object3 = new zzfa(this);
        ((zzhe)object3).zzv();
        this.zzm = object3;
        object3 = new zzlt(this);
        ((zzhe)object3).zzv();
        this.zzp = object3;
        this.zzq = new zzev(new zzhm(zzhn2, this));
        this.zzu = new zzd(this);
        object3 = new zzje(this);
        ((zzf)object3).zzb();
        this.zzs = object3;
        object3 = new zzip(this);
        ((zzf)object3).zzb();
        this.zzt = object3;
        object3 = new zzku(this);
        ((zzf)object3).zzb();
        this.zzo = object3;
        object3 = new zzit(this);
        ((zzhe)object3).zzv();
        this.zzv = object3;
        object3 = new zzgh(this);
        ((zzhe)object3).zzv();
        this.zzn = object3;
        object = zzhn2.zzg;
        if (object == null || ((zzcl)object).zzb == 0L) {
            bl = true;
        }
        if (object2.getApplicationContext() instanceof Application) {
            object2 = this.zzq();
            if (object2.zzs.zze.getApplicationContext() instanceof Application) {
                object = (Application)object2.zzs.zze.getApplicationContext();
                if (object2.zza == null) {
                    object2.zza = new zzio((zzip)object2, null);
                }
                if (bl) {
                    object.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)object2.zza);
                    object.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)object2.zza);
                    object2.zzs.zzay().zzj().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            this.zzay().zzk().zza("Application context is not an Application");
        }
        ((zzgh)object3).zzp(new zzgj(this, zzhn2));
    }

    static /* bridge */ /* synthetic */ void zzA(zzgk zzgk2, zzhn object) {
        ((zzhd)zzgk2.zzaz()).zzg();
        zzgk2.zzk.zzn();
        Object object2 = new zzaq(zzgk2);
        ((zzhe)object2).zzv();
        zzgk2.zzz = object2;
        object = new zzer(zzgk2, ((zzhn)object).zzf);
        ((zzf)object).zzb();
        zzgk2.zzA = object;
        object2 = new zzet(zzgk2);
        ((zzf)object2).zzb();
        zzgk2.zzx = object2;
        object2 = new zzke(zzgk2);
        ((zzf)object2).zzb();
        zzgk2.zzy = object2;
        zzgk2.zzp.zzw();
        zzgk2.zzl.zzw();
        zzgk2.zzA.zzc();
        object2 = zzgk2.zzay().zzi();
        zzgk2.zzk.zzh();
        ((zzey)object2).zzb("App measurement initialized, version", 64000L);
        zzgk2.zzay().zzi().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = ((zzer)object).zzl();
        if (TextUtils.isEmpty((CharSequence)zzgk2.zzf)) {
            if (zzgk2.zzv().zzae((String)object)) {
                zzgk2.zzay().zzi().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                zzgk2.zzay().zzi().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(String.valueOf(object)));
            }
        }
        zzgk2.zzay().zzc().zza("Debug-level message logging enabled");
        if (zzgk2.zzG != zzgk2.zzH.get()) {
            zzgk2.zzay().zzd().zzc("Not all components initialized", zzgk2.zzG, zzgk2.zzH.get());
        }
        zzgk2.zzB = true;
    }

    static final void zzO() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    private static final void zzP(zzhd zzhd2) {
        if (zzhd2 != null) {
            return;
        }
        throw new IllegalStateException("Component not created");
    }

    private static final void zzQ(zzf zzf2) {
        if (zzf2 != null) {
            if (zzf2.zze()) {
                return;
            }
            throw new IllegalStateException("Component not initialized: ".concat(String.valueOf(String.valueOf(zzf2.getClass()))));
        }
        throw new IllegalStateException("Component not created");
    }

    private static final void zzR(zzhe zzhe2) {
        if (zzhe2 != null) {
            if (zzhe2.zzx()) {
                return;
            }
            throw new IllegalStateException("Component not initialized: ".concat(String.valueOf(String.valueOf(zzhe2.getClass()))));
        }
        throw new IllegalStateException("Component not created");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzgk zzp(Context object, zzcl object2, Long l) {
        zzcl zzcl2;
        block9: {
            block10: {
                zzcl2 = object2;
                if (object2 == null) break block9;
                if (((zzcl)object2).zze == null) break block10;
                zzcl2 = object2;
                if (((zzcl)object2).zzf != null) break block9;
            }
            zzcl2 = new zzcl(((zzcl)object2).zza, ((zzcl)object2).zzb, ((zzcl)object2).zzc, ((zzcl)object2).zzd, null, null, ((zzcl)object2).zzg, null);
        }
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object.getApplicationContext());
        if (zzd == null) {
            synchronized (zzgk.class) {
                if (zzd == null) {
                    object2 = new zzhn((Context)object, zzcl2, l);
                    object = new zzgk((zzhn)object2);
                    zzd = object;
                }
            }
        } else if (zzcl2 != null && (object = zzcl2.zzg) != null && object.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull(zzd);
            zzgk.zzd.zzE = zzcl2.zzg.getBoolean("dataCollectionDefaultEnabled");
        }
        Preconditions.checkNotNull(zzd);
        return zzd;
    }

    final void zzB() {
        this.zzH.incrementAndGet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzC(String string2, int n, Throwable object, byte[] object2, Map object3) {
        int n2;
        block13: {
            block12: {
                n2 = n;
                if (n == 200) break block12;
                n2 = n;
                if (n == 204) break block12;
                n2 = n;
                if (n != 304) break block13;
                n2 = 304;
            }
            if (object == null) {
                this.zzm().zzm.zza(true);
                if (object2 != null && ((Object)object2).length != 0) {
                    string2 = new String((byte[])object2);
                    try {
                        object2 = new JSONObject(string2);
                        string2 = object2.optString("deeplink", "");
                        object = object2.optString("gclid", "");
                        double d = object2.optDouble("timestamp", 0.0);
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            this.zzay().zzc().zza("Deferred Deep Link is empty.");
                            return;
                        }
                        object2 = this.zzv();
                        object3 = ((zzhd)object2).zzs;
                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                            object2 = ((zzhd)object2).zzs.zze.getPackageManager();
                            object3 = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
                            if ((object2 = object2.queryIntentActivities((Intent)object3, 0)) != null && !object2.isEmpty()) {
                                object2 = new Bundle();
                                object2.putString("gclid", (String)object);
                                object2.putString("_cis", "ddp");
                                this.zzt.zzH("auto", "_cmp", (Bundle)object2);
                                object = this.zzv();
                                boolean bl = TextUtils.isEmpty((CharSequence)string2);
                                if (bl) {
                                    return;
                                }
                                try {
                                    object2 = ((zzhd)object).zzs.zze.getSharedPreferences("google.analytics.deferred.deeplink.prefs", 0).edit();
                                    object2.putString("deeplink", string2);
                                    object2.putLong("timestamp", Double.doubleToRawLongBits(d));
                                    bl = object2.commit();
                                    if (!bl) return;
                                }
                                catch (RuntimeException runtimeException) {
                                    ((zzhd)object).zzs.zzay().zzd().zzb("Failed to persist Deferred Deep Link. exception", runtimeException);
                                    return;
                                }
                                string2 = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                                ((zzhd)object).zzs.zze.sendBroadcast((Intent)string2);
                                return;
                            }
                        }
                        this.zzay().zzk().zzc("Deferred Deep Link validation failed. gclid, deep link", object, string2);
                        return;
                    }
                    catch (JSONException jSONException) {
                        this.zzay().zzd().zzb("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
                        return;
                    }
                }
                this.zzay().zzc().zza("Deferred Deep Link response empty.");
                return;
            }
        }
        this.zzay().zzk().zzc("Network Request for Deferred Deep Link failed. response, exception", n2, object);
    }

    final void zzD() {
        ++this.zzG;
    }

    public final void zzE() {
        ((zzhd)this.zzaz()).zzg();
        zzgk.zzR(this.zzr());
        String string2 = this.zzh().zzl();
        Object object = this.zzm().zzb(string2);
        if (this.zzk.zzr() && !((Boolean)((Pair)object).second).booleanValue() && !TextUtils.isEmpty((CharSequence)((CharSequence)((Pair)object).first))) {
            Object object2 = this.zzr();
            ((zzhe)object2).zzu();
            ConnectivityManager connectivityManager = (ConnectivityManager)((zzhd)object2).zzs.zze.getSystemService("connectivity");
            URL uRL = null;
            object2 = uRL;
            if (connectivityManager != null) {
                try {
                    object2 = connectivityManager.getActiveNetworkInfo();
                }
                catch (SecurityException securityException) {
                    object2 = uRL;
                }
            }
            if (object2 != null && object2.isConnected()) {
                object2 = this.zzv();
                this.zzh().zzs.zzk.zzh();
                uRL = ((zzlt)object2).zzE(64000L, string2, (String)((Pair)object).first, this.zzm().zzn.zza() - 1L);
                if (uRL != null) {
                    object = this.zzr();
                    object2 = new zzgi(this);
                    ((zzhd)object).zzg();
                    ((zzhe)object).zzu();
                    Preconditions.checkNotNull(uRL);
                    Preconditions.checkNotNull(object2);
                    ((zzhd)object).zzs.zzaz().zzo(new zzis((zzit)object, string2, uRL, null, null, (zzgi)object2, null));
                }
                return;
            }
            this.zzay().zzk().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        this.zzay().zzc().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
    }

    final void zzF(boolean bl) {
        this.zzE = bl;
    }

    public final void zzG(boolean bl) {
        ((zzhd)this.zzaz()).zzg();
        this.zzF = bl;
    }

    /*
     * Unable to fully structure code
     */
    protected final void zzH(zzcl var1_1) {
        block24: {
            block25: {
                block23: {
                    this.zzaz().zzg();
                    var2_3 = this.zzm().zzc();
                    var3_4 = this.zzm();
                    var4_5 = var3_4.zzs;
                    var3_4.zzg();
                    var4_5 = var3_4.zza();
                    var5_6 = 100;
                    var6_7 = var4_5.getInt("consent_source", 100);
                    var3_4 = this.zzk;
                    var4_5 = var3_4.zzs;
                    var4_5 = var3_4.zzk("google_analytics_default_allow_ad_storage");
                    var7_8 = this.zzk;
                    var3_4 = var7_8.zzs;
                    var3_4 = var7_8.zzk("google_analytics_default_allow_analytics_storage");
                    if (var4_5 == null && var3_4 == null || !this.zzm().zzl(-10)) break block23;
                    var1_1 = new zzai((Boolean)var4_5, (Boolean)var3_4);
                    var5_6 = -10;
                    break block24;
                }
                if (TextUtils.isEmpty((CharSequence)this.zzh().zzm()) || var6_7 != 0 && var6_7 != 30 && var6_7 != 10 && var6_7 != 30 && var6_7 != 30 && var6_7 != 40) break block25;
                this.zzq().zzT(zzai.zza, -10, this.zzc);
                ** GOTO lbl-1000
            }
            if (TextUtils.isEmpty((CharSequence)this.zzh().zzm()) && var1_1 != null && var1_1.zzg != null && this.zzm().zzl(30) && !(var1_1 = zzai.zza(var1_1.zzg)).equals(zzai.zza)) {
                var5_6 = 30;
            } else lbl-1000:
            // 2 sources

            {
                var1_1 = null;
            }
        }
        if (var1_1 != null) {
            this.zzq().zzT((zzai)var1_1, var5_6, this.zzc);
            var2_3 = var1_1;
        }
        this.zzq().zzX((zzai)var2_3);
        if (this.zzm().zzc.zza() == 0L) {
            this.zzay().zzj().zzb("Persisting first open", this.zzc);
            this.zzm().zzc.zzb(this.zzc);
        }
        this.zzq().zzb.zzc();
        if (!this.zzM()) {
            if (this.zzJ()) {
                if (!this.zzv().zzad("android.permission.INTERNET")) {
                    this.zzay().zzd().zza("App is missing INTERNET permission");
                }
                if (!this.zzv().zzad("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzay().zzd().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager(this.zze).isCallerInstantApp() && !this.zzk.zzx()) {
                    if (!zzlt.zzaj(this.zze)) {
                        this.zzay().zzd().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzlt.zzak(this.zze, false)) {
                        this.zzay().zzd().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzay().zzd().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            block22: {
                if (!TextUtils.isEmpty((CharSequence)this.zzh().zzm()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzk())) {
                    var1_1 = this.zzv();
                    var2_3 = this.zzh().zzm();
                    var4_5 = this.zzm();
                    var4_5.zzg();
                    var3_4 = var4_5.zza().getString("gmp_app_id", null);
                    var7_8 = this.zzh().zzk();
                    var4_5 = this.zzm();
                    var4_5.zzg();
                    if (var1_1.zzam((String)var2_3, (String)var3_4, (String)var7_8, var4_5.zza().getString("admob_app_id", null))) {
                        this.zzay().zzi().zza("Rechecking which service to use due to a GMP App Id change");
                        var4_5 = this.zzm();
                        var4_5.zzg();
                        var1_1 = var4_5.zzd();
                        var2_3 = var4_5.zza().edit();
                        var2_3.clear();
                        var2_3.apply();
                        if (var1_1 != null) {
                            var4_5.zzh((Boolean)var1_1);
                        }
                        this.zzi().zzj();
                        this.zzy.zzs();
                        this.zzy.zzr();
                        this.zzm().zzc.zzb(this.zzc);
                        this.zzm().zze.zzb(null);
                    }
                    var2_3 = this.zzm();
                    var1_1 = this.zzh().zzm();
                    var2_3.zzg();
                    var2_3 = var2_3.zza().edit();
                    var2_3.putString("gmp_app_id", (String)var1_1);
                    var2_3.apply();
                    var2_3 = this.zzm();
                    var1_1 = this.zzh().zzk();
                    var2_3.zzg();
                    var2_3 = var2_3.zza().edit();
                    var2_3.putString("admob_app_id", (String)var1_1);
                    var2_3.apply();
                }
                if (!this.zzm().zzc().zzi(zzah.zzb)) {
                    this.zzm().zze.zzb(null);
                }
                this.zzq().zzP(this.zzm().zze.zza());
                zzoc.zzc();
                if (this.zzk.zzs(null, zzen.zzad)) {
                    var1_1 = this.zzv();
                    try {
                        var1_1.zzs.zze.getClassLoader().loadClass("com.google.firebase.remoteconfig.FirebaseRemoteConfig");
                    }
                    catch (ClassNotFoundException var1_2) {
                        if (TextUtils.isEmpty((CharSequence)this.zzm().zzo.zza())) break block22;
                        this.zzay().zzk().zza("Remote config removed with active feature rollouts");
                        this.zzm().zzo.zzb(null);
                    }
                }
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzm()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzk())) {
                var8_9 = this.zzJ();
                if (!this.zzm().zzj() && !this.zzk.zzv()) {
                    this.zzm().zzi(var8_9 ^ true);
                }
                if (var8_9) {
                    this.zzq().zzz();
                }
                this.zzu().zza.zza();
                this.zzt().zzu(new AtomicReference<V>());
                this.zzt().zzH(this.zzm().zzr.zza());
            }
        }
        this.zzm().zzi.zza(true);
    }

    public final boolean zzI() {
        return this.zzE != null && this.zzE != false;
    }

    public final boolean zzJ() {
        return this.zza() == 0;
    }

    public final boolean zzK() {
        ((zzhd)this.zzaz()).zzg();
        return this.zzF;
    }

    @Pure
    public final boolean zzL() {
        return TextUtils.isEmpty((CharSequence)this.zzf);
    }

    protected final boolean zzM() {
        if (this.zzB) {
            ((zzhd)this.zzaz()).zzg();
            Boolean bl = this.zzC;
            if (bl == null || this.zzD == 0L || !bl.booleanValue() && Math.abs(this.zzr.elapsedRealtime() - this.zzD) > 1000L) {
                this.zzD = this.zzr.elapsedRealtime();
                boolean bl2 = this.zzv().zzad("android.permission.INTERNET");
                boolean bl3 = true;
                bl2 = bl2 && this.zzv().zzad("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager(this.zze).isCallerInstantApp() || this.zzk.zzx() || zzlt.zzaj(this.zze) && zzlt.zzak(this.zze, false));
                this.zzC = bl = Boolean.valueOf(bl2);
                if (bl.booleanValue()) {
                    bl2 = bl3;
                    if (!this.zzv().zzX(this.zzh().zzm(), this.zzh().zzk())) {
                        bl2 = !TextUtils.isEmpty((CharSequence)this.zzh().zzk()) ? bl3 : false;
                    }
                    this.zzC = bl2;
                }
            }
            return this.zzC;
        }
        throw new IllegalStateException("AppMeasurement is not initialized");
    }

    @Pure
    public final boolean zzN() {
        return this.zzi;
    }

    public final int zza() {
        ((zzhd)this.zzaz()).zzg();
        if (this.zzk.zzv()) {
            return 1;
        }
        Object object = this.zzb;
        if (object != null && ((Boolean)object).booleanValue()) {
            return 2;
        }
        ((zzhd)this.zzaz()).zzg();
        if (!this.zzF) {
            return 8;
        }
        object = this.zzm().zzd();
        if (object != null) {
            if (((Boolean)object).booleanValue()) {
                return 0;
            }
            return 3;
        }
        object = this.zzk;
        zzab zzab2 = ((zzhd)object).zzs.zzj;
        if ((object = ((zzag)object).zzk("firebase_analytics_collection_enabled")) != null) {
            if (((Boolean)object).booleanValue()) {
                return 0;
            }
            return 4;
        }
        object = this.zza;
        if (object != null) {
            if (((Boolean)object).booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzE != null) {
            if (this.zzE.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zzau() {
        return this.zze;
    }

    @Override
    @Pure
    public final Clock zzav() {
        return this.zzr;
    }

    @Override
    @Pure
    public final zzab zzaw() {
        return this.zzj;
    }

    @Override
    @Pure
    public final zzfa zzay() {
        zzgk.zzR(this.zzm);
        return this.zzm;
    }

    @Override
    @Pure
    public final zzgh zzaz() {
        zzgk.zzR(this.zzn);
        return this.zzn;
    }

    @Pure
    public final zzd zzd() {
        zzd zzd2 = this.zzu;
        if (zzd2 != null) {
            return zzd2;
        }
        throw new IllegalStateException("Component not created");
    }

    @Pure
    public final zzag zzf() {
        return this.zzk;
    }

    @Pure
    public final zzaq zzg() {
        zzgk.zzR(this.zzz);
        return this.zzz;
    }

    @Pure
    public final zzer zzh() {
        zzgk.zzQ(this.zzA);
        return this.zzA;
    }

    @Pure
    public final zzet zzi() {
        zzgk.zzQ(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzev zzj() {
        return this.zzq;
    }

    public final zzfa zzl() {
        zzfa zzfa2 = this.zzm;
        if (zzfa2 != null && zzfa2.zzx()) {
            return zzfa2;
        }
        return null;
    }

    @Pure
    public final zzfp zzm() {
        zzgk.zzP(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final zzgh zzo() {
        return this.zzn;
    }

    @Pure
    public final zzip zzq() {
        zzgk.zzQ(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzit zzr() {
        zzgk.zzR(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzje zzs() {
        zzgk.zzQ(this.zzs);
        return this.zzs;
    }

    @Pure
    public final zzke zzt() {
        zzgk.zzQ(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzku zzu() {
        zzgk.zzQ(this.zzo);
        return this.zzo;
    }

    @Pure
    public final zzlt zzv() {
        zzgk.zzP(this.zzp);
        return this.zzp;
    }

    @Pure
    public final String zzw() {
        return this.zzf;
    }

    @Pure
    public final String zzx() {
        return this.zzg;
    }

    @Pure
    public final String zzy() {
        return this.zzh;
    }

    @Pure
    public final String zzz() {
        return this.zzw;
    }
}

