/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzke;

public final class zzkd
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    final /* synthetic */ zzke zza;
    private volatile boolean zzb;
    private volatile zzew zzc;

    protected zzkd(zzke zzke2) {
        this.zza = zzke2;
    }

    static /* bridge */ /* synthetic */ void zza(zzkd zzkd2, boolean bl) {
        zzkd2.zzb = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread("MeasurementServiceConnection.onConnected");
        synchronized (this) {
            Throwable throwable3;
            block5: {
                try {
                    try {
                        Preconditions.checkNotNull(this.zzc);
                        zzeq zzeq2 = (zzeq)this.zzc.getService();
                        object = this.zza.zzs.zzaz();
                        zzka zzka2 = new zzka(this, zzeq2);
                        ((zzgh)object).zzp(zzka2);
                    }
                    catch (DeadObjectException | IllegalStateException throwable2) {
                        this.zzc = null;
                        this.zzb = false;
                    }
                }
                catch (Throwable throwable3) {
                    break block5;
                }
                return;
            }
            throw throwable3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void onConnectionFailed(ConnectionResult connectionResult) {
        Preconditions.checkMainThread("MeasurementServiceConnection.onConnectionFailed");
        zzfa zzfa2 = this.zza.zzs.zzl();
        if (zzfa2 != null) {
            zzfa2.zzk().zzb("Service connection failed", connectionResult);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
        }
        this.zza.zzs.zzaz().zzp(new zzkc(this));
    }

    @Override
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread("MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzs.zzay().zzc().zza("Service connection suspended");
        this.zza.zzs.zzaz().zzp(new zzkb(this));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onServiceConnected(ComponentName var1_1, IBinder var2_4) {
        Preconditions.checkMainThread("MeasurementServiceConnection.onServiceConnected");
        synchronized (this) {
            block13: {
                block12: {
                    if (var2_4 /* !! */  != null) ** GOTO lbl8
                    try {
                        this.zzb = false;
                        this.zza.zzs.zzay().zzd().zza("Service connected with null binder");
                        return;
lbl8:
                        // 1 sources

                        var3_6 = null;
                        var4_7 = null;
                        var1_1 /* !! */  = var4_7;
                        try {
                            var5_8 = var2_4 /* !! */ .getInterfaceDescriptor();
                            var1_1 /* !! */  = var4_7;
                            if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(var5_8)) {
                                var1_1 /* !! */  = var4_7;
                                var3_6 = var2_4 /* !! */ .queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                                var1_1 /* !! */  = var4_7;
                                if (var3_6 instanceof zzeq) {
                                    var1_1 /* !! */  = var4_7;
                                    var2_4 /* !! */  = (zzeq)var3_6;
                                } else {
                                    var1_1 /* !! */  = var4_7;
                                    var2_4 /* !! */  = new zzeo(var2_4 /* !! */ );
                                }
                                var1_1 /* !! */  = var2_4 /* !! */ ;
                                this.zza.zzs.zzay().zzj().zza("Bound to IMeasurementService interface");
                                var1_1 /* !! */  = var2_4 /* !! */ ;
                                break block12;
                            }
                            var1_1 /* !! */  = var4_7;
                            this.zza.zzs.zzay().zzd().zzb("Got binder with a wrong descriptor", var5_8);
                            var1_1 /* !! */  = var3_6;
                        }
                        catch (RemoteException var2_5) {
                            this.zza.zzs.zzay().zzd().zza("Service connect failed to get IMeasurementService");
                        }
                    }
                    catch (Throwable var1_2) {
                        break block13;
                    }
                }
                if (var1_1 /* !! */  == null) {
                    this.zzb = false;
                    try {
                        ConnectionTracker.getInstance().unbindService(this.zza.zzs.zzau(), zzke.zzi(this.zza));
                    }
                    catch (IllegalArgumentException var1_3) {}
                } else {
                    var4_7 = this.zza.zzs.zzaz();
                    var2_4 /* !! */  = new zzjy(this, (zzeq)var1_1 /* !! */ );
                    var4_7.zzp((Runnable)var2_4 /* !! */ );
                }
                return;
            }
            throw var1_2;
        }
    }

    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread("MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzs.zzay().zzc().zza("Service disconnected");
        this.zza.zzs.zzaz().zzp(new zzjz(this, componentName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb(Intent intent) {
        ((zzhd)this.zza).zzg();
        Context context = this.zza.zzs.zzau();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            if (this.zzb) {
                this.zza.zzs.zzay().zzj().zza("Connection attempt already in progress");
                return;
            }
            this.zza.zzs.zzay().zzj().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, zzke.zzi(this.zza), 129);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc() {
        ((zzhd)this.zza).zzg();
        Context context = this.zza.zzs.zzau();
        synchronized (this) {
            zzew zzew2;
            if (this.zzb) {
                this.zza.zzs.zzay().zzj().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                this.zza.zzs.zzay().zzj().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzew2 = new zzew(context, Looper.getMainLooper(), this, this);
            this.zza.zzs.zzay().zzj().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull(this.zzc);
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    public final void zzd() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }
}

