/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzey;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzlt
extends zzhe {
    private static final String[] zza = new String[]{"firebase_", "google_", "ga_"};
    private static final String[] zzb = new String[]{"_err"};
    private SecureRandom zzc;
    private final AtomicLong zzd = new AtomicLong(0L);
    private int zze;
    private Integer zzf = null;

    zzlt(zzgk zzgk2) {
        super(zzgk2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzF() {
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    public static ArrayList zzH(List list) {
        if (list == null) {
            return new ArrayList(0);
        }
        ArrayList<List> arrayList = new ArrayList<List>(list.size());
        for (AbstractSafeParcelable abstractSafeParcelable : list) {
            list = new Bundle();
            list.putString("app_id", ((zzac)abstractSafeParcelable).zza);
            list.putString("origin", ((zzac)abstractSafeParcelable).zzb);
            list.putLong("creation_timestamp", ((zzac)abstractSafeParcelable).zzd);
            list.putString("name", ((zzac)abstractSafeParcelable).zzc.zzb);
            zzhg.zzb((Bundle)list, Preconditions.checkNotNull(((zzac)abstractSafeParcelable).zzc.zza()));
            list.putBoolean("active", ((zzac)abstractSafeParcelable).zze);
            Object object = ((zzac)abstractSafeParcelable).zzf;
            if (object != null) {
                list.putString("trigger_event_name", (String)object);
            }
            if ((object = ((zzac)abstractSafeParcelable).zzg) != null) {
                list.putString("timed_out_event_name", ((zzaw)object).zza);
                object = ((zzaw)object).zzb;
                if (object != null) {
                    list.putBundle("timed_out_event_params", ((zzau)object).zzc());
                }
            }
            list.putLong("trigger_timeout", ((zzac)abstractSafeParcelable).zzh);
            object = ((zzac)abstractSafeParcelable).zzi;
            if (object != null) {
                list.putString("triggered_event_name", ((zzaw)object).zza);
                object = ((zzaw)object).zzb;
                if (object != null) {
                    list.putBundle("triggered_event_params", ((zzau)object).zzc());
                }
            }
            list.putLong("triggered_timestamp", ((zzac)abstractSafeParcelable).zzc.zzc);
            list.putLong("time_to_live", ((zzac)abstractSafeParcelable).zzj);
            abstractSafeParcelable = ((zzac)abstractSafeParcelable).zzk;
            if (abstractSafeParcelable != null) {
                list.putString("expired_event_name", ((zzaw)abstractSafeParcelable).zza);
                abstractSafeParcelable = ((zzaw)abstractSafeParcelable).zzb;
                if (abstractSafeParcelable != null) {
                    list.putBundle("expired_event_params", ((zzau)abstractSafeParcelable).zzc());
                }
            }
            arrayList.add(list);
        }
        return arrayList;
    }

    public static void zzK(zziw zziw2, Bundle bundle, boolean bl) {
        boolean bl2 = bl;
        if (bundle != null) {
            bl2 = bl;
            if (zziw2 != null) {
                if (bundle.containsKey("_sc") && !bl) {
                    bl2 = false;
                } else {
                    String string2 = zziw2.zza;
                    if (string2 != null) {
                        bundle.putString("_sn", string2);
                    } else {
                        bundle.remove("_sn");
                    }
                    string2 = zziw2.zzb;
                    if (string2 != null) {
                        bundle.putString("_sc", string2);
                    } else {
                        bundle.remove("_sc");
                    }
                    bundle.putLong("_si", zziw2.zzc);
                    return;
                }
            }
        }
        if (bundle != null && zziw2 == null && bl2) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    static boolean zzah(String string2) {
        return !TextUtils.isEmpty((CharSequence)string2) && string2.startsWith("_");
    }

    static boolean zzai(String string2) {
        Preconditions.checkNotEmpty(string2);
        return string2.charAt(0) != '_' || string2.equals("_ep");
        {
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzaj(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull(context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
            context = packageManager.getReceiverInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    static boolean zzak(Context context, boolean bl) {
        Preconditions.checkNotNull(context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzlt.zzat(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzlt.zzat(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    public static boolean zzal(String string2) {
        return !zzb[0].equals(string2);
    }

    static final boolean zzao(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    static final boolean zzap(String string2) {
        Preconditions.checkNotNull(string2);
        return string2.matches("^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$");
    }

    private final int zzaq(String string2) {
        if ("_ldl".equals(string2)) {
            this.zzs.zzf();
            return 2048;
        }
        if ("_id".equals(string2)) {
            this.zzs.zzf();
            return 256;
        }
        if ("_lgclid".equals(string2)) {
            this.zzs.zzf();
            return 100;
        }
        this.zzs.zzf();
        return 36;
    }

    private final Object zzar(int n, Object parcelableArray, boolean bl, boolean bl2) {
        if (parcelableArray == null) {
            return null;
        }
        if (!(parcelableArray instanceof Long) && !(parcelableArray instanceof Double)) {
            if (parcelableArray instanceof Integer) {
                return (long)((Integer)parcelableArray).intValue();
            }
            if (parcelableArray instanceof Byte) {
                return (long)((Byte)parcelableArray).byteValue();
            }
            if (parcelableArray instanceof Short) {
                return (long)((Short)parcelableArray).shortValue();
            }
            if (parcelableArray instanceof Boolean) {
                long l = true != (Boolean)parcelableArray ? 0L : 1L;
                return l;
            }
            if (parcelableArray instanceof Float) {
                return ((Float)parcelableArray).doubleValue();
            }
            if (!(parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence)) {
                if (bl2 && (parcelableArray instanceof Bundle[] || parcelableArray instanceof Parcelable[])) {
                    ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>();
                    for (Parcelable parcelable : (Parcelable[])parcelableArray) {
                        if (!(parcelable instanceof Bundle) || (parcelable = this.zzt((Bundle)parcelable)).isEmpty()) continue;
                        arrayList.add(parcelable);
                    }
                    return arrayList.toArray(new Bundle[arrayList.size()]);
                }
                return null;
            }
            return this.zzD(parcelableArray.toString(), n, bl);
        }
        return parcelableArray;
    }

    private static boolean zzas(String string2, String[] stringArray) {
        Preconditions.checkNotNull(stringArray);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!zzlr.zza(string2, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzat(Context context, String string2) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, string2);
            context = packageManager.getServiceInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    static long zzp(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        int n = byArray.length;
        int n2 = 0;
        boolean bl = n > 0;
        Preconditions.checkState(bl);
        --n;
        long l = 0L;
        while (n >= 0 && n >= byArray.length - 8) {
            l += ((long)byArray[n] & 0xFFL) << n2;
            n2 += 8;
            --n;
        }
        return l;
    }

    final Object zzA(String string2, Object object) {
        boolean bl = "_ev".equals(string2);
        int n = 256;
        if (bl) {
            this.zzs.zzf();
            return this.zzar(256, object, true, true);
        }
        if (zzlt.zzah(string2)) {
            this.zzs.zzf();
        } else {
            this.zzs.zzf();
            n = 100;
        }
        return this.zzar(n, object, false, true);
    }

    final Object zzB(String string2, Object object) {
        if ("_ldl".equals(string2)) {
            return this.zzar(this.zzaq(string2), object, true, false);
        }
        return this.zzar(this.zzaq(string2), object, false, false);
    }

    final String zzC() {
        byte[] byArray = new byte[16];
        this.zzG().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    public final String zzD(String string2, int n, boolean bl) {
        if (string2 == null) {
            return null;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            if (bl) {
                return String.valueOf(string2.substring(0, string2.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public final URL zzE(long l, String object, String string2, long l2) {
        void var3_5;
        String string3;
        Preconditions.checkNotEmpty(string2);
        Preconditions.checkNotEmpty((String)object);
        string2 = string3 = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", String.format("v%s.%s", 64000L, this.zzm()), string2, object, l2);
        try {
            if (((String)object).equals(this.zzs.zzf().zzm())) {
                string2 = string3.concat("&ddl_test=1");
            }
            object = new URL(string2);
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.zzs.zzay().zzd().zzb("Failed to create BOW URL for Deferred Deep Link. exception", var3_5.getMessage());
        return null;
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    final SecureRandom zzG() {
        this.zzg();
        if (this.zzc == null) {
            this.zzc = new SecureRandom();
        }
        return this.zzc;
    }

    final void zzI(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            this.zzs.zzay().zzk().zzb("Params already contained engagement", l2);
        } else {
            l2 = 0L;
        }
        bundle.putLong("_et", l + l2);
    }

    final void zzJ(Bundle bundle, int n, String string2, String string3, Object object) {
        if (zzlt.zzao(bundle, n)) {
            this.zzs.zzf();
            bundle.putString("_ev", this.zzD(string2, 40, true));
            if (object != null) {
                Preconditions.checkNotNull(bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    bundle.putLong("_el", (long)object.toString().length());
                }
            }
        }
    }

    final void zzL(Bundle bundle, Bundle bundle2) {
        if (bundle2 == null) {
            return;
        }
        for (String string2 : bundle2.keySet()) {
            if (bundle.containsKey(string2)) continue;
            this.zzs.zzv().zzO(bundle, string2, bundle2.get(string2));
        }
    }

    final void zzM(zzfb zzfb2, int n) {
        Iterator iterator2 = new TreeSet(zzfb2.zzd.keySet()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int n3;
            String string2 = (String)iterator2.next();
            if (!zzlt.zzai(string2)) continue;
            n2 = n3 = n2 + 1;
            if (n3 <= n) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Event can't contain more than ");
            stringBuilder.append(n);
            stringBuilder.append(" params");
            this.zzs.zzay().zze().zzc(stringBuilder.toString(), this.zzs.zzj().zzd(zzfb2.zza), this.zzs.zzj().zzb(zzfb2.zzd));
            zzlt.zzao(zzfb2.zzd, 5);
            zzfb2.zzd.remove(string2);
            n2 = n3;
        }
    }

    final void zzN(zzls zzls2, String string2, int n, String string3, String string4, int n2) {
        Bundle bundle = new Bundle();
        zzlt.zzao(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
            bundle.putString(string3, string4);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        zzls2.zza(string2, "_err", bundle);
    }

    final void zzO(Bundle object, String string2, Object object2) {
        if (object == null) {
            return;
        }
        if (object2 instanceof Long) {
            object.putLong(string2, ((Long)object2).longValue());
            return;
        }
        if (object2 instanceof String) {
            object.putString(string2, String.valueOf(object2));
            return;
        }
        if (object2 instanceof Double) {
            object.putDouble(string2, ((Double)object2).doubleValue());
            return;
        }
        if (object2 instanceof Bundle[]) {
            object.putParcelableArray(string2, (Parcelable[])((Bundle[])object2));
            return;
        }
        if (string2 != null) {
            object = object2 != null ? object2.getClass().getSimpleName() : null;
            this.zzs.zzay().zzl().zzc("Not putting event parameter. Invalid value type. name, type", this.zzs.zzj().zze(string2), object);
        }
    }

    public final void zzP(zzcf zzcf2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzQ(zzcf zzcf2, ArrayList arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzR(zzcf zzcf2, Bundle bundle) {
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzS(zzcf zzcf2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzT(zzcf zzcf2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzU(zzcf zzcf2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzV(zzcf zzcf2, String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string2);
        try {
            zzcf2.zzd(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzs.zzay().zzk().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    final void zzW(String string2, String string3, String string4, Bundle bundle, List list, boolean bl) {
        if (bundle == null) {
            return;
        }
        this.zzs.zzf();
        Iterator iterator2 = new TreeSet(bundle.keySet()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int n2;
            String string5 = (String)iterator2.next();
            if (list != null && list.contains(string5)) {
                n2 = 0;
            } else {
                int n3 = !bl ? this.zzj(string5) : 0;
                n2 = n3;
                if (n3 == 0) {
                    n2 = this.zzi(string5);
                }
            }
            if (n2 != 0) {
                String string6 = n2 == 3 ? string5 : null;
                this.zzJ(bundle, n2, string5, string5, string6);
                bundle.remove(string5);
                continue;
            }
            if (this.zzaf(bundle.get(string5))) {
                this.zzs.zzay().zzl().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string3, string4, string5);
                n2 = 22;
            } else {
                n2 = this.zza(string2, string3, string5, bundle.get(string5), bundle, list, bl, false);
            }
            if (n2 != 0 && !"_ev".equals(string5)) {
                this.zzJ(bundle, n2, string5, string5, bundle.get(string5));
                bundle.remove(string5);
                continue;
            }
            if (!zzlt.zzai(string5) || zzlt.zzas(string5, zzhi.zzd)) continue;
            n = n2 = n + 1;
            if (n2 <= 0) continue;
            this.zzs.zzay().zze().zzc("Item cannot contain custom parameters", this.zzs.zzj().zzd(string3), this.zzs.zzj().zzb(bundle));
            zzlt.zzao(bundle, 23);
            bundle.remove(string5);
            n = n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean zzX(String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (zzlt.zzap(string2)) return true;
            if (!this.zzs.zzL()) return false;
            this.zzs.zzay().zze().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzfa.zzn(string2));
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            if (zzlt.zzap(string3)) return true;
            this.zzs.zzay().zze().zzb("Invalid admob_app_id. Analytics disabled.", zzfa.zzn(string3));
            return false;
        }
        if (!this.zzs.zzL()) return false;
        this.zzs.zzay().zze().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzY(String string2, int n, String string3) {
        if (string3 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string2);
            return false;
        }
        if (string3.codePointCount(0, string3.length()) > n) {
            this.zzs.zzay().zze().zzd("Name is too long. Type, maximum supported length, name", string2, n, string3);
            return false;
        }
        return true;
    }

    final boolean zzZ(String string2, String[] stringArray, String[] stringArray2, String string3) {
        if (string3 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string2);
            return false;
        }
        Preconditions.checkNotNull(string3);
        String[] stringArray3 = zza;
        for (int i = 0; i < 3; ++i) {
            if (!string3.startsWith(stringArray3[i])) continue;
            this.zzs.zzay().zze().zzc("Name starts with reserved prefix. Type, name", string2, string3);
            return false;
        }
        if (stringArray != null && zzlt.zzas(string3, stringArray) && (stringArray2 == null || !zzlt.zzas(string3, stringArray2))) {
            this.zzs.zzay().zze().zzc("Name is reserved. Type, name", string2, string3);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    final int zza(String object, String object2, String string2, Object object3, Bundle object42, List list, boolean bl, boolean bl2) {
        block14: {
            int n;
            block21: {
                void var7_13;
                void var6_12;
                int n2;
                block22: {
                    block20: {
                        void var8_14;
                        block19: {
                            block15: {
                                block16: {
                                    void var5_8;
                                    boolean bl3;
                                    Object object4;
                                    block18: {
                                        block17: {
                                            this.zzg();
                                            if (!this.zzaf(object3)) break block15;
                                            if (var8_14 == false) break block16;
                                            if (!zzlt.zzas(string2, zzhi.zzc)) {
                                                return 20;
                                            }
                                            object4 = this.zzs.zzt();
                                            ((zzhd)object4).zzg();
                                            ((zzf)object4).zza();
                                            if (((zzke)object4).zzN() && ((zzhd)object4).zzs.zzv().zzm() < 200900) {
                                                return 25;
                                            }
                                            this.zzs.zzf();
                                            bl3 = object3 instanceof Parcelable[];
                                            if (!bl3) break block17;
                                            n = ((Parcelable[])object3).length;
                                            break block18;
                                        }
                                        if (!(object3 instanceof ArrayList)) break block15;
                                        n = ((ArrayList)object3).size();
                                    }
                                    if (n <= 200) break block15;
                                    this.zzs.zzay().zzl().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, n);
                                    this.zzs.zzf();
                                    if (bl3) {
                                        object4 = (Parcelable[])object3;
                                        if (((Parcelable[])object4).length > 200) {
                                            var5_8.putParcelableArray(string2, (Parcelable[])Arrays.copyOf(object4, 200));
                                        }
                                    } else if (object3 instanceof ArrayList && ((ArrayList)(object4 = (ArrayList)object3)).size() > 200) {
                                        var5_8.putParcelableArrayList(string2, new ArrayList(((ArrayList)object4).subList(0, 200)));
                                    }
                                    n = 17;
                                    break block19;
                                }
                                return 21;
                            }
                            n = 0;
                        }
                        if (this.zzs.zzf().zzs((String)object, zzen.zzS) && zzlt.zzah((String)object2) || zzlt.zzah(string2)) {
                            this.zzs.zzf();
                            n2 = 256;
                        } else {
                            this.zzs.zzf();
                            n2 = 100;
                        }
                        if (this.zzaa("param", string2, n2, object3)) {
                            return n;
                        }
                        if (var8_14 == false) break block14;
                        if (!(object3 instanceof Bundle)) break block20;
                        this.zzW((String)object, (String)object2, string2, (Bundle)object3, (List)var6_12, (boolean)var7_13);
                        break block21;
                    }
                    if (!(object3 instanceof Parcelable[])) break block22;
                    for (Parcelable parcelable : (Parcelable[])object3) {
                        if (!(parcelable instanceof Bundle)) {
                            this.zzs.zzay().zzl().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                            break block14;
                        }
                        this.zzW((String)object, (String)object2, string2, (Bundle)parcelable, (List)var6_12, (boolean)var7_13);
                    }
                    break block21;
                }
                if (object3 instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)object3;
                    int n3 = arrayList.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        Object e = arrayList.get(n2);
                        if (!(e instanceof Bundle)) {
                            object2 = this.zzs.zzay().zzl();
                            object = e != null ? e.getClass() : "null";
                            ((zzey)object2).zzc("All ArrayList elements must be of type Bundle. Value type, name", object, string2);
                            break block14;
                        }
                        this.zzW((String)object, (String)object2, string2, (Bundle)e, (List)var6_12, (boolean)var7_13);
                    }
                }
                break block14;
            }
            return n;
        }
        return 4;
    }

    @Override
    protected final void zzaA() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = l = secureRandom.nextLong();
        if (l == 0L) {
            l2 = l = secureRandom.nextLong();
            if (l == 0L) {
                this.zzs.zzay().zzk().zza("Utils falling back to Random for random id");
                l2 = l;
            }
        }
        this.zzd.set(l2);
    }

    final boolean zzaa(String string2, String string3, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (!(object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double)) {
            if (!(object instanceof String || object instanceof Character || object instanceof CharSequence)) {
                return false;
            }
            if (((String)(object = object.toString())).codePointCount(0, ((String)object).length()) > n) {
                this.zzs.zzay().zzl().zzd("Value is too long; discarded. Value kind, name, value length", string2, string3, ((String)object).length());
                return false;
            }
        }
        return true;
    }

    final boolean zzab(String string2, String string3) {
        int n;
        int n2;
        if (string3 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string2);
            return false;
        }
        if (string3.length() == 0) {
            this.zzs.zzay().zze().zzb("Name is required and can't be empty. Type", string2);
            return false;
        }
        int n3 = n2 = string3.codePointAt(0);
        if (!Character.isLetter(n2)) {
            if (n2 == 95) {
                n3 = 95;
            } else {
                this.zzs.zzay().zze().zzc("Name must start with a letter or _ (underscore). Type, name", string2, string3);
                return false;
            }
        }
        n2 = string3.length();
        for (n3 = Character.charCount(n3); n3 < n2; n3 += Character.charCount(n)) {
            n = string3.codePointAt(n3);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            this.zzs.zzay().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string2, string3);
            return false;
        }
        return true;
    }

    final boolean zzac(String string2, String string3) {
        int n;
        if (string3 == null) {
            this.zzs.zzay().zze().zzb("Name is required and can't be null. Type", string2);
            return false;
        }
        if (string3.length() == 0) {
            this.zzs.zzay().zze().zzb("Name is required and can't be empty. Type", string2);
            return false;
        }
        int n2 = string3.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzs.zzay().zze().zzc("Name must start with a letter. Type, name", string2, string3);
            return false;
        }
        int n3 = string3.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string3.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            this.zzs.zzay().zze().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string2, string3);
            return false;
        }
        return true;
    }

    final boolean zzad(String string2) {
        this.zzg();
        if (Wrappers.packageManager(this.zzs.zzau()).checkCallingOrSelfPermission(string2) == 0) {
            return true;
        }
        this.zzs.zzay().zzc().zzb("Permission not granted", string2);
        return false;
    }

    final boolean zzae(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        String string3 = this.zzs.zzf().zzl();
        this.zzs.zzaw();
        return string3.equals(string2);
    }

    final boolean zzaf(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
        {
        }
    }

    final boolean zzag(Context object, String object2) {
        block5: {
            X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
            object = Wrappers.packageManager(object).getPackageInfo((String)object2, 64);
            if (object == null) break block5;
            try {
                if (object.signatures != null && object.signatures.length > 0) {
                    Signature signature = object.signatures[0];
                    object2 = CertificateFactory.getInstance("X.509");
                    object = new ByteArrayInputStream(signature.toByteArray());
                    boolean bl = ((X509Certificate)((CertificateFactory)object2).generateCertificate((InputStream)object)).getSubjectX500Principal().equals(x500Principal);
                    return bl;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzs.zzay().zzd().zzb("Package name not found", (Object)nameNotFoundException);
            }
            catch (CertificateException certificateException) {
                this.zzs.zzay().zzd().zzb("Error obtaining certificate", certificateException);
            }
        }
        return true;
    }

    final boolean zzam(String string2, String string3, String string4, String string5) {
        boolean bl = TextUtils.isEmpty((CharSequence)string2);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string3);
        if (!bl && !bl2) {
            Preconditions.checkNotNull(string2);
            return !string2.equals(string3);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string4) && !TextUtils.isEmpty((CharSequence)string5)) {
                return !string4.equals(string5);
            }
            return !TextUtils.isEmpty((CharSequence)string5);
        }
        if (!bl) {
            if (TextUtils.isEmpty((CharSequence)string5)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string4) || !string4.equals(string5);
            {
            }
        }
        return TextUtils.isEmpty((CharSequence)string4) || !string4.equals(string5);
        {
        }
    }

    final byte[] zzan(Parcelable object) {
        if (object == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            object.writeToParcel(parcel, 0);
            object = parcel.marshall();
            return object;
        }
        finally {
            parcel.recycle();
        }
    }

    final int zzd(String string2, Object object) {
        boolean bl = "_ldl".equals(string2) ? this.zzaa("user property referrer", string2, this.zzaq(string2), object) : this.zzaa("user property", string2, this.zzaq(string2), object);
        if (bl) {
            return 0;
        }
        return 7;
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    final int zzh(String string2) {
        if (!this.zzab("event", string2)) {
            return 2;
        }
        if (!this.zzZ("event", zzhh.zza, zzhh.zzb, string2)) {
            return 13;
        }
        this.zzs.zzf();
        if (!this.zzY("event", 40, string2)) {
            return 2;
        }
        return 0;
    }

    final int zzi(String string2) {
        if (!this.zzab("event param", string2)) {
            return 3;
        }
        if (!this.zzZ("event param", null, null, string2)) {
            return 14;
        }
        this.zzs.zzf();
        if (!this.zzY("event param", 40, string2)) {
            return 3;
        }
        return 0;
    }

    final int zzj(String string2) {
        if (!this.zzac("event param", string2)) {
            return 3;
        }
        if (!this.zzZ("event param", null, null, string2)) {
            return 14;
        }
        this.zzs.zzf();
        if (!this.zzY("event param", 40, string2)) {
            return 3;
        }
        return 0;
    }

    final int zzl(String string2) {
        if (!this.zzab("user property", string2)) {
            return 6;
        }
        if (!this.zzZ("user property", zzhj.zza, null, string2)) {
            return 15;
        }
        this.zzs.zzf();
        if (!this.zzY("user property", 24, string2)) {
            return 6;
        }
        return 0;
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzm() {
        if (this.zzf == null) {
            this.zzf = GoogleApiAvailabilityLight.getInstance().getApkVersion(this.zzs.zzau()) / 1000;
        }
        return this.zzf;
    }

    public final int zzo(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(this.zzs.zzau(), 12451000);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzq() {
        if (this.zzd.get() == 0L) {
            AtomicLong atomicLong = this.zzd;
            synchronized (atomicLong) {
                int n;
                Random random = new Random(System.nanoTime() ^ this.zzs.zzav().currentTimeMillis());
                long l = random.nextLong();
                this.zze = n = this.zze + 1;
                long l2 = n;
                return l + l2;
            }
        }
        AtomicLong atomicLong = this.zzd;
        synchronized (atomicLong) {
            this.zzd.compareAndSet(-1L, 1L);
            return this.zzd.getAndIncrement();
        }
    }

    public final long zzr(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzs(Uri object, boolean bl, boolean bl2) {
        String string2;
        String string3;
        void var3_5;
        String string4;
        String string5;
        void var2_4;
        String string6;
        String string7;
        String string8;
        String string9;
        block24: {
            if (object == null) return null;
            try {
                boolean bl3 = object.isHierarchical();
                if (bl3) {
                    string9 = object.getQueryParameter("utm_campaign");
                    string8 = object.getQueryParameter("utm_source");
                    string7 = object.getQueryParameter("utm_medium");
                    string6 = object.getQueryParameter("gclid");
                    if (var2_4 != false) {
                        string5 = object.getQueryParameter("utm_id");
                        string4 = object.getQueryParameter("dclid");
                    } else {
                        string4 = string5 = null;
                    }
                    if (var3_5 != false) {
                        String string10 = object.getQueryParameter("srsltid");
                        string3 = string5;
                        string2 = string4;
                        string4 = string10;
                        break block24;
                    } else {
                        Object var11_14 = null;
                        string3 = string5;
                        string2 = string4;
                        string4 = var11_14;
                    }
                    break block24;
                }
                string4 = string2 = (string3 = (string7 = (string8 = (string5 = (string9 = null)))));
                string6 = string7;
                string7 = string8;
                string8 = string5;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.zzs.zzay().zzk().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
                return null;
            }
        }
        if (TextUtils.isEmpty((CharSequence)string9) && TextUtils.isEmpty((CharSequence)string8) && TextUtils.isEmpty((CharSequence)string7) && TextUtils.isEmpty((CharSequence)string6) && (var2_4 == false || TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string2)) && (var3_5 == false || TextUtils.isEmpty((CharSequence)string4))) {
            return null;
        }
        string5 = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)string9)) {
            string5.putString("campaign", string9);
        }
        if (!TextUtils.isEmpty((CharSequence)string8)) {
            string5.putString("source", string8);
        }
        if (!TextUtils.isEmpty((CharSequence)string7)) {
            string5.putString("medium", string7);
        }
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            string5.putString("gclid", string6);
        }
        if (!TextUtils.isEmpty((CharSequence)(string8 = object.getQueryParameter("utm_term")))) {
            string5.putString("term", string8);
        }
        if (!TextUtils.isEmpty((CharSequence)(string8 = object.getQueryParameter("utm_content")))) {
            string5.putString("content", string8);
        }
        if (!TextUtils.isEmpty((CharSequence)(string8 = object.getQueryParameter("aclid")))) {
            string5.putString("aclid", string8);
        }
        if (!TextUtils.isEmpty((CharSequence)(string8 = object.getQueryParameter("cp1")))) {
            string5.putString("cp1", string8);
        }
        if (!TextUtils.isEmpty((CharSequence)(string8 = object.getQueryParameter("anid")))) {
            string5.putString("anid", string8);
        }
        if (var2_4 != false) {
            String string11;
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                string5.putString("campaign_id", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string5.putString("dclid", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = object.getQueryParameter("utm_source_platform")))) {
                string5.putString("source_platform", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = object.getQueryParameter("utm_creative_format")))) {
                string5.putString("creative_format", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string11 = object.getQueryParameter("utm_marketing_tactic")))) {
                string5.putString("marketing_tactic", string11);
            }
        }
        if (var3_5 == false || TextUtils.isEmpty((CharSequence)string4)) return string5;
        string5.putString("srsltid", string4);
        return string5;
    }

    final Bundle zzt(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string2 : bundle.keySet()) {
                Object object = this.zzA(string2, bundle.get(string2));
                if (object == null) {
                    this.zzs.zzay().zzl().zzb("Param value can't be null", this.zzs.zzj().zze(string2));
                    continue;
                }
                this.zzO(bundle2, string2, object);
            }
        }
        return bundle2;
    }

    /*
     * Unable to fully structure code
     */
    final Bundle zzy(String var1_1, String var2_2, Bundle var3_3, List var4_4, boolean var5_5) {
        block11: {
            block7: {
                var6_6 = zzlt.zzas(var2_2, zzhh.zzd);
                if (var3_3 == null) break block7;
                var7_7 = new Bundle(var3_3);
                var8_8 = this.zzs.zzf().zzc();
                var9_9 = new TreeSet<E>(var3_3.keySet()).iterator();
                var10_10 = 0;
                while (var9_9.hasNext()) {
                    block9: {
                        block10: {
                            block8: {
                                var11_11 = (String)var9_9.next();
                                if (var4_4 != null && var4_4.contains(var11_11)) {
                                    var12_12 = 0;
                                } else {
                                    var13_13 = var5_5 == false ? this.zzj((String)var11_11) : 0;
                                    var12_12 = var13_13;
                                    if (var13_13 == 0) {
                                        var12_12 = this.zzi((String)var11_11);
                                    }
                                }
                                if (var12_12 == 0) break block8;
                                var14_14 = var12_12 == 3 ? var11_11 : null;
                                this.zzJ(var7_7, var12_12, (String)var11_11, (String)var11_11, var14_14);
                                var7_7.remove((String)var11_11);
                                var12_12 = var10_10;
                                break block9;
                            }
                            var14_14 = var3_3.get((String)var11_11);
                            var13_13 = var8_8;
                            var12_12 = this.zza(var1_1, var2_2, (String)var11_11, var14_14, var7_7, var4_4, var5_5, var6_6);
                            if (var12_12 != 17) break block10;
                            this.zzJ(var7_7, 17, (String)var11_11, (String)var11_11, false);
                            ** GOTO lbl-1000
                        }
                        if (var12_12 != 0 && !"_ev".equals(var14_14 = var11_11)) {
                            var11_11 = var12_12 == 21 ? var2_2 : var14_14;
                            this.zzJ(var7_7, var12_12, (String)var11_11, (String)var14_14, var3_3.get((String)var14_14));
                            var7_7.remove((String)var14_14);
                            var12_12 = var10_10;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var12_12 = var10_10;
                            if (zzlt.zzai((String)var11_11) && (var12_12 = var10_10 + 1) > var13_13) {
                                var14_14 = new StringBuilder();
                                var14_14.append("Event can't contain more than ");
                                var14_14.append(var13_13);
                                var14_14.append(" params");
                                this.zzs.zzay().zze().zzc(var14_14.toString(), this.zzs.zzj().zzd(var2_2), this.zzs.zzj().zzb(var3_3));
                                zzlt.zzao(var7_7, 5);
                                var7_7.remove((String)var11_11);
                            }
                        }
                    }
                    var10_10 = var12_12;
                }
                var1_1 = var7_7;
                break block11;
            }
            var1_1 = null;
        }
        return var1_1;
    }

    final zzaw zzz(String string2, String string3, Bundle bundle, String string4, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        if (this.zzh(string3) == 0) {
            bundle = bundle != null ? new Bundle(bundle) : new Bundle();
            bundle.putString("_o", string4);
            bundle = this.zzy(string2, string3, bundle, CollectionUtils.listOf("_o"), true);
            string2 = bundle;
            if (bl) {
                string2 = this.zzt(bundle);
            }
            Preconditions.checkNotNull(string2);
            return new zzaw(string3, new zzau((Bundle)string2), string4, l);
        }
        this.zzs.zzay().zzd().zzb("Invalid conditional property event name", this.zzs.zzj().zzf(string3));
        throw new IllegalArgumentException();
    }
}

