/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.animation;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.Log;
import android.util.Property;
import androidx.collection.SimpleArrayMap;
import com.google.android.material.animation.MotionTiming;
import java.util.ArrayList;
import java.util.List;

public class MotionSpec {
    private static final String TAG = "MotionSpec";
    private final SimpleArrayMap<String, PropertyValuesHolder[]> propertyValues;
    private final SimpleArrayMap<String, MotionTiming> timings = new SimpleArrayMap();

    public MotionSpec() {
        this.propertyValues = new SimpleArrayMap();
    }

    private static void addInfoFromAnimator(MotionSpec object, Animator animator2) {
        if (animator2 instanceof ObjectAnimator) {
            animator2 = (ObjectAnimator)animator2;
            ((MotionSpec)object).setPropertyValues(animator2.getPropertyName(), animator2.getValues());
            ((MotionSpec)object).setTiming(animator2.getPropertyName(), MotionTiming.createFromAnimator((ValueAnimator)animator2));
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Animator must be an ObjectAnimator: ");
        ((StringBuilder)object).append(animator2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    private PropertyValuesHolder[] clonePropertyValuesHolder(PropertyValuesHolder[] propertyValuesHolderArray) {
        PropertyValuesHolder[] propertyValuesHolderArray2 = new PropertyValuesHolder[propertyValuesHolderArray.length];
        for (int i = 0; i < propertyValuesHolderArray.length; ++i) {
            propertyValuesHolderArray2[i] = propertyValuesHolderArray[i].clone();
        }
        return propertyValuesHolderArray2;
    }

    public static MotionSpec createFromAttribute(Context context, TypedArray typedArray, int n) {
        if (typedArray.hasValue(n) && (n = typedArray.getResourceId(n, 0)) != 0) {
            return MotionSpec.createFromResource(context, n);
        }
        return null;
    }

    public static MotionSpec createFromResource(Context object, int n) {
        block4: {
            try {
                object = AnimatorInflater.loadAnimator((Context)object, (int)n);
                if (object instanceof AnimatorSet) {
                    return MotionSpec.createSpecFromAnimators(((AnimatorSet)object).getChildAnimations());
                }
                if (object == null) break block4;
            }
            catch (Exception exception) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Can't load animation resource ID #0x");
                stringBuilder.append(Integer.toHexString(n));
                Log.w((String)TAG, (String)stringBuilder.toString(), (Throwable)exception);
                return null;
            }
            ArrayList<Animator> arrayList = new ArrayList<Animator>();
            arrayList.add((Animator)object);
            object = MotionSpec.createSpecFromAnimators(arrayList);
            return object;
        }
        return null;
    }

    private static MotionSpec createSpecFromAnimators(List<Animator> list) {
        MotionSpec motionSpec = new MotionSpec();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MotionSpec.addInfoFromAnimator(motionSpec, list.get(i));
        }
        return motionSpec;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MotionSpec)) {
            return false;
        }
        object = (MotionSpec)object;
        return this.timings.equals(((MotionSpec)object).timings);
    }

    public <T> ObjectAnimator getAnimator(String string2, T object, Property<T, ?> property) {
        object = ObjectAnimator.ofPropertyValuesHolder(object, (PropertyValuesHolder[])this.getPropertyValues(string2));
        object.setProperty(property);
        this.getTiming(string2).apply((Animator)object);
        return object;
    }

    public PropertyValuesHolder[] getPropertyValues(String string2) {
        if (this.hasPropertyValues(string2)) {
            return this.clonePropertyValuesHolder((PropertyValuesHolder[])this.propertyValues.get((Object)string2));
        }
        throw new IllegalArgumentException();
    }

    public MotionTiming getTiming(String string2) {
        if (this.hasTiming(string2)) {
            return (MotionTiming)this.timings.get((Object)string2);
        }
        throw new IllegalArgumentException();
    }

    public long getTotalDuration() {
        int n = this.timings.size();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            MotionTiming motionTiming = (MotionTiming)this.timings.valueAt(i);
            l = Math.max(l, motionTiming.getDelay() + motionTiming.getDuration());
        }
        return l;
    }

    public boolean hasPropertyValues(String string2) {
        boolean bl = this.propertyValues.get((Object)string2) != null;
        return bl;
    }

    public boolean hasTiming(String string2) {
        boolean bl = this.timings.get((Object)string2) != null;
        return bl;
    }

    public int hashCode() {
        return this.timings.hashCode();
    }

    public void setPropertyValues(String string2, PropertyValuesHolder[] propertyValuesHolderArray) {
        this.propertyValues.put((Object)string2, (Object)propertyValuesHolderArray);
    }

    public void setTiming(String string2, MotionTiming motionTiming) {
        this.timings.put((Object)string2, (Object)motionTiming);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('{');
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" timings: ");
        stringBuilder.append(this.timings);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }
}

