/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.math.MathUtils;
import androidx.core.util.ObjectsCompat;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.appbar.HeaderBehavior;
import com.google.android.material.appbar.HeaderScrollingViewBehavior;
import com.google.android.material.appbar.ViewUtilsLollipop;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class AppBarLayout
extends LinearLayout
implements CoordinatorLayout.AttachedBehavior {
    private static final int DEF_STYLE_RES = R.style.Widget_Design_AppBarLayout;
    private static final int INVALID_SCROLL_RANGE = -1;
    static final int PENDING_ACTION_ANIMATE_ENABLED = 4;
    static final int PENDING_ACTION_COLLAPSED = 2;
    static final int PENDING_ACTION_EXPANDED = 1;
    static final int PENDING_ACTION_FORCE = 8;
    static final int PENDING_ACTION_NONE = 0;
    private int currentOffset;
    private int downPreScrollRange;
    private int downScrollRange;
    private ValueAnimator elevationOverlayAnimator;
    private boolean haveChildWithInterpolator;
    private WindowInsetsCompat lastInsets;
    private boolean liftOnScroll;
    private final List<LiftOnScrollListener> liftOnScrollListeners;
    private WeakReference<View> liftOnScrollTargetView;
    private int liftOnScrollTargetViewId;
    private boolean liftable;
    private boolean liftableOverride;
    private boolean lifted;
    private List<BaseOnOffsetChangedListener> listeners;
    private int pendingAction;
    private Drawable statusBarForeground;
    private int[] tmpStatesArray;
    private int totalScrollRange;

    public AppBarLayout(Context context) {
        this(context, null);
    }

    public AppBarLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.appBarLayoutStyle);
    }

    public AppBarLayout(Context context, AttributeSet object, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, (AttributeSet)object, n, n2), (AttributeSet)object, n);
        this.totalScrollRange = -1;
        this.downPreScrollRange = -1;
        this.downScrollRange = -1;
        this.pendingAction = 0;
        this.liftOnScrollListeners = new ArrayList<LiftOnScrollListener>();
        context = this.getContext();
        this.setOrientation(1);
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.getOutlineProvider() == ViewOutlineProvider.BACKGROUND) {
                ViewUtilsLollipop.setBoundsViewOutlineProvider((View)this);
            }
            ViewUtilsLollipop.setStateListAnimatorFromAttrs((View)this, (AttributeSet)object, n, n2);
        }
        TypedArray typedArray = ThemeEnforcement.obtainStyledAttributes(context, (AttributeSet)object, R.styleable.AppBarLayout, n, n2, new int[0]);
        ViewCompat.setBackground((View)this, (Drawable)typedArray.getDrawable(R.styleable.AppBarLayout_android_background));
        if (this.getBackground() instanceof ColorDrawable) {
            ColorDrawable colorDrawable = (ColorDrawable)this.getBackground();
            object = new MaterialShapeDrawable();
            ((MaterialShapeDrawable)object).setFillColor(ColorStateList.valueOf((int)colorDrawable.getColor()));
            ((MaterialShapeDrawable)object).initializeElevationOverlay(context);
            ViewCompat.setBackground((View)this, (Drawable)object);
        }
        if (typedArray.hasValue(R.styleable.AppBarLayout_expanded)) {
            this.setExpanded(typedArray.getBoolean(R.styleable.AppBarLayout_expanded, false), false, false);
        }
        if (Build.VERSION.SDK_INT >= 21 && typedArray.hasValue(R.styleable.AppBarLayout_elevation)) {
            ViewUtilsLollipop.setDefaultAppBarLayoutStateListAnimator((View)this, typedArray.getDimensionPixelSize(R.styleable.AppBarLayout_elevation, 0));
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (typedArray.hasValue(R.styleable.AppBarLayout_android_keyboardNavigationCluster)) {
                this.setKeyboardNavigationCluster(typedArray.getBoolean(R.styleable.AppBarLayout_android_keyboardNavigationCluster, false));
            }
            if (typedArray.hasValue(R.styleable.AppBarLayout_android_touchscreenBlocksFocus)) {
                this.setTouchscreenBlocksFocus(typedArray.getBoolean(R.styleable.AppBarLayout_android_touchscreenBlocksFocus, false));
            }
        }
        this.liftOnScroll = typedArray.getBoolean(R.styleable.AppBarLayout_liftOnScroll, false);
        this.liftOnScrollTargetViewId = typedArray.getResourceId(R.styleable.AppBarLayout_liftOnScrollTargetViewId, -1);
        this.setStatusBarForeground(typedArray.getDrawable(R.styleable.AppBarLayout_statusBarForeground));
        typedArray.recycle();
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
                return AppBarLayout.this.onWindowInsetChanged(windowInsetsCompat);
            }
        });
    }

    private void clearLiftOnScrollTargetView() {
        WeakReference<View> weakReference = this.liftOnScrollTargetView;
        if (weakReference != null) {
            weakReference.clear();
        }
        this.liftOnScrollTargetView = null;
    }

    private View findLiftOnScrollTargetView(View object) {
        int n;
        View view = this.liftOnScrollTargetView;
        Object var3_3 = null;
        if (view == null && (n = this.liftOnScrollTargetViewId) != -1) {
            object = object != null ? object.findViewById(n) : null;
            view = object;
            if (object == null) {
                view = object;
                if (this.getParent() instanceof ViewGroup) {
                    view = ((ViewGroup)this.getParent()).findViewById(this.liftOnScrollTargetViewId);
                }
            }
            if (view != null) {
                this.liftOnScrollTargetView = new WeakReference<View>(view);
            }
        }
        view = this.liftOnScrollTargetView;
        object = var3_3;
        if (view != null) {
            object = (View)view.get();
        }
        return object;
    }

    private boolean hasCollapsibleChild() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!((LayoutParams)this.getChildAt(i).getLayoutParams()).isCollapsible()) continue;
            return true;
        }
        return false;
    }

    private void invalidateScrollRanges() {
        this.totalScrollRange = -1;
        this.downPreScrollRange = -1;
        this.downScrollRange = -1;
    }

    private void setExpanded(boolean bl, boolean bl2, boolean bl3) {
        int n = bl ? 1 : 2;
        int n2 = 0;
        int n3 = bl2 ? 4 : 0;
        if (bl3) {
            n2 = 8;
        }
        this.pendingAction = n | n3 | n2;
        this.requestLayout();
    }

    private boolean setLiftableState(boolean bl) {
        if (this.liftable != bl) {
            this.liftable = bl;
            this.refreshDrawableState();
            return true;
        }
        return false;
    }

    private boolean shouldDrawStatusBarForeground() {
        boolean bl = this.statusBarForeground != null && this.getTopInset() > 0;
        return bl;
    }

    private boolean shouldOffsetFirstChild() {
        boolean bl;
        int n = this.getChildCount();
        boolean bl2 = bl = false;
        if (n > 0) {
            View view = this.getChildAt(0);
            bl2 = bl;
            if (view.getVisibility() != 8) {
                bl2 = bl;
                if (!ViewCompat.getFitsSystemWindows((View)view)) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private void startLiftOnScrollElevationOverlayAnimation(final MaterialShapeDrawable materialShapeDrawable, boolean bl) {
        float f = this.getResources().getDimension(R.dimen.design_appbar_elevation);
        float f2 = bl ? 0.0f : f;
        if (!bl) {
            f = 0.0f;
        }
        ValueAnimator valueAnimator = this.elevationOverlayAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.elevationOverlayAnimator = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{f2, f});
        valueAnimator.setDuration((long)this.getResources().getInteger(R.integer.app_bar_elevation_anim_duration));
        this.elevationOverlayAnimator.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.elevationOverlayAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator object) {
                float f = ((Float)object.getAnimatedValue()).floatValue();
                materialShapeDrawable.setElevation(f);
                if (AppBarLayout.this.statusBarForeground instanceof MaterialShapeDrawable) {
                    ((MaterialShapeDrawable)AppBarLayout.this.statusBarForeground).setElevation(f);
                }
                object = AppBarLayout.this.liftOnScrollListeners.iterator();
                while (object.hasNext()) {
                    ((LiftOnScrollListener)object.next()).onUpdate(f, materialShapeDrawable.getResolvedTintColor());
                }
            }
        });
        this.elevationOverlayAnimator.start();
    }

    private void updateWillNotDraw() {
        this.setWillNotDraw(this.shouldDrawStatusBarForeground() ^ true);
    }

    public void addLiftOnScrollListener(LiftOnScrollListener liftOnScrollListener) {
        this.liftOnScrollListeners.add(liftOnScrollListener);
    }

    public void addOnOffsetChangedListener(BaseOnOffsetChangedListener baseOnOffsetChangedListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BaseOnOffsetChangedListener>();
        }
        if (baseOnOffsetChangedListener != null && !this.listeners.contains(baseOnOffsetChangedListener)) {
            this.listeners.add(baseOnOffsetChangedListener);
        }
    }

    public void addOnOffsetChangedListener(OnOffsetChangedListener onOffsetChangedListener) {
        this.addOnOffsetChangedListener((BaseOnOffsetChangedListener)onOffsetChangedListener);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public void clearLiftOnScrollListener() {
        this.liftOnScrollListeners.clear();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.shouldDrawStatusBarForeground()) {
            int n = canvas.save();
            canvas.translate(0.0f, (float)(-this.currentOffset));
            this.statusBarForeground.draw(canvas);
            canvas.restoreToCount(n);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] nArray = this.getDrawableState();
        Drawable drawable2 = this.statusBarForeground;
        if (drawable2 != null && drawable2.isStateful() && drawable2.setState(nArray)) {
            this.invalidateDrawable(drawable2);
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT >= 19 && layoutParams instanceof LinearLayout.LayoutParams) {
            return new LayoutParams((LinearLayout.LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    public CoordinatorLayout.Behavior<AppBarLayout> getBehavior() {
        return new Behavior();
    }

    /*
     * Unable to fully structure code
     */
    int getDownNestedPreScrollRange() {
        var1_1 = this.downPreScrollRange;
        if (var1_1 != -1) {
            return var1_1;
        }
        var3_3 = 0;
        for (var2_2 = this.getChildCount() - 1; var2_2 >= 0; --var2_2) {
            var4_4 = this.getChildAt(var2_2);
            var5_5 = (LayoutParams)var4_4.getLayoutParams();
            var6_6 = var4_4.getMeasuredHeight();
            var1_1 = var5_5.scrollFlags;
            if ((var1_1 & 5) == 5) {
                var7_7 = var5_5.topMargin + var5_5.bottomMargin;
                if ((var1_1 & 8) != 0) {
                    var1_1 = ViewCompat.getMinimumHeight((View)var4_4);
lbl14:
                    // 2 sources

                    while (true) {
                        var1_1 = var7_7 + var1_1;
                        break;
                    }
                } else {
                    if ((var1_1 & 2) != 0) {
                        var1_1 = var6_6 - ViewCompat.getMinimumHeight((View)var4_4);
                        ** continue;
                    }
                    var1_1 = var7_7 + var6_6;
                }
                var7_7 = var1_1;
                if (var2_2 == 0) {
                    var7_7 = var1_1;
                    if (ViewCompat.getFitsSystemWindows((View)var4_4)) {
                        var7_7 = Math.min(var1_1, var6_6 - this.getTopInset());
                    }
                }
                var1_1 = var3_3 + var7_7;
            } else {
                var1_1 = var3_3;
                if (var3_3 > 0) break;
            }
            var3_3 = var1_1;
        }
        this.downPreScrollRange = var1_1 = Math.max(0, var3_3);
        return var1_1;
    }

    int getDownNestedScrollRange() {
        int n;
        int n2 = this.downScrollRange;
        if (n2 != -1) {
            return n2;
        }
        int n3 = this.getChildCount();
        int n4 = 0;
        n2 = 0;
        while (true) {
            n = n2;
            if (n4 >= n3) break;
            View view = this.getChildAt(n4);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n5 = view.getMeasuredHeight();
            int n6 = layoutParams.topMargin;
            int n7 = layoutParams.bottomMargin;
            int n8 = layoutParams.scrollFlags;
            n = n2;
            if ((n8 & 1) == 0) break;
            n2 += n5 + (n6 + n7);
            if ((n8 & 2) != 0) {
                n = n2 - ViewCompat.getMinimumHeight((View)view);
                break;
            }
            ++n4;
        }
        this.downScrollRange = n2 = Math.max(0, n);
        return n2;
    }

    public int getLiftOnScrollTargetViewId() {
        return this.liftOnScrollTargetViewId;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getMinimumHeightForVisibleOverlappingContent() {
        int n = this.getTopInset();
        int n2 = ViewCompat.getMinimumHeight((View)this);
        if (n2 != 0) {
            return n2 * 2 + n;
        }
        n2 = this.getChildCount();
        n2 = n2 >= 1 ? ViewCompat.getMinimumHeight((View)this.getChildAt(n2 - 1)) : 0;
        if (n2 == 0) return this.getHeight() / 3;
        return n2 * 2 + n;
    }

    int getPendingAction() {
        return this.pendingAction;
    }

    public Drawable getStatusBarForeground() {
        return this.statusBarForeground;
    }

    @Deprecated
    public float getTargetElevation() {
        return 0.0f;
    }

    final int getTopInset() {
        WindowInsetsCompat windowInsetsCompat = this.lastInsets;
        int n = windowInsetsCompat != null ? windowInsetsCompat.getSystemWindowInsetTop() : 0;
        return n;
    }

    public final int getTotalScrollRange() {
        int n;
        int n2 = this.totalScrollRange;
        if (n2 != -1) {
            return n2;
        }
        int n3 = this.getChildCount();
        int n4 = 0;
        n2 = 0;
        while (true) {
            n = n2;
            if (n4 >= n3) break;
            View view = this.getChildAt(n4);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            int n5 = view.getMeasuredHeight();
            int n6 = layoutParams.scrollFlags;
            n = n2;
            if ((n6 & 1) == 0) break;
            n2 = n = n2 + (n5 + layoutParams.topMargin + layoutParams.bottomMargin);
            if (n4 == 0) {
                n2 = n;
                if (ViewCompat.getFitsSystemWindows((View)view)) {
                    n2 = n - this.getTopInset();
                }
            }
            if ((n6 & 2) != 0) {
                n = n2 - ViewCompat.getMinimumHeight((View)view);
                break;
            }
            ++n4;
        }
        this.totalScrollRange = n2 = Math.max(0, n);
        return n2;
    }

    int getUpNestedPreScrollRange() {
        return this.getTotalScrollRange();
    }

    boolean hasChildWithInterpolator() {
        return this.haveChildWithInterpolator;
    }

    boolean hasScrollableChildren() {
        boolean bl = this.getTotalScrollRange() != 0;
        return bl;
    }

    public boolean isLiftOnScroll() {
        return this.liftOnScroll;
    }

    public boolean isLifted() {
        return this.lifted;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    protected int[] onCreateDrawableState(int n) {
        if (this.tmpStatesArray == null) {
            this.tmpStatesArray = new int[4];
        }
        int[] nArray = this.tmpStatesArray;
        int[] nArray2 = super.onCreateDrawableState(n + nArray.length);
        n = this.liftable ? R.attr.state_liftable : -R.attr.state_liftable;
        nArray[0] = n;
        n = this.liftable && this.lifted ? R.attr.state_lifted : -R.attr.state_lifted;
        nArray[1] = n;
        n = this.liftable ? R.attr.state_collapsible : -R.attr.state_collapsible;
        nArray[2] = n;
        n = this.liftable && this.lifted ? R.attr.state_collapsed : -R.attr.state_collapsed;
        nArray[3] = n;
        return AppBarLayout.mergeDrawableStates((int[])nArray2, (int[])nArray);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearLiftOnScrollTargetView();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        Drawable drawable2;
        super.onLayout(bl, n, n2, n3, n4);
        bl = ViewCompat.getFitsSystemWindows((View)this);
        boolean bl2 = true;
        if (bl && this.shouldOffsetFirstChild()) {
            n2 = this.getTopInset();
            for (n = this.getChildCount() - 1; n >= 0; --n) {
                ViewCompat.offsetTopAndBottom((View)this.getChildAt(n), (int)n2);
            }
        }
        this.invalidateScrollRanges();
        this.haveChildWithInterpolator = false;
        n2 = this.getChildCount();
        for (n = 0; n < n2; ++n) {
            if (((LayoutParams)this.getChildAt(n).getLayoutParams()).getScrollInterpolator() == null) continue;
            this.haveChildWithInterpolator = true;
            break;
        }
        if ((drawable2 = this.statusBarForeground) != null) {
            drawable2.setBounds(0, 0, this.getWidth(), this.getTopInset());
        }
        if (!this.liftableOverride) {
            bl = bl2;
            if (!this.liftOnScroll) {
                bl = this.hasCollapsibleChild() ? bl2 : false;
            }
            this.setLiftableState(bl);
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getMode((int)n2);
        if (n3 != 0x40000000 && ViewCompat.getFitsSystemWindows((View)this) && this.shouldOffsetFirstChild()) {
            n = this.getMeasuredHeight();
            if (n3 != Integer.MIN_VALUE) {
                if (n3 == 0) {
                    n += this.getTopInset();
                }
            } else {
                n = MathUtils.clamp((int)(this.getMeasuredHeight() + this.getTopInset()), (int)0, (int)View.MeasureSpec.getSize((int)n2));
            }
            this.setMeasuredDimension(this.getMeasuredWidth(), n);
        }
        this.invalidateScrollRanges();
    }

    void onOffsetChanged(int n) {
        Object object;
        this.currentOffset = n;
        if (!this.willNotDraw()) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        if ((object = this.listeners) != null) {
            int n2 = object.size();
            for (int i = 0; i < n2; ++i) {
                object = this.listeners.get(i);
                if (object == null) continue;
                object.onOffsetChanged(this, n);
            }
        }
    }

    WindowInsetsCompat onWindowInsetChanged(WindowInsetsCompat windowInsetsCompat) {
        Object object = ViewCompat.getFitsSystemWindows((View)this) ? windowInsetsCompat : null;
        if (!ObjectsCompat.equals((Object)this.lastInsets, (Object)object)) {
            this.lastInsets = object;
            this.updateWillNotDraw();
            this.requestLayout();
        }
        return windowInsetsCompat;
    }

    public boolean removeLiftOnScrollListener(LiftOnScrollListener liftOnScrollListener) {
        return this.liftOnScrollListeners.remove(liftOnScrollListener);
    }

    public void removeOnOffsetChangedListener(BaseOnOffsetChangedListener baseOnOffsetChangedListener) {
        List<BaseOnOffsetChangedListener> list = this.listeners;
        if (list != null && baseOnOffsetChangedListener != null) {
            list.remove(baseOnOffsetChangedListener);
        }
    }

    public void removeOnOffsetChangedListener(OnOffsetChangedListener onOffsetChangedListener) {
        this.removeOnOffsetChangedListener((BaseOnOffsetChangedListener)onOffsetChangedListener);
    }

    void resetPendingAction() {
        this.pendingAction = 0;
    }

    public void setElevation(float f) {
        super.setElevation(f);
        MaterialShapeUtils.setElevation((View)this, f);
    }

    public void setExpanded(boolean bl) {
        this.setExpanded(bl, ViewCompat.isLaidOut((View)this));
    }

    public void setExpanded(boolean bl, boolean bl2) {
        this.setExpanded(bl, bl2, true);
    }

    public void setLiftOnScroll(boolean bl) {
        this.liftOnScroll = bl;
    }

    public void setLiftOnScrollTargetViewId(int n) {
        this.liftOnScrollTargetViewId = n;
        this.clearLiftOnScrollTargetView();
    }

    public boolean setLiftable(boolean bl) {
        this.liftableOverride = true;
        return this.setLiftableState(bl);
    }

    public void setLiftableOverrideEnabled(boolean bl) {
        this.liftableOverride = bl;
    }

    public boolean setLifted(boolean bl) {
        return this.setLiftedState(bl, true);
    }

    boolean setLiftedState(boolean bl) {
        return this.setLiftedState(bl, this.liftableOverride ^ true);
    }

    boolean setLiftedState(boolean bl, boolean bl2) {
        if (bl2 && this.lifted != bl) {
            this.lifted = bl;
            this.refreshDrawableState();
            if (this.liftOnScroll && this.getBackground() instanceof MaterialShapeDrawable) {
                this.startLiftOnScrollElevationOverlayAnimation((MaterialShapeDrawable)this.getBackground(), bl);
            }
            return true;
        }
        return false;
    }

    public void setOrientation(int n) {
        if (n == 1) {
            super.setOrientation(n);
            return;
        }
        throw new IllegalArgumentException("AppBarLayout is always vertical and does not support horizontal orientation");
    }

    public void setStatusBarForeground(Drawable drawable2) {
        Drawable drawable3 = this.statusBarForeground;
        if (drawable3 != drawable2) {
            Drawable drawable4 = null;
            if (drawable3 != null) {
                drawable3.setCallback(null);
            }
            if (drawable2 != null) {
                drawable4 = drawable2.mutate();
            }
            this.statusBarForeground = drawable4;
            if (drawable4 != null) {
                if (drawable4.isStateful()) {
                    this.statusBarForeground.setState(this.getDrawableState());
                }
                DrawableCompat.setLayoutDirection((Drawable)this.statusBarForeground, (int)ViewCompat.getLayoutDirection((View)this));
                drawable2 = this.statusBarForeground;
                boolean bl = this.getVisibility() == 0;
                drawable2.setVisible(bl, false);
                this.statusBarForeground.setCallback((Drawable.Callback)this);
            }
            this.updateWillNotDraw();
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setStatusBarForegroundColor(int n) {
        this.setStatusBarForeground((Drawable)new ColorDrawable(n));
    }

    public void setStatusBarForegroundResource(int n) {
        this.setStatusBarForeground(AppCompatResources.getDrawable((Context)this.getContext(), (int)n));
    }

    @Deprecated
    public void setTargetElevation(float f) {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewUtilsLollipop.setDefaultAppBarLayoutStateListAnimator((View)this, f);
        }
    }

    public void setVisibility(int n) {
        super.setVisibility(n);
        boolean bl = n == 0;
        Drawable drawable2 = this.statusBarForeground;
        if (drawable2 != null) {
            drawable2.setVisible(bl, false);
        }
    }

    boolean shouldLift(View view) {
        View view2 = this.findLiftOnScrollTargetView(view);
        if (view2 != null) {
            view = view2;
        }
        boolean bl = view != null && (view.canScrollVertically(-1) || view.getScrollY() > 0);
        return bl;
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        boolean bl = super.verifyDrawable(drawable2) || drawable2 == this.statusBarForeground;
        return bl;
    }

    protected static class BaseBehavior<T extends AppBarLayout>
    extends HeaderBehavior<T> {
        private static final int MAX_OFFSET_ANIMATION_DURATION = 600;
        private WeakReference<View> lastNestedScrollingChildRef;
        private int lastStartedType;
        private ValueAnimator offsetAnimator;
        private int offsetDelta;
        private BaseDragCallback onDragCallback;
        private SavedState savedState;

        public BaseBehavior() {
        }

        public BaseBehavior(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        private void addAccessibilityScrollActions(final CoordinatorLayout coordinatorLayout, T t, View view) {
            if (this.getTopBottomOffsetForScrollingSibling() != -((AppBarLayout)((Object)t)).getTotalScrollRange() && view.canScrollVertically(1)) {
                this.addActionToExpand(coordinatorLayout, t, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD, false);
            }
            if (this.getTopBottomOffsetForScrollingSibling() != 0) {
                if (view.canScrollVertically(-1)) {
                    int n = -((AppBarLayout)((Object)t)).getDownNestedPreScrollRange();
                    if (n != 0) {
                        ViewCompat.replaceAccessibilityAction((View)coordinatorLayout, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD, null, (AccessibilityViewCommand)new AccessibilityViewCommand((AppBarLayout)((Object)t), view, n){
                            final /* synthetic */ AppBarLayout val$appBarLayout;
                            final /* synthetic */ int val$dy;
                            final /* synthetic */ View val$scrollingView;
                            {
                                this.val$appBarLayout = appBarLayout;
                                this.val$scrollingView = view;
                                this.val$dy = n;
                            }

                            public boolean perform(View view, AccessibilityViewCommand.CommandArguments commandArguments) {
                                BaseBehavior.this.onNestedPreScroll(coordinatorLayout, this.val$appBarLayout, this.val$scrollingView, 0, this.val$dy, new int[]{0, 0}, 1);
                                return true;
                            }
                        });
                    }
                } else {
                    this.addActionToExpand(coordinatorLayout, t, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD, true);
                }
            }
        }

        private void addActionToExpand(CoordinatorLayout coordinatorLayout, T t, AccessibilityNodeInfoCompat.AccessibilityActionCompat accessibilityActionCompat, boolean bl) {
            ViewCompat.replaceAccessibilityAction((View)coordinatorLayout, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)accessibilityActionCompat, null, (AccessibilityViewCommand)new AccessibilityViewCommand((AppBarLayout)((Object)t), bl){
                final /* synthetic */ AppBarLayout val$appBarLayout;
                final /* synthetic */ boolean val$expand;
                {
                    this.val$appBarLayout = appBarLayout;
                    this.val$expand = bl;
                }

                public boolean perform(View view, AccessibilityViewCommand.CommandArguments commandArguments) {
                    this.val$appBarLayout.setExpanded(this.val$expand);
                    return true;
                }
            });
        }

        private void animateOffsetTo(CoordinatorLayout coordinatorLayout, T t, int n, float f) {
            int n2 = Math.abs(this.getTopBottomOffsetForScrollingSibling() - n);
            n2 = (f = Math.abs(f)) > 0.0f ? Math.round((float)n2 / f * 1000.0f) * 3 : (int)(((float)n2 / (float)t.getHeight() + 1.0f) * 150.0f);
            this.animateOffsetWithDuration(coordinatorLayout, t, n, n2);
        }

        private void animateOffsetWithDuration(final CoordinatorLayout coordinatorLayout, T t, int n, int n2) {
            int n3 = this.getTopBottomOffsetForScrollingSibling();
            if (n3 == n) {
                coordinatorLayout = this.offsetAnimator;
                if (coordinatorLayout != null && coordinatorLayout.isRunning()) {
                    this.offsetAnimator.cancel();
                }
                return;
            }
            ValueAnimator valueAnimator = this.offsetAnimator;
            if (valueAnimator == null) {
                this.offsetAnimator = valueAnimator = new ValueAnimator();
                valueAnimator.setInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
                this.offsetAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((AppBarLayout)((Object)t)){
                    final /* synthetic */ AppBarLayout val$child;
                    {
                        this.val$child = appBarLayout;
                    }

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        BaseBehavior.this.setHeaderTopBottomOffset(coordinatorLayout, this.val$child, (Integer)valueAnimator.getAnimatedValue());
                    }
                });
            } else {
                valueAnimator.cancel();
            }
            this.offsetAnimator.setDuration((long)Math.min(n2, 600));
            this.offsetAnimator.setIntValues(new int[]{n3, n});
            this.offsetAnimator.start();
        }

        private boolean canScrollChildren(CoordinatorLayout coordinatorLayout, T t, View view) {
            boolean bl = ((AppBarLayout)((Object)t)).hasScrollableChildren() && coordinatorLayout.getHeight() - view.getHeight() <= t.getHeight();
            return bl;
        }

        private static boolean checkFlag(int n, int n2) {
            boolean bl = (n & n2) == n2;
            return bl;
        }

        private View findFirstScrollingChild(CoordinatorLayout coordinatorLayout) {
            int n = coordinatorLayout.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = coordinatorLayout.getChildAt(i);
                if (!(view instanceof NestedScrollingChild || view instanceof ListView || view instanceof ScrollView)) {
                    continue;
                }
                return view;
            }
            return null;
        }

        private static View getAppBarChildOnOffset(AppBarLayout appBarLayout, int n) {
            int n2 = Math.abs(n);
            int n3 = appBarLayout.getChildCount();
            for (n = 0; n < n3; ++n) {
                View view = appBarLayout.getChildAt(n);
                if (n2 < view.getTop() || n2 > view.getBottom()) continue;
                return view;
            }
            return null;
        }

        private int getChildIndexOnOffset(T t, int n) {
            int n2 = t.getChildCount();
            for (int i = 0; i < n2; ++i) {
                Object object = t.getChildAt(i);
                int n3 = object.getTop();
                int n4 = object.getBottom();
                object = (LayoutParams)object.getLayoutParams();
                int n5 = n3;
                int n6 = n4;
                if (BaseBehavior.checkFlag(((LayoutParams)((Object)object)).getScrollFlags(), 32)) {
                    n5 = n3 - ((LayoutParams)((Object)object)).topMargin;
                    n6 = n4 + ((LayoutParams)((Object)object)).bottomMargin;
                }
                if (n5 > (n4 = -n) || n6 < n4) continue;
                return i;
            }
            return -1;
        }

        private int interpolateOffset(T t, int n) {
            int n2 = Math.abs(n);
            int n3 = t.getChildCount();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                View view = t.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                Interpolator interpolator2 = layoutParams.getScrollInterpolator();
                if (n2 < view.getTop() || n2 > view.getBottom()) continue;
                if (interpolator2 == null) break;
                n3 = layoutParams.getScrollFlags();
                i = n4;
                if ((n3 & 1) != 0) {
                    i = n4 = 0 + (view.getHeight() + layoutParams.topMargin + layoutParams.bottomMargin);
                    if ((n3 & 2) != 0) {
                        i = n4 - ViewCompat.getMinimumHeight((View)view);
                    }
                }
                n4 = i;
                if (ViewCompat.getFitsSystemWindows((View)view)) {
                    n4 = i - ((AppBarLayout)((Object)t)).getTopInset();
                }
                if (n4 <= 0) break;
                i = view.getTop();
                float f = n4;
                i = Math.round(f * interpolator2.getInterpolation((float)(n2 - i) / f));
                return Integer.signum(n) * (view.getTop() + i);
            }
            return n;
        }

        private boolean shouldJumpElevationState(CoordinatorLayout coordinatorLayout, T object) {
            object = coordinatorLayout.getDependents(object);
            int n = object.size();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                coordinatorLayout = ((CoordinatorLayout.LayoutParams)((View)object.get(i)).getLayoutParams()).getBehavior();
                if (!(coordinatorLayout instanceof ScrollingViewBehavior)) continue;
                if (((ScrollingViewBehavior)coordinatorLayout).getOverlayTop() != 0) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        private void snapToChildIfNeeded(CoordinatorLayout coordinatorLayout, T t) {
            View view;
            LayoutParams layoutParams;
            int n;
            int n2 = this.getTopBottomOffsetForScrollingSibling();
            int n3 = this.getChildIndexOnOffset(t, n2);
            if (n3 >= 0 && ((n = (layoutParams = (LayoutParams)(view = t.getChildAt(n3)).getLayoutParams()).getScrollFlags()) & 0x11) == 17) {
                int n4;
                int n5 = -view.getTop();
                int n6 = n4 = -view.getBottom();
                if (n3 == t.getChildCount() - 1) {
                    n6 = n4 + (((AppBarLayout)((Object)t)).getTopInset() + t.getPaddingTop());
                }
                if (BaseBehavior.checkFlag(n, 2)) {
                    n4 = n6 + ViewCompat.getMinimumHeight((View)view);
                    n3 = n5;
                } else {
                    n3 = n5;
                    n4 = n6;
                    if (BaseBehavior.checkFlag(n, 5)) {
                        n4 = ViewCompat.getMinimumHeight((View)view) + n6;
                        if (n2 < n4) {
                            n3 = n4;
                            n4 = n6;
                        } else {
                            n3 = n5;
                        }
                    }
                }
                n5 = n3;
                n6 = n4;
                if (BaseBehavior.checkFlag(n, 32)) {
                    n5 = n3 + layoutParams.topMargin;
                    n6 = n4 - layoutParams.bottomMargin;
                }
                n4 = n5;
                if (n2 < (n6 + n5) / 2) {
                    n4 = n6;
                }
                this.animateOffsetTo(coordinatorLayout, t, MathUtils.clamp((int)n4, (int)(-((AppBarLayout)((Object)t)).getTotalScrollRange()), (int)0), 0.0f);
            }
        }

        private void updateAccessibilityActions(CoordinatorLayout coordinatorLayout, T t) {
            ViewCompat.removeAccessibilityAction((View)coordinatorLayout, (int)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId());
            ViewCompat.removeAccessibilityAction((View)coordinatorLayout, (int)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId());
            View view = this.findFirstScrollingChild(coordinatorLayout);
            if (view != null && ((AppBarLayout)((Object)t)).getTotalScrollRange() != 0) {
                if (!(((CoordinatorLayout.LayoutParams)view.getLayoutParams()).getBehavior() instanceof ScrollingViewBehavior)) {
                    return;
                }
                this.addAccessibilityScrollActions(coordinatorLayout, t, view);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void updateAppBarLayoutDrawableState(CoordinatorLayout coordinatorLayout, T t, int n, int n2, boolean bl) {
            boolean bl2;
            block5: {
                block7: {
                    int n3;
                    int n4;
                    boolean bl3;
                    View view;
                    block6: {
                        view = BaseBehavior.getAppBarChildOnOffset(t, n);
                        bl2 = bl3 = false;
                        if (view == null) break block5;
                        n4 = ((LayoutParams)view.getLayoutParams()).getScrollFlags();
                        bl2 = bl3;
                        if ((n4 & 1) == 0) break block5;
                        n3 = ViewCompat.getMinimumHeight((View)view);
                        if (n2 <= 0 || (n4 & 0xC) == 0) break block6;
                        bl2 = bl3;
                        if (-n < view.getBottom() - n3 - ((AppBarLayout)((Object)t)).getTopInset()) break block5;
                        break block7;
                    }
                    bl2 = bl3;
                    if ((n4 & 2) == 0) break block5;
                    bl2 = bl3;
                    if (-n < view.getBottom() - n3 - ((AppBarLayout)((Object)t)).getTopInset()) break block5;
                }
                bl2 = true;
            }
            if (((AppBarLayout)((Object)t)).isLiftOnScroll()) {
                bl2 = ((AppBarLayout)((Object)t)).shouldLift(this.findFirstScrollingChild(coordinatorLayout));
            }
            bl2 = ((AppBarLayout)((Object)t)).setLiftedState(bl2);
            if (bl || bl2 && this.shouldJumpElevationState(coordinatorLayout, t)) {
                t.jumpDrawablesToCurrentState();
            }
        }

        @Override
        boolean canDragView(T object) {
            boolean bl;
            BaseDragCallback baseDragCallback = this.onDragCallback;
            if (baseDragCallback != null) {
                return baseDragCallback.canDrag(object);
            }
            object = this.lastNestedScrollingChildRef;
            boolean bl2 = bl = true;
            if (object != null) {
                bl2 = (object = (View)((Reference)object).get()) != null && object.isShown() && !object.canScrollVertically(-1) ? bl : false;
            }
            return bl2;
        }

        @Override
        int getMaxDragOffset(T t) {
            return -((AppBarLayout)((Object)t)).getDownNestedScrollRange();
        }

        @Override
        int getScrollRangeForDragFling(T t) {
            return ((AppBarLayout)((Object)t)).getTotalScrollRange();
        }

        @Override
        int getTopBottomOffsetForScrollingSibling() {
            return this.getTopAndBottomOffset() + this.offsetDelta;
        }

        boolean isOffsetAnimatorRunning() {
            ValueAnimator valueAnimator = this.offsetAnimator;
            boolean bl = valueAnimator != null && valueAnimator.isRunning();
            return bl;
        }

        @Override
        void onFlingFinished(CoordinatorLayout coordinatorLayout, T t) {
            this.snapToChildIfNeeded(coordinatorLayout, t);
            if (((AppBarLayout)((Object)t)).isLiftOnScroll()) {
                ((AppBarLayout)((Object)t)).setLiftedState(((AppBarLayout)((Object)t)).shouldLift(this.findFirstScrollingChild(coordinatorLayout)));
            }
        }

        @Override
        public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, T t, int n) {
            boolean bl = super.onLayoutChild(coordinatorLayout, t, n);
            int n2 = ((AppBarLayout)((Object)t)).getPendingAction();
            SavedState savedState = this.savedState;
            if (savedState != null && (n2 & 8) == 0) {
                if (savedState.fullyScrolled) {
                    this.setHeaderTopBottomOffset(coordinatorLayout, t, -((AppBarLayout)((Object)t)).getTotalScrollRange());
                } else {
                    savedState = t.getChildAt(this.savedState.firstVisibleChildIndex);
                    n2 = -savedState.getBottom();
                    n = this.savedState.firstVisibleChildAtMinimumHeight ? ViewCompat.getMinimumHeight((View)savedState) + ((AppBarLayout)((Object)t)).getTopInset() : Math.round((float)savedState.getHeight() * this.savedState.firstVisibleChildPercentageShown);
                    this.setHeaderTopBottomOffset(coordinatorLayout, t, n2 + n);
                }
            } else if (n2 != 0) {
                n = (n2 & 4) != 0 ? 1 : 0;
                if ((n2 & 2) != 0) {
                    n2 = -((AppBarLayout)((Object)t)).getUpNestedPreScrollRange();
                    if (n != 0) {
                        this.animateOffsetTo(coordinatorLayout, t, n2, 0.0f);
                    } else {
                        this.setHeaderTopBottomOffset(coordinatorLayout, t, n2);
                    }
                } else if ((n2 & 1) != 0) {
                    if (n != 0) {
                        this.animateOffsetTo(coordinatorLayout, t, 0, 0.0f);
                    } else {
                        this.setHeaderTopBottomOffset(coordinatorLayout, t, 0);
                    }
                }
            }
            ((AppBarLayout)((Object)t)).resetPendingAction();
            this.savedState = null;
            this.setTopAndBottomOffset(MathUtils.clamp((int)this.getTopAndBottomOffset(), (int)(-((AppBarLayout)((Object)t)).getTotalScrollRange()), (int)0));
            this.updateAppBarLayoutDrawableState(coordinatorLayout, t, this.getTopAndBottomOffset(), 0, true);
            ((AppBarLayout)((Object)t)).onOffsetChanged(this.getTopAndBottomOffset());
            this.updateAccessibilityActions(coordinatorLayout, t);
            return bl;
        }

        public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, T t, int n, int n2, int n3, int n4) {
            if (((CoordinatorLayout.LayoutParams)t.getLayoutParams()).height == -2) {
                coordinatorLayout.onMeasureChild(t, n, n2, View.MeasureSpec.makeMeasureSpec((int)0, (int)0), n4);
                return true;
            }
            return super.onMeasureChild(coordinatorLayout, t, n, n2, n3, n4);
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, T t, View view, int n, int n2, int[] nArray, int n3) {
            if (n2 != 0) {
                if (n2 < 0) {
                    n3 = -((AppBarLayout)((Object)t)).getTotalScrollRange();
                    int n4 = ((AppBarLayout)((Object)t)).getDownNestedPreScrollRange();
                    n = n3;
                    n4 += n3;
                    n3 = n;
                    n = n4;
                } else {
                    n3 = -((AppBarLayout)((Object)t)).getUpNestedPreScrollRange();
                    n = 0;
                }
                if (n3 != n) {
                    nArray[1] = this.scroll(coordinatorLayout, t, n2, n3, n);
                }
            }
            if (((AppBarLayout)((Object)t)).isLiftOnScroll()) {
                ((AppBarLayout)((Object)t)).setLiftedState(((AppBarLayout)((Object)t)).shouldLift(view));
            }
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, T t, View view, int n, int n2, int n3, int n4, int n5, int[] nArray) {
            if (n4 < 0) {
                nArray[1] = this.scroll(coordinatorLayout, t, n4, -((AppBarLayout)((Object)t)).getDownNestedScrollRange(), 0);
            }
            if (n4 == 0) {
                this.updateAccessibilityActions(coordinatorLayout, t);
            }
        }

        public void onRestoreInstanceState(CoordinatorLayout coordinatorLayout, T t, Parcelable object) {
            if (object instanceof SavedState) {
                object = (SavedState)((Object)object);
                this.savedState = object;
                super.onRestoreInstanceState(coordinatorLayout, t, object.getSuperState());
            } else {
                super.onRestoreInstanceState(coordinatorLayout, t, object);
                this.savedState = null;
            }
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout coordinatorLayout, T t) {
            Object object = super.onSaveInstanceState(coordinatorLayout, t);
            int n = this.getTopAndBottomOffset();
            int n2 = t.getChildCount();
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                coordinatorLayout = t.getChildAt(i);
                int n3 = coordinatorLayout.getBottom() + n;
                if (coordinatorLayout.getTop() + n > 0 || n3 < 0) continue;
                object = new SavedState((Parcelable)object);
                boolean bl2 = -this.getTopAndBottomOffset() >= ((AppBarLayout)((Object)t)).getTotalScrollRange();
                object.fullyScrolled = bl2;
                object.firstVisibleChildIndex = i;
                bl2 = bl;
                if (n3 == ViewCompat.getMinimumHeight((View)coordinatorLayout) + ((AppBarLayout)((Object)t)).getTopInset()) {
                    bl2 = true;
                }
                object.firstVisibleChildAtMinimumHeight = bl2;
                object.firstVisibleChildPercentageShown = (float)n3 / (float)coordinatorLayout.getHeight();
                return object;
            }
            return object;
        }

        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, T t, View view, View view2, int n, int n2) {
            boolean bl = (n & 2) != 0 && (((AppBarLayout)((Object)t)).isLiftOnScroll() || this.canScrollChildren(coordinatorLayout, t, view));
            if (bl && (coordinatorLayout = this.offsetAnimator) != null) {
                coordinatorLayout.cancel();
            }
            this.lastNestedScrollingChildRef = null;
            this.lastStartedType = n2;
            return bl;
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, T t, View view, int n) {
            if (this.lastStartedType == 0 || n == 1) {
                this.snapToChildIfNeeded(coordinatorLayout, t);
                if (((AppBarLayout)((Object)t)).isLiftOnScroll()) {
                    ((AppBarLayout)((Object)t)).setLiftedState(((AppBarLayout)((Object)t)).shouldLift(view));
                }
            }
            this.lastNestedScrollingChildRef = new WeakReference<View>(view);
        }

        public void setDragCallback(BaseDragCallback baseDragCallback) {
            this.onDragCallback = baseDragCallback;
        }

        @Override
        int setHeaderTopBottomOffset(CoordinatorLayout coordinatorLayout, T t, int n, int n2, int n3) {
            int n4 = this.getTopBottomOffsetForScrollingSibling();
            int n5 = 0;
            int n6 = 0;
            if (n2 != 0 && n4 >= n2 && n4 <= n3) {
                n2 = MathUtils.clamp((int)n, (int)n2, (int)n3);
                n = n5;
                if (n4 != n2) {
                    n = ((AppBarLayout)((Object)t)).hasChildWithInterpolator() ? this.interpolateOffset(t, n2) : n2;
                    boolean bl = this.setTopAndBottomOffset(n);
                    this.offsetDelta = n2 - n;
                    if (bl) {
                        for (n = n6; n < t.getChildCount(); ++n) {
                            LayoutParams layoutParams = (LayoutParams)t.getChildAt(n).getLayoutParams();
                            ChildScrollEffect childScrollEffect = layoutParams.getScrollEffect();
                            if (childScrollEffect == null || (layoutParams.getScrollFlags() & 1) == 0) continue;
                            childScrollEffect.onOffsetChanged((AppBarLayout)((Object)t), t.getChildAt(n), this.getTopAndBottomOffset());
                        }
                    }
                    if (!bl && ((AppBarLayout)((Object)t)).hasChildWithInterpolator()) {
                        coordinatorLayout.dispatchDependentViewsChanged(t);
                    }
                    ((AppBarLayout)((Object)t)).onOffsetChanged(this.getTopAndBottomOffset());
                    n = n2 < n4 ? -1 : 1;
                    this.updateAppBarLayoutDrawableState(coordinatorLayout, t, n2, n, false);
                    n = n4 - n2;
                }
            } else {
                this.offsetDelta = 0;
                n = n5;
            }
            this.updateAccessibilityActions(coordinatorLayout, t);
            return n;
        }

        public static abstract class BaseDragCallback<T extends AppBarLayout> {
            public abstract boolean canDrag(T var1);
        }

        protected static class SavedState
        extends AbsSavedState {
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

                public SavedState createFromParcel(Parcel parcel) {
                    return new SavedState(parcel, null);
                }

                public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                    return new SavedState(parcel, classLoader);
                }

                public SavedState[] newArray(int n) {
                    return new SavedState[n];
                }
            };
            boolean firstVisibleChildAtMinimumHeight;
            int firstVisibleChildIndex;
            float firstVisibleChildPercentageShown;
            boolean fullyScrolled;

            public SavedState(Parcel parcel, ClassLoader classLoader) {
                super(parcel, classLoader);
                byte by = parcel.readByte();
                boolean bl = true;
                boolean bl2 = by != 0;
                this.fullyScrolled = bl2;
                this.firstVisibleChildIndex = parcel.readInt();
                this.firstVisibleChildPercentageShown = parcel.readFloat();
                bl2 = parcel.readByte() != 0 ? bl : false;
                this.firstVisibleChildAtMinimumHeight = bl2;
            }

            public SavedState(Parcelable parcelable) {
                super(parcelable);
            }

            public void writeToParcel(Parcel parcel, int n) {
                super.writeToParcel(parcel, n);
                parcel.writeByte((byte)(this.fullyScrolled ? 1 : 0));
                parcel.writeInt(this.firstVisibleChildIndex);
                parcel.writeFloat(this.firstVisibleChildPercentageShown);
                parcel.writeByte((byte)(this.firstVisibleChildAtMinimumHeight ? 1 : 0));
            }
        }
    }

    public static interface BaseOnOffsetChangedListener<T extends AppBarLayout> {
        public void onOffsetChanged(T var1, int var2);
    }

    public static class Behavior
    extends BaseBehavior<AppBarLayout> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public static abstract class DragCallback
        extends BaseBehavior.BaseDragCallback<AppBarLayout> {
        }
    }

    public static abstract class ChildScrollEffect {
        public abstract void onOffsetChanged(AppBarLayout var1, View var2, float var3);
    }

    public static class CompressChildScrollEffect
    extends ChildScrollEffect {
        private static final float COMPRESS_DISTANCE_FACTOR = 0.3f;
        private final Rect ghostRect;
        private final Rect relativeRect = new Rect();

        public CompressChildScrollEffect() {
            this.ghostRect = new Rect();
        }

        private static void updateRelativeRect(Rect rect, AppBarLayout appBarLayout, View view) {
            view.getDrawingRect(rect);
            appBarLayout.offsetDescendantRectToMyCoords(view, rect);
            rect.offset(0, -appBarLayout.getTopInset());
        }

        @Override
        public void onOffsetChanged(AppBarLayout appBarLayout, View view, float f) {
            CompressChildScrollEffect.updateRelativeRect(this.relativeRect, appBarLayout, view);
            f = (float)this.relativeRect.top - Math.abs(f);
            if (f <= 0.0f) {
                float f2 = MathUtils.clamp((float)Math.abs(f / (float)this.relativeRect.height()), (float)0.0f, (float)1.0f);
                f = -f;
                f2 = 1.0f - f2;
                view.setTranslationY(f -= (float)this.relativeRect.height() * 0.3f * (1.0f - f2 * f2));
                view.getDrawingRect(this.ghostRect);
                this.ghostRect.offset(0, (int)(-f));
                ViewCompat.setClipBounds((View)view, (Rect)this.ghostRect);
            } else {
                ViewCompat.setClipBounds((View)view, null);
                view.setTranslationY(0.0f);
            }
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        static final int COLLAPSIBLE_FLAGS = 10;
        static final int FLAG_QUICK_RETURN = 5;
        static final int FLAG_SNAP = 17;
        private static final int SCROLL_EFFECT_COMPRESS = 1;
        private static final int SCROLL_EFFECT_NONE = 0;
        public static final int SCROLL_FLAG_ENTER_ALWAYS = 4;
        public static final int SCROLL_FLAG_ENTER_ALWAYS_COLLAPSED = 8;
        public static final int SCROLL_FLAG_EXIT_UNTIL_COLLAPSED = 2;
        public static final int SCROLL_FLAG_NO_SCROLL = 0;
        public static final int SCROLL_FLAG_SCROLL = 1;
        public static final int SCROLL_FLAG_SNAP = 16;
        public static final int SCROLL_FLAG_SNAP_MARGINS = 32;
        private ChildScrollEffect scrollEffect;
        int scrollFlags = 1;
        Interpolator scrollInterpolator;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2, f);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.AppBarLayout_Layout);
            this.scrollFlags = attributeSet.getInt(R.styleable.AppBarLayout_Layout_layout_scrollFlags, 0);
            this.setScrollEffect(this.createScrollEffectFromInt(attributeSet.getInt(R.styleable.AppBarLayout_Layout_layout_scrollEffect, 0)));
            if (attributeSet.hasValue(R.styleable.AppBarLayout_Layout_layout_scrollInterpolator)) {
                this.scrollInterpolator = android.view.animation.AnimationUtils.loadInterpolator((Context)context, (int)attributeSet.getResourceId(R.styleable.AppBarLayout_Layout_layout_scrollInterpolator, 0));
            }
            attributeSet.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LinearLayout.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((LinearLayout.LayoutParams)layoutParams);
            this.scrollFlags = layoutParams.scrollFlags;
            this.scrollInterpolator = layoutParams.scrollInterpolator;
        }

        private ChildScrollEffect createScrollEffectFromInt(int n) {
            if (n != 1) {
                return null;
            }
            return new CompressChildScrollEffect();
        }

        public ChildScrollEffect getScrollEffect() {
            return this.scrollEffect;
        }

        public int getScrollFlags() {
            return this.scrollFlags;
        }

        public Interpolator getScrollInterpolator() {
            return this.scrollInterpolator;
        }

        boolean isCollapsible() {
            int n = this.scrollFlags;
            boolean bl = true;
            if ((n & 1) != 1 || (n & 0xA) == 0) {
                bl = false;
            }
            return bl;
        }

        public void setScrollEffect(ChildScrollEffect childScrollEffect) {
            this.scrollEffect = childScrollEffect;
        }

        public void setScrollFlags(int n) {
            this.scrollFlags = n;
        }

        public void setScrollInterpolator(Interpolator interpolator2) {
            this.scrollInterpolator = interpolator2;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ScrollFlags {
        }
    }

    public static interface LiftOnScrollListener {
        public void onUpdate(float var1, int var2);
    }

    public static interface OnOffsetChangedListener
    extends BaseOnOffsetChangedListener<AppBarLayout> {
        @Override
        public void onOffsetChanged(AppBarLayout var1, int var2);
    }

    public static class ScrollingViewBehavior
    extends HeaderScrollingViewBehavior {
        public ScrollingViewBehavior() {
        }

        public ScrollingViewBehavior(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, R.styleable.ScrollingViewBehavior_Layout);
            this.setOverlayTop(context.getDimensionPixelSize(R.styleable.ScrollingViewBehavior_Layout_behavior_overlapTop, 0));
            context.recycle();
        }

        private static int getAppBarLayoutOffset(AppBarLayout appBarLayout) {
            if ((appBarLayout = ((CoordinatorLayout.LayoutParams)appBarLayout.getLayoutParams()).getBehavior()) instanceof BaseBehavior) {
                return ((BaseBehavior)((Object)appBarLayout)).getTopBottomOffsetForScrollingSibling();
            }
            return 0;
        }

        private void offsetChildAsNeeded(View view, View view2) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)view2.getLayoutParams()).getBehavior();
            if (behavior instanceof BaseBehavior) {
                behavior = (BaseBehavior)behavior;
                ViewCompat.offsetTopAndBottom((View)view, (int)(view2.getBottom() - view.getTop() + ((BaseBehavior)behavior).offsetDelta + this.getVerticalLayoutGap() - this.getOverlapPixelsForOffset(view2)));
            }
        }

        private void updateLiftedStateIfNeeded(View view, View object) {
            if (object instanceof AppBarLayout && ((AppBarLayout)((Object)(object = (AppBarLayout)((Object)object)))).isLiftOnScroll()) {
                ((AppBarLayout)((Object)object)).setLiftedState(((AppBarLayout)((Object)object)).shouldLift(view));
            }
        }

        AppBarLayout findFirstDependency(List<View> list) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                View view = list.get(i);
                if (!(view instanceof AppBarLayout)) continue;
                return (AppBarLayout)view;
            }
            return null;
        }

        @Override
        float getOverlapRatioForOffset(View object) {
            if (object instanceof AppBarLayout) {
                object = (AppBarLayout)((Object)object);
                int n = ((AppBarLayout)((Object)object)).getTotalScrollRange();
                int n2 = ((AppBarLayout)((Object)object)).getDownNestedPreScrollRange();
                int n3 = ScrollingViewBehavior.getAppBarLayoutOffset((AppBarLayout)((Object)object));
                if (n2 != 0 && n + n3 <= n2) {
                    return 0.0f;
                }
                if ((n -= n2) != 0) {
                    return (float)n3 / (float)n + 1.0f;
                }
            }
            return 0.0f;
        }

        @Override
        int getScrollRange(View view) {
            if (view instanceof AppBarLayout) {
                return ((AppBarLayout)view).getTotalScrollRange();
            }
            return super.getScrollRange(view);
        }

        public boolean layoutDependsOn(CoordinatorLayout coordinatorLayout, View view, View view2) {
            return view2 instanceof AppBarLayout;
        }

        public boolean onDependentViewChanged(CoordinatorLayout coordinatorLayout, View view, View view2) {
            this.offsetChildAsNeeded(view, view2);
            this.updateLiftedStateIfNeeded(view, view2);
            return false;
        }

        public void onDependentViewRemoved(CoordinatorLayout coordinatorLayout, View view, View view2) {
            if (view2 instanceof AppBarLayout) {
                ViewCompat.removeAccessibilityAction((View)coordinatorLayout, (int)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_FORWARD.getId());
                ViewCompat.removeAccessibilityAction((View)coordinatorLayout, (int)AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_SCROLL_BACKWARD.getId());
            }
        }

        public boolean onRequestChildRectangleOnScreen(CoordinatorLayout coordinatorLayout, View view, Rect rect, boolean bl) {
            AppBarLayout appBarLayout = this.findFirstDependency((List<View>)coordinatorLayout.getDependencies(view));
            if (appBarLayout != null) {
                rect.offset(view.getLeft(), view.getTop());
                view = this.tempRect1;
                view.set(0, 0, coordinatorLayout.getWidth(), coordinatorLayout.getHeight());
                if (!view.contains(rect)) {
                    appBarLayout.setExpanded(false, bl ^ true);
                    return true;
                }
            }
            return false;
        }
    }
}

