/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.OverScroller;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.ViewCompat;
import com.google.android.material.appbar.ViewOffsetBehavior;

abstract class HeaderBehavior<V extends View>
extends ViewOffsetBehavior<V> {
    private static final int INVALID_POINTER = -1;
    private int activePointerId = -1;
    private Runnable flingRunnable;
    private boolean isBeingDragged;
    private int lastMotionY;
    OverScroller scroller;
    private int touchSlop = -1;
    private VelocityTracker velocityTracker;

    public HeaderBehavior() {
    }

    public HeaderBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private void ensureVelocityTracker() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    boolean canDragView(V v) {
        return false;
    }

    final boolean fling(CoordinatorLayout object, V v, int n, int n2, float f) {
        Runnable runnable = this.flingRunnable;
        if (runnable != null) {
            v.removeCallbacks(runnable);
            this.flingRunnable = null;
        }
        if (this.scroller == null) {
            this.scroller = new OverScroller(v.getContext());
        }
        this.scroller.fling(0, this.getTopAndBottomOffset(), 0, Math.round(f), 0, 0, n, n2);
        if (this.scroller.computeScrollOffset()) {
            object = new FlingRunnable(this, object, v);
            this.flingRunnable = object;
            ViewCompat.postOnAnimation(v, (Runnable)object);
            return true;
        }
        this.onFlingFinished((CoordinatorLayout)object, v);
        return false;
    }

    int getMaxDragOffset(V v) {
        return -v.getHeight();
    }

    int getScrollRangeForDragFling(V v) {
        return v.getHeight();
    }

    int getTopBottomOffsetForScrollingSibling() {
        return this.getTopAndBottomOffset();
    }

    void onFlingFinished(CoordinatorLayout coordinatorLayout, V v) {
    }

    public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
        int n;
        if (this.touchSlop < 0) {
            this.touchSlop = ViewConfiguration.get((Context)coordinatorLayout.getContext()).getScaledTouchSlop();
        }
        if (motionEvent.getActionMasked() == 2 && this.isBeingDragged) {
            n = this.activePointerId;
            if (n == -1) {
                return false;
            }
            if ((n = motionEvent.findPointerIndex(n)) == -1) {
                return false;
            }
            if (Math.abs((n = (int)motionEvent.getY(n)) - this.lastMotionY) > this.touchSlop) {
                this.lastMotionY = n;
                return true;
            }
        }
        if (motionEvent.getActionMasked() == 0) {
            this.activePointerId = -1;
            int n2 = (int)motionEvent.getX();
            n = (int)motionEvent.getY();
            boolean bl = this.canDragView(v) && coordinatorLayout.isPointInChildBounds(v, n2, n);
            this.isBeingDragged = bl;
            if (bl) {
                this.lastMotionY = n;
                this.activePointerId = motionEvent.getPointerId(0);
                this.ensureVelocityTracker();
                coordinatorLayout = this.scroller;
                if (coordinatorLayout != null && !coordinatorLayout.isFinished()) {
                    this.scroller.abortAnimation();
                    return true;
                }
            }
        }
        if ((coordinatorLayout = this.velocityTracker) != null) {
            coordinatorLayout.addMovement(motionEvent);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(CoordinatorLayout var1_1, V var2_2, MotionEvent var3_3) {
        block10: {
            block7: {
                block9: {
                    block8: {
                        var4_4 = var3_3.getActionMasked();
                        var5_5 = true;
                        if (var4_4 == 1) break block7;
                        if (var4_4 == 2) break block8;
                        if (var4_4 == 3) ** GOTO lbl-1000
                        if (var4_4 == 6) {
                            var4_4 = var3_3.getActionIndex() == 0 ? 1 : 0;
                            this.activePointerId = var3_3.getPointerId(var4_4);
                            this.lastMotionY = (int)(var3_3.getY(var4_4) + 0.5f);
                        }
                        break block9;
                    }
                    var4_4 = var3_3.findPointerIndex(this.activePointerId);
                    if (var4_4 == -1) {
                        return false;
                    }
                    var4_4 = (int)var3_3.getY(var4_4);
                    var6_6 = this.lastMotionY;
                    this.lastMotionY = var4_4;
                    this.scroll(var1_1, var2_2, var6_6 - var4_4, this.getMaxDragOffset(var2_2), 0);
                }
                var6_6 = 0;
                break block10;
            }
            var7_7 = this.velocityTracker;
            if (var7_7 != null) {
                var7_7.addMovement(var3_3);
                this.velocityTracker.computeCurrentVelocity(1000);
                var8_8 = this.velocityTracker.getYVelocity(this.activePointerId);
                this.fling(var1_1, var2_2, -this.getScrollRangeForDragFling(var2_2), 0, var8_8);
                var4_4 = 1;
            } else lbl-1000:
            // 2 sources

            {
                var4_4 = 0;
            }
            this.isBeingDragged = false;
            this.activePointerId = -1;
            var1_1 = this.velocityTracker;
            var6_6 = var4_4;
            if (var1_1 != null) {
                var1_1.recycle();
                this.velocityTracker = null;
                var6_6 = var4_4;
            }
        }
        var1_1 = this.velocityTracker;
        if (var1_1 != null) {
            var1_1.addMovement(var3_3);
        }
        var9_9 = var5_5;
        if (!this.isBeingDragged) {
            var9_9 = var6_6 != 0 ? var5_5 : false;
        }
        return var9_9;
    }

    final int scroll(CoordinatorLayout coordinatorLayout, V v, int n, int n2, int n3) {
        return this.setHeaderTopBottomOffset(coordinatorLayout, v, this.getTopBottomOffsetForScrollingSibling() - n, n2, n3);
    }

    int setHeaderTopBottomOffset(CoordinatorLayout coordinatorLayout, V v, int n) {
        return this.setHeaderTopBottomOffset(coordinatorLayout, v, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    int setHeaderTopBottomOffset(CoordinatorLayout coordinatorLayout, V v, int n, int n2, int n3) {
        int n4 = this.getTopAndBottomOffset();
        if (n2 != 0 && n4 >= n2 && n4 <= n3 && n4 != (n = MathUtils.clamp((int)n, (int)n2, (int)n3))) {
            this.setTopAndBottomOffset(n);
            n = n4 - n;
        } else {
            n = 0;
        }
        return n;
    }

    private static class FlingRunnable
    implements Runnable {
        private final V layout;
        private final CoordinatorLayout parent;
        final /* synthetic */ HeaderBehavior this$0;

        FlingRunnable(CoordinatorLayout coordinatorLayout, V v) {
            this.this$0 = var1_1;
            this.parent = coordinatorLayout;
            this.layout = v;
        }

        @Override
        public void run() {
            if (this.layout != null && this.this$0.scroller != null) {
                if (this.this$0.scroller.computeScrollOffset()) {
                    HeaderBehavior headerBehavior = this.this$0;
                    headerBehavior.setHeaderTopBottomOffset(this.parent, this.layout, headerBehavior.scroller.getCurrY());
                    ViewCompat.postOnAnimation(this.layout, (Runnable)this);
                } else {
                    this.this$0.onFlingFinished(this.parent, this.layout);
                }
            }
        }
    }
}

