/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.badge;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.TextDrawableHelper;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.shape.MaterialShapeDrawable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;

public class BadgeDrawable
extends Drawable
implements TextDrawableHelper.TextDrawableDelegate {
    private static final int BADGE_NUMBER_NONE = -1;
    public static final int BOTTOM_END = 0x800055;
    public static final int BOTTOM_START = 8388691;
    static final String DEFAULT_EXCEED_MAX_BADGE_NUMBER_SUFFIX = "+";
    private static final int DEFAULT_MAX_BADGE_CHARACTER_COUNT = 4;
    private static final int DEFAULT_STYLE = R.style.Widget_MaterialComponents_Badge;
    private static final int DEFAULT_THEME_ATTR = R.attr.badgeStyle;
    private static final int MAX_CIRCULAR_BADGE_NUMBER_COUNT = 9;
    public static final int TOP_END = 8388661;
    public static final int TOP_START = 0x800033;
    private WeakReference<View> anchorViewRef;
    private final Rect badgeBounds;
    private float badgeCenterX;
    private float badgeCenterY;
    private float badgeRadius;
    private float badgeWidePadding;
    private float badgeWithTextRadius;
    private final WeakReference<Context> contextRef;
    private float cornerRadius;
    private WeakReference<FrameLayout> customBadgeParentRef;
    private float halfBadgeHeight;
    private float halfBadgeWidth;
    private int maxBadgeNumber;
    private final SavedState savedState;
    private final MaterialShapeDrawable shapeDrawable;
    private final TextDrawableHelper textDrawableHelper;

    private BadgeDrawable(Context context) {
        this.contextRef = new WeakReference<Context>(context);
        ThemeEnforcement.checkMaterialTheme(context);
        Object object = context.getResources();
        this.badgeBounds = new Rect();
        this.shapeDrawable = new MaterialShapeDrawable();
        this.badgeRadius = object.getDimensionPixelSize(R.dimen.mtrl_badge_radius);
        this.badgeWidePadding = object.getDimensionPixelSize(R.dimen.mtrl_badge_long_text_horizontal_padding);
        this.badgeWithTextRadius = object.getDimensionPixelSize(R.dimen.mtrl_badge_with_text_radius);
        object = new TextDrawableHelper(this);
        this.textDrawableHelper = object;
        ((TextDrawableHelper)object).getTextPaint().setTextAlign(Paint.Align.CENTER);
        this.savedState = new SavedState(context);
        this.setTextAppearanceResource(R.style.TextAppearance_MaterialComponents_Badge);
    }

    private void calculateCenterAndBounds(Context context, Rect rect, View view) {
        float f;
        int n = this.getTotalVerticalOffsetForState();
        int n2 = this.savedState.badgeGravity;
        this.badgeCenterY = n2 != 8388691 && n2 != 0x800055 ? (float)(rect.top + n) : (float)(rect.bottom - n);
        if (this.getNumber() <= 9) {
            f = !this.hasNumber() ? this.badgeRadius : this.badgeWithTextRadius;
            this.cornerRadius = f;
            this.halfBadgeHeight = f;
            this.halfBadgeWidth = f;
        } else {
            this.cornerRadius = f = this.badgeWithTextRadius;
            this.halfBadgeHeight = f;
            String string2 = this.getBadgeText();
            this.halfBadgeWidth = this.textDrawableHelper.getTextWidth(string2) / 2.0f + this.badgeWidePadding;
        }
        context = context.getResources();
        n2 = this.hasNumber() ? R.dimen.mtrl_badge_text_horizontal_edge_offset : R.dimen.mtrl_badge_horizontal_edge_offset;
        int n3 = context.getDimensionPixelSize(n2);
        n = this.getTotalHorizontalOffsetForState();
        n2 = this.savedState.badgeGravity;
        if (n2 != 0x800033 && n2 != 8388691) {
            f = ViewCompat.getLayoutDirection((View)view) == 0 ? (float)rect.right + this.halfBadgeWidth - (float)n3 - (float)n : (float)rect.left - this.halfBadgeWidth + (float)n3 + (float)n;
            this.badgeCenterX = f;
        } else {
            f = ViewCompat.getLayoutDirection((View)view) == 0 ? (float)rect.left - this.halfBadgeWidth + (float)n3 + (float)n : (float)rect.right + this.halfBadgeWidth - (float)n3 - (float)n;
            this.badgeCenterX = f;
        }
    }

    public static BadgeDrawable create(Context context) {
        return BadgeDrawable.createFromAttributes(context, null, DEFAULT_THEME_ATTR, DEFAULT_STYLE);
    }

    private static BadgeDrawable createFromAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        BadgeDrawable badgeDrawable = new BadgeDrawable(context);
        badgeDrawable.loadDefaultStateFromAttributes(context, attributeSet, n, n2);
        return badgeDrawable;
    }

    public static BadgeDrawable createFromResource(Context context, int n) {
        int n2;
        AttributeSet attributeSet = DrawableUtils.parseDrawableXml(context, n, "badge");
        n = n2 = attributeSet.getStyleAttribute();
        if (n2 == 0) {
            n = DEFAULT_STYLE;
        }
        return BadgeDrawable.createFromAttributes(context, attributeSet, DEFAULT_THEME_ATTR, n);
    }

    static BadgeDrawable createFromSavedState(Context object, SavedState savedState) {
        object = new BadgeDrawable((Context)object);
        super.restoreFromSavedState(savedState);
        return object;
    }

    private void drawText(Canvas canvas) {
        Rect rect = new Rect();
        String string2 = this.getBadgeText();
        this.textDrawableHelper.getTextPaint().getTextBounds(string2, 0, string2.length(), rect);
        canvas.drawText(string2, this.badgeCenterX, this.badgeCenterY + (float)(rect.height() / 2), (Paint)this.textDrawableHelper.getTextPaint());
    }

    private String getBadgeText() {
        if (this.getNumber() <= this.maxBadgeNumber) {
            return NumberFormat.getInstance().format(this.getNumber());
        }
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return "";
        }
        return context.getString(R.string.mtrl_exceed_max_badge_number_suffix, new Object[]{this.maxBadgeNumber, DEFAULT_EXCEED_MAX_BADGE_NUMBER_SUFFIX});
    }

    private int getTotalHorizontalOffsetForState() {
        int n = this.hasNumber() ? this.savedState.horizontalOffsetWithText : this.savedState.horizontalOffsetWithoutText;
        return n + this.savedState.additionalHorizontalOffset;
    }

    private int getTotalVerticalOffsetForState() {
        int n = this.hasNumber() ? this.savedState.verticalOffsetWithText : this.savedState.verticalOffsetWithoutText;
        return n + this.savedState.additionalVerticalOffset;
    }

    private void loadDefaultStateFromAttributes(Context context, AttributeSet attributeSet, int n, int n2) {
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.Badge, n, n2, new int[0]);
        this.setMaxCharacterCount(attributeSet.getInt(R.styleable.Badge_maxCharacterCount, 4));
        if (attributeSet.hasValue(R.styleable.Badge_number)) {
            this.setNumber(attributeSet.getInt(R.styleable.Badge_number, 0));
        }
        this.setBackgroundColor(BadgeDrawable.readColorFromAttributes(context, (TypedArray)attributeSet, R.styleable.Badge_backgroundColor));
        if (attributeSet.hasValue(R.styleable.Badge_badgeTextColor)) {
            this.setBadgeTextColor(BadgeDrawable.readColorFromAttributes(context, (TypedArray)attributeSet, R.styleable.Badge_badgeTextColor));
        }
        this.setBadgeGravity(attributeSet.getInt(R.styleable.Badge_badgeGravity, 8388661));
        this.setHorizontalOffsetWithoutText(attributeSet.getDimensionPixelOffset(R.styleable.Badge_horizontalOffset, 0));
        this.setVerticalOffsetWithoutText(attributeSet.getDimensionPixelOffset(R.styleable.Badge_verticalOffset, 0));
        this.setHorizontalOffsetWithText(attributeSet.getDimensionPixelOffset(R.styleable.Badge_horizontalOffsetWithText, this.getHorizontalOffsetWithoutText()));
        this.setVerticalOffsetWithText(attributeSet.getDimensionPixelOffset(R.styleable.Badge_verticalOffsetWithText, this.getVerticalOffsetWithoutText()));
        if (attributeSet.hasValue(R.styleable.Badge_badgeRadius)) {
            this.badgeRadius = attributeSet.getDimensionPixelSize(R.styleable.Badge_badgeRadius, (int)this.badgeRadius);
        }
        if (attributeSet.hasValue(R.styleable.Badge_badgeWidePadding)) {
            this.badgeWidePadding = attributeSet.getDimensionPixelSize(R.styleable.Badge_badgeWidePadding, (int)this.badgeWidePadding);
        }
        if (attributeSet.hasValue(R.styleable.Badge_badgeWithTextRadius)) {
            this.badgeWithTextRadius = attributeSet.getDimensionPixelSize(R.styleable.Badge_badgeWithTextRadius, (int)this.badgeWithTextRadius);
        }
        attributeSet.recycle();
    }

    private static int readColorFromAttributes(Context context, TypedArray typedArray, int n) {
        return MaterialResources.getColorStateList(context, typedArray, n).getDefaultColor();
    }

    private void restoreFromSavedState(SavedState savedState) {
        this.setMaxCharacterCount(savedState.maxCharacterCount);
        if (savedState.number != -1) {
            this.setNumber(savedState.number);
        }
        this.setBackgroundColor(savedState.backgroundColor);
        this.setBadgeTextColor(savedState.badgeTextColor);
        this.setBadgeGravity(savedState.badgeGravity);
        this.setHorizontalOffsetWithoutText(savedState.horizontalOffsetWithoutText);
        this.setVerticalOffsetWithoutText(savedState.verticalOffsetWithoutText);
        this.setHorizontalOffsetWithText(savedState.horizontalOffsetWithText);
        this.setVerticalOffsetWithText(savedState.verticalOffsetWithText);
        this.setAdditionalHorizontalOffset(savedState.additionalHorizontalOffset);
        this.setAdditionalVerticalOffset(savedState.additionalVerticalOffset);
        this.setVisible(savedState.isVisible);
    }

    private void setTextAppearance(TextAppearance textAppearance) {
        if (this.textDrawableHelper.getTextAppearance() == textAppearance) {
            return;
        }
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return;
        }
        this.textDrawableHelper.setTextAppearance(textAppearance, context);
        this.updateCenterAndBounds();
    }

    private void setTextAppearanceResource(int n) {
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            return;
        }
        this.setTextAppearance(new TextAppearance(context, n));
    }

    private void tryWrapAnchorInCompatParent(final View view) {
        FrameLayout frameLayout;
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        if (viewGroup != null && viewGroup.getId() == R.id.mtrl_anchor_parent || (frameLayout = this.customBadgeParentRef) != null && frameLayout.get() == viewGroup) {
            return;
        }
        BadgeDrawable.updateAnchorParentToNotClip(view);
        frameLayout = new FrameLayout(view.getContext());
        frameLayout.setId(R.id.mtrl_anchor_parent);
        frameLayout.setClipChildren(false);
        frameLayout.setClipToPadding(false);
        frameLayout.setLayoutParams(view.getLayoutParams());
        frameLayout.setMinimumWidth(view.getWidth());
        frameLayout.setMinimumHeight(view.getHeight());
        int n = viewGroup.indexOfChild(view);
        viewGroup.removeViewAt(n);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        frameLayout.addView(view);
        viewGroup.addView((View)frameLayout, n);
        this.customBadgeParentRef = new WeakReference<FrameLayout>(frameLayout);
        frameLayout.post(new Runnable(){

            @Override
            public void run() {
                BadgeDrawable.this.updateBadgeCoordinates(view, frameLayout);
            }
        });
    }

    private static void updateAnchorParentToNotClip(View view) {
        view = (ViewGroup)view.getParent();
        view.setClipChildren(false);
        view.setClipToPadding(false);
    }

    private void updateCenterAndBounds() {
        Context context = (Context)this.contextRef.get();
        Object object = this.anchorViewRef;
        FrameLayout frameLayout = null;
        object = object != null ? (View)object.get() : null;
        if (context != null && object != null) {
            Rect rect = new Rect();
            rect.set(this.badgeBounds);
            Rect rect2 = new Rect();
            object.getDrawingRect(rect2);
            FrameLayout frameLayout2 = this.customBadgeParentRef;
            if (frameLayout2 != null) {
                frameLayout = (FrameLayout)frameLayout2.get();
            }
            if (frameLayout != null || BadgeUtils.USE_COMPAT_PARENT) {
                frameLayout2 = frameLayout;
                if (frameLayout == null) {
                    frameLayout2 = (ViewGroup)object.getParent();
                }
                frameLayout2.offsetDescendantRectToMyCoords(object, rect2);
            }
            this.calculateCenterAndBounds(context, rect2, (View)object);
            BadgeUtils.updateBadgeBounds(this.badgeBounds, this.badgeCenterX, this.badgeCenterY, this.halfBadgeWidth, this.halfBadgeHeight);
            this.shapeDrawable.setCornerSize(this.cornerRadius);
            if (!rect.equals((Object)this.badgeBounds)) {
                this.shapeDrawable.setBounds(this.badgeBounds);
            }
        }
    }

    private void updateMaxBadgeNumber() {
        this.maxBadgeNumber = (int)Math.pow(10.0, (double)this.getMaxCharacterCount() - 1.0) - 1;
    }

    public void clearNumber() {
        SavedState.access$202(this.savedState, -1);
        this.updateCenterAndBounds();
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (!this.getBounds().isEmpty() && this.getAlpha() != 0 && this.isVisible()) {
            this.shapeDrawable.draw(canvas);
            if (this.hasNumber()) {
                this.drawText(canvas);
            }
        }
    }

    int getAdditionalHorizontalOffset() {
        return this.savedState.additionalHorizontalOffset;
    }

    int getAdditionalVerticalOffset() {
        return this.savedState.additionalVerticalOffset;
    }

    public int getAlpha() {
        return this.savedState.alpha;
    }

    public int getBackgroundColor() {
        return this.shapeDrawable.getFillColor().getDefaultColor();
    }

    public int getBadgeGravity() {
        return this.savedState.badgeGravity;
    }

    public int getBadgeTextColor() {
        return this.textDrawableHelper.getTextPaint().getColor();
    }

    public CharSequence getContentDescription() {
        if (!this.isVisible()) {
            return null;
        }
        if (this.hasNumber()) {
            if (this.savedState.contentDescriptionQuantityStrings > 0) {
                Context context = (Context)this.contextRef.get();
                if (context == null) {
                    return null;
                }
                if (this.getNumber() <= this.maxBadgeNumber) {
                    return context.getResources().getQuantityString(this.savedState.contentDescriptionQuantityStrings, this.getNumber(), new Object[]{this.getNumber()});
                }
                return context.getString(this.savedState.contentDescriptionExceedsMaxBadgeNumberRes, new Object[]{this.maxBadgeNumber});
            }
            return null;
        }
        return this.savedState.contentDescriptionNumberless;
    }

    public FrameLayout getCustomBadgeParent() {
        Object object = this.customBadgeParentRef;
        object = object != null ? (FrameLayout)object.get() : null;
        return object;
    }

    public int getHorizontalOffset() {
        return this.savedState.horizontalOffsetWithoutText;
    }

    public int getHorizontalOffsetWithText() {
        return this.savedState.horizontalOffsetWithText;
    }

    public int getHorizontalOffsetWithoutText() {
        return this.savedState.horizontalOffsetWithoutText;
    }

    public int getIntrinsicHeight() {
        return this.badgeBounds.height();
    }

    public int getIntrinsicWidth() {
        return this.badgeBounds.width();
    }

    public int getMaxCharacterCount() {
        return this.savedState.maxCharacterCount;
    }

    public int getNumber() {
        if (!this.hasNumber()) {
            return 0;
        }
        return this.savedState.number;
    }

    public int getOpacity() {
        return -3;
    }

    public SavedState getSavedState() {
        return this.savedState;
    }

    public int getVerticalOffset() {
        return this.savedState.verticalOffsetWithoutText;
    }

    public int getVerticalOffsetWithText() {
        return this.savedState.verticalOffsetWithText;
    }

    public int getVerticalOffsetWithoutText() {
        return this.savedState.verticalOffsetWithoutText;
    }

    public boolean hasNumber() {
        boolean bl = this.savedState.number != -1;
        return bl;
    }

    public boolean isStateful() {
        return false;
    }

    @Override
    public boolean onStateChange(int[] nArray) {
        return super.onStateChange(nArray);
    }

    @Override
    public void onTextSizeChange() {
        this.invalidateSelf();
    }

    void setAdditionalHorizontalOffset(int n) {
        SavedState.access$1002(this.savedState, n);
        this.updateCenterAndBounds();
    }

    void setAdditionalVerticalOffset(int n) {
        SavedState.access$1102(this.savedState, n);
        this.updateCenterAndBounds();
    }

    public void setAlpha(int n) {
        SavedState.access$1202(this.savedState, n);
        this.textDrawableHelper.getTextPaint().setAlpha(n);
        this.invalidateSelf();
    }

    public void setBackgroundColor(int n) {
        SavedState.access$302(this.savedState, n);
        ColorStateList colorStateList = ColorStateList.valueOf((int)n);
        if (this.shapeDrawable.getFillColor() != colorStateList) {
            this.shapeDrawable.setFillColor(colorStateList);
            this.invalidateSelf();
        }
    }

    public void setBadgeGravity(int n) {
        if (this.savedState.badgeGravity != n) {
            SavedState.access$502(this.savedState, n);
            Object object = this.anchorViewRef;
            if (object != null && object.get() != null) {
                View view = (View)this.anchorViewRef.get();
                object = this.customBadgeParentRef;
                object = object != null ? (FrameLayout)object.get() : null;
                this.updateBadgeCoordinates(view, (FrameLayout)object);
            }
        }
    }

    public void setBadgeTextColor(int n) {
        SavedState.access$402(this.savedState, n);
        if (this.textDrawableHelper.getTextPaint().getColor() != n) {
            this.textDrawableHelper.getTextPaint().setColor(n);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public void setContentDescriptionExceedsMaxBadgeNumberStringResource(int n) {
        SavedState.access$1502(this.savedState, n);
    }

    public void setContentDescriptionNumberless(CharSequence charSequence) {
        SavedState.access$1302(this.savedState, charSequence);
    }

    public void setContentDescriptionQuantityStringsResource(int n) {
        SavedState.access$1402(this.savedState, n);
    }

    public void setHorizontalOffset(int n) {
        this.setHorizontalOffsetWithoutText(n);
        this.setHorizontalOffsetWithText(n);
    }

    public void setHorizontalOffsetWithText(int n) {
        SavedState.access$802(this.savedState, n);
        this.updateCenterAndBounds();
    }

    public void setHorizontalOffsetWithoutText(int n) {
        SavedState.access$602(this.savedState, n);
        this.updateCenterAndBounds();
    }

    public void setMaxCharacterCount(int n) {
        if (this.savedState.maxCharacterCount != n) {
            SavedState.access$102(this.savedState, n);
            this.updateMaxBadgeNumber();
            this.textDrawableHelper.setTextWidthDirty(true);
            this.updateCenterAndBounds();
            this.invalidateSelf();
        }
    }

    public void setNumber(int n) {
        n = Math.max(0, n);
        if (this.savedState.number != n) {
            SavedState.access$202(this.savedState, n);
            this.textDrawableHelper.setTextWidthDirty(true);
            this.updateCenterAndBounds();
            this.invalidateSelf();
        }
    }

    public void setVerticalOffset(int n) {
        this.setVerticalOffsetWithoutText(n);
        this.setVerticalOffsetWithText(n);
    }

    public void setVerticalOffsetWithText(int n) {
        SavedState.access$902(this.savedState, n);
        this.updateCenterAndBounds();
    }

    public void setVerticalOffsetWithoutText(int n) {
        SavedState.access$702(this.savedState, n);
        this.updateCenterAndBounds();
    }

    public void setVisible(boolean bl) {
        this.setVisible(bl, false);
        SavedState.access$002(this.savedState, bl);
        if (BadgeUtils.USE_COMPAT_PARENT && this.getCustomBadgeParent() != null && !bl) {
            ((ViewGroup)this.getCustomBadgeParent().getParent()).invalidate();
        }
    }

    public void updateBadgeCoordinates(View view) {
        this.updateBadgeCoordinates(view, (FrameLayout)null);
    }

    @Deprecated
    public void updateBadgeCoordinates(View view, ViewGroup viewGroup) {
        if (viewGroup instanceof FrameLayout) {
            this.updateBadgeCoordinates(view, (FrameLayout)viewGroup);
            return;
        }
        throw new IllegalArgumentException("customBadgeParent must be a FrameLayout");
    }

    public void updateBadgeCoordinates(View view, FrameLayout frameLayout) {
        this.anchorViewRef = new WeakReference<View>(view);
        if (BadgeUtils.USE_COMPAT_PARENT && frameLayout == null) {
            this.tryWrapAnchorInCompatParent(view);
        } else {
            this.customBadgeParentRef = new WeakReference<FrameLayout>(frameLayout);
        }
        if (!BadgeUtils.USE_COMPAT_PARENT) {
            BadgeDrawable.updateAnchorParentToNotClip(view);
        }
        this.updateCenterAndBounds();
        this.invalidateSelf();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BadgeGravity {
    }

    public static final class SavedState
    implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        private int additionalHorizontalOffset;
        private int additionalVerticalOffset;
        private int alpha = 255;
        private int backgroundColor;
        private int badgeGravity;
        private int badgeTextColor;
        private int contentDescriptionExceedsMaxBadgeNumberRes;
        private CharSequence contentDescriptionNumberless;
        private int contentDescriptionQuantityStrings;
        private int horizontalOffsetWithText;
        private int horizontalOffsetWithoutText;
        private boolean isVisible;
        private int maxCharacterCount;
        private int number = -1;
        private int verticalOffsetWithText;
        private int verticalOffsetWithoutText;

        public SavedState(Context context) {
            this.badgeTextColor = new TextAppearance(context, R.style.TextAppearance_MaterialComponents_Badge).getTextColor().getDefaultColor();
            this.contentDescriptionNumberless = context.getString(R.string.mtrl_badge_numberless_content_description);
            this.contentDescriptionQuantityStrings = R.plurals.mtrl_badge_content_description;
            this.contentDescriptionExceedsMaxBadgeNumberRes = R.string.mtrl_exceed_max_badge_number_content_description;
            this.isVisible = true;
        }

        protected SavedState(Parcel parcel) {
            this.backgroundColor = parcel.readInt();
            this.badgeTextColor = parcel.readInt();
            this.alpha = parcel.readInt();
            this.number = parcel.readInt();
            this.maxCharacterCount = parcel.readInt();
            this.contentDescriptionNumberless = parcel.readString();
            this.contentDescriptionQuantityStrings = parcel.readInt();
            this.badgeGravity = parcel.readInt();
            this.horizontalOffsetWithoutText = parcel.readInt();
            this.verticalOffsetWithoutText = parcel.readInt();
            this.horizontalOffsetWithText = parcel.readInt();
            this.verticalOffsetWithText = parcel.readInt();
            this.additionalHorizontalOffset = parcel.readInt();
            this.additionalVerticalOffset = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.isVisible = bl;
        }

        static /* synthetic */ boolean access$002(SavedState savedState, boolean bl) {
            savedState.isVisible = bl;
            return bl;
        }

        static /* synthetic */ int access$1002(SavedState savedState, int n) {
            savedState.additionalHorizontalOffset = n;
            return n;
        }

        static /* synthetic */ int access$102(SavedState savedState, int n) {
            savedState.maxCharacterCount = n;
            return n;
        }

        static /* synthetic */ int access$1102(SavedState savedState, int n) {
            savedState.additionalVerticalOffset = n;
            return n;
        }

        static /* synthetic */ int access$1202(SavedState savedState, int n) {
            savedState.alpha = n;
            return n;
        }

        static /* synthetic */ CharSequence access$1302(SavedState savedState, CharSequence charSequence) {
            savedState.contentDescriptionNumberless = charSequence;
            return charSequence;
        }

        static /* synthetic */ int access$1402(SavedState savedState, int n) {
            savedState.contentDescriptionQuantityStrings = n;
            return n;
        }

        static /* synthetic */ int access$1502(SavedState savedState, int n) {
            savedState.contentDescriptionExceedsMaxBadgeNumberRes = n;
            return n;
        }

        static /* synthetic */ int access$202(SavedState savedState, int n) {
            savedState.number = n;
            return n;
        }

        static /* synthetic */ int access$302(SavedState savedState, int n) {
            savedState.backgroundColor = n;
            return n;
        }

        static /* synthetic */ int access$402(SavedState savedState, int n) {
            savedState.badgeTextColor = n;
            return n;
        }

        static /* synthetic */ int access$502(SavedState savedState, int n) {
            savedState.badgeGravity = n;
            return n;
        }

        static /* synthetic */ int access$602(SavedState savedState, int n) {
            savedState.horizontalOffsetWithoutText = n;
            return n;
        }

        static /* synthetic */ int access$702(SavedState savedState, int n) {
            savedState.verticalOffsetWithoutText = n;
            return n;
        }

        static /* synthetic */ int access$802(SavedState savedState, int n) {
            savedState.horizontalOffsetWithText = n;
            return n;
        }

        static /* synthetic */ int access$902(SavedState savedState, int n) {
            savedState.verticalOffsetWithText = n;
            return n;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.backgroundColor);
            parcel.writeInt(this.badgeTextColor);
            parcel.writeInt(this.alpha);
            parcel.writeInt(this.number);
            parcel.writeInt(this.maxCharacterCount);
            parcel.writeString(this.contentDescriptionNumberless.toString());
            parcel.writeInt(this.contentDescriptionQuantityStrings);
            parcel.writeInt(this.badgeGravity);
            parcel.writeInt(this.horizontalOffsetWithoutText);
            parcel.writeInt(this.verticalOffsetWithoutText);
            parcel.writeInt(this.horizontalOffsetWithText);
            parcel.writeInt(this.verticalOffsetWithText);
            parcel.writeInt(this.additionalHorizontalOffset);
            parcel.writeInt(this.additionalVerticalOffset);
            parcel.writeInt(this.isVisible ? 1 : 0);
        }
    }
}

