/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.badge;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.widget.FrameLayout;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.widget.Toolbar;
import com.google.android.material.R;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.internal.ParcelableSparseArray;
import com.google.android.material.internal.ToolbarUtils;

public class BadgeUtils {
    private static final String LOG_TAG = "BadgeUtils";
    public static final boolean USE_COMPAT_PARENT;

    static {
        boolean bl = Build.VERSION.SDK_INT < 18;
        USE_COMPAT_PARENT = bl;
    }

    private BadgeUtils() {
    }

    public static void attachBadgeDrawable(BadgeDrawable badgeDrawable, View view) {
        BadgeUtils.attachBadgeDrawable(badgeDrawable, view, null);
    }

    public static void attachBadgeDrawable(BadgeDrawable badgeDrawable, View view, FrameLayout frameLayout) {
        block4: {
            block3: {
                block2: {
                    BadgeUtils.setBadgeDrawableBounds(badgeDrawable, view, frameLayout);
                    if (badgeDrawable.getCustomBadgeParent() == null) break block2;
                    badgeDrawable.getCustomBadgeParent().setForeground((Drawable)badgeDrawable);
                    break block3;
                }
                if (USE_COMPAT_PARENT) break block4;
                view.getOverlay().add((Drawable)badgeDrawable);
            }
            return;
        }
        throw new IllegalArgumentException("Trying to reference null customBadgeParent");
    }

    public static void attachBadgeDrawable(BadgeDrawable badgeDrawable, Toolbar toolbar, int n) {
        BadgeUtils.attachBadgeDrawable(badgeDrawable, toolbar, n, null);
    }

    public static void attachBadgeDrawable(final BadgeDrawable badgeDrawable, final Toolbar toolbar, final int n, final FrameLayout frameLayout) {
        toolbar.post(new Runnable(){

            @Override
            public void run() {
                ActionMenuItemView actionMenuItemView = ToolbarUtils.getActionMenuItemView(toolbar, n);
                if (actionMenuItemView != null) {
                    BadgeUtils.setToolbarOffset(badgeDrawable, toolbar.getResources());
                    BadgeUtils.attachBadgeDrawable(badgeDrawable, (View)actionMenuItemView, frameLayout);
                }
            }
        });
    }

    public static SparseArray<BadgeDrawable> createBadgeDrawablesFromSavedStates(Context context, ParcelableSparseArray parcelableSparseArray) {
        SparseArray sparseArray = new SparseArray(parcelableSparseArray.size());
        for (int i = 0; i < parcelableSparseArray.size(); ++i) {
            int n = parcelableSparseArray.keyAt(i);
            BadgeDrawable.SavedState savedState = (BadgeDrawable.SavedState)parcelableSparseArray.valueAt(i);
            if (savedState != null) {
                sparseArray.put(n, (Object)BadgeDrawable.createFromSavedState(context, savedState));
                continue;
            }
            throw new IllegalArgumentException("BadgeDrawable's savedState cannot be null");
        }
        return sparseArray;
    }

    public static ParcelableSparseArray createParcelableBadgeStates(SparseArray<BadgeDrawable> sparseArray) {
        ParcelableSparseArray parcelableSparseArray = new ParcelableSparseArray();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            BadgeDrawable badgeDrawable = (BadgeDrawable)sparseArray.valueAt(i);
            if (badgeDrawable != null) {
                parcelableSparseArray.put(n, badgeDrawable.getSavedState());
                continue;
            }
            throw new IllegalArgumentException("badgeDrawable cannot be null");
        }
        return parcelableSparseArray;
    }

    public static void detachBadgeDrawable(BadgeDrawable badgeDrawable, View view) {
        if (badgeDrawable == null) {
            return;
        }
        if (!USE_COMPAT_PARENT && badgeDrawable.getCustomBadgeParent() == null) {
            view.getOverlay().remove((Drawable)badgeDrawable);
        } else {
            badgeDrawable.getCustomBadgeParent().setForeground(null);
        }
    }

    public static void detachBadgeDrawable(BadgeDrawable object, Toolbar toolbar, int n) {
        if (object == null) {
            return;
        }
        if ((toolbar = ToolbarUtils.getActionMenuItemView(toolbar, n)) != null) {
            BadgeUtils.removeToolbarOffset((BadgeDrawable)object);
            BadgeUtils.detachBadgeDrawable((BadgeDrawable)object, (View)toolbar);
        } else {
            object = new StringBuilder();
            ((StringBuilder)object).append("Trying to remove badge from a null menuItemView: ");
            ((StringBuilder)object).append(n);
            Log.w((String)LOG_TAG, (String)((StringBuilder)object).toString());
        }
    }

    static void removeToolbarOffset(BadgeDrawable badgeDrawable) {
        badgeDrawable.setAdditionalHorizontalOffset(0);
        badgeDrawable.setAdditionalVerticalOffset(0);
    }

    public static void setBadgeDrawableBounds(BadgeDrawable badgeDrawable, View view, FrameLayout frameLayout) {
        Rect rect = new Rect();
        view.getDrawingRect(rect);
        badgeDrawable.setBounds(rect);
        badgeDrawable.updateBadgeCoordinates(view, frameLayout);
    }

    static void setToolbarOffset(BadgeDrawable badgeDrawable, Resources resources) {
        badgeDrawable.setAdditionalHorizontalOffset(resources.getDimensionPixelOffset(R.dimen.mtrl_badge_toolbar_action_menu_item_horizontal_offset));
        badgeDrawable.setAdditionalVerticalOffset(resources.getDimensionPixelOffset(R.dimen.mtrl_badge_toolbar_action_menu_item_vertical_offset));
    }

    public static void updateBadgeBounds(Rect rect, float f, float f2, float f3, float f4) {
        rect.set((int)(f - f3), (int)(f2 - f4), (int)(f + f3), (int)(f2 + f4));
    }
}

