/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomappbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.customview.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.animation.TransformationCallback;
import com.google.android.material.behavior.HideBottomViewOnScrollBehavior;
import com.google.android.material.bottomappbar.BottomAppBarTopEdgeTreatment;
import com.google.android.material.floatingactionbutton.ExtendedFloatingActionButton;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.EdgeTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class BottomAppBar
extends Toolbar
implements CoordinatorLayout.AttachedBehavior {
    private static final long ANIMATION_DURATION = 300L;
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_BottomAppBar;
    public static final int FAB_ALIGNMENT_MODE_CENTER = 0;
    public static final int FAB_ALIGNMENT_MODE_END = 1;
    public static final int FAB_ANIMATION_MODE_SCALE = 0;
    public static final int FAB_ANIMATION_MODE_SLIDE = 1;
    private static final int NO_MENU_RES_ID = 0;
    private int animatingModeChangeCounter;
    private ArrayList<AnimationListener> animationListeners;
    private Behavior behavior;
    private int bottomInset;
    private int fabAlignmentMode;
    AnimatorListenerAdapter fabAnimationListener;
    private int fabAnimationMode;
    private boolean fabAttached;
    private final int fabOffsetEndMode;
    TransformationCallback<FloatingActionButton> fabTransformationCallback;
    private boolean hideOnScroll;
    private int leftInset;
    private final MaterialShapeDrawable materialShapeDrawable;
    private boolean menuAnimatingWithFabAlignmentMode;
    private Animator menuAnimator;
    private Animator modeAnimator;
    private Integer navigationIconTint;
    private final boolean paddingBottomSystemWindowInsets;
    private final boolean paddingLeftSystemWindowInsets;
    private final boolean paddingRightSystemWindowInsets;
    private int pendingMenuResId;
    private int rightInset;

    public BottomAppBar(Context context) {
        this(context, null);
    }

    public BottomAppBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.bottomAppBarStyle);
    }

    public BottomAppBar(Context context, AttributeSet attributeSet, int n) {
        MaterialShapeDrawable materialShapeDrawable;
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
        this.materialShapeDrawable = materialShapeDrawable = new MaterialShapeDrawable();
        this.animatingModeChangeCounter = 0;
        this.pendingMenuResId = 0;
        this.menuAnimatingWithFabAlignmentMode = false;
        this.fabAttached = true;
        this.fabAnimationListener = new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator object) {
                if (!BottomAppBar.this.menuAnimatingWithFabAlignmentMode) {
                    object = BottomAppBar.this;
                    ((BottomAppBar)((Object)object)).maybeAnimateMenuView(((BottomAppBar)((Object)object)).fabAlignmentMode, BottomAppBar.this.fabAttached);
                }
            }
        };
        this.fabTransformationCallback = new TransformationCallback<FloatingActionButton>(){

            @Override
            public void onScaleChanged(FloatingActionButton floatingActionButton) {
                MaterialShapeDrawable materialShapeDrawable = BottomAppBar.this.materialShapeDrawable;
                float f = floatingActionButton.getVisibility() == 0 ? floatingActionButton.getScaleY() : 0.0f;
                materialShapeDrawable.setInterpolation(f);
            }

            @Override
            public void onTranslationChanged(FloatingActionButton floatingActionButton) {
                float f = floatingActionButton.getTranslationX();
                if (BottomAppBar.this.getTopEdgeTreatment().getHorizontalOffset() != f) {
                    BottomAppBar.this.getTopEdgeTreatment().setHorizontalOffset(f);
                    BottomAppBar.this.materialShapeDrawable.invalidateSelf();
                }
                float f2 = -floatingActionButton.getTranslationY();
                f = 0.0f;
                f2 = Math.max(0.0f, f2);
                if (BottomAppBar.this.getTopEdgeTreatment().getCradleVerticalOffset() != f2) {
                    BottomAppBar.this.getTopEdgeTreatment().setCradleVerticalOffset(f2);
                    BottomAppBar.this.materialShapeDrawable.invalidateSelf();
                }
                MaterialShapeDrawable materialShapeDrawable = BottomAppBar.this.materialShapeDrawable;
                if (floatingActionButton.getVisibility() == 0) {
                    f = floatingActionButton.getScaleY();
                }
                materialShapeDrawable.setInterpolation(f);
            }
        };
        Context context2 = this.getContext();
        Object object = ThemeEnforcement.obtainStyledAttributes(context2, attributeSet, R.styleable.BottomAppBar, n, n2, new int[0]);
        context = MaterialResources.getColorStateList(context2, object, R.styleable.BottomAppBar_backgroundTint);
        if (object.hasValue(R.styleable.BottomAppBar_navigationIconTint)) {
            this.setNavigationIconTint(object.getColor(R.styleable.BottomAppBar_navigationIconTint, -1));
        }
        int n3 = object.getDimensionPixelSize(R.styleable.BottomAppBar_elevation, 0);
        float f = object.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleMargin, 0);
        float f2 = object.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleRoundedCornerRadius, 0);
        float f3 = object.getDimensionPixelOffset(R.styleable.BottomAppBar_fabCradleVerticalOffset, 0);
        this.fabAlignmentMode = object.getInt(R.styleable.BottomAppBar_fabAlignmentMode, 0);
        this.fabAnimationMode = object.getInt(R.styleable.BottomAppBar_fabAnimationMode, 0);
        this.hideOnScroll = object.getBoolean(R.styleable.BottomAppBar_hideOnScroll, false);
        this.paddingBottomSystemWindowInsets = object.getBoolean(R.styleable.BottomAppBar_paddingBottomSystemWindowInsets, false);
        this.paddingLeftSystemWindowInsets = object.getBoolean(R.styleable.BottomAppBar_paddingLeftSystemWindowInsets, false);
        this.paddingRightSystemWindowInsets = object.getBoolean(R.styleable.BottomAppBar_paddingRightSystemWindowInsets, false);
        object.recycle();
        this.fabOffsetEndMode = this.getResources().getDimensionPixelOffset(R.dimen.mtrl_bottomappbar_fabOffsetEndMode);
        object = new BottomAppBarTopEdgeTreatment(f, f2, f3);
        materialShapeDrawable.setShapeAppearanceModel(ShapeAppearanceModel.builder().setTopEdge((EdgeTreatment)object).build());
        materialShapeDrawable.setShadowCompatibilityMode(2);
        materialShapeDrawable.setPaintStyle(Paint.Style.FILL);
        materialShapeDrawable.initializeElevationOverlay(context2);
        this.setElevation(n3);
        DrawableCompat.setTintList((Drawable)materialShapeDrawable, (ColorStateList)context);
        ViewCompat.setBackground((View)this, (Drawable)materialShapeDrawable);
        ViewUtils.doOnApplyWindowInsets((View)this, attributeSet, n, n2, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat, ViewUtils.RelativePadding relativePadding) {
                boolean bl;
                boolean bl2;
                if (BottomAppBar.this.paddingBottomSystemWindowInsets) {
                    BottomAppBar.access$702(BottomAppBar.this, windowInsetsCompat.getSystemWindowInsetBottom());
                }
                boolean bl3 = BottomAppBar.this.paddingLeftSystemWindowInsets;
                boolean bl4 = true;
                boolean bl5 = false;
                if (bl3) {
                    bl2 = BottomAppBar.this.leftInset != windowInsetsCompat.getSystemWindowInsetLeft();
                    BottomAppBar.access$902(BottomAppBar.this, windowInsetsCompat.getSystemWindowInsetLeft());
                    bl = bl2;
                } else {
                    bl = false;
                }
                bl2 = bl5;
                if (BottomAppBar.this.paddingRightSystemWindowInsets) {
                    bl2 = BottomAppBar.this.rightInset != windowInsetsCompat.getSystemWindowInsetRight() ? bl4 : false;
                    BottomAppBar.access$1102(BottomAppBar.this, windowInsetsCompat.getSystemWindowInsetRight());
                }
                if (bl || bl2) {
                    BottomAppBar.this.cancelAnimations();
                    BottomAppBar.this.setCutoutState();
                    BottomAppBar.this.setActionMenuViewPosition();
                }
                return windowInsetsCompat;
            }
        });
    }

    static /* synthetic */ boolean access$002(BottomAppBar bottomAppBar, boolean bl) {
        bottomAppBar.menuAnimatingWithFabAlignmentMode = bl;
        return bl;
    }

    static /* synthetic */ int access$1102(BottomAppBar bottomAppBar, int n) {
        bottomAppBar.rightInset = n;
        return n;
    }

    static /* synthetic */ Animator access$1702(BottomAppBar bottomAppBar, Animator animator2) {
        bottomAppBar.modeAnimator = animator2;
        return animator2;
    }

    static /* synthetic */ Animator access$1902(BottomAppBar bottomAppBar, Animator animator2) {
        bottomAppBar.menuAnimator = animator2;
        return animator2;
    }

    static /* synthetic */ int access$702(BottomAppBar bottomAppBar, int n) {
        bottomAppBar.bottomInset = n;
        return n;
    }

    static /* synthetic */ int access$902(BottomAppBar bottomAppBar, int n) {
        bottomAppBar.leftInset = n;
        return n;
    }

    private void addFabAnimationListeners(FloatingActionButton floatingActionButton) {
        floatingActionButton.addOnHideAnimationListener((Animator.AnimatorListener)this.fabAnimationListener);
        floatingActionButton.addOnShowAnimationListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator object) {
                BottomAppBar.this.fabAnimationListener.onAnimationStart((Animator)object);
                object = BottomAppBar.this.findDependentFab();
                if (object != null) {
                    ((FloatingActionButton)object).setTranslationX(BottomAppBar.this.getFabTranslationX());
                }
            }
        });
        floatingActionButton.addTransformationCallback(this.fabTransformationCallback);
    }

    private void cancelAnimations() {
        Animator animator2 = this.menuAnimator;
        if (animator2 != null) {
            animator2.cancel();
        }
        if ((animator2 = this.modeAnimator) != null) {
            animator2.cancel();
        }
    }

    private void createFabTranslationXAnimation(int n, List<Animator> list) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.findDependentFab(), (String)"translationX", (float[])new float[]{this.getFabTranslationX(n)});
        objectAnimator.setDuration(300L);
        list.add((Animator)objectAnimator);
    }

    private void createMenuViewTranslationAnimation(final int n, final boolean bl, List<Animator> list) {
        final ActionMenuView actionMenuView = this.getActionMenuView();
        if (actionMenuView == null) {
            return;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)actionMenuView, (String)"alpha", (float[])new float[]{1.0f});
        if (Math.abs(actionMenuView.getTranslationX() - (float)this.getActionMenuViewTranslationX(actionMenuView, n, bl)) > 1.0f) {
            ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)actionMenuView, (String)"alpha", (float[])new float[]{0.0f});
            objectAnimator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                public boolean cancelled;

                public void onAnimationCancel(Animator animator2) {
                    this.cancelled = true;
                }

                public void onAnimationEnd(Animator object) {
                    if (!this.cancelled) {
                        boolean bl2 = BottomAppBar.this.pendingMenuResId != 0;
                        object = BottomAppBar.this;
                        ((BottomAppBar)((Object)object)).replaceMenu(((BottomAppBar)((Object)object)).pendingMenuResId);
                        BottomAppBar.this.translateActionMenuView(actionMenuView, n, bl, bl2);
                    }
                }
            });
            actionMenuView = new AnimatorSet();
            actionMenuView.setDuration(150L);
            actionMenuView.playSequentially(new Animator[]{objectAnimator2, objectAnimator});
            list.add((Animator)actionMenuView);
        } else if (actionMenuView.getAlpha() < 1.0f) {
            list.add((Animator)objectAnimator);
        }
    }

    private void dispatchAnimationEnd() {
        Object object;
        int n;
        this.animatingModeChangeCounter = n = this.animatingModeChangeCounter - 1;
        if (n == 0 && (object = this.animationListeners) != null) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                ((AnimationListener)object.next()).onAnimationEnd(this);
            }
        }
    }

    private void dispatchAnimationStart() {
        Object object;
        int n = this.animatingModeChangeCounter;
        this.animatingModeChangeCounter = n + 1;
        if (n == 0 && (object = this.animationListeners) != null) {
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                ((AnimationListener)object.next()).onAnimationStart(this);
            }
        }
    }

    private FloatingActionButton findDependentFab() {
        Object object = this.findDependentView();
        object = object instanceof FloatingActionButton ? (FloatingActionButton)object : null;
        return object;
    }

    private View findDependentView() {
        if (!(this.getParent() instanceof CoordinatorLayout)) {
            return null;
        }
        for (View view : ((CoordinatorLayout)this.getParent()).getDependents((View)this)) {
            if (!(view instanceof FloatingActionButton) && !(view instanceof ExtendedFloatingActionButton)) continue;
            return view;
        }
        return null;
    }

    private ActionMenuView getActionMenuView() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof ActionMenuView)) continue;
            return (ActionMenuView)view;
        }
        return null;
    }

    private int getBottomInset() {
        return this.bottomInset;
    }

    private float getFabTranslationX() {
        return this.getFabTranslationX(this.fabAlignmentMode);
    }

    private float getFabTranslationX(int n) {
        boolean bl = ViewUtils.isLayoutRtl((View)this);
        int n2 = 1;
        if (n == 1) {
            n = bl ? this.leftInset : this.rightInset;
            int n3 = this.fabOffsetEndMode;
            int n4 = this.getMeasuredWidth() / 2;
            if (bl) {
                n2 = -1;
            }
            return (n4 - (n3 + n)) * n2;
        }
        return 0.0f;
    }

    private float getFabTranslationY() {
        return -this.getTopEdgeTreatment().getCradleVerticalOffset();
    }

    private int getLeftInset() {
        return this.leftInset;
    }

    private int getRightInset() {
        return this.rightInset;
    }

    private BottomAppBarTopEdgeTreatment getTopEdgeTreatment() {
        return (BottomAppBarTopEdgeTreatment)this.materialShapeDrawable.getShapeAppearanceModel().getTopEdge();
    }

    private boolean isFabVisibleOrWillBeShown() {
        FloatingActionButton floatingActionButton = this.findDependentFab();
        boolean bl = floatingActionButton != null && floatingActionButton.isOrWillBeShown();
        return bl;
    }

    private void maybeAnimateMenuView(int n, boolean bl) {
        if (!ViewCompat.isLaidOut((View)this)) {
            this.menuAnimatingWithFabAlignmentMode = false;
            this.replaceMenu(this.pendingMenuResId);
            return;
        }
        Animator animator2 = this.menuAnimator;
        if (animator2 != null) {
            animator2.cancel();
        }
        ArrayList<Animator> arrayList = new ArrayList<Animator>();
        if (!this.isFabVisibleOrWillBeShown()) {
            n = 0;
            bl = false;
        }
        this.createMenuViewTranslationAnimation(n, bl, arrayList);
        animator2 = new AnimatorSet();
        animator2.playTogether(arrayList);
        this.menuAnimator = animator2;
        animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                BottomAppBar.this.dispatchAnimationEnd();
                BottomAppBar.access$002(BottomAppBar.this, false);
                BottomAppBar.access$1902(BottomAppBar.this, null);
            }

            public void onAnimationStart(Animator animator2) {
                BottomAppBar.this.dispatchAnimationStart();
            }
        });
        this.menuAnimator.start();
    }

    private void maybeAnimateModeChange(int n) {
        if (this.fabAlignmentMode != n && ViewCompat.isLaidOut((View)this)) {
            Animator animator2 = this.modeAnimator;
            if (animator2 != null) {
                animator2.cancel();
            }
            ArrayList<Animator> arrayList = new ArrayList<Animator>();
            if (this.fabAnimationMode == 1) {
                this.createFabTranslationXAnimation(n, arrayList);
            } else {
                this.createFabDefaultXAnimation(n, arrayList);
            }
            animator2 = new AnimatorSet();
            animator2.playTogether(arrayList);
            this.modeAnimator = animator2;
            animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator2) {
                    BottomAppBar.this.dispatchAnimationEnd();
                    BottomAppBar.access$1702(BottomAppBar.this, null);
                }

                public void onAnimationStart(Animator animator2) {
                    BottomAppBar.this.dispatchAnimationStart();
                }
            });
            this.modeAnimator.start();
        }
    }

    private Drawable maybeTintNavigationIcon(Drawable drawable2) {
        Drawable drawable3 = drawable2;
        if (drawable2 != null) {
            drawable3 = drawable2;
            if (this.navigationIconTint != null) {
                drawable3 = DrawableCompat.wrap((Drawable)drawable2.mutate());
                DrawableCompat.setTint((Drawable)drawable3, (int)this.navigationIconTint);
            }
        }
        return drawable3;
    }

    private void setActionMenuViewPosition() {
        ActionMenuView actionMenuView = this.getActionMenuView();
        if (actionMenuView != null && this.menuAnimator == null) {
            actionMenuView.setAlpha(1.0f);
            if (!this.isFabVisibleOrWillBeShown()) {
                this.translateActionMenuView(actionMenuView, 0, false);
            } else {
                this.translateActionMenuView(actionMenuView, this.fabAlignmentMode, this.fabAttached);
            }
        }
    }

    private void setCutoutState() {
        this.getTopEdgeTreatment().setHorizontalOffset(this.getFabTranslationX());
        View view = this.findDependentView();
        MaterialShapeDrawable materialShapeDrawable = this.materialShapeDrawable;
        float f = this.fabAttached && this.isFabVisibleOrWillBeShown() ? 1.0f : 0.0f;
        materialShapeDrawable.setInterpolation(f);
        if (view != null) {
            view.setTranslationY(this.getFabTranslationY());
            view.setTranslationX(this.getFabTranslationX());
        }
    }

    private void translateActionMenuView(ActionMenuView actionMenuView, int n, boolean bl) {
        this.translateActionMenuView(actionMenuView, n, bl, false);
    }

    private void translateActionMenuView(final ActionMenuView actionMenuView, final int n, final boolean bl, boolean bl2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ActionMenuView actionMenuView2 = actionMenuView;
                actionMenuView2.setTranslationX((float)BottomAppBar.this.getActionMenuViewTranslationX(actionMenuView2, n, bl));
            }
        };
        if (bl2) {
            actionMenuView.post(runnable);
        } else {
            runnable.run();
        }
    }

    void addAnimationListener(AnimationListener animationListener) {
        if (this.animationListeners == null) {
            this.animationListeners = new ArrayList();
        }
        this.animationListeners.add(animationListener);
    }

    protected void createFabDefaultXAnimation(final int n, List<Animator> object) {
        object = this.findDependentFab();
        if (object != null && !((FloatingActionButton)object).isOrWillBeHidden()) {
            this.dispatchAnimationStart();
            ((FloatingActionButton)object).hide(new FloatingActionButton.OnVisibilityChangedListener(){

                @Override
                public void onHidden(FloatingActionButton floatingActionButton) {
                    floatingActionButton.setTranslationX(BottomAppBar.this.getFabTranslationX(n));
                    floatingActionButton.show(new FloatingActionButton.OnVisibilityChangedListener(){

                        @Override
                        public void onShown(FloatingActionButton floatingActionButton) {
                            BottomAppBar.this.dispatchAnimationEnd();
                        }
                    });
                }
            });
        }
    }

    protected int getActionMenuViewTranslationX(ActionMenuView actionMenuView, int n, boolean bl) {
        if (n == 1 && bl) {
            int n2;
            bl = ViewUtils.isLayoutRtl((View)this);
            n = bl ? this.getMeasuredWidth() : 0;
            int n3 = n;
            for (n2 = 0; n2 < this.getChildCount(); ++n2) {
                View view = this.getChildAt(n2);
                boolean bl2 = view.getLayoutParams() instanceof Toolbar.LayoutParams && (((Toolbar.LayoutParams)view.getLayoutParams()).gravity & 0x800007) == 0x800003;
                n = n3;
                if (bl2) {
                    n = bl ? Math.min(n3, view.getLeft()) : Math.max(n3, view.getRight());
                }
                n3 = n;
            }
            n = bl ? actionMenuView.getRight() : actionMenuView.getLeft();
            n2 = bl ? this.rightInset : -this.leftInset;
            return n3 - (n + n2);
        }
        return 0;
    }

    public ColorStateList getBackgroundTint() {
        return this.materialShapeDrawable.getTintList();
    }

    public Behavior getBehavior() {
        if (this.behavior == null) {
            this.behavior = new Behavior();
        }
        return this.behavior;
    }

    public float getCradleVerticalOffset() {
        return this.getTopEdgeTreatment().getCradleVerticalOffset();
    }

    public int getFabAlignmentMode() {
        return this.fabAlignmentMode;
    }

    public int getFabAnimationMode() {
        return this.fabAnimationMode;
    }

    public float getFabCradleMargin() {
        return this.getTopEdgeTreatment().getFabCradleMargin();
    }

    public float getFabCradleRoundedCornerRadius() {
        return this.getTopEdgeTreatment().getFabCradleRoundedCornerRadius();
    }

    public boolean getHideOnScroll() {
        return this.hideOnScroll;
    }

    public boolean isScrolledDown() {
        return this.getBehavior().isScrolledDown();
    }

    public boolean isScrolledUp() {
        return this.getBehavior().isScrolledUp();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this, this.materialShapeDrawable);
        if (this.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.getParent()).setClipChildren(false);
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        if (bl) {
            this.cancelAnimations();
            this.setCutoutState();
        }
        this.setActionMenuViewPosition();
    }

    protected void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.fabAlignmentMode = object.fabAlignmentMode;
        this.fabAttached = object.fabAttached;
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.fabAlignmentMode = this.fabAlignmentMode;
        savedState.fabAttached = this.fabAttached;
        return savedState;
    }

    public void performHide() {
        this.performHide(true);
    }

    public void performHide(boolean bl) {
        this.getBehavior().slideDown(this, bl);
    }

    public void performShow() {
        this.performShow(true);
    }

    public void performShow(boolean bl) {
        this.getBehavior().slideUp(this, bl);
    }

    void removeAnimationListener(AnimationListener animationListener) {
        ArrayList<AnimationListener> arrayList = this.animationListeners;
        if (arrayList == null) {
            return;
        }
        arrayList.remove(animationListener);
    }

    public void replaceMenu(int n) {
        if (n != 0) {
            this.pendingMenuResId = 0;
            this.getMenu().clear();
            this.inflateMenu(n);
        }
    }

    public void setBackgroundTint(ColorStateList colorStateList) {
        DrawableCompat.setTintList((Drawable)this.materialShapeDrawable, (ColorStateList)colorStateList);
    }

    public void setCradleVerticalOffset(float f) {
        if (f != this.getCradleVerticalOffset()) {
            this.getTopEdgeTreatment().setCradleVerticalOffset(f);
            this.materialShapeDrawable.invalidateSelf();
            this.setCutoutState();
        }
    }

    public void setElevation(float f) {
        this.materialShapeDrawable.setElevation(f);
        int n = this.materialShapeDrawable.getShadowRadius();
        int n2 = this.materialShapeDrawable.getShadowOffsetY();
        this.getBehavior().setAdditionalHiddenOffsetY(this, n - n2);
    }

    public void setFabAlignmentMode(int n) {
        this.setFabAlignmentModeAndReplaceMenu(n, 0);
    }

    public void setFabAlignmentModeAndReplaceMenu(int n, int n2) {
        this.pendingMenuResId = n2;
        this.menuAnimatingWithFabAlignmentMode = true;
        this.maybeAnimateMenuView(n, this.fabAttached);
        this.maybeAnimateModeChange(n);
        this.fabAlignmentMode = n;
    }

    public void setFabAnimationMode(int n) {
        this.fabAnimationMode = n;
    }

    void setFabCornerSize(float f) {
        if (f != this.getTopEdgeTreatment().getFabCornerRadius()) {
            this.getTopEdgeTreatment().setFabCornerSize(f);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    public void setFabCradleMargin(float f) {
        if (f != this.getFabCradleMargin()) {
            this.getTopEdgeTreatment().setFabCradleMargin(f);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    public void setFabCradleRoundedCornerRadius(float f) {
        if (f != this.getFabCradleRoundedCornerRadius()) {
            this.getTopEdgeTreatment().setFabCradleRoundedCornerRadius(f);
            this.materialShapeDrawable.invalidateSelf();
        }
    }

    boolean setFabDiameter(int n) {
        float f = n;
        if (f != this.getTopEdgeTreatment().getFabDiameter()) {
            this.getTopEdgeTreatment().setFabDiameter(f);
            this.materialShapeDrawable.invalidateSelf();
            return true;
        }
        return false;
    }

    public void setHideOnScroll(boolean bl) {
        this.hideOnScroll = bl;
    }

    public void setNavigationIcon(Drawable drawable2) {
        super.setNavigationIcon(this.maybeTintNavigationIcon(drawable2));
    }

    public void setNavigationIconTint(int n) {
        this.navigationIconTint = n;
        Drawable drawable2 = this.getNavigationIcon();
        if (drawable2 != null) {
            this.setNavigationIcon(drawable2);
        }
    }

    public void setSubtitle(CharSequence charSequence) {
    }

    public void setTitle(CharSequence charSequence) {
    }

    static interface AnimationListener {
        public void onAnimationEnd(BottomAppBar var1);

        public void onAnimationStart(BottomAppBar var1);
    }

    public static class Behavior
    extends HideBottomViewOnScrollBehavior<BottomAppBar> {
        private final Rect fabContentRect;
        private final View.OnLayoutChangeListener fabLayoutListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                BottomAppBar bottomAppBar = (BottomAppBar)((Object)Behavior.this.viewRef.get());
                if (bottomAppBar != null && view instanceof FloatingActionButton) {
                    FloatingActionButton floatingActionButton = (FloatingActionButton)view;
                    floatingActionButton.getMeasuredContentRect(Behavior.this.fabContentRect);
                    n = Behavior.this.fabContentRect.height();
                    bottomAppBar.setFabDiameter(n);
                    bottomAppBar.setFabCornerSize(floatingActionButton.getShapeAppearanceModel().getTopLeftCornerSize().getCornerSize(new RectF(Behavior.this.fabContentRect)));
                    view = (CoordinatorLayout.LayoutParams)view.getLayoutParams();
                    if (Behavior.this.originalBottomMargin == 0) {
                        n2 = (floatingActionButton.getMeasuredHeight() - n) / 2;
                        n = bottomAppBar.getResources().getDimensionPixelOffset(R.dimen.mtrl_bottomappbar_fab_bottom_margin);
                        view.bottomMargin = bottomAppBar.getBottomInset() + (n - n2);
                        view.leftMargin = bottomAppBar.getLeftInset();
                        view.rightMargin = bottomAppBar.getRightInset();
                        if (ViewUtils.isLayoutRtl((View)floatingActionButton)) {
                            view.leftMargin += bottomAppBar.fabOffsetEndMode;
                        } else {
                            view.rightMargin += bottomAppBar.fabOffsetEndMode;
                        }
                    }
                    return;
                }
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            }
        };
        private int originalBottomMargin;
        private WeakReference<BottomAppBar> viewRef;

        public Behavior() {
            this.fabContentRect = new Rect();
        }

        public Behavior(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.fabContentRect = new Rect();
        }

        @Override
        public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, BottomAppBar bottomAppBar, int n) {
            this.viewRef = new WeakReference<BottomAppBar>(bottomAppBar);
            Object object = bottomAppBar.findDependentView();
            if (object != null && !ViewCompat.isLaidOut((View)object)) {
                CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)object.getLayoutParams();
                layoutParams.anchorGravity = 49;
                this.originalBottomMargin = layoutParams.bottomMargin;
                if (object instanceof FloatingActionButton) {
                    if (((FloatingActionButton)(object = (FloatingActionButton)object)).getShowMotionSpec() == null) {
                        ((FloatingActionButton)object).setShowMotionSpecResource(R.animator.mtrl_fab_show_motion_spec);
                    }
                    if (((FloatingActionButton)object).getHideMotionSpec() == null) {
                        ((FloatingActionButton)object).setHideMotionSpecResource(R.animator.mtrl_fab_hide_motion_spec);
                    }
                    object.addOnLayoutChangeListener(this.fabLayoutListener);
                    bottomAppBar.addFabAnimationListeners((FloatingActionButton)object);
                }
                bottomAppBar.setCutoutState();
            }
            coordinatorLayout.onLayoutChild((View)bottomAppBar, n);
            return super.onLayoutChild(coordinatorLayout, bottomAppBar, n);
        }

        @Override
        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, BottomAppBar bottomAppBar, View view, View view2, int n, int n2) {
            boolean bl = bottomAppBar.getHideOnScroll() && super.onStartNestedScroll(coordinatorLayout, bottomAppBar, view, view2, n, n2);
            return bl;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FabAlignmentMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FabAnimationMode {
    }

    static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int fabAlignmentMode;
        boolean fabAttached;

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.fabAlignmentMode = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.fabAttached = bl;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.fabAlignmentMode);
            parcel.writeInt(this.fabAttached ? 1 : 0);
        }
    }
}

