/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomappbar;

import com.google.android.material.shape.EdgeTreatment;
import com.google.android.material.shape.ShapePath;

public class BottomAppBarTopEdgeTreatment
extends EdgeTreatment
implements Cloneable {
    private static final int ANGLE_LEFT = 180;
    private static final int ANGLE_UP = 270;
    private static final int ARC_HALF = 180;
    private static final int ARC_QUARTER = 90;
    private static final float ROUNDED_CORNER_FAB_OFFSET = 1.75f;
    private float cradleVerticalOffset;
    private float fabCornerSize = -1.0f;
    private float fabDiameter;
    private float fabMargin;
    private float horizontalOffset;
    private float roundedCornerRadius;

    public BottomAppBarTopEdgeTreatment(float f, float f2, float f3) {
        this.fabMargin = f;
        this.roundedCornerRadius = f2;
        this.setCradleVerticalOffset(f3);
        this.horizontalOffset = 0.0f;
    }

    float getCradleVerticalOffset() {
        return this.cradleVerticalOffset;
    }

    @Override
    public void getEdgePath(float f, float f2, float f3, ShapePath shapePath) {
        float f4 = this.fabDiameter;
        if (f4 == 0.0f) {
            shapePath.lineTo(f, 0.0f);
            return;
        }
        float f5 = (this.fabMargin * 2.0f + f4) / 2.0f;
        float f6 = f3 * this.roundedCornerRadius;
        float f7 = f2 + this.horizontalOffset;
        f2 = this.cradleVerticalOffset * f3 + (1.0f - f3) * f5;
        if (f2 / f5 >= 1.0f) {
            shapePath.lineTo(f, 0.0f);
            return;
        }
        float f8 = this.fabCornerSize;
        float f9 = f8 * f3;
        boolean bl = f8 == -1.0f || Math.abs(f8 * 2.0f - f4) < 0.1f;
        if (!bl) {
            f3 = 1.75f;
            f2 = 0.0f;
        } else {
            f3 = 0.0f;
        }
        f4 = f5 + f6;
        f8 = f2 + f6;
        float f10 = (float)Math.sqrt(f4 * f4 - f8 * f8);
        float f11 = f7 - f10;
        f4 = f7 + f10;
        f8 = (float)Math.toDegrees(Math.atan(f10 / f8));
        f3 = 90.0f - f8 + f3;
        shapePath.lineTo(f11, 0.0f);
        f10 = f6 * 2.0f;
        shapePath.addArc(f11 - f6, 0.0f, f11 + f6, f10, 270.0f, f8);
        if (bl) {
            shapePath.addArc(f7 - f5, -f5 - f2, f7 + f5, f5 - f2, 180.0f - f3, f3 * 2.0f - 180.0f);
        } else {
            float f12 = this.fabMargin;
            f2 = f9 * 2.0f;
            f11 = f7 - f5;
            shapePath.addArc(f11, -(f9 + f12), f11 + (f12 + f2), f12 + f9, 180.0f - f3, (f3 * 2.0f - 180.0f) / 2.0f);
            f5 = f7 + f5;
            f7 = this.fabMargin;
            shapePath.lineTo(f5 - (f7 / 2.0f + f9), f7 + f9);
            f7 = this.fabMargin;
            shapePath.addArc(f5 - (f2 + f7), -(f9 + f7), f5, f7 + f9, 90.0f, f3 - 90.0f);
        }
        shapePath.addArc(f4 - f6, 0.0f, f4 + f6, f10, 270.0f - f8, f8);
        shapePath.lineTo(f, 0.0f);
    }

    public float getFabCornerRadius() {
        return this.fabCornerSize;
    }

    float getFabCradleMargin() {
        return this.fabMargin;
    }

    float getFabCradleRoundedCornerRadius() {
        return this.roundedCornerRadius;
    }

    public float getFabDiameter() {
        return this.fabDiameter;
    }

    public float getHorizontalOffset() {
        return this.horizontalOffset;
    }

    void setCradleVerticalOffset(float f) {
        if (!(f < 0.0f)) {
            this.cradleVerticalOffset = f;
            return;
        }
        throw new IllegalArgumentException("cradleVerticalOffset must be positive.");
    }

    public void setFabCornerSize(float f) {
        this.fabCornerSize = f;
    }

    void setFabCradleMargin(float f) {
        this.fabMargin = f;
    }

    void setFabCradleRoundedCornerRadius(float f) {
        this.roundedCornerRadius = f;
    }

    public void setFabDiameter(float f) {
        this.fabDiameter = f;
    }

    void setHorizontalOffset(float f) {
        this.horizontalOffset = f;
    }
}

