/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomnavigation;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.R;
import com.google.android.material.bottomnavigation.BottomNavigationMenuView;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.navigation.NavigationBarMenuView;
import com.google.android.material.navigation.NavigationBarView;
import com.google.android.material.shape.MaterialShapeDrawable;

public class BottomNavigationView
extends NavigationBarView {
    static final int MAX_ITEM_COUNT = 5;

    public BottomNavigationView(Context context) {
        this(context, null);
    }

    public BottomNavigationView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.bottomNavigationStyle);
    }

    public BottomNavigationView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, R.style.Widget_Design_BottomNavigationView);
    }

    public BottomNavigationView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        context = this.getContext();
        attributeSet = ThemeEnforcement.obtainTintedStyledAttributes(context, attributeSet, R.styleable.BottomNavigationView, n, n2, new int[0]);
        this.setItemHorizontalTranslationEnabled(attributeSet.getBoolean(R.styleable.BottomNavigationView_itemHorizontalTranslationEnabled, true));
        if (attributeSet.hasValue(R.styleable.BottomNavigationView_android_minHeight)) {
            this.setMinimumHeight(attributeSet.getDimensionPixelSize(R.styleable.BottomNavigationView_android_minHeight, 0));
        }
        attributeSet.recycle();
        if (this.shouldDrawCompatibilityTopDivider()) {
            this.addCompatibilityTopDivider(context);
        }
        this.applyWindowInsets();
    }

    private void addCompatibilityTopDivider(Context context) {
        View view = new View(context);
        view.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.design_bottom_navigation_shadow_color));
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.getResources().getDimensionPixelSize(R.dimen.design_bottom_navigation_shadow_height)));
        this.addView(view);
    }

    private void applyWindowInsets() {
        ViewUtils.doOnApplyWindowInsets((View)this, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat, ViewUtils.RelativePadding relativePadding) {
                relativePadding.bottom += windowInsetsCompat.getSystemWindowInsetBottom();
                int n = ViewCompat.getLayoutDirection((View)view);
                boolean bl = true;
                if (n != 1) {
                    bl = false;
                }
                int n2 = windowInsetsCompat.getSystemWindowInsetLeft();
                n = windowInsetsCompat.getSystemWindowInsetRight();
                int n3 = relativePadding.start;
                int n4 = bl ? n : n2;
                relativePadding.start = n3 + n4;
                n4 = relativePadding.end;
                if (!bl) {
                    n2 = n;
                }
                relativePadding.end = n4 + n2;
                relativePadding.applyToView(view);
                return windowInsetsCompat;
            }
        });
    }

    private int makeMinHeightSpec(int n) {
        int n2 = this.getSuggestedMinimumHeight();
        int n3 = n;
        if (View.MeasureSpec.getMode((int)n) != 0x40000000) {
            n3 = n;
            if (n2 > 0) {
                int n4 = this.getPaddingTop();
                n3 = this.getPaddingBottom();
                n3 = View.MeasureSpec.makeMeasureSpec((int)Math.min(View.MeasureSpec.getSize((int)n), n2 + (n4 + n3)), (int)0x40000000);
            }
        }
        return n3;
    }

    private boolean shouldDrawCompatibilityTopDivider() {
        boolean bl = Build.VERSION.SDK_INT < 21 && !(this.getBackground() instanceof MaterialShapeDrawable);
        return bl;
    }

    @Override
    protected NavigationBarMenuView createNavigationBarMenuView(Context context) {
        return new BottomNavigationMenuView(context);
    }

    @Override
    public int getMaxItemCount() {
        return 5;
    }

    public boolean isItemHorizontalTranslationEnabled() {
        return ((BottomNavigationMenuView)this.getMenuView()).isItemHorizontalTranslationEnabled();
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, this.makeMinHeightSpec(n2));
    }

    public void setItemHorizontalTranslationEnabled(boolean bl) {
        BottomNavigationMenuView bottomNavigationMenuView = (BottomNavigationMenuView)this.getMenuView();
        if (bottomNavigationMenuView.isItemHorizontalTranslationEnabled() != bl) {
            bottomNavigationMenuView.setItemHorizontalTranslationEnabled(bl);
            this.getPresenter().updateMenuView(false);
        }
    }

    @Deprecated
    public void setOnNavigationItemReselectedListener(OnNavigationItemReselectedListener onNavigationItemReselectedListener) {
        this.setOnItemReselectedListener(onNavigationItemReselectedListener);
    }

    @Deprecated
    public void setOnNavigationItemSelectedListener(OnNavigationItemSelectedListener onNavigationItemSelectedListener) {
        this.setOnItemSelectedListener(onNavigationItemSelectedListener);
    }

    @Deprecated
    public static interface OnNavigationItemReselectedListener
    extends NavigationBarView.OnItemReselectedListener {
    }

    @Deprecated
    public static interface OnNavigationItemSelectedListener
    extends NavigationBarView.OnItemSelectedListener {
    }
}

