/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomsheet;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.customview.view.AbsSavedState;
import androidx.customview.widget.ViewDragHelper;
import com.google.android.material.R;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BottomSheetBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    private static final int CORNER_ANIMATION_DURATION = 500;
    private static final int DEF_STYLE_RES = R.style.Widget_Design_BottomSheet_Modal;
    private static final float HIDE_FRICTION = 0.1f;
    private static final float HIDE_THRESHOLD = 0.5f;
    private static final int NO_MAX_SIZE = -1;
    public static final int PEEK_HEIGHT_AUTO = -1;
    public static final int SAVE_ALL = -1;
    public static final int SAVE_FIT_TO_CONTENTS = 2;
    public static final int SAVE_HIDEABLE = 4;
    public static final int SAVE_NONE = 0;
    public static final int SAVE_PEEK_HEIGHT = 1;
    public static final int SAVE_SKIP_COLLAPSED = 8;
    private static final int SIGNIFICANT_VEL_THRESHOLD = 500;
    public static final int STATE_COLLAPSED = 4;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_EXPANDED = 3;
    public static final int STATE_HALF_EXPANDED = 6;
    public static final int STATE_HIDDEN = 5;
    public static final int STATE_SETTLING = 2;
    private static final String TAG = "BottomSheetBehavior";
    int activePointerId;
    private final ArrayList<BottomSheetCallback> callbacks = new ArrayList();
    private int childHeight;
    int collapsedOffset;
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){
        private long viewCapturedMillis;

        private boolean releasedLow(View view) {
            boolean bl = view.getTop() > (BottomSheetBehavior.this.parentHeight + BottomSheetBehavior.this.getExpandedOffset()) / 2;
            return bl;
        }

        public int clampViewPositionHorizontal(View view, int n, int n2) {
            return view.getLeft();
        }

        public int clampViewPositionVertical(View view, int n, int n2) {
            int n3 = BottomSheetBehavior.this.getExpandedOffset();
            n2 = BottomSheetBehavior.this.hideable ? BottomSheetBehavior.this.parentHeight : BottomSheetBehavior.this.collapsedOffset;
            return MathUtils.clamp((int)n, (int)n3, (int)n2);
        }

        public int getViewVerticalDragRange(View view) {
            if (BottomSheetBehavior.this.hideable) {
                return BottomSheetBehavior.this.parentHeight;
            }
            return BottomSheetBehavior.this.collapsedOffset;
        }

        public void onViewDragStateChanged(int n) {
            if (n == 1 && BottomSheetBehavior.this.draggable) {
                BottomSheetBehavior.this.setStateInternal(1);
            }
        }

        public void onViewPositionChanged(View view, int n, int n2, int n3, int n4) {
            BottomSheetBehavior.this.dispatchOnSlide(n2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onViewReleased(View view, float f, float f2) {
            int n;
            int n2;
            block7: {
                block5: {
                    block21: {
                        block22: {
                            block18: {
                                block20: {
                                    block19: {
                                        block2: {
                                            block16: {
                                                block17: {
                                                    block12: {
                                                        block14: {
                                                            block15: {
                                                                block13: {
                                                                    block8: {
                                                                        block11: {
                                                                            block10: {
                                                                                block9: {
                                                                                    block0: {
                                                                                        block6: {
                                                                                            block3: {
                                                                                                block4: {
                                                                                                    block1: {
                                                                                                        n2 = 6;
                                                                                                        if (!(f2 < 0.0f)) break block0;
                                                                                                        if (!BottomSheetBehavior.this.fitToContents) break block1;
                                                                                                        n = BottomSheetBehavior.this.fitToContentsOffset;
                                                                                                        break block2;
                                                                                                    }
                                                                                                    n = view.getTop();
                                                                                                    long l = System.currentTimeMillis();
                                                                                                    long l2 = this.viewCapturedMillis;
                                                                                                    if (!BottomSheetBehavior.this.shouldSkipHalfExpandedStateWhenDragging()) break block3;
                                                                                                    f = (float)n * 100.0f / (float)BottomSheetBehavior.this.parentHeight;
                                                                                                    if (!BottomSheetBehavior.this.shouldExpandOnUpwardDrag(l - l2, f)) break block4;
                                                                                                    n = BottomSheetBehavior.this.expandedOffset;
                                                                                                    break block2;
                                                                                                }
                                                                                                n = BottomSheetBehavior.this.collapsedOffset;
                                                                                                break block5;
                                                                                            }
                                                                                            if (n <= BottomSheetBehavior.this.halfExpandedOffset) break block6;
                                                                                            n = BottomSheetBehavior.this.halfExpandedOffset;
                                                                                            break block7;
                                                                                        }
                                                                                        n = BottomSheetBehavior.this.getExpandedOffset();
                                                                                        break block2;
                                                                                    }
                                                                                    if (!BottomSheetBehavior.this.hideable || !BottomSheetBehavior.this.shouldHide(view, f2)) break block8;
                                                                                    if (!(Math.abs(f) < Math.abs(f2) && f2 > 500.0f) && !this.releasedLow(view)) break block9;
                                                                                    n = BottomSheetBehavior.this.parentHeight;
                                                                                    n2 = 5;
                                                                                    break block7;
                                                                                }
                                                                                if (!BottomSheetBehavior.this.fitToContents) break block10;
                                                                                n = BottomSheetBehavior.this.fitToContentsOffset;
                                                                                break block2;
                                                                            }
                                                                            if (Math.abs(view.getTop() - BottomSheetBehavior.this.getExpandedOffset()) >= Math.abs(view.getTop() - BottomSheetBehavior.this.halfExpandedOffset)) break block11;
                                                                            n = BottomSheetBehavior.this.getExpandedOffset();
                                                                            break block2;
                                                                        }
                                                                        n = BottomSheetBehavior.this.halfExpandedOffset;
                                                                        break block7;
                                                                    }
                                                                    if (f2 == 0.0f || Math.abs(f) > Math.abs(f2)) break block12;
                                                                    if (!BottomSheetBehavior.this.fitToContents) break block13;
                                                                    n = BottomSheetBehavior.this.collapsedOffset;
                                                                    break block5;
                                                                }
                                                                n = view.getTop();
                                                                if (Math.abs(n - BottomSheetBehavior.this.halfExpandedOffset) >= Math.abs(n - BottomSheetBehavior.this.collapsedOffset)) break block14;
                                                                if (!BottomSheetBehavior.this.shouldSkipHalfExpandedStateWhenDragging()) break block15;
                                                                n = BottomSheetBehavior.this.collapsedOffset;
                                                                break block5;
                                                            }
                                                            n = BottomSheetBehavior.this.halfExpandedOffset;
                                                            break block7;
                                                        }
                                                        n = BottomSheetBehavior.this.collapsedOffset;
                                                        break block5;
                                                    }
                                                    n = view.getTop();
                                                    if (!BottomSheetBehavior.this.fitToContents) break block16;
                                                    if (Math.abs(n - BottomSheetBehavior.this.fitToContentsOffset) >= Math.abs(n - BottomSheetBehavior.this.collapsedOffset)) break block17;
                                                    n = BottomSheetBehavior.this.fitToContentsOffset;
                                                    break block2;
                                                }
                                                n = BottomSheetBehavior.this.collapsedOffset;
                                                break block5;
                                            }
                                            if (n >= BottomSheetBehavior.this.halfExpandedOffset) break block18;
                                            if (n >= Math.abs(n - BottomSheetBehavior.this.collapsedOffset)) break block19;
                                            n = BottomSheetBehavior.this.getExpandedOffset();
                                        }
                                        n2 = 3;
                                        break block7;
                                    }
                                    if (!BottomSheetBehavior.this.shouldSkipHalfExpandedStateWhenDragging()) break block20;
                                    n = BottomSheetBehavior.this.collapsedOffset;
                                    break block5;
                                }
                                n = BottomSheetBehavior.this.halfExpandedOffset;
                                break block7;
                            }
                            if (Math.abs(n - BottomSheetBehavior.this.halfExpandedOffset) >= Math.abs(n - BottomSheetBehavior.this.collapsedOffset)) break block21;
                            if (!BottomSheetBehavior.this.shouldSkipHalfExpandedStateWhenDragging()) break block22;
                            n = BottomSheetBehavior.this.collapsedOffset;
                            break block5;
                        }
                        n = BottomSheetBehavior.this.halfExpandedOffset;
                        break block7;
                    }
                    n = BottomSheetBehavior.this.collapsedOffset;
                }
                n2 = 4;
            }
            BottomSheetBehavior bottomSheetBehavior = BottomSheetBehavior.this;
            bottomSheetBehavior.startSettlingAnimation(view, n2, n, bottomSheetBehavior.shouldSkipSmoothAnimation());
        }

        public boolean tryCaptureView(View view, int n) {
            View view2;
            int n2 = BottomSheetBehavior.this.state;
            boolean bl = true;
            if (n2 == 1) {
                return false;
            }
            if (BottomSheetBehavior.this.touchingScrollingChild) {
                return false;
            }
            if (BottomSheetBehavior.this.state == 3 && BottomSheetBehavior.this.activePointerId == n && (view2 = BottomSheetBehavior.this.nestedScrollingChildRef != null ? (View)BottomSheetBehavior.this.nestedScrollingChildRef.get() : null) != null && view2.canScrollVertically(-1)) {
                return false;
            }
            this.viewCapturedMillis = System.currentTimeMillis();
            if (BottomSheetBehavior.this.viewRef == null || BottomSheetBehavior.this.viewRef.get() != view) {
                bl = false;
            }
            return bl;
        }
    };
    private boolean draggable = true;
    float elevation = -1.0f;
    private int expandHalfwayActionId = -1;
    int expandedOffset;
    private boolean fitToContents = true;
    int fitToContentsOffset;
    private int gestureInsetBottom;
    private boolean gestureInsetBottomIgnored;
    int halfExpandedOffset;
    float halfExpandedRatio = 0.5f;
    boolean hideable;
    private boolean ignoreEvents;
    private Map<View, Integer> importantForAccessibilityMap;
    private int initialY;
    private int insetBottom;
    private int insetTop;
    private ValueAnimator interpolatorAnimator;
    private boolean isShapeExpanded;
    private int lastNestedScrollDy;
    int lastStableState = 4;
    private MaterialShapeDrawable materialShapeDrawable;
    private int maxHeight = -1;
    private int maxWidth = -1;
    private float maximumVelocity;
    private boolean nestedScrolled;
    WeakReference<View> nestedScrollingChildRef;
    private boolean paddingBottomSystemWindowInsets;
    private boolean paddingLeftSystemWindowInsets;
    private boolean paddingRightSystemWindowInsets;
    private boolean paddingTopSystemWindowInsets;
    int parentHeight;
    int parentWidth;
    private int peekHeight;
    private boolean peekHeightAuto;
    private int peekHeightGestureInsetBuffer;
    private int peekHeightMin;
    private int saveFlags = 0;
    private SettleRunnable settleRunnable = null;
    private ShapeAppearanceModel shapeAppearanceModelDefault;
    private boolean shapeThemingEnabled;
    private boolean skipCollapsed;
    int state = 4;
    boolean touchingScrollingChild;
    private boolean updateImportantForAccessibilityOnSiblings = false;
    private VelocityTracker velocityTracker;
    ViewDragHelper viewDragHelper;
    WeakReference<V> viewRef;

    public BottomSheetBehavior() {
    }

    public BottomSheetBehavior(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.peekHeightGestureInsetBuffer = context.getResources().getDimensionPixelSize(R.dimen.mtrl_min_touch_target_size);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.BottomSheetBehavior_Layout);
        this.shapeThemingEnabled = typedArray.hasValue(R.styleable.BottomSheetBehavior_Layout_shapeAppearance);
        boolean bl = typedArray.hasValue(R.styleable.BottomSheetBehavior_Layout_backgroundTint);
        if (bl) {
            this.createMaterialShapeDrawable(context, attributeSet, bl, MaterialResources.getColorStateList(context, typedArray, R.styleable.BottomSheetBehavior_Layout_backgroundTint));
        } else {
            this.createMaterialShapeDrawable(context, attributeSet, bl);
        }
        this.createShapeValueAnimator();
        if (Build.VERSION.SDK_INT >= 21) {
            this.elevation = typedArray.getDimension(R.styleable.BottomSheetBehavior_Layout_android_elevation, -1.0f);
        }
        if (typedArray.hasValue(R.styleable.BottomSheetBehavior_Layout_android_maxWidth)) {
            this.setMaxWidth(typedArray.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_android_maxWidth, -1));
        }
        if (typedArray.hasValue(R.styleable.BottomSheetBehavior_Layout_android_maxHeight)) {
            this.setMaxHeight(typedArray.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_android_maxHeight, -1));
        }
        if ((attributeSet = typedArray.peekValue(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight)) != null && attributeSet.data == -1) {
            this.setPeekHeight(attributeSet.data);
        } else {
            this.setPeekHeight(typedArray.getDimensionPixelSize(R.styleable.BottomSheetBehavior_Layout_behavior_peekHeight, -1));
        }
        this.setHideable(typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_hideable, false));
        this.setGestureInsetBottomIgnored(typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_gestureInsetBottomIgnored, false));
        this.setFitToContents(typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_fitToContents, true));
        this.setSkipCollapsed(typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_skipCollapsed, false));
        this.setDraggable(typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_behavior_draggable, true));
        this.setSaveFlags(typedArray.getInt(R.styleable.BottomSheetBehavior_Layout_behavior_saveFlags, 0));
        this.setHalfExpandedRatio(typedArray.getFloat(R.styleable.BottomSheetBehavior_Layout_behavior_halfExpandedRatio, 0.5f));
        attributeSet = typedArray.peekValue(R.styleable.BottomSheetBehavior_Layout_behavior_expandedOffset);
        if (attributeSet != null && attributeSet.type == 16) {
            this.setExpandedOffset(attributeSet.data);
        } else {
            this.setExpandedOffset(typedArray.getDimensionPixelOffset(R.styleable.BottomSheetBehavior_Layout_behavior_expandedOffset, 0));
        }
        this.paddingBottomSystemWindowInsets = typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingBottomSystemWindowInsets, false);
        this.paddingLeftSystemWindowInsets = typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingLeftSystemWindowInsets, false);
        this.paddingRightSystemWindowInsets = typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingRightSystemWindowInsets, false);
        this.paddingTopSystemWindowInsets = typedArray.getBoolean(R.styleable.BottomSheetBehavior_Layout_paddingTopSystemWindowInsets, true);
        typedArray.recycle();
        this.maximumVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
    }

    static /* synthetic */ int access$102(BottomSheetBehavior bottomSheetBehavior, int n) {
        bottomSheetBehavior.insetTop = n;
        return n;
    }

    static /* synthetic */ int access$302(BottomSheetBehavior bottomSheetBehavior, int n) {
        bottomSheetBehavior.insetBottom = n;
        return n;
    }

    static /* synthetic */ int access$602(BottomSheetBehavior bottomSheetBehavior, int n) {
        bottomSheetBehavior.gestureInsetBottom = n;
        return n;
    }

    private int addAccessibilityActionForState(V v, int n, int n2) {
        return ViewCompat.addAccessibilityAction(v, (CharSequence)v.getResources().getString(n), (AccessibilityViewCommand)this.createAccessibilityViewCommandForState(n2));
    }

    private void calculateCollapsedOffset() {
        int n = this.calculatePeekHeight();
        this.collapsedOffset = this.fitToContents ? Math.max(this.parentHeight - n, this.fitToContentsOffset) : this.parentHeight - n;
    }

    private void calculateHalfExpandedOffset() {
        this.halfExpandedOffset = (int)((float)this.parentHeight * (1.0f - this.halfExpandedRatio));
    }

    private int calculatePeekHeight() {
        int n;
        if (this.peekHeightAuto) {
            return Math.min(Math.max(this.peekHeightMin, this.parentHeight - this.parentWidth * 9 / 16), this.childHeight) + this.insetBottom;
        }
        if (!this.gestureInsetBottomIgnored && !this.paddingBottomSystemWindowInsets && (n = this.gestureInsetBottom) > 0) {
            return Math.max(this.peekHeight, n + this.peekHeightGestureInsetBuffer);
        }
        return this.peekHeight + this.insetBottom;
    }

    private AccessibilityViewCommand createAccessibilityViewCommandForState(final int n) {
        return new AccessibilityViewCommand(){

            public boolean perform(View view, AccessibilityViewCommand.CommandArguments commandArguments) {
                BottomSheetBehavior.this.setState(n);
                return true;
            }
        };
    }

    private void createMaterialShapeDrawable(Context context, AttributeSet attributeSet, boolean bl) {
        this.createMaterialShapeDrawable(context, attributeSet, bl, null);
    }

    private void createMaterialShapeDrawable(Context context, AttributeSet object, boolean bl, ColorStateList colorStateList) {
        if (this.shapeThemingEnabled) {
            this.shapeAppearanceModelDefault = ShapeAppearanceModel.builder(context, (AttributeSet)object, R.attr.bottomSheetStyle, DEF_STYLE_RES).build();
            object = new MaterialShapeDrawable(this.shapeAppearanceModelDefault);
            this.materialShapeDrawable = object;
            ((MaterialShapeDrawable)object).initializeElevationOverlay(context);
            if (bl && colorStateList != null) {
                this.materialShapeDrawable.setFillColor(colorStateList);
            } else {
                object = new TypedValue();
                context.getTheme().resolveAttribute(0x1010031, (TypedValue)object, true);
                this.materialShapeDrawable.setTint(((TypedValue)object).data);
            }
        }
    }

    private void createShapeValueAnimator() {
        ValueAnimator valueAnimator;
        this.interpolatorAnimator = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.setDuration(500L);
        this.interpolatorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                if (BottomSheetBehavior.this.materialShapeDrawable != null) {
                    BottomSheetBehavior.this.materialShapeDrawable.setInterpolation(f);
                }
            }
        });
    }

    public static <V extends View> BottomSheetBehavior<V> from(V object) {
        if ((object = object.getLayoutParams()) instanceof CoordinatorLayout.LayoutParams) {
            if ((object = ((CoordinatorLayout.LayoutParams)object).getBehavior()) instanceof BottomSheetBehavior) {
                return (BottomSheetBehavior)((Object)object);
            }
            throw new IllegalArgumentException("The view is not associated with BottomSheetBehavior");
        }
        throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
    }

    private int getChildMeasureSpec(int n, int n2, int n3, int n4) {
        n2 = ViewGroup.getChildMeasureSpec((int)n, (int)n2, (int)n4);
        if (n3 == -1) {
            return n2;
        }
        n = View.MeasureSpec.getMode((int)n2);
        n2 = View.MeasureSpec.getSize((int)n2);
        if (n != 0x40000000) {
            if (n2 != 0) {
                n3 = Math.min(n2, n3);
            }
            return View.MeasureSpec.makeMeasureSpec((int)n3, (int)Integer.MIN_VALUE);
        }
        return View.MeasureSpec.makeMeasureSpec((int)Math.min(n2, n3), (int)0x40000000);
    }

    private float getYVelocity() {
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker == null) {
            return 0.0f;
        }
        velocityTracker.computeCurrentVelocity(1000, this.maximumVelocity);
        return this.velocityTracker.getYVelocity(this.activePointerId);
    }

    private void replaceAccessibilityActionForState(V v, AccessibilityNodeInfoCompat.AccessibilityActionCompat accessibilityActionCompat, int n) {
        ViewCompat.replaceAccessibilityAction(v, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)accessibilityActionCompat, null, (AccessibilityViewCommand)this.createAccessibilityViewCommandForState(n));
    }

    private void reset() {
        this.activePointerId = -1;
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.velocityTracker = null;
        }
    }

    private void restoreOptionalState(SavedState savedState) {
        int n = this.saveFlags;
        if (n == 0) {
            return;
        }
        if (n == -1 || (n & 1) == 1) {
            this.peekHeight = savedState.peekHeight;
        }
        if ((n = this.saveFlags) == -1 || (n & 2) == 2) {
            this.fitToContents = savedState.fitToContents;
        }
        if ((n = this.saveFlags) == -1 || (n & 4) == 4) {
            this.hideable = savedState.hideable;
        }
        if ((n = this.saveFlags) == -1 || (n & 8) == 8) {
            this.skipCollapsed = savedState.skipCollapsed;
        }
    }

    private void setWindowInsetsListener(View view) {
        final boolean bl = Build.VERSION.SDK_INT >= 29 && !this.isGestureInsetBottomIgnored() && !this.peekHeightAuto;
        if (!(this.paddingBottomSystemWindowInsets || this.paddingLeftSystemWindowInsets || this.paddingRightSystemWindowInsets || bl)) {
            return;
        }
        ViewUtils.doOnApplyWindowInsets(view, new ViewUtils.OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat, ViewUtils.RelativePadding relativePadding) {
                BottomSheetBehavior.access$102(BottomSheetBehavior.this, windowInsetsCompat.getSystemWindowInsetTop());
                boolean bl2 = ViewUtils.isLayoutRtl(view);
                int n = view.getPaddingBottom();
                int n2 = view.getPaddingLeft();
                int n3 = view.getPaddingRight();
                if (BottomSheetBehavior.this.paddingBottomSystemWindowInsets) {
                    BottomSheetBehavior.access$302(BottomSheetBehavior.this, windowInsetsCompat.getSystemWindowInsetBottom());
                    n = relativePadding.bottom + BottomSheetBehavior.this.insetBottom;
                }
                if (BottomSheetBehavior.this.paddingLeftSystemWindowInsets) {
                    n2 = bl2 ? relativePadding.end : relativePadding.start;
                    n2 += windowInsetsCompat.getSystemWindowInsetLeft();
                }
                if (BottomSheetBehavior.this.paddingRightSystemWindowInsets) {
                    n3 = bl2 ? relativePadding.start : relativePadding.end;
                    n3 += windowInsetsCompat.getSystemWindowInsetRight();
                }
                view.setPadding(n2, view.getPaddingTop(), n3, n);
                if (bl) {
                    BottomSheetBehavior.access$602(BottomSheetBehavior.this, windowInsetsCompat.getMandatorySystemGestureInsets().bottom);
                }
                if (BottomSheetBehavior.this.paddingBottomSystemWindowInsets || bl) {
                    BottomSheetBehavior.this.updatePeekHeight(false);
                }
                return windowInsetsCompat;
            }
        });
    }

    private void settleToStatePendingLayout(final int n) {
        final View view = (View)this.viewRef.get();
        if (view == null) {
            return;
        }
        ViewParent viewParent = view.getParent();
        if (viewParent != null && viewParent.isLayoutRequested() && ViewCompat.isAttachedToWindow((View)view)) {
            view.post(new Runnable(){

                @Override
                public void run() {
                    BottomSheetBehavior.this.settleToState(view, n);
                }
            });
        } else {
            this.settleToState(view, n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldHandleDraggingWithHelper() {
        ViewDragHelper viewDragHelper = this.viewDragHelper;
        boolean bl = true;
        if (viewDragHelper == null) return false;
        boolean bl2 = bl;
        if (this.draggable) return bl2;
        if (this.state != 1) return false;
        return bl;
    }

    private void updateAccessibilityActions() {
        int n;
        View view = this.viewRef;
        if (view == null) {
            return;
        }
        if ((view = (View)view.get()) == null) {
            return;
        }
        ViewCompat.removeAccessibilityAction((View)view, (int)524288);
        ViewCompat.removeAccessibilityAction((View)view, (int)262144);
        ViewCompat.removeAccessibilityAction((View)view, (int)0x100000);
        int n2 = this.expandHalfwayActionId;
        if (n2 != -1) {
            ViewCompat.removeAccessibilityAction((View)view, (int)n2);
        }
        boolean bl = this.fitToContents;
        n2 = 6;
        if (!bl && this.state != 6) {
            this.expandHalfwayActionId = this.addAccessibilityActionForState(view, R.string.bottomsheet_action_expand_halfway, 6);
        }
        if (this.hideable && this.state != 5) {
            this.replaceAccessibilityActionForState(view, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_DISMISS, 5);
        }
        if ((n = this.state) != 3) {
            if (n != 4) {
                if (n == 6) {
                    this.replaceAccessibilityActionForState(view, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_COLLAPSE, 4);
                    this.replaceAccessibilityActionForState(view, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_EXPAND, 3);
                }
            } else {
                if (this.fitToContents) {
                    n2 = 3;
                }
                this.replaceAccessibilityActionForState(view, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_EXPAND, n2);
            }
        } else {
            if (this.fitToContents) {
                n2 = 4;
            }
            this.replaceAccessibilityActionForState(view, AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_COLLAPSE, n2);
        }
    }

    private void updateDrawableForTargetState(int n) {
        if (n == 2) {
            return;
        }
        boolean bl = n == 3;
        if (this.isShapeExpanded != bl) {
            ValueAnimator valueAnimator;
            this.isShapeExpanded = bl;
            if (this.materialShapeDrawable != null && (valueAnimator = this.interpolatorAnimator) != null) {
                if (valueAnimator.isRunning()) {
                    this.interpolatorAnimator.reverse();
                } else {
                    float f = bl ? 0.0f : 1.0f;
                    this.interpolatorAnimator.setFloatValues(new float[]{1.0f - f, f});
                    this.interpolatorAnimator.start();
                }
            }
        }
    }

    private void updateImportantForAccessibility(boolean bl) {
        ViewParent viewParent = this.viewRef;
        if (viewParent == null) {
            return;
        }
        if (!((viewParent = ((View)viewParent.get()).getParent()) instanceof CoordinatorLayout)) {
            return;
        }
        viewParent = (CoordinatorLayout)viewParent;
        int n = viewParent.getChildCount();
        if (Build.VERSION.SDK_INT >= 16 && bl) {
            if (this.importantForAccessibilityMap == null) {
                this.importantForAccessibilityMap = new HashMap<View, Integer>(n);
            } else {
                return;
            }
        }
        for (int i = 0; i < n; ++i) {
            Map<View, Integer> map;
            View view = viewParent.getChildAt(i);
            if (view == this.viewRef.get()) continue;
            if (bl) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.importantForAccessibilityMap.put(view, view.getImportantForAccessibility());
                }
                if (!this.updateImportantForAccessibilityOnSiblings) continue;
                ViewCompat.setImportantForAccessibility((View)view, (int)4);
                continue;
            }
            if (!this.updateImportantForAccessibilityOnSiblings || (map = this.importantForAccessibilityMap) == null || !map.containsKey(view)) continue;
            ViewCompat.setImportantForAccessibility((View)view, (int)this.importantForAccessibilityMap.get(view));
        }
        if (!bl) {
            this.importantForAccessibilityMap = null;
        } else if (this.updateImportantForAccessibilityOnSiblings) {
            ((View)this.viewRef.get()).sendAccessibilityEvent(8);
        }
    }

    private void updatePeekHeight(boolean bl) {
        if (this.viewRef != null) {
            View view;
            this.calculateCollapsedOffset();
            if (this.state == 4 && (view = (View)this.viewRef.get()) != null) {
                if (bl) {
                    this.settleToStatePendingLayout(this.state);
                } else {
                    view.requestLayout();
                }
            }
        }
    }

    public void addBottomSheetCallback(BottomSheetCallback bottomSheetCallback) {
        if (!this.callbacks.contains(bottomSheetCallback)) {
            this.callbacks.add(bottomSheetCallback);
        }
    }

    public void disableShapeAnimations() {
        this.interpolatorAnimator = null;
    }

    void dispatchOnSlide(int n) {
        View view = (View)this.viewRef.get();
        if (view != null && !this.callbacks.isEmpty()) {
            float f;
            float f2;
            int n2 = this.collapsedOffset;
            if (n <= n2 && n2 != this.getExpandedOffset()) {
                n2 = this.collapsedOffset;
                f2 = n2 - n;
                f = n2 - this.getExpandedOffset();
            } else {
                n2 = this.collapsedOffset;
                f2 = n2 - n;
                f = this.parentHeight - n2;
            }
            f = f2 / f;
            for (n = 0; n < this.callbacks.size(); ++n) {
                this.callbacks.get(n).onSlide(view, f);
            }
        }
    }

    View findScrollingChild(View view) {
        if (ViewCompat.isNestedScrollingEnabled((View)view)) {
            return view;
        }
        if (view instanceof ViewGroup) {
            view = (ViewGroup)view;
            int n = view.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view2 = this.findScrollingChild(view.getChildAt(i));
                if (view2 == null) continue;
                return view2;
            }
        }
        return null;
    }

    public int getExpandedOffset() {
        int n;
        if (this.fitToContents) {
            n = this.fitToContentsOffset;
        } else {
            int n2 = this.expandedOffset;
            n = this.paddingTopSystemWindowInsets ? 0 : this.insetTop;
            n = Math.max(n2, n);
        }
        return n;
    }

    public float getHalfExpandedRatio() {
        return this.halfExpandedRatio;
    }

    public int getLastStableState() {
        return this.lastStableState;
    }

    MaterialShapeDrawable getMaterialShapeDrawable() {
        return this.materialShapeDrawable;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getPeekHeight() {
        int n = this.peekHeightAuto ? -1 : this.peekHeight;
        return n;
    }

    int getPeekHeightMin() {
        return this.peekHeightMin;
    }

    public int getSaveFlags() {
        return this.saveFlags;
    }

    public boolean getSkipCollapsed() {
        return this.skipCollapsed;
    }

    public int getState() {
        return this.state;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public boolean isFitToContents() {
        return this.fitToContents;
    }

    public boolean isGestureInsetBottomIgnored() {
        return this.gestureInsetBottomIgnored;
    }

    public boolean isHideable() {
        return this.hideable;
    }

    public boolean isNestedScrollingCheckEnabled() {
        return true;
    }

    public void onAttachedToLayoutParams(CoordinatorLayout.LayoutParams layoutParams) {
        super.onAttachedToLayoutParams(layoutParams);
        this.viewRef = null;
        this.viewDragHelper = null;
    }

    public void onDetachedFromLayoutParams() {
        super.onDetachedFromLayoutParams();
        this.viewRef = null;
        this.viewDragHelper = null;
    }

    public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V object, MotionEvent motionEvent) {
        boolean bl = object.isShown();
        boolean bl2 = false;
        if (bl && this.draggable) {
            Object object2;
            int n = motionEvent.getActionMasked();
            if (n == 0) {
                this.reset();
            }
            if (this.velocityTracker == null) {
                this.velocityTracker = VelocityTracker.obtain();
            }
            this.velocityTracker.addMovement(motionEvent);
            Object var7_7 = null;
            if (n != 0) {
                if (n == 1 || n == 3) {
                    this.touchingScrollingChild = false;
                    this.activePointerId = -1;
                    if (this.ignoreEvents) {
                        this.ignoreEvents = false;
                        return false;
                    }
                }
            } else {
                int n2 = (int)motionEvent.getX();
                this.initialY = (int)motionEvent.getY();
                if (this.state != 2 && (object2 = (object2 = this.nestedScrollingChildRef) != null ? (View)object2.get() : null) != null && coordinatorLayout.isPointInChildBounds(object2, n2, this.initialY)) {
                    this.activePointerId = motionEvent.getPointerId(motionEvent.getActionIndex());
                    this.touchingScrollingChild = true;
                }
                bl = this.activePointerId == -1 && !coordinatorLayout.isPointInChildBounds(object, n2, this.initialY);
                this.ignoreEvents = bl;
            }
            if (!this.ignoreEvents && (object = this.viewDragHelper) != null && object.shouldInterceptTouchEvent(motionEvent)) {
                return true;
            }
            object2 = this.nestedScrollingChildRef;
            object = var7_7;
            if (object2 != null) {
                object = (View)object2.get();
            }
            bl = bl2;
            if (n == 2) {
                bl = bl2;
                if (object != null) {
                    bl = bl2;
                    if (!this.ignoreEvents) {
                        bl = bl2;
                        if (this.state != 1) {
                            bl = bl2;
                            if (!coordinatorLayout.isPointInChildBounds(object, (int)motionEvent.getX(), (int)motionEvent.getY())) {
                                bl = bl2;
                                if (this.viewDragHelper != null) {
                                    bl = bl2;
                                    if (Math.abs((float)this.initialY - motionEvent.getY()) > (float)this.viewDragHelper.getTouchSlop()) {
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return bl;
        }
        this.ignoreEvents = true;
        return false;
    }

    public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v, int n) {
        if (ViewCompat.getFitsSystemWindows((View)coordinatorLayout) && !ViewCompat.getFitsSystemWindows(v)) {
            v.setFitsSystemWindows(true);
        }
        if (this.viewRef == null) {
            MaterialShapeDrawable materialShapeDrawable;
            this.peekHeightMin = coordinatorLayout.getResources().getDimensionPixelSize(R.dimen.design_bottom_sheet_peek_height_min);
            this.setWindowInsetsListener((View)v);
            this.viewRef = new WeakReference<V>(v);
            if (this.shapeThemingEnabled && (materialShapeDrawable = this.materialShapeDrawable) != null) {
                ViewCompat.setBackground(v, (Drawable)materialShapeDrawable);
            }
            if ((materialShapeDrawable = this.materialShapeDrawable) != null) {
                float f;
                float f2 = f = this.elevation;
                if (f == -1.0f) {
                    f2 = ViewCompat.getElevation(v);
                }
                materialShapeDrawable.setElevation(f2);
                boolean bl = this.state == 3;
                this.isShapeExpanded = bl;
                materialShapeDrawable = this.materialShapeDrawable;
                f2 = bl ? 0.0f : 1.0f;
                materialShapeDrawable.setInterpolation(f2);
            }
            this.updateAccessibilityActions();
            if (ViewCompat.getImportantForAccessibility(v) == 0) {
                ViewCompat.setImportantForAccessibility(v, (int)1);
            }
        }
        if (this.viewDragHelper == null) {
            this.viewDragHelper = ViewDragHelper.create((ViewGroup)coordinatorLayout, (ViewDragHelper.Callback)this.dragCallback);
        }
        int n2 = v.getTop();
        coordinatorLayout.onLayoutChild(v, n);
        this.parentWidth = coordinatorLayout.getWidth();
        this.parentHeight = coordinatorLayout.getHeight();
        this.childHeight = n = v.getHeight();
        int n3 = this.parentHeight;
        int n4 = this.insetTop;
        if (n3 - n < n4) {
            this.childHeight = this.paddingTopSystemWindowInsets ? n3 : n3 - n4;
        }
        this.fitToContentsOffset = Math.max(0, n3 - this.childHeight);
        this.calculateHalfExpandedOffset();
        this.calculateCollapsedOffset();
        n = this.state;
        if (n == 3) {
            ViewCompat.offsetTopAndBottom(v, (int)this.getExpandedOffset());
        } else if (n == 6) {
            ViewCompat.offsetTopAndBottom(v, (int)this.halfExpandedOffset);
        } else if (this.hideable && n == 5) {
            ViewCompat.offsetTopAndBottom(v, (int)this.parentHeight);
        } else if (n == 4) {
            ViewCompat.offsetTopAndBottom(v, (int)this.collapsedOffset);
        } else if (n == 1 || n == 2) {
            ViewCompat.offsetTopAndBottom(v, (int)(n2 - v.getTop()));
        }
        this.nestedScrollingChildRef = new WeakReference<View>(this.findScrollingChild((View)v));
        return true;
    }

    public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, V v, int n, int n2, int n3, int n4) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)v.getLayoutParams();
        v.measure(this.getChildMeasureSpec(n, coordinatorLayout.getPaddingLeft() + coordinatorLayout.getPaddingRight() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + n2, this.maxWidth, marginLayoutParams.width), this.getChildMeasureSpec(n3, coordinatorLayout.getPaddingTop() + coordinatorLayout.getPaddingBottom() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin + n4, this.maxHeight, marginLayoutParams.height));
        return true;
    }

    public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V v, View view, float f, float f2) {
        boolean bl;
        block2: {
            block3: {
                boolean bl2;
                boolean bl3 = this.isNestedScrollingCheckEnabled();
                bl = bl2 = false;
                if (!bl3) break block2;
                WeakReference<View> weakReference = this.nestedScrollingChildRef;
                bl = bl2;
                if (weakReference == null) break block2;
                bl = bl2;
                if (view != weakReference.get()) break block2;
                if (this.state != 3) break block3;
                bl = bl2;
                if (!super.onNestedPreFling(coordinatorLayout, v, view, f, f2)) break block2;
            }
            bl = true;
        }
        return bl;
    }

    public void onNestedPreScroll(CoordinatorLayout object, V v, View view, int n, int n2, int[] nArray, int n3) {
        if (n3 == 1) {
            return;
        }
        object = this.nestedScrollingChildRef;
        object = object != null ? (View)((Reference)object).get() : null;
        if (this.isNestedScrollingCheckEnabled() && view != object) {
            return;
        }
        n = v.getTop();
        n3 = n - n2;
        if (n2 > 0) {
            if (n3 < this.getExpandedOffset()) {
                nArray[1] = n - this.getExpandedOffset();
                ViewCompat.offsetTopAndBottom(v, (int)(-nArray[1]));
                this.setStateInternal(3);
            } else {
                if (!this.draggable) {
                    return;
                }
                nArray[1] = n2;
                ViewCompat.offsetTopAndBottom(v, (int)(-n2));
                this.setStateInternal(1);
            }
        } else if (n2 < 0 && !view.canScrollVertically(-1)) {
            int n4 = this.collapsedOffset;
            if (n3 > n4 && !this.hideable) {
                nArray[1] = n - n4;
                ViewCompat.offsetTopAndBottom(v, (int)(-nArray[1]));
                this.setStateInternal(4);
            } else {
                if (!this.draggable) {
                    return;
                }
                nArray[1] = n2;
                ViewCompat.offsetTopAndBottom(v, (int)(-n2));
                this.setStateInternal(1);
            }
        }
        this.dispatchOnSlide(v.getTop());
        this.lastNestedScrollDy = n2;
        this.nestedScrolled = true;
    }

    public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n, int n2, int n3, int n4, int n5, int[] nArray) {
    }

    public void onRestoreInstanceState(CoordinatorLayout coordinatorLayout, V v, Parcelable object) {
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(coordinatorLayout, v, object.getSuperState());
        this.restoreOptionalState((SavedState)((Object)object));
        if (object.state != 1 && object.state != 2) {
            int n;
            this.state = n = object.state;
            this.lastStableState = n;
        } else {
            this.state = 4;
            this.lastStableState = 4;
        }
    }

    public Parcelable onSaveInstanceState(CoordinatorLayout coordinatorLayout, V v) {
        return new SavedState(super.onSaveInstanceState(coordinatorLayout, v), this);
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int n, int n2) {
        boolean bl = false;
        this.lastNestedScrollDy = 0;
        this.nestedScrolled = false;
        if ((n & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void onStopNestedScroll(CoordinatorLayout var1_1, V var2_2, View var3_3, int var4_4) {
        block9: {
            block11: {
                block17: {
                    block14: {
                        block16: {
                            block15: {
                                block12: {
                                    block13: {
                                        block10: {
                                            block7: {
                                                block8: {
                                                    var5_5 = var2_2.getTop();
                                                    var4_4 = this.getExpandedOffset();
                                                    var6_6 = 3;
                                                    if (var5_5 == var4_4) {
                                                        this.setStateInternal(3);
                                                        return;
                                                    }
                                                    if (this.isNestedScrollingCheckEnabled() && ((var1_1 = this.nestedScrollingChildRef) == null || var3_3 != var1_1.get() || !this.nestedScrolled)) {
                                                        return;
                                                    }
                                                    if (this.lastNestedScrollDy <= 0) break block7;
                                                    if (!this.fitToContents) break block8;
                                                    var4_4 = this.fitToContentsOffset;
                                                    break block9;
                                                }
                                                var5_5 = var2_2.getTop();
                                                if (var5_5 > (var4_4 = this.halfExpandedOffset)) ** GOTO lbl62
                                                var4_4 = this.getExpandedOffset();
                                                break block9;
                                            }
                                            if (!this.hideable || !this.shouldHide((View)var2_2, this.getYVelocity())) break block10;
                                            var4_4 = this.parentHeight;
                                            var6_6 = 5;
                                            break block9;
                                        }
                                        if (this.lastNestedScrollDy != 0) break block11;
                                        var4_4 = var2_2.getTop();
                                        if (!this.fitToContents) break block12;
                                        if (Math.abs(var4_4 - this.fitToContentsOffset) >= Math.abs(var4_4 - this.collapsedOffset)) break block13;
                                        var4_4 = this.fitToContentsOffset;
                                        break block9;
                                    }
                                    var4_4 = this.collapsedOffset;
                                    ** GOTO lbl56
                                }
                                var5_5 = this.halfExpandedOffset;
                                if (var4_4 >= var5_5) break block14;
                                if (var4_4 >= Math.abs(var4_4 - this.collapsedOffset)) break block15;
                                var4_4 = this.getExpandedOffset();
                                break block9;
                            }
                            if (!this.shouldSkipHalfExpandedStateWhenDragging()) break block16;
                            var4_4 = this.collapsedOffset;
                            ** GOTO lbl56
                        }
                        var4_4 = this.halfExpandedOffset;
                        ** GOTO lbl62
                    }
                    if (Math.abs(var4_4 - var5_5) >= Math.abs(var4_4 - this.collapsedOffset)) break block17;
                    var4_4 = this.halfExpandedOffset;
                    ** GOTO lbl62
                }
                var4_4 = this.collapsedOffset;
                ** GOTO lbl56
            }
            if (this.fitToContents) {
                var4_4 = this.collapsedOffset;
lbl56:
                // 5 sources

                while (true) {
                    var6_6 = 4;
                    break;
                }
            } else {
                var4_4 = var2_2.getTop();
                if (Math.abs(var4_4 - this.halfExpandedOffset) < Math.abs(var4_4 - this.collapsedOffset)) {
                    var4_4 = this.halfExpandedOffset;
lbl62:
                    // 4 sources

                    var6_6 = 6;
                } else {
                    var4_4 = this.collapsedOffset;
                    ** continue;
                }
            }
        }
        this.startSettlingAnimation((View)var2_2, var6_6, var4_4, false);
        this.nestedScrolled = false;
    }

    public boolean onTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
        if (!v.isShown()) {
            return false;
        }
        int n = motionEvent.getActionMasked();
        if (this.state == 1 && n == 0) {
            return true;
        }
        if (this.shouldHandleDraggingWithHelper()) {
            this.viewDragHelper.processTouchEvent(motionEvent);
        }
        if (n == 0) {
            this.reset();
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(motionEvent);
        if (this.shouldHandleDraggingWithHelper() && n == 2 && !this.ignoreEvents && Math.abs((float)this.initialY - motionEvent.getY()) > (float)this.viewDragHelper.getTouchSlop()) {
            this.viewDragHelper.captureChildView(v, motionEvent.getPointerId(motionEvent.getActionIndex()));
        }
        return this.ignoreEvents ^ true;
    }

    public void removeBottomSheetCallback(BottomSheetCallback bottomSheetCallback) {
        this.callbacks.remove(bottomSheetCallback);
    }

    @Deprecated
    public void setBottomSheetCallback(BottomSheetCallback bottomSheetCallback) {
        Log.w((String)TAG, (String)"BottomSheetBehavior now supports multiple callbacks. `setBottomSheetCallback()` removes all existing callbacks, including ones set internally by library authors, which may result in unintended behavior. This may change in the future. Please use `addBottomSheetCallback()` and `removeBottomSheetCallback()` instead to set your own callbacks.");
        this.callbacks.clear();
        if (bottomSheetCallback != null) {
            this.callbacks.add(bottomSheetCallback);
        }
    }

    public void setDraggable(boolean bl) {
        this.draggable = bl;
    }

    public void setExpandedOffset(int n) {
        if (n >= 0) {
            this.expandedOffset = n;
            return;
        }
        throw new IllegalArgumentException("offset must be greater than or equal to 0");
    }

    public void setFitToContents(boolean bl) {
        if (this.fitToContents == bl) {
            return;
        }
        this.fitToContents = bl;
        if (this.viewRef != null) {
            this.calculateCollapsedOffset();
        }
        int n = this.fitToContents && this.state == 6 ? 3 : this.state;
        this.setStateInternal(n);
        this.updateAccessibilityActions();
    }

    public void setGestureInsetBottomIgnored(boolean bl) {
        this.gestureInsetBottomIgnored = bl;
    }

    public void setHalfExpandedRatio(float f) {
        if (!(f <= 0.0f) && !(f >= 1.0f)) {
            this.halfExpandedRatio = f;
            if (this.viewRef != null) {
                this.calculateHalfExpandedOffset();
            }
            return;
        }
        throw new IllegalArgumentException("ratio must be a float value between 0 and 1");
    }

    public void setHideable(boolean bl) {
        if (this.hideable != bl) {
            this.hideable = bl;
            if (!bl && this.state == 5) {
                this.setState(4);
            }
            this.updateAccessibilityActions();
        }
    }

    public void setHideableInternal(boolean bl) {
        this.hideable = bl;
    }

    public void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
    }

    public void setPeekHeight(int n) {
        this.setPeekHeight(n, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setPeekHeight(int n, boolean bl) {
        int n2 = 1;
        if (n == -1) {
            if (this.peekHeightAuto) return;
            this.peekHeightAuto = true;
            n = n2;
        } else {
            if (!this.peekHeightAuto) {
                if (this.peekHeight == n) return;
            }
            this.peekHeightAuto = false;
            this.peekHeight = Math.max(0, n);
            n = n2;
        }
        if (n == 0) return;
        this.updatePeekHeight(bl);
    }

    public void setSaveFlags(int n) {
        this.saveFlags = n;
    }

    public void setSkipCollapsed(boolean bl) {
        this.skipCollapsed = bl;
    }

    public void setState(int n) {
        if (n == this.state) {
            return;
        }
        if (this.viewRef == null) {
            if (n == 4 || n == 3 || n == 6 || this.hideable && n == 5) {
                this.state = n;
                this.lastStableState = n;
            }
            return;
        }
        this.settleToStatePendingLayout(n);
    }

    void setStateInternal(int n) {
        View view;
        if (this.state == n) {
            return;
        }
        this.state = n;
        if (n == 4 || n == 3 || n == 6 || this.hideable && n == 5) {
            this.lastStableState = n;
        }
        if ((view = this.viewRef) == null) {
            return;
        }
        if ((view = (View)view.get()) == null) {
            return;
        }
        int n2 = 0;
        if (n == 3) {
            this.updateImportantForAccessibility(true);
        } else if (n == 6 || n == 5 || n == 4) {
            this.updateImportantForAccessibility(false);
        }
        this.updateDrawableForTargetState(n);
        while (n2 < this.callbacks.size()) {
            this.callbacks.get(n2).onStateChanged(view, n);
            ++n2;
        }
        this.updateAccessibilityActions();
    }

    public void setUpdateImportantForAccessibilityOnSiblings(boolean bl) {
        this.updateImportantForAccessibilityOnSiblings = bl;
    }

    void settleToState(View view, int n) {
        block9: {
            int n2;
            block6: {
                block8: {
                    block7: {
                        int n3;
                        block5: {
                            if (n != 4) break block5;
                            n2 = this.collapsedOffset;
                            break block6;
                        }
                        if (n != 6) break block7;
                        n2 = this.halfExpandedOffset;
                        if (this.fitToContents && n2 <= (n3 = this.fitToContentsOffset)) {
                            n2 = n3;
                            n = 3;
                        }
                        break block6;
                    }
                    if (n != 3) break block8;
                    n2 = this.getExpandedOffset();
                    break block6;
                }
                if (!this.hideable || n != 5) break block9;
                n2 = this.parentHeight;
            }
            this.startSettlingAnimation(view, n, n2, false);
            return;
        }
        Log.w((String)TAG, (String)"The bottom sheet may be in an invalid state. Ensure `hideable` is true when using `STATE_HIDDEN`.");
    }

    public boolean shouldExpandOnUpwardDrag(long l, float f) {
        return false;
    }

    boolean shouldHide(View view, float f) {
        boolean bl = this.skipCollapsed;
        boolean bl2 = true;
        if (bl) {
            return true;
        }
        if (view.getTop() < this.collapsedOffset) {
            return false;
        }
        int n = this.calculatePeekHeight();
        if (!(Math.abs((float)view.getTop() + f * 0.1f - (float)this.collapsedOffset) / (float)n > 0.5f)) {
            bl2 = false;
        }
        return bl2;
    }

    public boolean shouldSkipHalfExpandedStateWhenDragging() {
        return false;
    }

    public boolean shouldSkipSmoothAnimation() {
        return true;
    }

    void startSettlingAnimation(View view, int n, int n2, boolean bl) {
        ViewDragHelper viewDragHelper = this.viewDragHelper;
        n2 = viewDragHelper != null && (bl ? viewDragHelper.settleCapturedViewAt(view.getLeft(), n2) : viewDragHelper.smoothSlideViewTo(view, view.getLeft(), n2)) ? 1 : 0;
        if (n2 != 0) {
            this.setStateInternal(2);
            this.updateDrawableForTargetState(n);
            if (this.settleRunnable == null) {
                this.settleRunnable = new SettleRunnable(view, n);
            }
            if (!this.settleRunnable.isPosted) {
                this.settleRunnable.targetState = n;
                ViewCompat.postOnAnimation((View)view, (Runnable)this.settleRunnable);
                SettleRunnable.access$802(this.settleRunnable, true);
            } else {
                this.settleRunnable.targetState = n;
            }
        } else {
            this.setStateInternal(n);
        }
    }

    public static abstract class BottomSheetCallback {
        public abstract void onSlide(View var1, float var2);

        public abstract void onStateChanged(View var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SaveFlags {
    }

    protected static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean fitToContents;
        boolean hideable;
        int peekHeight;
        boolean skipCollapsed;
        final int state;

        public SavedState(Parcel parcel) {
            this(parcel, null);
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.state = parcel.readInt();
            this.peekHeight = parcel.readInt();
            int n = parcel.readInt();
            boolean bl = false;
            boolean bl2 = n == 1;
            this.fitToContents = bl2;
            bl2 = parcel.readInt() == 1;
            this.hideable = bl2;
            bl2 = bl;
            if (parcel.readInt() == 1) {
                bl2 = true;
            }
            this.skipCollapsed = bl2;
        }

        @Deprecated
        public SavedState(Parcelable parcelable, int n) {
            super(parcelable);
            this.state = n;
        }

        public SavedState(Parcelable parcelable, BottomSheetBehavior<?> bottomSheetBehavior) {
            super(parcelable);
            this.state = bottomSheetBehavior.state;
            this.peekHeight = ((BottomSheetBehavior)bottomSheetBehavior).peekHeight;
            this.fitToContents = ((BottomSheetBehavior)bottomSheetBehavior).fitToContents;
            this.hideable = bottomSheetBehavior.hideable;
            this.skipCollapsed = ((BottomSheetBehavior)bottomSheetBehavior).skipCollapsed;
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.state);
            parcel.writeInt(this.peekHeight);
            parcel.writeInt(this.fitToContents ? 1 : 0);
            parcel.writeInt(this.hideable ? 1 : 0);
            parcel.writeInt(this.skipCollapsed ? 1 : 0);
        }
    }

    private class SettleRunnable
    implements Runnable {
        private boolean isPosted;
        int targetState;
        private final View view;

        SettleRunnable(View view, int n) {
            this.view = view;
            this.targetState = n;
        }

        static /* synthetic */ boolean access$802(SettleRunnable settleRunnable, boolean bl) {
            settleRunnable.isPosted = bl;
            return bl;
        }

        @Override
        public void run() {
            if (BottomSheetBehavior.this.viewDragHelper != null && BottomSheetBehavior.this.viewDragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.view, (Runnable)this);
            } else {
                BottomSheetBehavior.this.setStateInternal(this.targetState);
            }
            this.isPosted = false;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

