/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomsheet;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.appcompat.app.AppCompatDialog;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.shape.MaterialShapeDrawable;

public class BottomSheetDialog
extends AppCompatDialog {
    private BottomSheetBehavior<FrameLayout> behavior;
    private FrameLayout bottomSheet;
    private BottomSheetBehavior.BottomSheetCallback bottomSheetCallback = new BottomSheetBehavior.BottomSheetCallback(){

        @Override
        public void onSlide(View view, float f) {
        }

        @Override
        public void onStateChanged(View view, int n) {
            if (n == 5) {
                BottomSheetDialog.this.cancel();
            }
        }
    };
    boolean cancelable = true;
    private boolean canceledOnTouchOutside = true;
    private boolean canceledOnTouchOutsideSet;
    private FrameLayout container;
    private CoordinatorLayout coordinator;
    boolean dismissWithAnimation;
    private BottomSheetBehavior.BottomSheetCallback edgeToEdgeCallback;
    private boolean edgeToEdgeEnabled;

    public BottomSheetDialog(Context context) {
        this(context, 0);
        this.edgeToEdgeEnabled = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.enableEdgeToEdge}).getBoolean(0, false);
    }

    public BottomSheetDialog(Context context, int n) {
        super(context, BottomSheetDialog.getThemeResId(context, n));
        this.supportRequestWindowFeature(1);
        this.edgeToEdgeEnabled = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.enableEdgeToEdge}).getBoolean(0, false);
    }

    protected BottomSheetDialog(Context context, boolean bl, DialogInterface.OnCancelListener onCancelListener) {
        super(context, bl, onCancelListener);
        this.supportRequestWindowFeature(1);
        this.cancelable = bl;
        this.edgeToEdgeEnabled = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.enableEdgeToEdge}).getBoolean(0, false);
    }

    static /* synthetic */ BottomSheetBehavior.BottomSheetCallback access$002(BottomSheetDialog bottomSheetDialog, BottomSheetBehavior.BottomSheetCallback bottomSheetCallback) {
        bottomSheetDialog.edgeToEdgeCallback = bottomSheetCallback;
        return bottomSheetCallback;
    }

    private FrameLayout ensureContainerAndBehavior() {
        if (this.container == null) {
            Object object = (FrameLayout)View.inflate((Context)this.getContext(), (int)R.layout.design_bottom_sheet_dialog, null);
            this.container = object;
            this.coordinator = (CoordinatorLayout)object.findViewById(R.id.coordinator);
            object = (FrameLayout)this.container.findViewById(R.id.design_bottom_sheet);
            this.bottomSheet = object;
            this.behavior = object = BottomSheetBehavior.from(object);
            ((BottomSheetBehavior)((Object)object)).addBottomSheetCallback(this.bottomSheetCallback);
            this.behavior.setHideable(this.cancelable);
        }
        return this.container;
    }

    private static int getThemeResId(Context context, int n) {
        int n2 = n;
        if (n == 0) {
            TypedValue typedValue = new TypedValue();
            n2 = context.getTheme().resolveAttribute(R.attr.bottomSheetDialogTheme, typedValue, true) ? typedValue.resourceId : R.style.Theme_Design_Light_BottomSheetDialog;
        }
        return n2;
    }

    public static void setLightStatusBar(View view, boolean bl) {
        if (Build.VERSION.SDK_INT >= 23) {
            int n = view.getSystemUiVisibility();
            n = bl ? (n |= 0x2000) : (n &= 0xFFFFDFFF);
            view.setSystemUiVisibility(n);
        }
    }

    private View wrapInBottomSheet(int n, View view, ViewGroup.LayoutParams layoutParams) {
        this.ensureContainerAndBehavior();
        CoordinatorLayout coordinatorLayout = (CoordinatorLayout)this.container.findViewById(R.id.coordinator);
        View view2 = view;
        if (n != 0) {
            view2 = view;
            if (view == null) {
                view2 = this.getLayoutInflater().inflate(n, (ViewGroup)coordinatorLayout, false);
            }
        }
        if (this.edgeToEdgeEnabled) {
            ViewCompat.setOnApplyWindowInsetsListener((View)this.bottomSheet, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

                public WindowInsetsCompat onApplyWindowInsets(View object, WindowInsetsCompat windowInsetsCompat) {
                    if (BottomSheetDialog.this.edgeToEdgeCallback != null) {
                        BottomSheetDialog.this.behavior.removeBottomSheetCallback(BottomSheetDialog.this.edgeToEdgeCallback);
                    }
                    if (windowInsetsCompat != null) {
                        object = BottomSheetDialog.this;
                        BottomSheetDialog.access$002((BottomSheetDialog)((Object)object), new EdgeToEdgeCallback((View)((BottomSheetDialog)((Object)object)).bottomSheet, windowInsetsCompat));
                        BottomSheetDialog.this.behavior.addBottomSheetCallback(BottomSheetDialog.this.edgeToEdgeCallback);
                    }
                    return windowInsetsCompat;
                }
            });
        }
        this.bottomSheet.removeAllViews();
        if (layoutParams == null) {
            this.bottomSheet.addView(view2);
        } else {
            this.bottomSheet.addView(view2, layoutParams);
        }
        coordinatorLayout.findViewById(R.id.touch_outside).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BottomSheetDialog.this.cancelable && BottomSheetDialog.this.isShowing() && BottomSheetDialog.this.shouldWindowCloseOnTouchOutside()) {
                    BottomSheetDialog.this.cancel();
                }
            }
        });
        ViewCompat.setAccessibilityDelegate((View)this.bottomSheet, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                if (BottomSheetDialog.this.cancelable) {
                    accessibilityNodeInfoCompat.addAction(0x100000);
                    accessibilityNodeInfoCompat.setDismissable(true);
                } else {
                    accessibilityNodeInfoCompat.setDismissable(false);
                }
            }

            public boolean performAccessibilityAction(View view, int n, Bundle bundle) {
                if (n == 0x100000 && BottomSheetDialog.this.cancelable) {
                    BottomSheetDialog.this.cancel();
                    return true;
                }
                return super.performAccessibilityAction(view, n, bundle);
            }
        });
        this.bottomSheet.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        return this.container;
    }

    public void cancel() {
        BottomSheetBehavior<FrameLayout> bottomSheetBehavior = this.getBehavior();
        if (this.dismissWithAnimation && bottomSheetBehavior.getState() != 5) {
            bottomSheetBehavior.setState(5);
        } else {
            super.cancel();
        }
    }

    public BottomSheetBehavior<FrameLayout> getBehavior() {
        if (this.behavior == null) {
            this.ensureContainerAndBehavior();
        }
        return this.behavior;
    }

    public boolean getDismissWithAnimation() {
        return this.dismissWithAnimation;
    }

    public boolean getEdgeToEdgeEnabled() {
        return this.edgeToEdgeEnabled;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Window window = this.getWindow();
        if (window != null && Build.VERSION.SDK_INT >= 21) {
            boolean bl = this.edgeToEdgeEnabled && Color.alpha((int)window.getNavigationBarColor()) < 255;
            FrameLayout frameLayout = this.container;
            if (frameLayout != null) {
                frameLayout.setFitsSystemWindows(bl ^ true);
            }
            if ((frameLayout = this.coordinator) != null) {
                frameLayout.setFitsSystemWindows(bl ^ true);
            }
            if (bl) {
                window.getDecorView().setSystemUiVisibility(768);
            }
        }
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        bundle = this.getWindow();
        if (bundle != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                bundle.setStatusBarColor(0);
                bundle.addFlags(Integer.MIN_VALUE);
                if (Build.VERSION.SDK_INT < 23) {
                    bundle.addFlags(0x4000000);
                }
            }
            bundle.setLayout(-1, -1);
        }
    }

    protected void onStart() {
        super.onStart();
        BottomSheetBehavior<FrameLayout> bottomSheetBehavior = this.behavior;
        if (bottomSheetBehavior != null && bottomSheetBehavior.getState() == 5) {
            this.behavior.setState(4);
        }
    }

    void removeDefaultCallback() {
        this.behavior.removeBottomSheetCallback(this.bottomSheetCallback);
    }

    public void setCancelable(boolean bl) {
        super.setCancelable(bl);
        if (this.cancelable != bl) {
            this.cancelable = bl;
            BottomSheetBehavior<FrameLayout> bottomSheetBehavior = this.behavior;
            if (bottomSheetBehavior != null) {
                bottomSheetBehavior.setHideable(bl);
            }
        }
    }

    public void setCanceledOnTouchOutside(boolean bl) {
        super.setCanceledOnTouchOutside(bl);
        if (bl && !this.cancelable) {
            this.cancelable = true;
        }
        this.canceledOnTouchOutside = bl;
        this.canceledOnTouchOutsideSet = true;
    }

    public void setContentView(int n) {
        super.setContentView(this.wrapInBottomSheet(n, null, null));
    }

    public void setContentView(View view) {
        super.setContentView(this.wrapInBottomSheet(0, view, null));
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        super.setContentView(this.wrapInBottomSheet(0, view, layoutParams));
    }

    public void setDismissWithAnimation(boolean bl) {
        this.dismissWithAnimation = bl;
    }

    boolean shouldWindowCloseOnTouchOutside() {
        if (!this.canceledOnTouchOutsideSet) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(new int[]{16843611});
            this.canceledOnTouchOutside = typedArray.getBoolean(0, true);
            typedArray.recycle();
            this.canceledOnTouchOutsideSet = true;
        }
        return this.canceledOnTouchOutside;
    }

    private static class EdgeToEdgeCallback
    extends BottomSheetBehavior.BottomSheetCallback {
        private final WindowInsetsCompat insetsCompat;
        private final boolean lightBottomSheet;
        private final boolean lightStatusBar;

        private EdgeToEdgeCallback(View view, WindowInsetsCompat object) {
            this.insetsCompat = object;
            boolean bl = Build.VERSION.SDK_INT >= 23 && (view.getSystemUiVisibility() & 0x2000) != 0;
            this.lightStatusBar = bl;
            object = BottomSheetBehavior.from(view).getMaterialShapeDrawable();
            object = object != null ? ((MaterialShapeDrawable)object).getFillColor() : ViewCompat.getBackgroundTintList((View)view);
            this.lightBottomSheet = object != null ? MaterialColors.isColorLight(object.getDefaultColor()) : (view.getBackground() instanceof ColorDrawable ? MaterialColors.isColorLight(((ColorDrawable)view.getBackground()).getColor()) : bl);
        }

        private void setPaddingForPosition(View view) {
            if (view.getTop() < this.insetsCompat.getSystemWindowInsetTop()) {
                BottomSheetDialog.setLightStatusBar(view, this.lightBottomSheet);
                view.setPadding(view.getPaddingLeft(), this.insetsCompat.getSystemWindowInsetTop() - view.getTop(), view.getPaddingRight(), view.getPaddingBottom());
            } else if (view.getTop() != 0) {
                BottomSheetDialog.setLightStatusBar(view, this.lightStatusBar);
                view.setPadding(view.getPaddingLeft(), 0, view.getPaddingRight(), view.getPaddingBottom());
            }
        }

        @Override
        public void onSlide(View view, float f) {
            this.setPaddingForPosition(view);
        }

        @Override
        public void onStateChanged(View view, int n) {
            this.setPaddingForPosition(view);
        }
    }
}

