/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.bottomsheet;

import android.app.Dialog;
import android.os.Bundle;
import android.view.View;
import androidx.appcompat.app.AppCompatDialogFragment;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;

public class BottomSheetDialogFragment
extends AppCompatDialogFragment {
    private boolean waitingForDismissAllowingStateLoss;

    private void dismissAfterAnimation() {
        if (this.waitingForDismissAllowingStateLoss) {
            super.dismissAllowingStateLoss();
        } else {
            super.dismiss();
        }
    }

    private void dismissWithAnimation(BottomSheetBehavior<?> bottomSheetBehavior, boolean bl) {
        this.waitingForDismissAllowingStateLoss = bl;
        if (bottomSheetBehavior.getState() == 5) {
            this.dismissAfterAnimation();
        } else {
            if (this.getDialog() instanceof BottomSheetDialog) {
                ((BottomSheetDialog)this.getDialog()).removeDefaultCallback();
            }
            bottomSheetBehavior.addBottomSheetCallback(new BottomSheetDismissCallback());
            bottomSheetBehavior.setState(5);
        }
    }

    private boolean tryDismissWithAnimation(boolean bl) {
        BottomSheetDialog bottomSheetDialog;
        Object object = this.getDialog();
        if (object instanceof BottomSheetDialog && ((BottomSheetBehavior)((Object)(object = (bottomSheetDialog = (BottomSheetDialog)((Object)object)).getBehavior()))).isHideable() && bottomSheetDialog.getDismissWithAnimation()) {
            this.dismissWithAnimation((BottomSheetBehavior<?>)((Object)object), bl);
            return true;
        }
        return false;
    }

    public void dismiss() {
        if (!this.tryDismissWithAnimation(false)) {
            super.dismiss();
        }
    }

    public void dismissAllowingStateLoss() {
        if (!this.tryDismissWithAnimation(true)) {
            super.dismissAllowingStateLoss();
        }
    }

    public Dialog onCreateDialog(Bundle bundle) {
        return new BottomSheetDialog(this.getContext(), this.getTheme());
    }

    private class BottomSheetDismissCallback
    extends BottomSheetBehavior.BottomSheetCallback {
        private BottomSheetDismissCallback() {
        }

        @Override
        public void onSlide(View view, float f) {
        }

        @Override
        public void onStateChanged(View view, int n) {
            if (n == 5) {
                BottomSheetDialogFragment.this.dismissAfterAnimation();
            }
        }
    }
}

