/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.chip;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import com.google.android.material.R;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.chip.ChipDrawable;
import com.google.android.material.chip.ChipGroup;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.resources.TextAppearanceFontCallback;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.Shapeable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.List;

public class Chip
extends AppCompatCheckBox
implements ChipDrawable.Delegate,
Shapeable {
    private static final String BUTTON_ACCESSIBILITY_CLASS_NAME = "android.widget.Button";
    private static final int[] CHECKABLE_STATE_SET;
    private static final int CHIP_BODY_VIRTUAL_ID = 0;
    private static final int CLOSE_ICON_VIRTUAL_ID = 1;
    private static final String COMPOUND_BUTTON_ACCESSIBILITY_CLASS_NAME = "android.widget.CompoundButton";
    private static final int DEF_STYLE_RES;
    private static final Rect EMPTY_BOUNDS;
    private static final String GENERIC_VIEW_ACCESSIBILITY_CLASS_NAME = "android.view.View";
    private static final int MIN_TOUCH_TARGET_DP = 48;
    private static final String NAMESPACE_ANDROID = "http://schemas.android.com/apk/res/android";
    private static final String RADIO_BUTTON_ACCESSIBILITY_CLASS_NAME = "android.widget.RadioButton";
    private static final int[] SELECTED_STATE;
    private static final String TAG = "Chip";
    private ChipDrawable chipDrawable;
    private boolean closeIconFocused;
    private boolean closeIconHovered;
    private boolean closeIconPressed;
    private boolean deferredCheckedValue;
    private boolean ensureMinTouchTargetSize;
    private final TextAppearanceFontCallback fontCallback;
    private InsetDrawable insetBackgroundDrawable;
    private int lastLayoutDirection;
    private int minTouchTargetSize;
    private CompoundButton.OnCheckedChangeListener onCheckedChangeListenerInternal;
    private View.OnClickListener onCloseIconClickListener;
    private final Rect rect;
    private final RectF rectF;
    private RippleDrawable ripple;
    private final ChipTouchHelper touchHelper;
    private boolean touchHelperEnabled;

    static {
        DEF_STYLE_RES = R.style.Widget_MaterialComponents_Chip_Action;
        EMPTY_BOUNDS = new Rect();
        SELECTED_STATE = new int[]{0x10100A1};
        CHECKABLE_STATE_SET = new int[]{16842911};
    }

    public Chip(Context context) {
        this(context, null);
    }

    public Chip(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.chipStyle);
    }

    public Chip(Context context, AttributeSet attributeSet, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
        this.rect = new Rect();
        this.rectF = new RectF();
        this.fontCallback = new TextAppearanceFontCallback(){

            @Override
            public void onFontRetrievalFailed(int n) {
            }

            @Override
            public void onFontRetrieved(Typeface object, boolean bl) {
                Chip chip = Chip.this;
                object = chip.chipDrawable.shouldDrawText() ? Chip.this.chipDrawable.getText() : Chip.this.getText();
                chip.setText((CharSequence)object);
                Chip.this.requestLayout();
                Chip.this.invalidate();
            }
        };
        context = this.getContext();
        this.validateAttributes(attributeSet);
        ChipDrawable chipDrawable = ChipDrawable.createFromAttributes(context, attributeSet, n, n2);
        this.initMinTouchTarget(context, attributeSet, n);
        this.setChipDrawable(chipDrawable);
        chipDrawable.setElevation(ViewCompat.getElevation((View)this));
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.Chip, n, n2, new int[0]);
        if (Build.VERSION.SDK_INT < 23) {
            this.setTextColor(MaterialResources.getColorStateList(context, (TypedArray)attributeSet, R.styleable.Chip_android_textColor));
        }
        boolean bl = attributeSet.hasValue(R.styleable.Chip_shapeAppearance);
        attributeSet.recycle();
        this.touchHelper = new ChipTouchHelper(this);
        this.updateAccessibilityDelegate();
        if (!bl) {
            this.initOutlineProvider();
        }
        this.setChecked(this.deferredCheckedValue);
        this.setText(chipDrawable.getText());
        this.setEllipsize(chipDrawable.getEllipsize());
        this.updateTextPaintDrawState();
        if (!this.chipDrawable.shouldDrawText()) {
            this.setLines(1);
            this.setHorizontallyScrolling(true);
        }
        this.setGravity(8388627);
        this.updatePaddingInternal();
        if (this.shouldEnsureMinTouchTargetSize()) {
            this.setMinHeight(this.minTouchTargetSize);
        }
        this.lastLayoutDirection = ViewCompat.getLayoutDirection((View)this);
    }

    static /* synthetic */ boolean access$402(Chip chip, boolean bl) {
        chip.closeIconFocused = bl;
        return bl;
    }

    private void applyChipDrawable(ChipDrawable chipDrawable) {
        chipDrawable.setDelegate(this);
    }

    private int[] createCloseIconDrawableState() {
        int n;
        int n2 = n = this.isEnabled();
        if (this.closeIconFocused) {
            n2 = n + 1;
        }
        n = n2;
        if (this.closeIconHovered) {
            n = n2 + 1;
        }
        n2 = n;
        if (this.closeIconPressed) {
            n2 = n + 1;
        }
        n = n2;
        if (this.isChecked()) {
            n = n2 + 1;
        }
        int[] nArray = new int[n];
        n2 = 0;
        if (this.isEnabled()) {
            nArray[0] = 16842910;
            n2 = 1;
        }
        n = n2;
        if (this.closeIconFocused) {
            nArray[n2] = 16842908;
            n = n2 + 1;
        }
        n2 = n;
        if (this.closeIconHovered) {
            nArray[n] = 16843623;
            n2 = n + 1;
        }
        n = n2;
        if (this.closeIconPressed) {
            nArray[n2] = 16842919;
            n = n2 + 1;
        }
        if (this.isChecked()) {
            nArray[n] = 0x10100A1;
        }
        return nArray;
    }

    private void ensureChipDrawableHasCallback() {
        if (this.getBackgroundDrawable() == this.insetBackgroundDrawable && this.chipDrawable.getCallback() == null) {
            this.chipDrawable.setCallback((Drawable.Callback)this.insetBackgroundDrawable);
        }
    }

    private RectF getCloseIconTouchBounds() {
        this.rectF.setEmpty();
        if (this.hasCloseIcon() && this.onCloseIconClickListener != null) {
            this.chipDrawable.getCloseIconTouchBounds(this.rectF);
        }
        return this.rectF;
    }

    private Rect getCloseIconTouchBoundsInt() {
        RectF rectF = this.getCloseIconTouchBounds();
        this.rect.set((int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom);
        return this.rect;
    }

    private TextAppearance getTextAppearance() {
        Object object = this.chipDrawable;
        object = object != null ? ((ChipDrawable)object).getTextAppearance() : null;
        return object;
    }

    private boolean hasCloseIcon() {
        ChipDrawable chipDrawable = this.chipDrawable;
        boolean bl = chipDrawable != null && chipDrawable.getCloseIcon() != null;
        return bl;
    }

    private void initMinTouchTarget(Context context, AttributeSet attributeSet, int n) {
        context = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.Chip, n, DEF_STYLE_RES, new int[0]);
        this.ensureMinTouchTargetSize = context.getBoolean(R.styleable.Chip_ensureMinTouchTargetSize, false);
        float f = (float)Math.ceil(ViewUtils.dpToPx(this.getContext(), 48));
        this.minTouchTargetSize = (int)Math.ceil(context.getDimension(R.styleable.Chip_chipMinTouchTargetSize, f));
        context.recycle();
    }

    private void initOutlineProvider() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    if (Chip.this.chipDrawable != null) {
                        Chip.this.chipDrawable.getOutline(outline);
                    } else {
                        outline.setAlpha(0.0f);
                    }
                }
            });
        }
    }

    private void insetChipBackgroundDrawable(int n, int n2, int n3, int n4) {
        this.insetBackgroundDrawable = new InsetDrawable((Drawable)this.chipDrawable, n, n2, n3, n4);
    }

    private void removeBackgroundInset() {
        if (this.insetBackgroundDrawable != null) {
            this.insetBackgroundDrawable = null;
            this.setMinWidth(0);
            this.setMinHeight((int)this.getChipMinHeight());
            this.updateBackgroundDrawable();
        }
    }

    private void setCloseIconHovered(boolean bl) {
        if (this.closeIconHovered != bl) {
            this.closeIconHovered = bl;
            this.refreshDrawableState();
        }
    }

    private void setCloseIconPressed(boolean bl) {
        if (this.closeIconPressed != bl) {
            this.closeIconPressed = bl;
            this.refreshDrawableState();
        }
    }

    private void unapplyChipDrawable(ChipDrawable chipDrawable) {
        if (chipDrawable != null) {
            chipDrawable.setDelegate(null);
        }
    }

    private void updateAccessibilityDelegate() {
        if (this.hasCloseIcon() && this.isCloseIconVisible() && this.onCloseIconClickListener != null) {
            ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.touchHelper);
            this.touchHelperEnabled = true;
        } else {
            ViewCompat.setAccessibilityDelegate((View)this, null);
            this.touchHelperEnabled = false;
        }
    }

    private void updateBackgroundDrawable() {
        if (RippleUtils.USE_FRAMEWORK_RIPPLE) {
            this.updateFrameworkRippleBackground();
        } else {
            this.chipDrawable.setUseCompatRipple(true);
            ViewCompat.setBackground((View)this, (Drawable)this.getBackgroundDrawable());
            this.updatePaddingInternal();
            this.ensureChipDrawableHasCallback();
        }
    }

    private void updateFrameworkRippleBackground() {
        this.ripple = new RippleDrawable(RippleUtils.sanitizeRippleDrawableColor(this.chipDrawable.getRippleColor()), this.getBackgroundDrawable(), null);
        this.chipDrawable.setUseCompatRipple(false);
        ViewCompat.setBackground((View)this, (Drawable)this.ripple);
        this.updatePaddingInternal();
    }

    private void updatePaddingInternal() {
        ChipDrawable chipDrawable;
        if (!TextUtils.isEmpty((CharSequence)this.getText()) && (chipDrawable = this.chipDrawable) != null) {
            int n = (int)(chipDrawable.getChipEndPadding() + this.chipDrawable.getTextEndPadding() + this.chipDrawable.calculateCloseIconWidth());
            int n2 = (int)(this.chipDrawable.getChipStartPadding() + this.chipDrawable.getTextStartPadding() + this.chipDrawable.calculateChipIconWidth());
            int n3 = n;
            int n4 = n2;
            if (this.insetBackgroundDrawable != null) {
                chipDrawable = new Rect();
                this.insetBackgroundDrawable.getPadding((Rect)chipDrawable);
                n4 = n2 + ((Rect)chipDrawable).left;
                n3 = n + ((Rect)chipDrawable).right;
            }
            ViewCompat.setPaddingRelative((View)this, (int)n4, (int)this.getPaddingTop(), (int)n3, (int)this.getPaddingBottom());
        }
    }

    private void updateTextPaintDrawState() {
        TextPaint textPaint = this.getPaint();
        Object object = this.chipDrawable;
        if (object != null) {
            textPaint.drawableState = object.getState();
        }
        if ((object = this.getTextAppearance()) != null) {
            ((TextAppearance)object).updateDrawState(this.getContext(), textPaint, this.fontCallback);
        }
    }

    private void validateAttributes(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "background") != null) {
            Log.w((String)TAG, (String)"Do not set the background; Chip manages its own background drawable.");
        }
        if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableLeft") == null) {
            if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableStart") == null) {
                if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableEnd") == null) {
                    if (attributeSet.getAttributeValue(NAMESPACE_ANDROID, "drawableRight") == null) {
                        if (attributeSet.getAttributeBooleanValue(NAMESPACE_ANDROID, "singleLine", true) && attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "lines", 1) == 1 && attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "minLines", 1) == 1 && attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "maxLines", 1) == 1) {
                            if (attributeSet.getAttributeIntValue(NAMESPACE_ANDROID, "gravity", 8388627) != 8388627) {
                                Log.w((String)TAG, (String)"Chip text must be vertically center and start aligned");
                            }
                            return;
                        }
                        throw new UnsupportedOperationException("Chip does not support multi-line text");
                    }
                    throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
                }
                throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
            }
            throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
        }
        throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
    }

    protected boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (!this.touchHelperEnabled) {
            return super.dispatchHoverEvent(motionEvent);
        }
        boolean bl = this.touchHelper.dispatchHoverEvent(motionEvent) || super.dispatchHoverEvent(motionEvent);
        return bl;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (!this.touchHelperEnabled) {
            return super.dispatchKeyEvent(keyEvent);
        }
        if (this.touchHelper.dispatchKeyEvent(keyEvent) && this.touchHelper.getKeyboardFocusedVirtualViewId() != Integer.MIN_VALUE) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        ChipDrawable chipDrawable = this.chipDrawable;
        boolean bl = chipDrawable != null && chipDrawable.isCloseIconStateful() ? this.chipDrawable.setCloseIconState(this.createCloseIconDrawableState()) : false;
        if (bl) {
            this.invalidate();
        }
    }

    public boolean ensureAccessibleTouchTarget(int n) {
        this.minTouchTargetSize = n;
        boolean bl = this.shouldEnsureMinTouchTargetSize();
        int n2 = 0;
        if (!bl) {
            if (this.insetBackgroundDrawable != null) {
                this.removeBackgroundInset();
            } else {
                this.updateBackgroundDrawable();
            }
            return false;
        }
        int n3 = Math.max(0, n - this.chipDrawable.getIntrinsicHeight());
        int n4 = Math.max(0, n - this.chipDrawable.getIntrinsicWidth());
        if (n4 <= 0 && n3 <= 0) {
            if (this.insetBackgroundDrawable != null) {
                this.removeBackgroundInset();
            } else {
                this.updateBackgroundDrawable();
            }
            return false;
        }
        n4 = n4 > 0 ? (n4 /= 2) : 0;
        if (n3 > 0) {
            n2 = n3 / 2;
        }
        if (this.insetBackgroundDrawable != null) {
            Rect rect = new Rect();
            this.insetBackgroundDrawable.getPadding(rect);
            if (rect.top == n2 && rect.bottom == n2 && rect.left == n4 && rect.right == n4) {
                this.updateBackgroundDrawable();
                return true;
            }
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (this.getMinHeight() != n) {
                this.setMinHeight(n);
            }
            if (this.getMinWidth() != n) {
                this.setMinWidth(n);
            }
        } else {
            this.setMinHeight(n);
            this.setMinWidth(n);
        }
        this.insetChipBackgroundDrawable(n4, n2, n4, n2);
        this.updateBackgroundDrawable();
        return true;
    }

    public CharSequence getAccessibilityClassName() {
        if (this.isCheckable()) {
            ViewParent viewParent = this.getParent();
            if (viewParent instanceof ChipGroup && ((ChipGroup)viewParent).isSingleSelection()) {
                return RADIO_BUTTON_ACCESSIBILITY_CLASS_NAME;
            }
            return COMPOUND_BUTTON_ACCESSIBILITY_CLASS_NAME;
        }
        if (this.isClickable()) {
            return BUTTON_ACCESSIBILITY_CLASS_NAME;
        }
        return GENERIC_VIEW_ACCESSIBILITY_CLASS_NAME;
    }

    public Drawable getBackgroundDrawable() {
        InsetDrawable insetDrawable;
        Object object = insetDrawable = this.insetBackgroundDrawable;
        if (insetDrawable == null) {
            object = this.chipDrawable;
        }
        return object;
    }

    public Drawable getCheckedIcon() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getCheckedIcon() : null;
        return chipDrawable;
    }

    public ColorStateList getCheckedIconTint() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getCheckedIconTint() : null;
        return chipDrawable;
    }

    public ColorStateList getChipBackgroundColor() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getChipBackgroundColor() : null;
        return chipDrawable;
    }

    public float getChipCornerRadius() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = 0.0f;
        if (chipDrawable != null) {
            f = Math.max(0.0f, chipDrawable.getChipCornerRadius());
        }
        return f;
    }

    public Drawable getChipDrawable() {
        return this.chipDrawable;
    }

    public float getChipEndPadding() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getChipEndPadding() : 0.0f;
        return f;
    }

    public Drawable getChipIcon() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getChipIcon() : null;
        return chipDrawable;
    }

    public float getChipIconSize() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getChipIconSize() : 0.0f;
        return f;
    }

    public ColorStateList getChipIconTint() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getChipIconTint() : null;
        return chipDrawable;
    }

    public float getChipMinHeight() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getChipMinHeight() : 0.0f;
        return f;
    }

    public float getChipStartPadding() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getChipStartPadding() : 0.0f;
        return f;
    }

    public ColorStateList getChipStrokeColor() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getChipStrokeColor() : null;
        return chipDrawable;
    }

    public float getChipStrokeWidth() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getChipStrokeWidth() : 0.0f;
        return f;
    }

    @Deprecated
    public CharSequence getChipText() {
        return this.getText();
    }

    public Drawable getCloseIcon() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getCloseIcon() : null;
        return chipDrawable;
    }

    public CharSequence getCloseIconContentDescription() {
        Object object = this.chipDrawable;
        object = object != null ? ((ChipDrawable)object).getCloseIconContentDescription() : null;
        return object;
    }

    public float getCloseIconEndPadding() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getCloseIconEndPadding() : 0.0f;
        return f;
    }

    public float getCloseIconSize() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getCloseIconSize() : 0.0f;
        return f;
    }

    public float getCloseIconStartPadding() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getCloseIconStartPadding() : 0.0f;
        return f;
    }

    public ColorStateList getCloseIconTint() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getCloseIconTint() : null;
        return chipDrawable;
    }

    public TextUtils.TruncateAt getEllipsize() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getEllipsize() : null;
        return chipDrawable;
    }

    public void getFocusedRect(Rect rect) {
        if (this.touchHelperEnabled && (this.touchHelper.getKeyboardFocusedVirtualViewId() == 1 || this.touchHelper.getAccessibilityFocusedVirtualViewId() == 1)) {
            rect.set(this.getCloseIconTouchBoundsInt());
        } else {
            super.getFocusedRect(rect);
        }
    }

    public MotionSpec getHideMotionSpec() {
        Object object = this.chipDrawable;
        object = object != null ? ((ChipDrawable)object).getHideMotionSpec() : null;
        return object;
    }

    public float getIconEndPadding() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getIconEndPadding() : 0.0f;
        return f;
    }

    public float getIconStartPadding() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getIconStartPadding() : 0.0f;
        return f;
    }

    public ColorStateList getRippleColor() {
        ChipDrawable chipDrawable = this.chipDrawable;
        chipDrawable = chipDrawable != null ? chipDrawable.getRippleColor() : null;
        return chipDrawable;
    }

    @Override
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.chipDrawable.getShapeAppearanceModel();
    }

    public MotionSpec getShowMotionSpec() {
        Object object = this.chipDrawable;
        object = object != null ? ((ChipDrawable)object).getShowMotionSpec() : null;
        return object;
    }

    public float getTextEndPadding() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getTextEndPadding() : 0.0f;
        return f;
    }

    public float getTextStartPadding() {
        ChipDrawable chipDrawable = this.chipDrawable;
        float f = chipDrawable != null ? chipDrawable.getTextStartPadding() : 0.0f;
        return f;
    }

    public boolean isCheckable() {
        ChipDrawable chipDrawable = this.chipDrawable;
        boolean bl = chipDrawable != null && chipDrawable.isCheckable();
        return bl;
    }

    @Deprecated
    public boolean isCheckedIconEnabled() {
        return this.isCheckedIconVisible();
    }

    public boolean isCheckedIconVisible() {
        ChipDrawable chipDrawable = this.chipDrawable;
        boolean bl = chipDrawable != null && chipDrawable.isCheckedIconVisible();
        return bl;
    }

    @Deprecated
    public boolean isChipIconEnabled() {
        return this.isChipIconVisible();
    }

    public boolean isChipIconVisible() {
        ChipDrawable chipDrawable = this.chipDrawable;
        boolean bl = chipDrawable != null && chipDrawable.isChipIconVisible();
        return bl;
    }

    @Deprecated
    public boolean isCloseIconEnabled() {
        return this.isCloseIconVisible();
    }

    public boolean isCloseIconVisible() {
        ChipDrawable chipDrawable = this.chipDrawable;
        boolean bl = chipDrawable != null && chipDrawable.isCloseIconVisible();
        return bl;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this, this.chipDrawable);
    }

    @Override
    public void onChipDrawableSizeChange() {
        this.ensureAccessibleTouchTarget(this.minTouchTargetSize);
        this.requestLayout();
        if (Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    protected int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 2);
        if (this.isChecked()) {
            Chip.mergeDrawableStates((int[])nArray, (int[])SELECTED_STATE);
        }
        if (this.isCheckable()) {
            Chip.mergeDrawableStates((int[])nArray, (int[])CHECKABLE_STATE_SET);
        }
        return nArray;
    }

    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (this.touchHelperEnabled) {
            this.touchHelper.onFocusChanged(bl, n, rect);
        }
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n != 7) {
            if (n == 10) {
                this.setCloseIconHovered(false);
            }
        } else {
            this.setCloseIconHovered(this.getCloseIconTouchBounds().contains(motionEvent.getX(), motionEvent.getY()));
        }
        return super.onHoverEvent(motionEvent);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(this.getAccessibilityClassName());
        accessibilityNodeInfo.setCheckable(this.isCheckable());
        accessibilityNodeInfo.setClickable(this.isClickable());
        if (this.getParent() instanceof ChipGroup) {
            ChipGroup chipGroup = (ChipGroup)this.getParent();
            accessibilityNodeInfo = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)accessibilityNodeInfo);
            int n = chipGroup.isSingleLine() ? chipGroup.getIndexOfChip((View)this) : -1;
            accessibilityNodeInfo.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)chipGroup.getRowIndex((View)this), (int)1, (int)n, (int)1, (boolean)false, (boolean)this.isChecked()));
        }
    }

    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int n) {
        if (this.getCloseIconTouchBounds().contains(motionEvent.getX(), motionEvent.getY()) && this.isEnabled()) {
            return PointerIcon.getSystemIcon((Context)this.getContext(), (int)1002);
        }
        return null;
    }

    public void onRtlPropertiesChanged(int n) {
        super.onRtlPropertiesChanged(n);
        if (this.lastLayoutDirection != n) {
            this.lastLayoutDirection = n;
            this.updatePaddingInternal();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block9: {
            block6: {
                block7: {
                    block8: {
                        var2_2 = var1_1.getActionMasked();
                        var3_3 = this.getCloseIconTouchBounds().contains(var1_1.getX(), var1_1.getY());
                        var4_4 = false;
                        if (var2_2 == 0) break block6;
                        if (var2_2 == 1) break block7;
                        if (var2_2 == 2) break block8;
                        if (var2_2 == 3) ** GOTO lbl-1000
                        ** GOTO lbl-1000
                    }
                    if (!this.closeIconPressed) ** GOTO lbl-1000
                    if (!var3_3) {
                        this.setCloseIconPressed(false);
                    }
                    ** GOTO lbl26
                }
                if (this.closeIconPressed) {
                    this.performCloseIconClick();
                    var2_2 = 1;
                } else lbl-1000:
                // 2 sources

                {
                    var2_2 = 0;
                }
                this.setCloseIconPressed(false);
                break block9;
            }
            if (var3_3) {
                this.setCloseIconPressed(true);
lbl26:
                // 2 sources

                var2_2 = 1;
            } else lbl-1000:
            // 3 sources

            {
                var2_2 = 0;
            }
        }
        if (var2_2 != 0 || super.onTouchEvent(var1_1)) {
            var4_4 = true;
        }
        return var4_4;
    }

    public boolean performCloseIconClick() {
        boolean bl = false;
        this.playSoundEffect(0);
        View.OnClickListener onClickListener = this.onCloseIconClickListener;
        if (onClickListener != null) {
            onClickListener.onClick((View)this);
            bl = true;
        }
        if (this.touchHelperEnabled) {
            this.touchHelper.sendEventForVirtualView(1, 1);
        }
        return bl;
    }

    public void setBackground(Drawable drawable2) {
        if (drawable2 != this.getBackgroundDrawable() && drawable2 != this.ripple) {
            Log.w((String)TAG, (String)"Do not set the background; Chip manages its own background drawable.");
        } else {
            super.setBackground(drawable2);
        }
    }

    public void setBackgroundColor(int n) {
        Log.w((String)TAG, (String)"Do not set the background color; Chip manages its own background drawable.");
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        if (drawable2 != this.getBackgroundDrawable() && drawable2 != this.ripple) {
            Log.w((String)TAG, (String)"Do not set the background drawable; Chip manages its own background drawable.");
        } else {
            super.setBackgroundDrawable(drawable2);
        }
    }

    public void setBackgroundResource(int n) {
        Log.w((String)TAG, (String)"Do not set the background resource; Chip manages its own background drawable.");
    }

    public void setBackgroundTintList(ColorStateList colorStateList) {
        Log.w((String)TAG, (String)"Do not set the background tint list; Chip manages its own background drawable.");
    }

    public void setBackgroundTintMode(PorterDuff.Mode mode) {
        Log.w((String)TAG, (String)"Do not set the background tint mode; Chip manages its own background drawable.");
    }

    public void setCheckable(boolean bl) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCheckable(bl);
        }
    }

    public void setCheckableResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCheckableResource(n);
        }
    }

    public void setChecked(boolean bl) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable == null) {
            this.deferredCheckedValue = bl;
        } else if (chipDrawable.isCheckable()) {
            boolean bl2 = this.isChecked();
            super.setChecked(bl);
            if (bl2 != bl && (chipDrawable = this.onCheckedChangeListenerInternal) != null) {
                chipDrawable.onCheckedChanged((CompoundButton)this, bl);
            }
        }
    }

    public void setCheckedIcon(Drawable drawable2) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCheckedIcon(drawable2);
        }
    }

    @Deprecated
    public void setCheckedIconEnabled(boolean bl) {
        this.setCheckedIconVisible(bl);
    }

    @Deprecated
    public void setCheckedIconEnabledResource(int n) {
        this.setCheckedIconVisible(n);
    }

    public void setCheckedIconResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCheckedIconResource(n);
        }
    }

    public void setCheckedIconTint(ColorStateList colorStateList) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCheckedIconTint(colorStateList);
        }
    }

    public void setCheckedIconTintResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCheckedIconTintResource(n);
        }
    }

    public void setCheckedIconVisible(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCheckedIconVisible(n);
        }
    }

    public void setCheckedIconVisible(boolean bl) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCheckedIconVisible(bl);
        }
    }

    public void setChipBackgroundColor(ColorStateList colorStateList) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipBackgroundColor(colorStateList);
        }
    }

    public void setChipBackgroundColorResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipBackgroundColorResource(n);
        }
    }

    @Deprecated
    public void setChipCornerRadius(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipCornerRadius(f);
        }
    }

    @Deprecated
    public void setChipCornerRadiusResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipCornerRadiusResource(n);
        }
    }

    public void setChipDrawable(ChipDrawable chipDrawable) {
        ChipDrawable chipDrawable2 = this.chipDrawable;
        if (chipDrawable2 != chipDrawable) {
            this.unapplyChipDrawable(chipDrawable2);
            this.chipDrawable = chipDrawable;
            chipDrawable.setShouldDrawText(false);
            this.applyChipDrawable(this.chipDrawable);
            this.ensureAccessibleTouchTarget(this.minTouchTargetSize);
        }
    }

    public void setChipEndPadding(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipEndPadding(f);
        }
    }

    public void setChipEndPaddingResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipEndPaddingResource(n);
        }
    }

    public void setChipIcon(Drawable drawable2) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipIcon(drawable2);
        }
    }

    @Deprecated
    public void setChipIconEnabled(boolean bl) {
        this.setChipIconVisible(bl);
    }

    @Deprecated
    public void setChipIconEnabledResource(int n) {
        this.setChipIconVisible(n);
    }

    public void setChipIconResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipIconResource(n);
        }
    }

    public void setChipIconSize(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipIconSize(f);
        }
    }

    public void setChipIconSizeResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipIconSizeResource(n);
        }
    }

    public void setChipIconTint(ColorStateList colorStateList) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipIconTint(colorStateList);
        }
    }

    public void setChipIconTintResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipIconTintResource(n);
        }
    }

    public void setChipIconVisible(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipIconVisible(n);
        }
    }

    public void setChipIconVisible(boolean bl) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipIconVisible(bl);
        }
    }

    public void setChipMinHeight(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipMinHeight(f);
        }
    }

    public void setChipMinHeightResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipMinHeightResource(n);
        }
    }

    public void setChipStartPadding(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipStartPadding(f);
        }
    }

    public void setChipStartPaddingResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipStartPaddingResource(n);
        }
    }

    public void setChipStrokeColor(ColorStateList colorStateList) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipStrokeColor(colorStateList);
        }
    }

    public void setChipStrokeColorResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipStrokeColorResource(n);
        }
    }

    public void setChipStrokeWidth(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipStrokeWidth(f);
        }
    }

    public void setChipStrokeWidthResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setChipStrokeWidthResource(n);
        }
    }

    @Deprecated
    public void setChipText(CharSequence charSequence) {
        this.setText(charSequence);
    }

    @Deprecated
    public void setChipTextResource(int n) {
        this.setText(this.getResources().getString(n));
    }

    public void setCloseIcon(Drawable drawable2) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIcon(drawable2);
        }
        this.updateAccessibilityDelegate();
    }

    public void setCloseIconContentDescription(CharSequence charSequence) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconContentDescription(charSequence);
        }
    }

    @Deprecated
    public void setCloseIconEnabled(boolean bl) {
        this.setCloseIconVisible(bl);
    }

    @Deprecated
    public void setCloseIconEnabledResource(int n) {
        this.setCloseIconVisible(n);
    }

    public void setCloseIconEndPadding(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconEndPadding(f);
        }
    }

    public void setCloseIconEndPaddingResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconEndPaddingResource(n);
        }
    }

    public void setCloseIconResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconResource(n);
        }
        this.updateAccessibilityDelegate();
    }

    public void setCloseIconSize(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconSize(f);
        }
    }

    public void setCloseIconSizeResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconSizeResource(n);
        }
    }

    public void setCloseIconStartPadding(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconStartPadding(f);
        }
    }

    public void setCloseIconStartPaddingResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconStartPaddingResource(n);
        }
    }

    public void setCloseIconTint(ColorStateList colorStateList) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconTint(colorStateList);
        }
    }

    public void setCloseIconTintResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconTintResource(n);
        }
    }

    public void setCloseIconVisible(int n) {
        this.setCloseIconVisible(this.getResources().getBoolean(n));
    }

    public void setCloseIconVisible(boolean bl) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setCloseIconVisible(bl);
        }
        this.updateAccessibilityDelegate();
    }

    public void setCompoundDrawables(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        if (drawable2 == null) {
            if (drawable4 == null) {
                super.setCompoundDrawables(drawable2, drawable3, drawable4, drawable5);
                return;
            }
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
    }

    public void setCompoundDrawablesRelative(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        if (drawable2 == null) {
            if (drawable4 == null) {
                super.setCompoundDrawablesRelative(drawable2, drawable3, drawable4, drawable5);
                return;
            }
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(int n, int n2, int n3, int n4) {
        if (n == 0) {
            if (n3 == 0) {
                super.setCompoundDrawablesRelativeWithIntrinsicBounds(n, n2, n3, n4);
                return;
            }
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        if (drawable2 == null) {
            if (drawable4 == null) {
                super.setCompoundDrawablesRelativeWithIntrinsicBounds(drawable2, drawable3, drawable4, drawable5);
                return;
            }
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int n, int n2, int n3, int n4) {
        if (n == 0) {
            if (n3 == 0) {
                super.setCompoundDrawablesWithIntrinsicBounds(n, n2, n3, n4);
                return;
            }
            throw new UnsupportedOperationException("Please set end drawable using R.attr#closeIcon.");
        }
        throw new UnsupportedOperationException("Please set start drawable using R.attr#chipIcon.");
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5) {
        if (drawable2 == null) {
            if (drawable4 == null) {
                super.setCompoundDrawablesWithIntrinsicBounds(drawable2, drawable3, drawable4, drawable5);
                return;
            }
            throw new UnsupportedOperationException("Please set right drawable using R.attr#closeIcon.");
        }
        throw new UnsupportedOperationException("Please set left drawable using R.attr#chipIcon.");
    }

    public void setElevation(float f) {
        super.setElevation(f);
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setElevation(f);
        }
    }

    public void setEllipsize(TextUtils.TruncateAt truncateAt) {
        if (this.chipDrawable == null) {
            return;
        }
        if (truncateAt != TextUtils.TruncateAt.MARQUEE) {
            super.setEllipsize(truncateAt);
            ChipDrawable chipDrawable = this.chipDrawable;
            if (chipDrawable != null) {
                chipDrawable.setEllipsize(truncateAt);
            }
            return;
        }
        throw new UnsupportedOperationException("Text within a chip are not allowed to scroll.");
    }

    public void setEnsureMinTouchTargetSize(boolean bl) {
        this.ensureMinTouchTargetSize = bl;
        this.ensureAccessibleTouchTarget(this.minTouchTargetSize);
    }

    public void setGravity(int n) {
        if (n != 8388627) {
            Log.w((String)TAG, (String)"Chip text must be vertically center and start aligned");
        } else {
            super.setGravity(n);
        }
    }

    public void setHideMotionSpec(MotionSpec motionSpec) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setHideMotionSpec(motionSpec);
        }
    }

    public void setHideMotionSpecResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setHideMotionSpecResource(n);
        }
    }

    public void setIconEndPadding(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setIconEndPadding(f);
        }
    }

    public void setIconEndPaddingResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setIconEndPaddingResource(n);
        }
    }

    public void setIconStartPadding(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setIconStartPadding(f);
        }
    }

    public void setIconStartPaddingResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setIconStartPaddingResource(n);
        }
    }

    public void setLayoutDirection(int n) {
        if (this.chipDrawable == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            super.setLayoutDirection(n);
        }
    }

    public void setLines(int n) {
        if (n <= 1) {
            super.setLines(n);
            return;
        }
        throw new UnsupportedOperationException("Chip does not support multi-line text");
    }

    public void setMaxLines(int n) {
        if (n <= 1) {
            super.setMaxLines(n);
            return;
        }
        throw new UnsupportedOperationException("Chip does not support multi-line text");
    }

    public void setMaxWidth(int n) {
        super.setMaxWidth(n);
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setMaxWidth(n);
        }
    }

    public void setMinLines(int n) {
        if (n <= 1) {
            super.setMinLines(n);
            return;
        }
        throw new UnsupportedOperationException("Chip does not support multi-line text");
    }

    void setOnCheckedChangeListenerInternal(CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListenerInternal = onCheckedChangeListener;
    }

    public void setOnCloseIconClickListener(View.OnClickListener onClickListener) {
        this.onCloseIconClickListener = onClickListener;
        this.updateAccessibilityDelegate();
    }

    public void setRippleColor(ColorStateList colorStateList) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setRippleColor(colorStateList);
        }
        if (!this.chipDrawable.getUseCompatRipple()) {
            this.updateFrameworkRippleBackground();
        }
    }

    public void setRippleColorResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setRippleColorResource(n);
            if (!this.chipDrawable.getUseCompatRipple()) {
                this.updateFrameworkRippleBackground();
            }
        }
    }

    @Override
    public void setShapeAppearanceModel(ShapeAppearanceModel shapeAppearanceModel) {
        this.chipDrawable.setShapeAppearanceModel(shapeAppearanceModel);
    }

    public void setShowMotionSpec(MotionSpec motionSpec) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setShowMotionSpec(motionSpec);
        }
    }

    public void setShowMotionSpecResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setShowMotionSpecResource(n);
        }
    }

    public void setSingleLine(boolean bl) {
        if (bl) {
            super.setSingleLine(bl);
            return;
        }
        throw new UnsupportedOperationException("Chip does not support multi-line text");
    }

    public void setText(CharSequence object, TextView.BufferType bufferType) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable == null) {
            return;
        }
        CharSequence charSequence = object;
        if (object == null) {
            charSequence = "";
        }
        object = chipDrawable.shouldDrawText() ? null : charSequence;
        super.setText((CharSequence)object, bufferType);
        object = this.chipDrawable;
        if (object != null) {
            ((ChipDrawable)object).setText(charSequence);
        }
    }

    public void setTextAppearance(int n) {
        super.setTextAppearance(n);
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setTextAppearanceResource(n);
        }
        this.updateTextPaintDrawState();
    }

    public void setTextAppearance(Context object, int n) {
        super.setTextAppearance((Context)object, n);
        object = this.chipDrawable;
        if (object != null) {
            ((ChipDrawable)object).setTextAppearanceResource(n);
        }
        this.updateTextPaintDrawState();
    }

    public void setTextAppearance(TextAppearance textAppearance) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setTextAppearance(textAppearance);
        }
        this.updateTextPaintDrawState();
    }

    public void setTextAppearanceResource(int n) {
        this.setTextAppearance(this.getContext(), n);
    }

    public void setTextEndPadding(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setTextEndPadding(f);
        }
    }

    public void setTextEndPaddingResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setTextEndPaddingResource(n);
        }
    }

    public void setTextStartPadding(float f) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setTextStartPadding(f);
        }
    }

    public void setTextStartPaddingResource(int n) {
        ChipDrawable chipDrawable = this.chipDrawable;
        if (chipDrawable != null) {
            chipDrawable.setTextStartPaddingResource(n);
        }
    }

    public boolean shouldEnsureMinTouchTargetSize() {
        return this.ensureMinTouchTargetSize;
    }

    private class ChipTouchHelper
    extends ExploreByTouchHelper {
        ChipTouchHelper(Chip chip2) {
            super((View)chip2);
        }

        protected int getVirtualViewAt(float f, float f2) {
            int n = Chip.this.hasCloseIcon() && Chip.this.getCloseIconTouchBounds().contains(f, f2) ? 1 : 0;
            return n;
        }

        protected void getVisibleVirtualViews(List<Integer> list) {
            list.add(0);
            if (Chip.this.hasCloseIcon() && Chip.this.isCloseIconVisible() && Chip.this.onCloseIconClickListener != null) {
                list.add(1);
            }
        }

        protected boolean onPerformActionForVirtualView(int n, int n2, Bundle bundle) {
            if (n2 == 16) {
                if (n == 0) {
                    return Chip.this.performClick();
                }
                if (n == 1) {
                    return Chip.this.performCloseIconClick();
                }
            }
            return false;
        }

        protected void onPopulateNodeForHost(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            accessibilityNodeInfoCompat.setCheckable(Chip.this.isCheckable());
            accessibilityNodeInfoCompat.setClickable(Chip.this.isClickable());
            accessibilityNodeInfoCompat.setClassName(Chip.this.getAccessibilityClassName());
            CharSequence charSequence = Chip.this.getText();
            if (Build.VERSION.SDK_INT >= 23) {
                accessibilityNodeInfoCompat.setText(charSequence);
            } else {
                accessibilityNodeInfoCompat.setContentDescription(charSequence);
            }
        }

        protected void onPopulateNodeForVirtualView(int n, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            CharSequence charSequence = "";
            if (n == 1) {
                CharSequence charSequence2 = Chip.this.getCloseIconContentDescription();
                if (charSequence2 != null) {
                    accessibilityNodeInfoCompat.setContentDescription(charSequence2);
                } else {
                    charSequence2 = Chip.this.getText();
                    Context context = Chip.this.getContext();
                    n = R.string.mtrl_chip_close_icon_content_description;
                    if (!TextUtils.isEmpty((CharSequence)charSequence2)) {
                        charSequence = charSequence2;
                    }
                    accessibilityNodeInfoCompat.setContentDescription((CharSequence)context.getString(n, new Object[]{charSequence}).trim());
                }
                accessibilityNodeInfoCompat.setBoundsInParent(Chip.this.getCloseIconTouchBoundsInt());
                accessibilityNodeInfoCompat.addAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
                accessibilityNodeInfoCompat.setEnabled(Chip.this.isEnabled());
            } else {
                accessibilityNodeInfoCompat.setContentDescription((CharSequence)"");
                accessibilityNodeInfoCompat.setBoundsInParent(EMPTY_BOUNDS);
            }
        }

        protected void onVirtualViewKeyboardFocusChanged(int n, boolean bl) {
            if (n == 1) {
                Chip.access$402(Chip.this, bl);
                Chip.this.refreshDrawableState();
            }
        }
    }
}

