/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import java.util.Arrays;

final class ColorUtils {
    private static final float[] WHITE_POINT_D65 = new float[]{95.047f, 100.0f, 108.883f};

    private ColorUtils() {
    }

    public static int blueFromInt(int n) {
        return n & 0xFF;
    }

    public static float delinearized(float f) {
        if (f <= 0.0031308f) {
            return f * 12.92f;
        }
        return (float)Math.pow(f, 0.4166666567325592) * 1.055f - 0.055f;
    }

    public static int greenFromInt(int n) {
        return (n & 0xFF00) >> 8;
    }

    public static String hexFromInt(int n) {
        int n2 = ColorUtils.redFromInt(n);
        int n3 = ColorUtils.blueFromInt(n);
        return String.format("#%02x%02x%02x", n2, ColorUtils.greenFromInt(n), n3);
    }

    public static int intFromLab(double d, double d2, double d3) {
        double d4 = (d + 16.0) / 116.0;
        double d5 = d2 / 500.0 + d4;
        double d6 = d4 - d3 / 200.0;
        d2 = d5 * d5 * d5;
        if (!(d2 > 0.008856451679035631)) {
            d2 = (d5 * 116.0 - 16.0) / 903.2962962962963;
        }
        d = d > 8.0 ? d4 * d4 * d4 : (d /= 903.2962962962963);
        d3 = d6 * d6 * d6;
        if (!(d3 > 0.008856451679035631)) {
            d3 = (d6 * 116.0 - 16.0) / 903.2962962962963;
        }
        float[] fArray = WHITE_POINT_D65;
        d4 = fArray[0];
        d6 = fArray[1];
        d5 = fArray[2];
        return ColorUtils.intFromXyzComponents((float)(d2 * d4), (float)(d * d6), (float)(d3 * d5));
    }

    public static int intFromLstar(float f) {
        float f2 = (f + 16.0f) / 116.0f;
        float f3 = f2 * f2 * f2;
        boolean bl = f3 > 0.008856452f;
        boolean bl2 = f > 8.0f;
        f = bl2 ? f3 : (f /= 903.2963f);
        float f4 = bl ? f3 : (f2 * 116.0f - 16.0f) / 903.2963f;
        if (!bl) {
            f3 = (f2 * 116.0f - 16.0f) / 903.2963f;
        }
        float[] fArray = WHITE_POINT_D65;
        return ColorUtils.intFromXyz(new float[]{f4 * fArray[0], f * fArray[1], f3 * fArray[2]});
    }

    public static int intFromRgb(int n, int n2, int n3) {
        return ((n & 0xFF) << 16 | 0xFF000000 | (n2 & 0xFF) << 8 | n3 & 0xFF) >>> 0;
    }

    public static int intFromXyz(float[] fArray) {
        return ColorUtils.intFromXyzComponents(fArray[0], fArray[1], fArray[2]);
    }

    public static int intFromXyzComponents(float f, float f2, float f3) {
        float f4 = f3 / 100.0f;
        f3 = ColorUtils.delinearized(3.2406f * (f /= 100.0f) + -1.5372f * (f2 /= 100.0f) + -0.4986f * f4);
        float f5 = ColorUtils.delinearized(-0.9689f * f + 1.8758f * f2 + 0.0415f * f4);
        f = ColorUtils.delinearized(f * 0.0557f + f2 * -0.204f + f4 * 1.057f);
        return ColorUtils.intFromRgb(Math.max(Math.min(255, Math.round(f3 * 255.0f)), 0), Math.max(Math.min(255, Math.round(f5 * 255.0f)), 0), Math.max(Math.min(255, Math.round(f * 255.0f)), 0));
    }

    public static double[] labFromInt(int n) {
        float[] fArray;
        float[] fArray2 = ColorUtils.xyzFromInt(n);
        float f = fArray2[1];
        double d = f / (fArray = WHITE_POINT_D65)[1];
        d = d > 0.008856451679035631 ? Math.cbrt(d) : (d * 903.2962962962963 + 16.0) / 116.0;
        double d2 = fArray2[0] / fArray[0];
        d2 = d2 > 0.008856451679035631 ? Math.cbrt(d2) : (d2 * 903.2962962962963 + 16.0) / 116.0;
        double d3 = fArray2[2] / fArray[2];
        d3 = d3 > 0.008856451679035631 ? Math.cbrt(d3) : (d3 * 903.2962962962963 + 16.0) / 116.0;
        return new double[]{116.0 * d - 16.0, (d2 - d) * 500.0, (d - d3) * 200.0};
    }

    public static float linearized(float f) {
        if (f <= 0.04045f) {
            return f / 12.92f;
        }
        return (float)Math.pow((f + 0.055f) / 1.055f, 2.4f);
    }

    public static float lstarFromInt(int n) {
        return (float)ColorUtils.labFromInt(n)[0];
    }

    public static int redFromInt(int n) {
        return (n & 0xFF0000) >> 16;
    }

    public static final float[] whitePointD65() {
        return Arrays.copyOf(WHITE_POINT_D65, 3);
    }

    public static float[] xyzFromInt(int n) {
        float f = ColorUtils.linearized((float)ColorUtils.redFromInt(n) / 255.0f) * 100.0f;
        float f2 = ColorUtils.linearized((float)ColorUtils.greenFromInt(n) / 255.0f) * 100.0f;
        float f3 = ColorUtils.linearized((float)ColorUtils.blueFromInt(n) / 255.0f) * 100.0f;
        return new float[]{0.41233894f * f + 0.35762063f * f2 + 0.18051042f * f3, 0.2126f * f + 0.7152f * f2 + 0.0722f * f3, f * 0.01932141f + f2 * 0.11916382f + f3 * 0.9503448f};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float yFromLstar(float f) {
        if (f > 8.0f) {
            f = (float)Math.pow(((double)f + 16.0) / 116.0, 3.0);
            return f * 100.0f;
        }
        f /= 903.2963f;
        return f * 100.0f;
    }
}

