/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.core.util.ObjectsCompat;
import com.google.android.material.datepicker.DateValidatorPointForward;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.UtcDates;
import java.util.Arrays;

public final class CalendarConstraints
implements Parcelable {
    public static final Parcelable.Creator<CalendarConstraints> CREATOR = new Parcelable.Creator<CalendarConstraints>(){

        public CalendarConstraints createFromParcel(Parcel parcel) {
            Month month = (Month)parcel.readParcelable(Month.class.getClassLoader());
            Month month2 = (Month)parcel.readParcelable(Month.class.getClassLoader());
            Month month3 = (Month)parcel.readParcelable(Month.class.getClassLoader());
            return new CalendarConstraints(month, month2, (DateValidator)parcel.readParcelable(DateValidator.class.getClassLoader()), month3);
        }

        public CalendarConstraints[] newArray(int n) {
            return new CalendarConstraints[n];
        }
    };
    private final Month end;
    private final int monthSpan;
    private Month openAt;
    private final Month start;
    private final DateValidator validator;
    private final int yearSpan;

    private CalendarConstraints(Month month, Month month2, DateValidator dateValidator, Month month3) {
        this.start = month;
        this.end = month2;
        this.openAt = month3;
        this.validator = dateValidator;
        if (month3 != null && month.compareTo(month3) > 0) {
            throw new IllegalArgumentException("start Month cannot be after current Month");
        }
        if (month3 != null && month3.compareTo(month2) > 0) {
            throw new IllegalArgumentException("current Month cannot be after end Month");
        }
        this.monthSpan = month.monthsUntil(month2) + 1;
        this.yearSpan = month2.year - month.year + 1;
    }

    Month clamp(Month month) {
        if (month.compareTo(this.start) < 0) {
            return this.start;
        }
        Month month2 = month;
        if (month.compareTo(this.end) > 0) {
            month2 = this.end;
        }
        return month2;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (!(object instanceof CalendarConstraints)) {
            return false;
        }
        object = (CalendarConstraints)object;
        if (!(this.start.equals(((CalendarConstraints)object).start) && this.end.equals(((CalendarConstraints)object).end) && ObjectsCompat.equals((Object)this.openAt, (Object)((CalendarConstraints)object).openAt) && this.validator.equals(((CalendarConstraints)object).validator))) {
            bl = false;
        }
        return bl;
    }

    public DateValidator getDateValidator() {
        return this.validator;
    }

    Month getEnd() {
        return this.end;
    }

    int getMonthSpan() {
        return this.monthSpan;
    }

    Month getOpenAt() {
        return this.openAt;
    }

    Month getStart() {
        return this.start;
    }

    int getYearSpan() {
        return this.yearSpan;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.start, this.end, this.openAt, this.validator});
    }

    boolean isWithinBounds(long l) {
        Month month = this.start;
        boolean bl = true;
        if (month.getDay(1) > l || l > (month = this.end).getDay(month.daysInMonth)) {
            bl = false;
        }
        return bl;
    }

    void setOpenAt(Month month) {
        this.openAt = month;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeParcelable((Parcelable)this.start, 0);
        parcel.writeParcelable((Parcelable)this.end, 0);
        parcel.writeParcelable((Parcelable)this.openAt, 0);
        parcel.writeParcelable((Parcelable)this.validator, 0);
    }

    public static final class Builder {
        private static final String DEEP_COPY_VALIDATOR_KEY = "DEEP_COPY_VALIDATOR_KEY";
        static final long DEFAULT_END;
        static final long DEFAULT_START;
        private long end;
        private Long openAt;
        private long start = DEFAULT_START;
        private DateValidator validator;

        static {
            DEFAULT_START = UtcDates.canonicalYearMonthDay(Month.create((int)1900, (int)0).timeInMillis);
            DEFAULT_END = UtcDates.canonicalYearMonthDay(Month.create((int)2100, (int)11).timeInMillis);
        }

        public Builder() {
            this.end = DEFAULT_END;
            this.validator = DateValidatorPointForward.from(Long.MIN_VALUE);
        }

        Builder(CalendarConstraints calendarConstraints) {
            this.end = DEFAULT_END;
            this.validator = DateValidatorPointForward.from(Long.MIN_VALUE);
            this.start = ((CalendarConstraints)calendarConstraints).start.timeInMillis;
            this.end = ((CalendarConstraints)calendarConstraints).end.timeInMillis;
            this.openAt = ((CalendarConstraints)calendarConstraints).openAt.timeInMillis;
            this.validator = calendarConstraints.validator;
        }

        public CalendarConstraints build() {
            Object object = new Bundle();
            object.putParcelable(DEEP_COPY_VALIDATOR_KEY, (Parcelable)this.validator);
            Month month = Month.create(this.start);
            Month month2 = Month.create(this.end);
            DateValidator dateValidator = (DateValidator)object.getParcelable(DEEP_COPY_VALIDATOR_KEY);
            object = this.openAt;
            object = object == null ? null : Month.create((Long)object);
            return new CalendarConstraints(month, month2, dateValidator, (Month)object);
        }

        public Builder setEnd(long l) {
            this.end = l;
            return this;
        }

        public Builder setOpenAt(long l) {
            this.openAt = l;
            return this;
        }

        public Builder setStart(long l) {
            this.start = l;
            return this;
        }

        public Builder setValidator(DateValidator dateValidator) {
            this.validator = dateValidator;
            return this;
        }
    }

    public static interface DateValidator
    extends Parcelable {
        public boolean isValid(long var1);
    }
}

