/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.core.util.Preconditions;
import com.google.android.material.datepicker.CalendarConstraints;
import java.util.ArrayList;
import java.util.List;

public final class CompositeDateValidator
implements CalendarConstraints.DateValidator {
    private static final Operator ALL_OPERATOR;
    private static final Operator ANY_OPERATOR;
    private static final int COMPARATOR_ALL_ID = 2;
    private static final int COMPARATOR_ANY_ID = 1;
    public static final Parcelable.Creator<CompositeDateValidator> CREATOR;
    private final Operator operator;
    private final List<CalendarConstraints.DateValidator> validators;

    static {
        ANY_OPERATOR = new Operator(){

            @Override
            public int getId() {
                return 1;
            }

            @Override
            public boolean isValid(List<CalendarConstraints.DateValidator> object, long l) {
                object = object.iterator();
                while (object.hasNext()) {
                    CalendarConstraints.DateValidator dateValidator = (CalendarConstraints.DateValidator)object.next();
                    if (dateValidator == null || !dateValidator.isValid(l)) continue;
                    return true;
                }
                return false;
            }
        };
        ALL_OPERATOR = new Operator(){

            @Override
            public int getId() {
                return 2;
            }

            @Override
            public boolean isValid(List<CalendarConstraints.DateValidator> object, long l) {
                object = object.iterator();
                while (object.hasNext()) {
                    CalendarConstraints.DateValidator dateValidator = (CalendarConstraints.DateValidator)object.next();
                    if (dateValidator == null || dateValidator.isValid(l)) continue;
                    return false;
                }
                return true;
            }
        };
        CREATOR = new Parcelable.Creator<CompositeDateValidator>(){

            public CompositeDateValidator createFromParcel(Parcel object) {
                ArrayList arrayList = object.readArrayList(CalendarConstraints.DateValidator.class.getClassLoader());
                int n = object.readInt();
                object = n == 2 ? ALL_OPERATOR : (n == 1 ? ANY_OPERATOR : ALL_OPERATOR);
                return new CompositeDateValidator((List)Preconditions.checkNotNull((Object)arrayList), (Operator)object);
            }

            public CompositeDateValidator[] newArray(int n) {
                return new CompositeDateValidator[n];
            }
        };
    }

    private CompositeDateValidator(List<CalendarConstraints.DateValidator> list, Operator operator) {
        this.validators = list;
        this.operator = operator;
    }

    public static CalendarConstraints.DateValidator allOf(List<CalendarConstraints.DateValidator> list) {
        return new CompositeDateValidator(list, ALL_OPERATOR);
    }

    public static CalendarConstraints.DateValidator anyOf(List<CalendarConstraints.DateValidator> list) {
        return new CompositeDateValidator(list, ANY_OPERATOR);
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompositeDateValidator)) {
            return false;
        }
        object = (CompositeDateValidator)object;
        if (!this.validators.equals(((CompositeDateValidator)object).validators) || this.operator.getId() != ((CompositeDateValidator)object).operator.getId()) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.validators.hashCode();
    }

    @Override
    public boolean isValid(long l) {
        return this.operator.isValid(this.validators, l);
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeList(this.validators);
        parcel.writeInt(this.operator.getId());
    }

    private static interface Operator {
        public int getId();

        public boolean isValid(List<CalendarConstraints.DateValidator> var1, long var2);
    }
}

