/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.text.TextUtils;
import android.view.View;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.textfield.TextInputLayout;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

abstract class DateFormatTextWatcher
extends TextWatcherAdapter {
    private static final int VALIDATION_DELAY = 1000;
    private final CalendarConstraints constraints;
    private final DateFormat dateFormat;
    private final String outOfRange;
    private final Runnable setErrorCallback;
    private Runnable setRangeErrorCallback;
    private final TextInputLayout textInputLayout;

    DateFormatTextWatcher(final String string2, DateFormat dateFormat, TextInputLayout textInputLayout, CalendarConstraints calendarConstraints) {
        this.dateFormat = dateFormat;
        this.textInputLayout = textInputLayout;
        this.constraints = calendarConstraints;
        this.outOfRange = textInputLayout.getContext().getString(R.string.mtrl_picker_out_of_range);
        this.setErrorCallback = new Runnable(){

            @Override
            public void run() {
                TextInputLayout textInputLayout = DateFormatTextWatcher.this.textInputLayout;
                Object object = DateFormatTextWatcher.this.dateFormat;
                Object object2 = textInputLayout.getContext();
                String string22 = object2.getString(R.string.mtrl_picker_invalid_format);
                String string3 = String.format(object2.getString(R.string.mtrl_picker_invalid_format_use), string2);
                object = String.format(object2.getString(R.string.mtrl_picker_invalid_format_example), ((DateFormat)object).format(new Date(UtcDates.getTodayCalendar().getTimeInMillis())));
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(string22);
                ((StringBuilder)object2).append("\n");
                ((StringBuilder)object2).append(string3);
                ((StringBuilder)object2).append("\n");
                ((StringBuilder)object2).append((String)object);
                textInputLayout.setError(((StringBuilder)object2).toString());
                DateFormatTextWatcher.this.onInvalidDate();
            }
        };
    }

    private Runnable createRangeErrorCallback(final long l) {
        return new Runnable(){

            @Override
            public void run() {
                DateFormatTextWatcher.this.textInputLayout.setError(String.format(DateFormatTextWatcher.this.outOfRange, DateStrings.getDateString(l)));
                DateFormatTextWatcher.this.onInvalidDate();
            }
        };
    }

    void onInvalidDate() {
    }

    @Override
    public void onTextChanged(CharSequence object, int n, int n2, int n3) {
        this.textInputLayout.removeCallbacks(this.setErrorCallback);
        this.textInputLayout.removeCallbacks(this.setRangeErrorCallback);
        this.textInputLayout.setError(null);
        this.onValidDate(null);
        if (TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        try {
            object = this.dateFormat.parse(object.toString());
            this.textInputLayout.setError(null);
            long l = ((Date)object).getTime();
            if (this.constraints.getDateValidator().isValid(l) && this.constraints.isWithinBounds(l)) {
                this.onValidDate(((Date)object).getTime());
                return;
            }
            this.setRangeErrorCallback = object = this.createRangeErrorCallback(l);
            this.runValidation((View)this.textInputLayout, (Runnable)object);
        }
        catch (ParseException parseException) {
            this.runValidation((View)this.textInputLayout, this.setErrorCallback);
        }
    }

    abstract void onValidDate(Long var1);

    public void runValidation(View view, Runnable runnable) {
        view.postDelayed(runnable, 1000L);
    }
}

