/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.core.util.Pair;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.CalendarStyle;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DaysOfWeekAdapter;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.MonthAdapter;
import com.google.android.material.datepicker.MonthsPagerAdapter;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.PickerFragment;
import com.google.android.material.datepicker.SmoothCalendarLayoutManager;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.datepicker.YearGridAdapter;
import java.util.Calendar;
import java.util.Iterator;

public final class MaterialCalendar<S>
extends PickerFragment<S> {
    private static final String CALENDAR_CONSTRAINTS_KEY = "CALENDAR_CONSTRAINTS_KEY";
    private static final String CURRENT_MONTH_KEY = "CURRENT_MONTH_KEY";
    private static final String GRID_SELECTOR_KEY = "GRID_SELECTOR_KEY";
    static final Object MONTHS_VIEW_GROUP_TAG = "MONTHS_VIEW_GROUP_TAG";
    static final Object NAVIGATION_NEXT_TAG;
    static final Object NAVIGATION_PREV_TAG;
    static final Object SELECTOR_TOGGLE_TAG;
    private static final int SMOOTH_SCROLL_MAX = 3;
    private static final String THEME_RES_ID_KEY = "THEME_RES_ID_KEY";
    private CalendarConstraints calendarConstraints;
    private CalendarSelector calendarSelector;
    private CalendarStyle calendarStyle;
    private Month current;
    private DateSelector<S> dateSelector;
    private View dayFrame;
    private RecyclerView recyclerView;
    private int themeResId;
    private View yearFrame;
    private RecyclerView yearSelector;

    static {
        NAVIGATION_PREV_TAG = "NAVIGATION_PREV_TAG";
        NAVIGATION_NEXT_TAG = "NAVIGATION_NEXT_TAG";
        SELECTOR_TOGGLE_TAG = "SELECTOR_TOGGLE_TAG";
    }

    static /* synthetic */ Month access$602(MaterialCalendar materialCalendar, Month month) {
        materialCalendar.current = month;
        return month;
    }

    private void addActionsToMonthNavigation(View view, final MonthsPagerAdapter monthsPagerAdapter) {
        final MaterialButton materialButton = (MaterialButton)view.findViewById(R.id.month_navigation_fragment_toggle);
        materialButton.setTag(SELECTOR_TOGGLE_TAG);
        ViewCompat.setAccessibilityDelegate((View)materialButton, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View object, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(object, accessibilityNodeInfoCompat);
                object = MaterialCalendar.this.dayFrame.getVisibility() == 0 ? MaterialCalendar.this.getString(R.string.mtrl_picker_toggle_to_year_selection) : MaterialCalendar.this.getString(R.string.mtrl_picker_toggle_to_day_selection);
                accessibilityNodeInfoCompat.setHintText((CharSequence)object);
            }
        });
        MaterialButton materialButton2 = (MaterialButton)view.findViewById(R.id.month_navigation_previous);
        materialButton2.setTag(NAVIGATION_PREV_TAG);
        MaterialButton materialButton3 = (MaterialButton)view.findViewById(R.id.month_navigation_next);
        materialButton3.setTag(NAVIGATION_NEXT_TAG);
        this.yearFrame = view.findViewById(R.id.mtrl_calendar_year_selector_frame);
        this.dayFrame = view.findViewById(R.id.mtrl_calendar_day_selector_frame);
        this.setSelector(CalendarSelector.DAY);
        materialButton.setText(this.current.getLongName(view.getContext()));
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int n) {
                if (n == 0) {
                    CharSequence charSequence = materialButton.getText();
                    if (Build.VERSION.SDK_INT >= 16) {
                        recyclerView.announceForAccessibility(charSequence);
                    } else {
                        recyclerView.sendAccessibilityEvent(2048);
                    }
                }
            }

            public void onScrolled(RecyclerView recyclerView, int n, int n2) {
                n = n < 0 ? MaterialCalendar.this.getLayoutManager().findFirstVisibleItemPosition() : MaterialCalendar.this.getLayoutManager().findLastVisibleItemPosition();
                MaterialCalendar.access$602(MaterialCalendar.this, monthsPagerAdapter.getPageMonth(n));
                materialButton.setText(monthsPagerAdapter.getPageTitle(n));
            }
        });
        materialButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialCalendar.this.toggleVisibleSelector();
            }
        });
        materialButton3.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int n = MaterialCalendar.this.getLayoutManager().findFirstVisibleItemPosition() + 1;
                if (n < MaterialCalendar.this.recyclerView.getAdapter().getItemCount()) {
                    MaterialCalendar.this.setCurrentMonth(monthsPagerAdapter.getPageMonth(n));
                }
            }
        });
        materialButton2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int n = MaterialCalendar.this.getLayoutManager().findLastVisibleItemPosition() - 1;
                if (n >= 0) {
                    MaterialCalendar.this.setCurrentMonth(monthsPagerAdapter.getPageMonth(n));
                }
            }
        });
    }

    private RecyclerView.ItemDecoration createItemDecoration() {
        return new RecyclerView.ItemDecoration(){
            private final Calendar endItem;
            private final Calendar startItem = UtcDates.getUtcCalendar();
            {
                this.endItem = UtcDates.getUtcCalendar();
            }

            public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
                if (recyclerView.getAdapter() instanceof YearGridAdapter && recyclerView.getLayoutManager() instanceof GridLayoutManager) {
                    YearGridAdapter yearGridAdapter = (YearGridAdapter)recyclerView.getAdapter();
                    state = (GridLayoutManager)recyclerView.getLayoutManager();
                    for (Pair<Long, Long> pair : MaterialCalendar.this.dateSelector.getSelectedRanges()) {
                        if (pair.first == null || pair.second == null) continue;
                        this.startItem.setTimeInMillis((Long)pair.first);
                        this.endItem.setTimeInMillis((Long)pair.second);
                        int n = yearGridAdapter.getPositionForYear(this.startItem.get(1));
                        int n2 = yearGridAdapter.getPositionForYear(this.endItem.get(1));
                        View view = state.findViewByPosition(n);
                        View view2 = state.findViewByPosition(n2);
                        int n3 = n / state.getSpanCount();
                        int n4 = n2 / state.getSpanCount();
                        for (n2 = n3; n2 <= n4; ++n2) {
                            View view3 = state.findViewByPosition(state.getSpanCount() * n2);
                            if (view3 == null) continue;
                            int n5 = view3.getTop();
                            int n6 = ((MaterialCalendar)MaterialCalendar.this).calendarStyle.year.getTopInset();
                            int n7 = view3.getBottom();
                            int n8 = ((MaterialCalendar)MaterialCalendar.this).calendarStyle.year.getBottomInset();
                            n = n2 == n3 ? view.getLeft() + view.getWidth() / 2 : 0;
                            int n9 = n2 == n4 ? view2.getLeft() + view2.getWidth() / 2 : recyclerView.getWidth();
                            canvas.drawRect((float)n, (float)(n5 + n6), (float)n9, (float)(n7 - n8), ((MaterialCalendar)MaterialCalendar.this).calendarStyle.rangeFill);
                        }
                    }
                }
            }
        };
    }

    static int getDayHeight(Context context) {
        return context.getResources().getDimensionPixelSize(R.dimen.mtrl_calendar_day_height);
    }

    private static int getDialogPickerHeight(Context context) {
        context = context.getResources();
        return context.getDimensionPixelSize(R.dimen.mtrl_calendar_navigation_height) + context.getDimensionPixelOffset(R.dimen.mtrl_calendar_navigation_top_padding) + context.getDimensionPixelOffset(R.dimen.mtrl_calendar_navigation_bottom_padding) + context.getDimensionPixelSize(R.dimen.mtrl_calendar_days_of_week_height) + (MonthAdapter.MAXIMUM_WEEKS * context.getDimensionPixelSize(R.dimen.mtrl_calendar_day_height) + (MonthAdapter.MAXIMUM_WEEKS - 1) * context.getDimensionPixelOffset(R.dimen.mtrl_calendar_month_vertical_padding)) + context.getDimensionPixelOffset(R.dimen.mtrl_calendar_bottom_padding);
    }

    public static <T> MaterialCalendar<T> newInstance(DateSelector<T> dateSelector, int n, CalendarConstraints calendarConstraints) {
        MaterialCalendar materialCalendar = new MaterialCalendar();
        Bundle bundle = new Bundle();
        bundle.putInt(THEME_RES_ID_KEY, n);
        bundle.putParcelable(GRID_SELECTOR_KEY, dateSelector);
        bundle.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)calendarConstraints);
        bundle.putParcelable(CURRENT_MONTH_KEY, (Parcelable)calendarConstraints.getOpenAt());
        materialCalendar.setArguments(bundle);
        return materialCalendar;
    }

    private void postSmoothRecyclerViewScroll(final int n) {
        this.recyclerView.post(new Runnable(){

            @Override
            public void run() {
                MaterialCalendar.this.recyclerView.smoothScrollToPosition(n);
            }
        });
    }

    @Override
    public boolean addOnSelectionChangedListener(OnSelectionChangedListener<S> onSelectionChangedListener) {
        return super.addOnSelectionChangedListener(onSelectionChangedListener);
    }

    CalendarConstraints getCalendarConstraints() {
        return this.calendarConstraints;
    }

    CalendarStyle getCalendarStyle() {
        return this.calendarStyle;
    }

    Month getCurrentMonth() {
        return this.current;
    }

    @Override
    public DateSelector<S> getDateSelector() {
        return this.dateSelector;
    }

    LinearLayoutManager getLayoutManager() {
        return (LinearLayoutManager)this.recyclerView.getLayoutManager();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = bundle;
        if (bundle == null) {
            bundle2 = this.getArguments();
        }
        this.themeResId = bundle2.getInt(THEME_RES_ID_KEY);
        this.dateSelector = (DateSelector)bundle2.getParcelable(GRID_SELECTOR_KEY);
        this.calendarConstraints = (CalendarConstraints)bundle2.getParcelable(CALENDAR_CONSTRAINTS_KEY);
        this.current = (Month)bundle2.getParcelable(CURRENT_MONTH_KEY);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup object, Bundle bundle) {
        int n;
        int n2;
        bundle = new ContextThemeWrapper(this.getContext(), this.themeResId);
        this.calendarStyle = new CalendarStyle((Context)bundle);
        layoutInflater = layoutInflater.cloneInContext((Context)bundle);
        Month month = this.calendarConstraints.getStart();
        if (MaterialDatePicker.isFullscreen((Context)bundle)) {
            n2 = R.layout.mtrl_calendar_vertical;
            n = 1;
        } else {
            n2 = R.layout.mtrl_calendar_horizontal;
            n = 0;
        }
        layoutInflater = layoutInflater.inflate(n2, (ViewGroup)object, false);
        layoutInflater.setMinimumHeight(MaterialCalendar.getDialogPickerHeight(this.requireContext()));
        object = (GridView)layoutInflater.findViewById(R.id.mtrl_calendar_days_of_week);
        ViewCompat.setAccessibilityDelegate((View)object, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setCollectionInfo(null);
            }
        });
        object.setAdapter((ListAdapter)new DaysOfWeekAdapter());
        object.setNumColumns(month.daysInWeek);
        object.setEnabled(false);
        this.recyclerView = (RecyclerView)layoutInflater.findViewById(R.id.mtrl_calendar_months);
        object = new SmoothCalendarLayoutManager(this.getContext(), n, false){

            protected void calculateExtraLayoutSpace(RecyclerView.State state, int[] nArray) {
                if (n == 0) {
                    nArray[0] = MaterialCalendar.this.recyclerView.getWidth();
                    nArray[1] = MaterialCalendar.this.recyclerView.getWidth();
                } else {
                    nArray[0] = MaterialCalendar.this.recyclerView.getHeight();
                    nArray[1] = MaterialCalendar.this.recyclerView.getHeight();
                }
            }
        };
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)object);
        this.recyclerView.setTag(MONTHS_VIEW_GROUP_TAG);
        object = new MonthsPagerAdapter((Context)bundle, this.dateSelector, this.calendarConstraints, new OnDayClickListener(){

            @Override
            public void onDayClick(long l) {
                if (MaterialCalendar.this.calendarConstraints.getDateValidator().isValid(l)) {
                    MaterialCalendar.this.dateSelector.select(l);
                    Iterator iterator2 = MaterialCalendar.this.onSelectionChangedListeners.iterator();
                    while (iterator2.hasNext()) {
                        ((OnSelectionChangedListener)iterator2.next()).onSelectionChanged(MaterialCalendar.this.dateSelector.getSelection());
                    }
                    MaterialCalendar.this.recyclerView.getAdapter().notifyDataSetChanged();
                    if (MaterialCalendar.this.yearSelector != null) {
                        MaterialCalendar.this.yearSelector.getAdapter().notifyDataSetChanged();
                    }
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)object);
        n = bundle.getResources().getInteger(R.integer.mtrl_calendar_year_selector_span);
        month = (RecyclerView)layoutInflater.findViewById(R.id.mtrl_calendar_year_selector_frame);
        this.yearSelector = month;
        if (month != null) {
            month.setHasFixedSize(true);
            this.yearSelector.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)bundle, n, 1, false));
            this.yearSelector.setAdapter((RecyclerView.Adapter)new YearGridAdapter(this));
            this.yearSelector.addItemDecoration(this.createItemDecoration());
        }
        if (layoutInflater.findViewById(R.id.month_navigation_fragment_toggle) != null) {
            this.addActionsToMonthNavigation((View)layoutInflater, (MonthsPagerAdapter)((Object)object));
        }
        if (!MaterialDatePicker.isFullscreen((Context)bundle)) {
            new PagerSnapHelper().attachToRecyclerView(this.recyclerView);
        }
        this.recyclerView.scrollToPosition(((MonthsPagerAdapter)((Object)object)).getPosition(this.current));
        return layoutInflater;
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt(THEME_RES_ID_KEY, this.themeResId);
        bundle.putParcelable(GRID_SELECTOR_KEY, this.dateSelector);
        bundle.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)this.calendarConstraints);
        bundle.putParcelable(CURRENT_MONTH_KEY, (Parcelable)this.current);
    }

    void setCurrentMonth(Month month) {
        MonthsPagerAdapter monthsPagerAdapter = (MonthsPagerAdapter)this.recyclerView.getAdapter();
        int n = monthsPagerAdapter.getPosition(month);
        int n2 = n - monthsPagerAdapter.getPosition(this.current);
        int n3 = Math.abs(n2);
        boolean bl = true;
        n3 = n3 > 3 ? 1 : 0;
        if (n2 <= 0) {
            bl = false;
        }
        this.current = month;
        if (n3 != 0 && bl) {
            this.recyclerView.scrollToPosition(n - 3);
            this.postSmoothRecyclerViewScroll(n);
        } else if (n3 != 0) {
            this.recyclerView.scrollToPosition(n + 3);
            this.postSmoothRecyclerViewScroll(n);
        } else {
            this.postSmoothRecyclerViewScroll(n);
        }
    }

    void setSelector(CalendarSelector calendarSelector) {
        this.calendarSelector = calendarSelector;
        if (calendarSelector == CalendarSelector.YEAR) {
            this.yearSelector.getLayoutManager().scrollToPosition(((YearGridAdapter)this.yearSelector.getAdapter()).getPositionForYear(this.current.year));
            this.yearFrame.setVisibility(0);
            this.dayFrame.setVisibility(8);
        } else if (calendarSelector == CalendarSelector.DAY) {
            this.yearFrame.setVisibility(8);
            this.dayFrame.setVisibility(0);
            this.setCurrentMonth(this.current);
        }
    }

    void toggleVisibleSelector() {
        if (this.calendarSelector == CalendarSelector.YEAR) {
            this.setSelector(CalendarSelector.DAY);
        } else if (this.calendarSelector == CalendarSelector.DAY) {
            this.setSelector(CalendarSelector.YEAR);
        }
    }

    static final class CalendarSelector
    extends Enum<CalendarSelector> {
        private static final /* synthetic */ CalendarSelector[] $VALUES;
        public static final /* enum */ CalendarSelector DAY;
        public static final /* enum */ CalendarSelector YEAR;

        static {
            CalendarSelector calendarSelector;
            CalendarSelector calendarSelector2;
            DAY = calendarSelector2 = new CalendarSelector();
            YEAR = calendarSelector = new CalendarSelector();
            $VALUES = new CalendarSelector[]{calendarSelector2, calendarSelector};
        }

        public static CalendarSelector valueOf(String string2) {
            return Enum.valueOf(CalendarSelector.class, string2);
        }

        public static CalendarSelector[] values() {
            return (CalendarSelector[])$VALUES.clone();
        }
    }

    static interface OnDayClickListener {
        public void onDayClick(long var1);
    }
}

