/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.core.util.Pair;
import androidx.core.util.Preconditions;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateFormatTextWatcher;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.textfield.TextInputLayout;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

public class RangeDateSelector
implements DateSelector<Pair<Long, Long>> {
    public static final Parcelable.Creator<RangeDateSelector> CREATOR = new Parcelable.Creator<RangeDateSelector>(){

        public RangeDateSelector createFromParcel(Parcel parcel) {
            RangeDateSelector rangeDateSelector = new RangeDateSelector();
            RangeDateSelector.access$302(rangeDateSelector, (Long)parcel.readValue(Long.class.getClassLoader()));
            RangeDateSelector.access$402(rangeDateSelector, (Long)parcel.readValue(Long.class.getClassLoader()));
            return rangeDateSelector;
        }

        public RangeDateSelector[] newArray(int n) {
            return new RangeDateSelector[n];
        }
    };
    private final String invalidRangeEndError;
    private String invalidRangeStartError;
    private Long proposedTextEnd = null;
    private Long proposedTextStart = null;
    private Long selectedEndItem = null;
    private Long selectedStartItem = null;

    public RangeDateSelector() {
        this.invalidRangeEndError = " ";
    }

    static /* synthetic */ Long access$002(RangeDateSelector rangeDateSelector, Long l) {
        rangeDateSelector.proposedTextStart = l;
        return l;
    }

    static /* synthetic */ Long access$202(RangeDateSelector rangeDateSelector, Long l) {
        rangeDateSelector.proposedTextEnd = l;
        return l;
    }

    static /* synthetic */ Long access$302(RangeDateSelector rangeDateSelector, Long l) {
        rangeDateSelector.selectedStartItem = l;
        return l;
    }

    static /* synthetic */ Long access$402(RangeDateSelector rangeDateSelector, Long l) {
        rangeDateSelector.selectedEndItem = l;
        return l;
    }

    private void clearInvalidRange(TextInputLayout textInputLayout, TextInputLayout textInputLayout2) {
        if (textInputLayout.getError() != null && this.invalidRangeStartError.contentEquals(textInputLayout.getError())) {
            textInputLayout.setError(null);
        }
        if (textInputLayout2.getError() != null && " ".contentEquals(textInputLayout2.getError())) {
            textInputLayout2.setError(null);
        }
    }

    private boolean isValidRange(long l, long l2) {
        boolean bl = l <= l2;
        return bl;
    }

    private void setInvalidRange(TextInputLayout textInputLayout, TextInputLayout textInputLayout2) {
        textInputLayout.setError(this.invalidRangeStartError);
        textInputLayout2.setError(" ");
    }

    private void updateIfValidTextProposal(TextInputLayout textInputLayout, TextInputLayout textInputLayout2, OnSelectionChangedListener<Pair<Long, Long>> onSelectionChangedListener) {
        Long l = this.proposedTextStart;
        if (l != null && this.proposedTextEnd != null) {
            if (this.isValidRange(l, this.proposedTextEnd)) {
                this.selectedStartItem = this.proposedTextStart;
                this.selectedEndItem = this.proposedTextEnd;
                onSelectionChangedListener.onSelectionChanged(this.getSelection());
            } else {
                this.setInvalidRange(textInputLayout, textInputLayout2);
                onSelectionChangedListener.onIncompleteSelectionChanged();
            }
            return;
        }
        this.clearInvalidRange(textInputLayout, textInputLayout2);
        onSelectionChangedListener.onIncompleteSelectionChanged();
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public int getDefaultThemeResId(Context context) {
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        int n = resources.getDimensionPixelSize(R.dimen.mtrl_calendar_maximum_default_fullscreen_minor_axis);
        n = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels) > n ? R.attr.materialCalendarTheme : R.attr.materialCalendarFullscreenTheme;
        return MaterialAttributes.resolveOrThrow(context, n, MaterialDatePicker.class.getCanonicalName());
    }

    @Override
    public int getDefaultTitleResId() {
        return R.string.mtrl_picker_range_header_title;
    }

    @Override
    public Collection<Long> getSelectedDays() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Long l = this.selectedStartItem;
        if (l != null) {
            arrayList.add(l);
        }
        if ((l = this.selectedEndItem) != null) {
            arrayList.add(l);
        }
        return arrayList;
    }

    @Override
    public Collection<Pair<Long, Long>> getSelectedRanges() {
        if (this.selectedStartItem != null && this.selectedEndItem != null) {
            ArrayList<Pair<Long, Long>> arrayList = new ArrayList<Pair<Long, Long>>();
            arrayList.add(new Pair((Object)this.selectedStartItem, (Object)this.selectedEndItem));
            return arrayList;
        }
        return new ArrayList<Pair<Long, Long>>();
    }

    @Override
    public Pair<Long, Long> getSelection() {
        return new Pair((Object)this.selectedStartItem, (Object)this.selectedEndItem);
    }

    @Override
    public String getSelectionDisplayString(Context context) {
        context = context.getResources();
        Long l = this.selectedStartItem;
        if (l == null && this.selectedEndItem == null) {
            return context.getString(R.string.mtrl_picker_range_header_unselected);
        }
        Pair<String, String> pair = this.selectedEndItem;
        if (pair == null) {
            return context.getString(R.string.mtrl_picker_range_header_only_start_selected, new Object[]{DateStrings.getDateString(this.selectedStartItem)});
        }
        if (l == null) {
            return context.getString(R.string.mtrl_picker_range_header_only_end_selected, new Object[]{DateStrings.getDateString(this.selectedEndItem)});
        }
        pair = DateStrings.getDateRangeString(l, (Long)pair);
        return context.getString(R.string.mtrl_picker_range_header_selected, new Object[]{pair.first, pair.second});
    }

    @Override
    public boolean isSelectionComplete() {
        Long l = this.selectedStartItem;
        boolean bl = l != null && this.selectedEndItem != null && this.isValidRange(l, this.selectedEndItem);
        return bl;
    }

    @Override
    public View onCreateTextInputView(LayoutInflater layoutInflater, ViewGroup object, Bundle object2, CalendarConstraints calendarConstraints, OnSelectionChangedListener<Pair<Long, Long>> onSelectionChangedListener) {
        View view = layoutInflater.inflate(R.layout.mtrl_picker_text_input_date_range, (ViewGroup)object, false);
        object = (TextInputLayout)view.findViewById(R.id.mtrl_picker_text_input_range_start);
        TextInputLayout textInputLayout = (TextInputLayout)view.findViewById(R.id.mtrl_picker_text_input_range_end);
        EditText editText = ((TextInputLayout)((Object)object)).getEditText();
        layoutInflater = textInputLayout.getEditText();
        if (ManufacturerUtils.isDateInputKeyboardMissingSeparatorCharacters()) {
            editText.setInputType(17);
            layoutInflater.setInputType(17);
        }
        this.invalidRangeStartError = view.getResources().getString(R.string.mtrl_picker_invalid_range);
        object2 = UtcDates.getTextInputFormat();
        Object object3 = this.selectedStartItem;
        if (object3 != null) {
            editText.setText((CharSequence)((Format)object2).format(object3));
            this.proposedTextStart = this.selectedStartItem;
        }
        if ((object3 = this.selectedEndItem) != null) {
            layoutInflater.setText((CharSequence)((Format)object2).format(object3));
            this.proposedTextEnd = this.selectedEndItem;
        }
        object3 = UtcDates.getTextInputHint(view.getResources(), (SimpleDateFormat)object2);
        ((TextInputLayout)((Object)object)).setPlaceholderText((CharSequence)object3);
        textInputLayout.setPlaceholderText((CharSequence)object3);
        editText.addTextChangedListener((TextWatcher)new DateFormatTextWatcher((String)object3, (DateFormat)object2, (TextInputLayout)((Object)object), calendarConstraints, (TextInputLayout)((Object)object), textInputLayout, onSelectionChangedListener){
            final /* synthetic */ TextInputLayout val$endTextInput;
            final /* synthetic */ OnSelectionChangedListener val$listener;
            final /* synthetic */ TextInputLayout val$startTextInput;
            {
                this.val$startTextInput = textInputLayout2;
                this.val$endTextInput = textInputLayout3;
                this.val$listener = onSelectionChangedListener;
                super(string2, dateFormat, textInputLayout, calendarConstraints);
            }

            @Override
            void onInvalidDate() {
                RangeDateSelector.access$002(RangeDateSelector.this, null);
                RangeDateSelector.this.updateIfValidTextProposal(this.val$startTextInput, this.val$endTextInput, this.val$listener);
            }

            @Override
            void onValidDate(Long l) {
                RangeDateSelector.access$002(RangeDateSelector.this, l);
                RangeDateSelector.this.updateIfValidTextProposal(this.val$startTextInput, this.val$endTextInput, this.val$listener);
            }
        });
        layoutInflater.addTextChangedListener((TextWatcher)new DateFormatTextWatcher((String)object3, (DateFormat)object2, textInputLayout, calendarConstraints, (TextInputLayout)((Object)object), textInputLayout, onSelectionChangedListener){
            final /* synthetic */ TextInputLayout val$endTextInput;
            final /* synthetic */ OnSelectionChangedListener val$listener;
            final /* synthetic */ TextInputLayout val$startTextInput;
            {
                this.val$startTextInput = textInputLayout2;
                this.val$endTextInput = textInputLayout3;
                this.val$listener = onSelectionChangedListener;
                super(string2, dateFormat, textInputLayout, calendarConstraints);
            }

            @Override
            void onInvalidDate() {
                RangeDateSelector.access$202(RangeDateSelector.this, null);
                RangeDateSelector.this.updateIfValidTextProposal(this.val$startTextInput, this.val$endTextInput, this.val$listener);
            }

            @Override
            void onValidDate(Long l) {
                RangeDateSelector.access$202(RangeDateSelector.this, l);
                RangeDateSelector.this.updateIfValidTextProposal(this.val$startTextInput, this.val$endTextInput, this.val$listener);
            }
        });
        ViewUtils.requestFocusAndShowKeyboard((View)editText);
        return view;
    }

    @Override
    public void select(long l) {
        Long l2 = this.selectedStartItem;
        if (l2 == null) {
            this.selectedStartItem = l;
        } else if (this.selectedEndItem == null && this.isValidRange(l2, l)) {
            this.selectedEndItem = l;
        } else {
            this.selectedEndItem = null;
            this.selectedStartItem = l;
        }
    }

    @Override
    public void setSelection(Pair<Long, Long> object) {
        if (object.first != null && object.second != null) {
            Preconditions.checkArgument((boolean)this.isValidRange((Long)object.first, (Long)object.second));
        }
        Object object2 = object.first;
        Object var3_3 = null;
        object2 = object2 == null ? null : Long.valueOf(UtcDates.canonicalYearMonthDay((Long)object.first));
        this.selectedStartItem = object2;
        object = object.second == null ? var3_3 : Long.valueOf(UtcDates.canonicalYearMonthDay((Long)object.second));
        this.selectedEndItem = object;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.selectedStartItem);
        parcel.writeValue((Object)this.selectedEndItem);
    }
}

