/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.core.util.Pair;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateFormatTextWatcher;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.textfield.TextInputLayout;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

public class SingleDateSelector
implements DateSelector<Long> {
    public static final Parcelable.Creator<SingleDateSelector> CREATOR = new Parcelable.Creator<SingleDateSelector>(){

        public SingleDateSelector createFromParcel(Parcel parcel) {
            SingleDateSelector singleDateSelector = new SingleDateSelector();
            SingleDateSelector.access$102(singleDateSelector, (Long)parcel.readValue(Long.class.getClassLoader()));
            return singleDateSelector;
        }

        public SingleDateSelector[] newArray(int n) {
            return new SingleDateSelector[n];
        }
    };
    private Long selectedItem;

    static /* synthetic */ Long access$102(SingleDateSelector singleDateSelector, Long l) {
        singleDateSelector.selectedItem = l;
        return l;
    }

    private void clearSelection() {
        this.selectedItem = null;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public int getDefaultThemeResId(Context context) {
        return MaterialAttributes.resolveOrThrow(context, R.attr.materialCalendarTheme, MaterialDatePicker.class.getCanonicalName());
    }

    @Override
    public int getDefaultTitleResId() {
        return R.string.mtrl_picker_date_header_title;
    }

    @Override
    public Collection<Long> getSelectedDays() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Long l = this.selectedItem;
        if (l != null) {
            arrayList.add(l);
        }
        return arrayList;
    }

    @Override
    public Collection<Pair<Long, Long>> getSelectedRanges() {
        return new ArrayList<Pair<Long, Long>>();
    }

    @Override
    public Long getSelection() {
        return this.selectedItem;
    }

    @Override
    public String getSelectionDisplayString(Context context) {
        context = context.getResources();
        Object object = this.selectedItem;
        if (object == null) {
            return context.getString(R.string.mtrl_picker_date_header_unselected);
        }
        object = DateStrings.getYearMonthDay((Long)object);
        return context.getString(R.string.mtrl_picker_date_header_selected, new Object[]{object});
    }

    @Override
    public boolean isSelectionComplete() {
        boolean bl = this.selectedItem != null;
        return bl;
    }

    @Override
    public View onCreateTextInputView(LayoutInflater object, ViewGroup object2, Bundle object3, CalendarConstraints calendarConstraints, final OnSelectionChangedListener<Long> onSelectionChangedListener) {
        View view = object.inflate(R.layout.mtrl_picker_text_input_date, (ViewGroup)object2, false);
        object2 = (TextInputLayout)view.findViewById(R.id.mtrl_picker_text_input_date);
        EditText editText = ((TextInputLayout)((Object)object2)).getEditText();
        if (ManufacturerUtils.isDateInputKeyboardMissingSeparatorCharacters()) {
            editText.setInputType(17);
        }
        object = UtcDates.getTextInputFormat();
        object3 = UtcDates.getTextInputHint(view.getResources(), (SimpleDateFormat)object);
        ((TextInputLayout)((Object)object2)).setPlaceholderText((CharSequence)object3);
        Long l = this.selectedItem;
        if (l != null) {
            editText.setText((CharSequence)((Format)object).format(l));
        }
        editText.addTextChangedListener((TextWatcher)new DateFormatTextWatcher((String)object3, (DateFormat)object, (TextInputLayout)((Object)object2), calendarConstraints){

            @Override
            void onInvalidDate() {
                onSelectionChangedListener.onIncompleteSelectionChanged();
            }

            @Override
            void onValidDate(Long l) {
                if (l == null) {
                    SingleDateSelector.this.clearSelection();
                } else {
                    SingleDateSelector.this.select(l);
                }
                onSelectionChangedListener.onSelectionChanged(SingleDateSelector.this.getSelection());
            }
        });
        ViewUtils.requestFocusAndShowKeyboard((View)editText);
        return view;
    }

    @Override
    public void select(long l) {
        this.selectedItem = l;
    }

    @Override
    public void setSelection(Long l) {
        l = l == null ? null : Long.valueOf(UtcDates.canonicalYearMonthDay(l));
        this.selectedItem = l;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeValue((Object)this.selectedItem);
    }
}

