/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.divider;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class MaterialDivider
extends View {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_MaterialDivider;
    private int color;
    private final MaterialShapeDrawable dividerDrawable;
    private int insetEnd;
    private int insetStart;
    private int thickness;

    public MaterialDivider(Context context) {
        this(context, null);
    }

    public MaterialDivider(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.materialDividerStyle);
    }

    public MaterialDivider(Context context, AttributeSet attributeSet, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
        context = this.getContext();
        this.dividerDrawable = new MaterialShapeDrawable();
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.MaterialDivider, n, n2, new int[0]);
        this.thickness = attributeSet.getDimensionPixelSize(R.styleable.MaterialDivider_dividerThickness, this.getResources().getDimensionPixelSize(R.dimen.material_divider_thickness));
        this.insetStart = attributeSet.getDimensionPixelOffset(R.styleable.MaterialDivider_dividerInsetStart, 0);
        this.insetEnd = attributeSet.getDimensionPixelOffset(R.styleable.MaterialDivider_dividerInsetEnd, 0);
        this.setDividerColor(MaterialResources.getColorStateList(context, (TypedArray)attributeSet, R.styleable.MaterialDivider_dividerColor).getDefaultColor());
        attributeSet.recycle();
    }

    public int getDividerColor() {
        return this.color;
    }

    public int getDividerInsetEnd() {
        return this.insetEnd;
    }

    public int getDividerInsetStart() {
        return this.insetStart;
    }

    public int getDividerThickness() {
        return this.thickness;
    }

    protected void onDraw(Canvas canvas) {
        int n;
        super.onDraw(canvas);
        int n2 = ViewCompat.getLayoutDirection((View)this);
        int n3 = 1;
        if (n2 != 1) {
            n3 = 0;
        }
        n2 = n3 != 0 ? this.insetEnd : this.insetStart;
        if (n3 != 0) {
            n = this.getWidth();
            n3 = this.insetStart;
        } else {
            n = this.getWidth();
            n3 = this.insetEnd;
        }
        this.dividerDrawable.setBounds(n2, 0, n - n3, this.getBottom() - this.getTop());
        this.dividerDrawable.draw(canvas);
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        n = View.MeasureSpec.getMode((int)n2);
        n2 = this.getMeasuredHeight();
        if (n == Integer.MIN_VALUE || n == 0) {
            int n3 = this.thickness;
            n = n2;
            if (n3 > 0) {
                n = n2;
                if (n2 != n3) {
                    n = n3;
                }
            }
            this.setMeasuredDimension(this.getMeasuredWidth(), n);
        }
    }

    public void setDividerColor(int n) {
        if (this.color != n) {
            this.color = n;
            this.dividerDrawable.setFillColor(ColorStateList.valueOf((int)n));
            this.invalidate();
        }
    }

    public void setDividerColorResource(int n) {
        this.setDividerColor(ContextCompat.getColor((Context)this.getContext(), (int)n));
    }

    public void setDividerInsetEnd(int n) {
        this.insetEnd = n;
    }

    public void setDividerInsetEndResource(int n) {
        this.setDividerInsetEnd(this.getContext().getResources().getDimensionPixelOffset(n));
    }

    public void setDividerInsetStart(int n) {
        this.insetStart = n;
    }

    public void setDividerInsetStartResource(int n) {
        this.setDividerInsetStart(this.getContext().getResources().getDimensionPixelOffset(n));
    }

    public void setDividerThickness(int n) {
        if (this.thickness != n) {
            this.thickness = n;
            this.requestLayout();
        }
    }

    public void setDividerThicknessResource(int n) {
        this.setDividerThickness(this.getContext().getResources().getDimensionPixelSize(n));
    }
}

