/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.divider;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;

public class MaterialDividerItemDecoration
extends RecyclerView.ItemDecoration {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_MaterialDivider;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int color;
    private Drawable dividerDrawable;
    private int insetEnd;
    private int insetStart;
    private int orientation;
    private final Rect tempRect = new Rect();
    private int thickness;

    public MaterialDividerItemDecoration(Context context, int n) {
        this(context, null, n);
    }

    public MaterialDividerItemDecoration(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, R.attr.materialDividerStyle, n);
    }

    public MaterialDividerItemDecoration(Context context, AttributeSet attributeSet, int n, int n2) {
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.MaterialDivider, n, DEF_STYLE_RES, new int[0]);
        this.color = MaterialResources.getColorStateList(context, (TypedArray)attributeSet, R.styleable.MaterialDivider_dividerColor).getDefaultColor();
        this.thickness = attributeSet.getDimensionPixelSize(R.styleable.MaterialDivider_dividerThickness, context.getResources().getDimensionPixelSize(R.dimen.material_divider_thickness));
        this.insetStart = attributeSet.getDimensionPixelOffset(R.styleable.MaterialDivider_dividerInsetStart, 0);
        this.insetEnd = attributeSet.getDimensionPixelOffset(R.styleable.MaterialDivider_dividerInsetEnd, 0);
        attributeSet.recycle();
        this.dividerDrawable = new ShapeDrawable();
        this.setDividerColor(this.color);
        this.setOrientation(n2);
    }

    private void drawForHorizontalOrientation(Canvas canvas, RecyclerView recyclerView) {
        int n;
        int n2;
        canvas.save();
        boolean bl = recyclerView.getClipToPadding();
        int n3 = 0;
        if (bl) {
            n2 = recyclerView.getPaddingTop();
            n = recyclerView.getHeight() - recyclerView.getPaddingBottom();
            canvas.clipRect(recyclerView.getPaddingLeft(), n2, recyclerView.getWidth() - recyclerView.getPaddingRight(), n);
        } else {
            n = recyclerView.getHeight();
            n2 = 0;
        }
        int n4 = this.insetStart;
        int n5 = this.insetEnd;
        int n6 = recyclerView.getChildCount();
        while (n3 < n6) {
            View view = recyclerView.getChildAt(n3);
            recyclerView.getLayoutManager().getDecoratedBoundsWithMargins(view, this.tempRect);
            int n7 = this.tempRect.right + Math.round(view.getTranslationX());
            int n8 = this.dividerDrawable.getIntrinsicWidth();
            int n9 = this.thickness;
            this.dividerDrawable.setBounds(n7 - n8 - n9, n2 + n4, n7, n - n5);
            this.dividerDrawable.draw(canvas);
            ++n3;
        }
        canvas.restore();
    }

    private void drawForVerticalOrientation(Canvas canvas, RecyclerView recyclerView) {
        int n;
        int n2;
        canvas.save();
        boolean bl = recyclerView.getClipToPadding();
        int n3 = 0;
        if (bl) {
            n2 = recyclerView.getPaddingLeft();
            n = recyclerView.getWidth() - recyclerView.getPaddingRight();
            canvas.clipRect(n2, recyclerView.getPaddingTop(), n, recyclerView.getHeight() - recyclerView.getPaddingBottom());
        } else {
            n = recyclerView.getWidth();
            n2 = 0;
        }
        int n4 = ViewCompat.getLayoutDirection((View)recyclerView);
        int n5 = 1;
        if (n4 != 1) {
            n5 = 0;
        }
        n4 = n5 != 0 ? this.insetEnd : this.insetStart;
        n5 = n5 != 0 ? this.insetStart : this.insetEnd;
        int n6 = recyclerView.getChildCount();
        while (n3 < n6) {
            View view = recyclerView.getChildAt(n3);
            recyclerView.getDecoratedBoundsWithMargins(view, this.tempRect);
            int n7 = this.tempRect.bottom + Math.round(view.getTranslationY());
            int n8 = this.dividerDrawable.getIntrinsicHeight();
            int n9 = this.thickness;
            this.dividerDrawable.setBounds(n2 + n4, n7 - n8 - n9, n - n5, n7);
            this.dividerDrawable.draw(canvas);
            ++n3;
        }
        canvas.restore();
    }

    public int getDividerColor() {
        return this.color;
    }

    public int getDividerInsetEnd() {
        return this.insetEnd;
    }

    public int getDividerInsetStart() {
        return this.insetStart;
    }

    public int getDividerThickness() {
        return this.thickness;
    }

    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        rect.set(0, 0, 0, 0);
        if (this.orientation == 1) {
            rect.bottom = this.dividerDrawable.getIntrinsicHeight() + this.thickness;
        } else {
            rect.right = this.dividerDrawable.getIntrinsicWidth() + this.thickness;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        if (recyclerView.getLayoutManager() == null) {
            return;
        }
        if (this.orientation == 1) {
            this.drawForVerticalOrientation(canvas, recyclerView);
        } else {
            this.drawForHorizontalOrientation(canvas, recyclerView);
        }
    }

    public void setDividerColor(int n) {
        Drawable drawable2;
        this.color = n;
        this.dividerDrawable = drawable2 = DrawableCompat.wrap((Drawable)this.dividerDrawable);
        DrawableCompat.setTint((Drawable)drawable2, (int)n);
    }

    public void setDividerColorResource(Context context, int n) {
        this.setDividerColor(ContextCompat.getColor((Context)context, (int)n));
    }

    public void setDividerInsetEnd(int n) {
        this.insetEnd = n;
    }

    public void setDividerInsetEndResource(Context context, int n) {
        this.setDividerInsetEnd(context.getResources().getDimensionPixelOffset(n));
    }

    public void setDividerInsetStart(int n) {
        this.insetStart = n;
    }

    public void setDividerInsetStartResource(Context context, int n) {
        this.setDividerInsetStart(context.getResources().getDimensionPixelOffset(n));
    }

    public void setDividerThickness(int n) {
        this.thickness = n;
    }

    public void setDividerThicknessResource(Context context, int n) {
        this.setDividerThickness(context.getResources().getDimensionPixelSize(n));
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid orientation: ");
            stringBuilder.append(n);
            stringBuilder.append(". It should be either HORIZONTAL or VERTICAL");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.orientation = n;
    }
}

