/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.drawable;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Xml;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class DrawableUtils {
    private DrawableUtils() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AttributeSet parseDrawableXml(Context object, int n, CharSequence object2) {
        void var0_6;
        void var1_7;
        try {
            void var2_8;
            int n2;
            XmlResourceParser xmlResourceParser = object.getResources().getXml((int)var1_7);
            while ((n2 = xmlResourceParser.next()) != 2 && n2 != 1) {
            }
            if (n2 != 2) {
                XmlPullParserException xmlPullParserException = new XmlPullParserException("No start tag found");
                throw xmlPullParserException;
            }
            if (TextUtils.equals((CharSequence)xmlResourceParser.getName(), (CharSequence)var2_8)) {
                return Xml.asAttributeSet((XmlPullParser)xmlResourceParser);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Must have a <");
            stringBuilder.append(var2_8);
            stringBuilder.append("> start tag");
            XmlPullParserException xmlPullParserException = new XmlPullParserException(stringBuilder.toString());
            throw xmlPullParserException;
        }
        catch (IOException iOException) {
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Can't load badge resource ID #0x");
        stringBuilder.append(Integer.toHexString((int)var1_7));
        Resources.NotFoundException notFoundException = new Resources.NotFoundException(stringBuilder.toString());
        notFoundException.initCause((Throwable)var0_6);
        throw notFoundException;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setRippleDrawableRadius(RippleDrawable rippleDrawable, int n) {
        void var0_4;
        if (Build.VERSION.SDK_INT >= 23) {
            rippleDrawable.setRadius(n);
            return;
        }
        try {
            RippleDrawable.class.getDeclaredMethod("setMaxRadius", Integer.TYPE).invoke((Object)rippleDrawable, n);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Couldn't set RippleDrawable radius", (Throwable)var0_4);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException("Couldn't set RippleDrawable radius", (Throwable)var0_4);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new IllegalStateException("Couldn't set RippleDrawable radius", (Throwable)var0_4);
    }

    public static PorterDuffColorFilter updateTintFilter(Drawable drawable2, ColorStateList colorStateList, PorterDuff.Mode mode) {
        if (colorStateList != null && mode != null) {
            return new PorterDuffColorFilter(colorStateList.getColorForState(drawable2.getState(), 0), mode);
        }
        return null;
    }
}

