/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.elevation;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import androidx.core.graphics.ColorUtils;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialAttributes;

public class ElevationOverlayProvider {
    private static final float FORMULA_MULTIPLIER = 4.5f;
    private static final float FORMULA_OFFSET = 2.0f;
    private static final int OVERLAY_ACCENT_COLOR_ALPHA = (int)Math.round(5.1000000000000005);
    private final int colorSurface;
    private final float displayDensity;
    private final int elevationOverlayAccentColor;
    private final int elevationOverlayColor;
    private final boolean elevationOverlayEnabled;

    public ElevationOverlayProvider(Context context) {
        this(MaterialAttributes.resolveBoolean(context, R.attr.elevationOverlayEnabled, false), MaterialColors.getColor(context, R.attr.elevationOverlayColor, 0), MaterialColors.getColor(context, R.attr.elevationOverlayAccentColor, 0), MaterialColors.getColor(context, R.attr.colorSurface, 0), context.getResources().getDisplayMetrics().density);
    }

    public ElevationOverlayProvider(boolean bl, int n, int n2, int n3, float f) {
        this.elevationOverlayEnabled = bl;
        this.elevationOverlayColor = n;
        this.elevationOverlayAccentColor = n2;
        this.colorSurface = n3;
        this.displayDensity = f;
    }

    private boolean isThemeSurfaceColor(int n) {
        boolean bl = ColorUtils.setAlphaComponent((int)n, (int)255) == this.colorSurface;
        return bl;
    }

    public int calculateOverlayAlpha(float f) {
        return Math.round(this.calculateOverlayAlphaFraction(f) * 255.0f);
    }

    public float calculateOverlayAlphaFraction(float f) {
        float f2 = this.displayDensity;
        if (!(f2 <= 0.0f) && !(f <= 0.0f)) {
            return Math.min(((float)Math.log1p(f / f2) * 4.5f + 2.0f) / 100.0f, 1.0f);
        }
        return 0.0f;
    }

    public int compositeOverlay(int n, float f) {
        int n2;
        f = this.calculateOverlayAlphaFraction(f);
        int n3 = Color.alpha((int)n);
        n = n2 = MaterialColors.layer(ColorUtils.setAlphaComponent((int)n, (int)255), this.elevationOverlayColor, f);
        if (f > 0.0f) {
            int n4 = this.elevationOverlayAccentColor;
            n = n2;
            if (n4 != 0) {
                n = MaterialColors.layer(n2, ColorUtils.setAlphaComponent((int)n4, (int)OVERLAY_ACCENT_COLOR_ALPHA));
            }
        }
        return ColorUtils.setAlphaComponent((int)n, (int)n3);
    }

    public int compositeOverlay(int n, float f, View view) {
        return this.compositeOverlay(n, f + this.getParentAbsoluteElevation(view));
    }

    public int compositeOverlayIfNeeded(int n, float f) {
        int n2 = n;
        if (this.elevationOverlayEnabled) {
            n2 = n;
            if (this.isThemeSurfaceColor(n)) {
                n2 = this.compositeOverlay(n, f);
            }
        }
        return n2;
    }

    public int compositeOverlayIfNeeded(int n, float f, View view) {
        return this.compositeOverlayIfNeeded(n, f + this.getParentAbsoluteElevation(view));
    }

    public int compositeOverlayWithThemeSurfaceColorIfNeeded(float f) {
        return this.compositeOverlayIfNeeded(this.colorSurface, f);
    }

    public int compositeOverlayWithThemeSurfaceColorIfNeeded(float f, View view) {
        return this.compositeOverlayWithThemeSurfaceColorIfNeeded(f + this.getParentAbsoluteElevation(view));
    }

    public float getParentAbsoluteElevation(View view) {
        return ViewUtils.getParentAbsoluteElevation(view);
    }

    public int getThemeElevationOverlayColor() {
        return this.elevationOverlayColor;
    }

    public int getThemeSurfaceColor() {
        return this.colorSurface;
    }

    public boolean isThemeElevationOverlayEnabled() {
        return this.elevationOverlayEnabled;
    }
}

