/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.floatingactionbutton;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.floatingactionbutton.AnimatorTracker;
import com.google.android.material.floatingactionbutton.BaseMotionStrategy;
import com.google.android.material.floatingactionbutton.MotionStrategy;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.util.List;

public class ExtendedFloatingActionButton
extends MaterialButton
implements CoordinatorLayout.AttachedBehavior {
    private static final int ANIM_STATE_HIDING = 1;
    private static final int ANIM_STATE_NONE = 0;
    private static final int ANIM_STATE_SHOWING = 2;
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_ExtendedFloatingActionButton_Icon;
    static final Property<View, Float> HEIGHT;
    static final Property<View, Float> PADDING_END;
    static final Property<View, Float> PADDING_START;
    static final Property<View, Float> WIDTH;
    private int animState;
    private boolean animateShowBeforeLayout;
    private final CoordinatorLayout.Behavior<ExtendedFloatingActionButton> behavior;
    private final AnimatorTracker changeVisibilityTracker;
    private final int collapsedSize;
    private final MotionStrategy extendStrategy;
    private int extendedPaddingEnd;
    private int extendedPaddingStart;
    private final MotionStrategy hideStrategy;
    private boolean isExtended;
    private boolean isTransforming;
    protected ColorStateList originalTextCsl;
    private final MotionStrategy showStrategy;
    private final MotionStrategy shrinkStrategy;

    static {
        WIDTH = new Property<View, Float>(Float.class, "width"){

            public Float get(View view) {
                return Float.valueOf(view.getLayoutParams().width);
            }

            public void set(View view, Float f) {
                view.getLayoutParams().width = f.intValue();
                view.requestLayout();
            }
        };
        HEIGHT = new Property<View, Float>(Float.class, "height"){

            public Float get(View view) {
                return Float.valueOf(view.getLayoutParams().height);
            }

            public void set(View view, Float f) {
                view.getLayoutParams().height = f.intValue();
                view.requestLayout();
            }
        };
        PADDING_START = new Property<View, Float>(Float.class, "paddingStart"){

            public Float get(View view) {
                return Float.valueOf(ViewCompat.getPaddingStart((View)view));
            }

            public void set(View view, Float f) {
                ViewCompat.setPaddingRelative((View)view, (int)f.intValue(), (int)view.getPaddingTop(), (int)ViewCompat.getPaddingEnd((View)view), (int)view.getPaddingBottom());
            }
        };
        PADDING_END = new Property<View, Float>(Float.class, "paddingEnd"){

            public Float get(View view) {
                return Float.valueOf(ViewCompat.getPaddingEnd((View)view));
            }

            public void set(View view, Float f) {
                ViewCompat.setPaddingRelative((View)view, (int)ViewCompat.getPaddingStart((View)view), (int)view.getPaddingTop(), (int)f.intValue(), (int)view.getPaddingBottom());
            }
        };
    }

    public ExtendedFloatingActionButton(Context context) {
        this(context, null);
    }

    public ExtendedFloatingActionButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.extendedFloatingActionButtonStyle);
    }

    public ExtendedFloatingActionButton(Context object, AttributeSet attributeSet, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap((Context)object, attributeSet, n, n2), attributeSet, n);
        this.animState = 0;
        Object object2 = new AnimatorTracker();
        this.changeVisibilityTracker = object2;
        object = new ShowStrategy((AnimatorTracker)object2);
        this.showStrategy = object;
        HideStrategy hideStrategy = new HideStrategy((AnimatorTracker)object2);
        this.hideStrategy = hideStrategy;
        this.isExtended = true;
        this.isTransforming = false;
        this.animateShowBeforeLayout = false;
        Context context = this.getContext();
        this.behavior = new ExtendedFloatingActionButtonBehavior<ExtendedFloatingActionButton>(context, attributeSet);
        TypedArray typedArray = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.ExtendedFloatingActionButton, n, n2, new int[0]);
        MotionSpec motionSpec = MotionSpec.createFromAttribute(context, typedArray, R.styleable.ExtendedFloatingActionButton_showMotionSpec);
        object2 = MotionSpec.createFromAttribute(context, typedArray, R.styleable.ExtendedFloatingActionButton_hideMotionSpec);
        MotionSpec motionSpec2 = MotionSpec.createFromAttribute(context, typedArray, R.styleable.ExtendedFloatingActionButton_extendMotionSpec);
        MotionSpec motionSpec3 = MotionSpec.createFromAttribute(context, typedArray, R.styleable.ExtendedFloatingActionButton_shrinkMotionSpec);
        this.collapsedSize = typedArray.getDimensionPixelSize(R.styleable.ExtendedFloatingActionButton_collapsedSize, -1);
        this.extendedPaddingStart = ViewCompat.getPaddingStart((View)this);
        this.extendedPaddingEnd = ViewCompat.getPaddingEnd((View)this);
        Object object3 = new AnimatorTracker();
        ChangeSizeStrategy changeSizeStrategy = new ChangeSizeStrategy((AnimatorTracker)object3, new Size(){

            @Override
            public int getHeight() {
                return ExtendedFloatingActionButton.this.getMeasuredHeight();
            }

            @Override
            public ViewGroup.LayoutParams getLayoutParams() {
                return new ViewGroup.LayoutParams(-2, -2);
            }

            @Override
            public int getPaddingEnd() {
                return ExtendedFloatingActionButton.this.extendedPaddingEnd;
            }

            @Override
            public int getPaddingStart() {
                return ExtendedFloatingActionButton.this.extendedPaddingStart;
            }

            @Override
            public int getWidth() {
                return ExtendedFloatingActionButton.this.getMeasuredWidth() - ExtendedFloatingActionButton.this.getCollapsedPadding() * 2 + ExtendedFloatingActionButton.this.extendedPaddingStart + ExtendedFloatingActionButton.this.extendedPaddingEnd;
            }
        }, true);
        this.extendStrategy = changeSizeStrategy;
        this.shrinkStrategy = object3 = new ChangeSizeStrategy((AnimatorTracker)object3, new Size(){

            @Override
            public int getHeight() {
                return ExtendedFloatingActionButton.this.getCollapsedSize();
            }

            @Override
            public ViewGroup.LayoutParams getLayoutParams() {
                return new ViewGroup.LayoutParams(this.getWidth(), this.getHeight());
            }

            @Override
            public int getPaddingEnd() {
                return ExtendedFloatingActionButton.this.getCollapsedPadding();
            }

            @Override
            public int getPaddingStart() {
                return ExtendedFloatingActionButton.this.getCollapsedPadding();
            }

            @Override
            public int getWidth() {
                return ExtendedFloatingActionButton.this.getCollapsedSize();
            }
        }, false);
        object.setMotionSpec(motionSpec);
        hideStrategy.setMotionSpec((MotionSpec)object2);
        changeSizeStrategy.setMotionSpec(motionSpec2);
        object3.setMotionSpec(motionSpec3);
        typedArray.recycle();
        this.setShapeAppearanceModel(ShapeAppearanceModel.builder(context, attributeSet, n, n2, ShapeAppearanceModel.PILL).build());
        this.saveOriginalTextCsl();
    }

    static /* synthetic */ boolean access$702(ExtendedFloatingActionButton extendedFloatingActionButton, boolean bl) {
        extendedFloatingActionButton.isExtended = bl;
        return bl;
    }

    static /* synthetic */ boolean access$802(ExtendedFloatingActionButton extendedFloatingActionButton, boolean bl) {
        extendedFloatingActionButton.isTransforming = bl;
        return bl;
    }

    static /* synthetic */ int access$902(ExtendedFloatingActionButton extendedFloatingActionButton, int n) {
        extendedFloatingActionButton.animState = n;
        return n;
    }

    private boolean isOrWillBeHidden() {
        int n = this.getVisibility();
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            if (this.animState == 1) {
                bl2 = true;
            }
            return bl2;
        }
        bl2 = bl;
        if (this.animState != 2) {
            bl2 = true;
        }
        return bl2;
    }

    private boolean isOrWillBeShown() {
        int n = this.getVisibility();
        boolean bl = false;
        boolean bl2 = false;
        if (n != 0) {
            if (this.animState == 2) {
                bl2 = true;
            }
            return bl2;
        }
        bl2 = bl;
        if (this.animState != 1) {
            bl2 = true;
        }
        return bl2;
    }

    private void performMotion(MotionStrategy object, OnChangedCallback onChangedCallback) {
        if (object.shouldCancel()) {
            return;
        }
        if (!this.shouldAnimateVisibilityChange()) {
            object.performNow();
            object.onChange(onChangedCallback);
            return;
        }
        this.measure(0, 0);
        AnimatorSet animatorSet = object.createAnimator();
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((MotionStrategy)object, onChangedCallback){
            private boolean cancelled;
            final /* synthetic */ OnChangedCallback val$callback;
            final /* synthetic */ MotionStrategy val$strategy;
            {
                this.val$strategy = motionStrategy;
                this.val$callback = onChangedCallback;
            }

            public void onAnimationCancel(Animator animator2) {
                this.cancelled = true;
                this.val$strategy.onAnimationCancel();
            }

            public void onAnimationEnd(Animator animator2) {
                this.val$strategy.onAnimationEnd();
                if (!this.cancelled) {
                    this.val$strategy.onChange(this.val$callback);
                }
            }

            public void onAnimationStart(Animator animator2) {
                this.val$strategy.onAnimationStart(animator2);
                this.cancelled = false;
            }
        });
        object = object.getListeners().iterator();
        while (object.hasNext()) {
            animatorSet.addListener((Animator.AnimatorListener)object.next());
        }
        animatorSet.start();
    }

    private void saveOriginalTextCsl() {
        this.originalTextCsl = this.getTextColors();
    }

    private boolean shouldAnimateVisibilityChange() {
        boolean bl = (ViewCompat.isLaidOut((View)this) || !this.isOrWillBeShown() && this.animateShowBeforeLayout) && !this.isInEditMode();
        return bl;
    }

    public void addOnExtendAnimationListener(Animator.AnimatorListener animatorListener) {
        this.extendStrategy.addAnimationListener(animatorListener);
    }

    public void addOnHideAnimationListener(Animator.AnimatorListener animatorListener) {
        this.hideStrategy.addAnimationListener(animatorListener);
    }

    public void addOnShowAnimationListener(Animator.AnimatorListener animatorListener) {
        this.showStrategy.addAnimationListener(animatorListener);
    }

    public void addOnShrinkAnimationListener(Animator.AnimatorListener animatorListener) {
        this.shrinkStrategy.addAnimationListener(animatorListener);
    }

    public void extend() {
        this.performMotion(this.extendStrategy, null);
    }

    public void extend(OnChangedCallback onChangedCallback) {
        this.performMotion(this.extendStrategy, onChangedCallback);
    }

    public CoordinatorLayout.Behavior<ExtendedFloatingActionButton> getBehavior() {
        return this.behavior;
    }

    int getCollapsedPadding() {
        return (this.getCollapsedSize() - this.getIconSize()) / 2;
    }

    int getCollapsedSize() {
        int n;
        int n2 = n = this.collapsedSize;
        if (n < 0) {
            n2 = Math.min(ViewCompat.getPaddingStart((View)this), ViewCompat.getPaddingEnd((View)this)) * 2 + this.getIconSize();
        }
        return n2;
    }

    public MotionSpec getExtendMotionSpec() {
        return this.extendStrategy.getMotionSpec();
    }

    public MotionSpec getHideMotionSpec() {
        return this.hideStrategy.getMotionSpec();
    }

    public MotionSpec getShowMotionSpec() {
        return this.showStrategy.getMotionSpec();
    }

    public MotionSpec getShrinkMotionSpec() {
        return this.shrinkStrategy.getMotionSpec();
    }

    public void hide() {
        this.performMotion(this.hideStrategy, null);
    }

    public void hide(OnChangedCallback onChangedCallback) {
        this.performMotion(this.hideStrategy, onChangedCallback);
    }

    public final boolean isExtended() {
        return this.isExtended;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isExtended && TextUtils.isEmpty((CharSequence)this.getText()) && this.getIcon() != null) {
            this.isExtended = false;
            this.shrinkStrategy.performNow();
        }
    }

    public void removeOnExtendAnimationListener(Animator.AnimatorListener animatorListener) {
        this.extendStrategy.removeAnimationListener(animatorListener);
    }

    public void removeOnHideAnimationListener(Animator.AnimatorListener animatorListener) {
        this.hideStrategy.removeAnimationListener(animatorListener);
    }

    public void removeOnShowAnimationListener(Animator.AnimatorListener animatorListener) {
        this.showStrategy.removeAnimationListener(animatorListener);
    }

    public void removeOnShrinkAnimationListener(Animator.AnimatorListener animatorListener) {
        this.shrinkStrategy.removeAnimationListener(animatorListener);
    }

    public void setAnimateShowBeforeLayout(boolean bl) {
        this.animateShowBeforeLayout = bl;
    }

    public void setExtendMotionSpec(MotionSpec motionSpec) {
        this.extendStrategy.setMotionSpec(motionSpec);
    }

    public void setExtendMotionSpecResource(int n) {
        this.setExtendMotionSpec(MotionSpec.createFromResource(this.getContext(), n));
    }

    public void setExtended(boolean bl) {
        if (this.isExtended == bl) {
            return;
        }
        MotionStrategy motionStrategy = bl ? this.extendStrategy : this.shrinkStrategy;
        if (motionStrategy.shouldCancel()) {
            return;
        }
        motionStrategy.performNow();
    }

    public void setHideMotionSpec(MotionSpec motionSpec) {
        this.hideStrategy.setMotionSpec(motionSpec);
    }

    public void setHideMotionSpecResource(int n) {
        this.setHideMotionSpec(MotionSpec.createFromResource(this.getContext(), n));
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        super.setPadding(n, n2, n3, n4);
        if (this.isExtended && !this.isTransforming) {
            this.extendedPaddingStart = ViewCompat.getPaddingStart((View)this);
            this.extendedPaddingEnd = ViewCompat.getPaddingEnd((View)this);
        }
    }

    public void setPaddingRelative(int n, int n2, int n3, int n4) {
        super.setPaddingRelative(n, n2, n3, n4);
        if (this.isExtended && !this.isTransforming) {
            this.extendedPaddingStart = n;
            this.extendedPaddingEnd = n3;
        }
    }

    public void setShowMotionSpec(MotionSpec motionSpec) {
        this.showStrategy.setMotionSpec(motionSpec);
    }

    public void setShowMotionSpecResource(int n) {
        this.setShowMotionSpec(MotionSpec.createFromResource(this.getContext(), n));
    }

    public void setShrinkMotionSpec(MotionSpec motionSpec) {
        this.shrinkStrategy.setMotionSpec(motionSpec);
    }

    public void setShrinkMotionSpecResource(int n) {
        this.setShrinkMotionSpec(MotionSpec.createFromResource(this.getContext(), n));
    }

    public void setTextColor(int n) {
        super.setTextColor(n);
        this.saveOriginalTextCsl();
    }

    public void setTextColor(ColorStateList colorStateList) {
        super.setTextColor(colorStateList);
        this.saveOriginalTextCsl();
    }

    public void show() {
        this.performMotion(this.showStrategy, null);
    }

    public void show(OnChangedCallback onChangedCallback) {
        this.performMotion(this.showStrategy, onChangedCallback);
    }

    public void shrink() {
        this.performMotion(this.shrinkStrategy, null);
    }

    public void shrink(OnChangedCallback onChangedCallback) {
        this.performMotion(this.shrinkStrategy, onChangedCallback);
    }

    protected void silentlyUpdateTextColor(ColorStateList colorStateList) {
        super.setTextColor(colorStateList);
    }

    class ChangeSizeStrategy
    extends BaseMotionStrategy {
        private final boolean extending;
        private final Size size;

        ChangeSizeStrategy(AnimatorTracker animatorTracker, Size size, boolean bl) {
            super(ExtendedFloatingActionButton.this, animatorTracker);
            this.size = size;
            this.extending = bl;
        }

        @Override
        public AnimatorSet createAnimator() {
            PropertyValuesHolder[] propertyValuesHolderArray;
            MotionSpec motionSpec = this.getCurrentMotionSpec();
            if (motionSpec.hasPropertyValues("width")) {
                propertyValuesHolderArray = motionSpec.getPropertyValues("width");
                propertyValuesHolderArray[0].setFloatValues(new float[]{ExtendedFloatingActionButton.this.getWidth(), this.size.getWidth()});
                motionSpec.setPropertyValues("width", propertyValuesHolderArray);
            }
            if (motionSpec.hasPropertyValues("height")) {
                propertyValuesHolderArray = motionSpec.getPropertyValues("height");
                propertyValuesHolderArray[0].setFloatValues(new float[]{ExtendedFloatingActionButton.this.getHeight(), this.size.getHeight()});
                motionSpec.setPropertyValues("height", propertyValuesHolderArray);
            }
            if (motionSpec.hasPropertyValues("paddingStart")) {
                propertyValuesHolderArray = motionSpec.getPropertyValues("paddingStart");
                propertyValuesHolderArray[0].setFloatValues(new float[]{ViewCompat.getPaddingStart((View)ExtendedFloatingActionButton.this), this.size.getPaddingStart()});
                motionSpec.setPropertyValues("paddingStart", propertyValuesHolderArray);
            }
            if (motionSpec.hasPropertyValues("paddingEnd")) {
                propertyValuesHolderArray = motionSpec.getPropertyValues("paddingEnd");
                propertyValuesHolderArray[0].setFloatValues(new float[]{ViewCompat.getPaddingEnd((View)ExtendedFloatingActionButton.this), this.size.getPaddingEnd()});
                motionSpec.setPropertyValues("paddingEnd", propertyValuesHolderArray);
            }
            if (motionSpec.hasPropertyValues("labelOpacity")) {
                propertyValuesHolderArray = motionSpec.getPropertyValues("labelOpacity");
                boolean bl = this.extending;
                float f = 0.0f;
                float f2 = bl ? 0.0f : 1.0f;
                if (bl) {
                    f = 1.0f;
                }
                propertyValuesHolderArray[0].setFloatValues(new float[]{f2, f});
                motionSpec.setPropertyValues("labelOpacity", propertyValuesHolderArray);
            }
            return super.createAnimator(motionSpec);
        }

        @Override
        public int getDefaultMotionSpecResource() {
            int n = this.extending ? R.animator.mtrl_extended_fab_change_size_expand_motion_spec : R.animator.mtrl_extended_fab_change_size_collapse_motion_spec;
            return n;
        }

        @Override
        public void onAnimationEnd() {
            super.onAnimationEnd();
            ExtendedFloatingActionButton.access$802(ExtendedFloatingActionButton.this, false);
            ExtendedFloatingActionButton.this.setHorizontallyScrolling(false);
            ViewGroup.LayoutParams layoutParams = ExtendedFloatingActionButton.this.getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.width = this.size.getLayoutParams().width;
            layoutParams.height = this.size.getLayoutParams().height;
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            super.onAnimationStart(animator2);
            ExtendedFloatingActionButton.access$702(ExtendedFloatingActionButton.this, this.extending);
            ExtendedFloatingActionButton.access$802(ExtendedFloatingActionButton.this, true);
            ExtendedFloatingActionButton.this.setHorizontallyScrolling(true);
        }

        @Override
        public void onChange(OnChangedCallback onChangedCallback) {
            if (onChangedCallback == null) {
                return;
            }
            if (this.extending) {
                onChangedCallback.onExtended(ExtendedFloatingActionButton.this);
            } else {
                onChangedCallback.onShrunken(ExtendedFloatingActionButton.this);
            }
        }

        @Override
        public void performNow() {
            ExtendedFloatingActionButton.access$702(ExtendedFloatingActionButton.this, this.extending);
            ViewGroup.LayoutParams layoutParams = ExtendedFloatingActionButton.this.getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.width = this.size.getLayoutParams().width;
            layoutParams.height = this.size.getLayoutParams().height;
            ViewCompat.setPaddingRelative((View)ExtendedFloatingActionButton.this, (int)this.size.getPaddingStart(), (int)ExtendedFloatingActionButton.this.getPaddingTop(), (int)this.size.getPaddingEnd(), (int)ExtendedFloatingActionButton.this.getPaddingBottom());
            ExtendedFloatingActionButton.this.requestLayout();
        }

        @Override
        public boolean shouldCancel() {
            boolean bl = this.extending == ExtendedFloatingActionButton.this.isExtended || ExtendedFloatingActionButton.this.getIcon() == null || TextUtils.isEmpty((CharSequence)ExtendedFloatingActionButton.this.getText());
            return bl;
        }
    }

    protected static class ExtendedFloatingActionButtonBehavior<T extends ExtendedFloatingActionButton>
    extends CoordinatorLayout.Behavior<T> {
        private static final boolean AUTO_HIDE_DEFAULT = false;
        private static final boolean AUTO_SHRINK_DEFAULT = true;
        private boolean autoHideEnabled;
        private boolean autoShrinkEnabled;
        private OnChangedCallback internalAutoHideCallback;
        private OnChangedCallback internalAutoShrinkCallback;
        private Rect tmpRect;

        public ExtendedFloatingActionButtonBehavior() {
            this.autoHideEnabled = false;
            this.autoShrinkEnabled = true;
        }

        public ExtendedFloatingActionButtonBehavior(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            context = context.obtainStyledAttributes(attributeSet, R.styleable.ExtendedFloatingActionButton_Behavior_Layout);
            this.autoHideEnabled = context.getBoolean(R.styleable.ExtendedFloatingActionButton_Behavior_Layout_behavior_autoHide, false);
            this.autoShrinkEnabled = context.getBoolean(R.styleable.ExtendedFloatingActionButton_Behavior_Layout_behavior_autoShrink, true);
            context.recycle();
        }

        private static boolean isBottomSheet(View view) {
            if ((view = view.getLayoutParams()) instanceof CoordinatorLayout.LayoutParams) {
                return ((CoordinatorLayout.LayoutParams)view).getBehavior() instanceof BottomSheetBehavior;
            }
            return false;
        }

        private boolean shouldUpdateVisibility(View view, ExtendedFloatingActionButton extendedFloatingActionButton) {
            extendedFloatingActionButton = (CoordinatorLayout.LayoutParams)extendedFloatingActionButton.getLayoutParams();
            if (!this.autoHideEnabled && !this.autoShrinkEnabled) {
                return false;
            }
            return extendedFloatingActionButton.getAnchorId() == view.getId();
        }

        private boolean updateFabVisibilityForAppBarLayout(CoordinatorLayout coordinatorLayout, AppBarLayout appBarLayout, ExtendedFloatingActionButton extendedFloatingActionButton) {
            if (!this.shouldUpdateVisibility((View)appBarLayout, extendedFloatingActionButton)) {
                return false;
            }
            if (this.tmpRect == null) {
                this.tmpRect = new Rect();
            }
            Rect rect = this.tmpRect;
            DescendantOffsetUtils.getDescendantRect((ViewGroup)coordinatorLayout, (View)appBarLayout, rect);
            if (rect.bottom <= appBarLayout.getMinimumHeightForVisibleOverlappingContent()) {
                this.shrinkOrHide(extendedFloatingActionButton);
            } else {
                this.extendOrShow(extendedFloatingActionButton);
            }
            return true;
        }

        private boolean updateFabVisibilityForBottomSheet(View view, ExtendedFloatingActionButton extendedFloatingActionButton) {
            if (!this.shouldUpdateVisibility(view, extendedFloatingActionButton)) {
                return false;
            }
            CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)extendedFloatingActionButton.getLayoutParams();
            if (view.getTop() < extendedFloatingActionButton.getHeight() / 2 + layoutParams.topMargin) {
                this.shrinkOrHide(extendedFloatingActionButton);
            } else {
                this.extendOrShow(extendedFloatingActionButton);
            }
            return true;
        }

        protected void extendOrShow(ExtendedFloatingActionButton extendedFloatingActionButton) {
            boolean bl = this.autoShrinkEnabled;
            OnChangedCallback onChangedCallback = bl ? this.internalAutoShrinkCallback : this.internalAutoHideCallback;
            MotionStrategy motionStrategy = bl ? extendedFloatingActionButton.extendStrategy : extendedFloatingActionButton.showStrategy;
            extendedFloatingActionButton.performMotion(motionStrategy, onChangedCallback);
        }

        public boolean getInsetDodgeRect(CoordinatorLayout coordinatorLayout, ExtendedFloatingActionButton extendedFloatingActionButton, Rect rect) {
            return super.getInsetDodgeRect(coordinatorLayout, (View)extendedFloatingActionButton, rect);
        }

        public boolean isAutoHideEnabled() {
            return this.autoHideEnabled;
        }

        public boolean isAutoShrinkEnabled() {
            return this.autoShrinkEnabled;
        }

        public void onAttachedToLayoutParams(CoordinatorLayout.LayoutParams layoutParams) {
            if (layoutParams.dodgeInsetEdges == 0) {
                layoutParams.dodgeInsetEdges = 80;
            }
        }

        public boolean onDependentViewChanged(CoordinatorLayout coordinatorLayout, ExtendedFloatingActionButton extendedFloatingActionButton, View view) {
            if (view instanceof AppBarLayout) {
                this.updateFabVisibilityForAppBarLayout(coordinatorLayout, (AppBarLayout)view, extendedFloatingActionButton);
            } else if (ExtendedFloatingActionButtonBehavior.isBottomSheet(view)) {
                this.updateFabVisibilityForBottomSheet(view, extendedFloatingActionButton);
            }
            return false;
        }

        public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, ExtendedFloatingActionButton extendedFloatingActionButton, int n) {
            View view;
            List list = coordinatorLayout.getDependencies((View)extendedFloatingActionButton);
            int n2 = list.size();
            for (int i = 0; i < n2 && !((view = (View)list.get(i)) instanceof AppBarLayout ? this.updateFabVisibilityForAppBarLayout(coordinatorLayout, (AppBarLayout)view, extendedFloatingActionButton) : ExtendedFloatingActionButtonBehavior.isBottomSheet(view) && this.updateFabVisibilityForBottomSheet(view, extendedFloatingActionButton)); ++i) {
            }
            coordinatorLayout.onLayoutChild((View)extendedFloatingActionButton, n);
            return true;
        }

        public void setAutoHideEnabled(boolean bl) {
            this.autoHideEnabled = bl;
        }

        public void setAutoShrinkEnabled(boolean bl) {
            this.autoShrinkEnabled = bl;
        }

        void setInternalAutoHideCallback(OnChangedCallback onChangedCallback) {
            this.internalAutoHideCallback = onChangedCallback;
        }

        void setInternalAutoShrinkCallback(OnChangedCallback onChangedCallback) {
            this.internalAutoShrinkCallback = onChangedCallback;
        }

        protected void shrinkOrHide(ExtendedFloatingActionButton extendedFloatingActionButton) {
            boolean bl = this.autoShrinkEnabled;
            OnChangedCallback onChangedCallback = bl ? this.internalAutoShrinkCallback : this.internalAutoHideCallback;
            MotionStrategy motionStrategy = bl ? extendedFloatingActionButton.shrinkStrategy : extendedFloatingActionButton.hideStrategy;
            extendedFloatingActionButton.performMotion(motionStrategy, onChangedCallback);
        }
    }

    class HideStrategy
    extends BaseMotionStrategy {
        private boolean isCancelled;

        public HideStrategy(AnimatorTracker animatorTracker) {
            super(ExtendedFloatingActionButton.this, animatorTracker);
        }

        @Override
        public int getDefaultMotionSpecResource() {
            return R.animator.mtrl_extended_fab_hide_motion_spec;
        }

        @Override
        public void onAnimationCancel() {
            super.onAnimationCancel();
            this.isCancelled = true;
        }

        @Override
        public void onAnimationEnd() {
            super.onAnimationEnd();
            ExtendedFloatingActionButton.access$902(ExtendedFloatingActionButton.this, 0);
            if (!this.isCancelled) {
                ExtendedFloatingActionButton.this.setVisibility(8);
            }
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            super.onAnimationStart(animator2);
            this.isCancelled = false;
            ExtendedFloatingActionButton.this.setVisibility(0);
            ExtendedFloatingActionButton.access$902(ExtendedFloatingActionButton.this, 1);
        }

        @Override
        public void onChange(OnChangedCallback onChangedCallback) {
            if (onChangedCallback != null) {
                onChangedCallback.onHidden(ExtendedFloatingActionButton.this);
            }
        }

        @Override
        public void performNow() {
            ExtendedFloatingActionButton.this.setVisibility(8);
        }

        @Override
        public boolean shouldCancel() {
            return ExtendedFloatingActionButton.this.isOrWillBeHidden();
        }
    }

    public static abstract class OnChangedCallback {
        public void onExtended(ExtendedFloatingActionButton extendedFloatingActionButton) {
        }

        public void onHidden(ExtendedFloatingActionButton extendedFloatingActionButton) {
        }

        public void onShown(ExtendedFloatingActionButton extendedFloatingActionButton) {
        }

        public void onShrunken(ExtendedFloatingActionButton extendedFloatingActionButton) {
        }
    }

    class ShowStrategy
    extends BaseMotionStrategy {
        public ShowStrategy(AnimatorTracker animatorTracker) {
            super(ExtendedFloatingActionButton.this, animatorTracker);
        }

        @Override
        public int getDefaultMotionSpecResource() {
            return R.animator.mtrl_extended_fab_show_motion_spec;
        }

        @Override
        public void onAnimationEnd() {
            super.onAnimationEnd();
            ExtendedFloatingActionButton.access$902(ExtendedFloatingActionButton.this, 0);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            super.onAnimationStart(animator2);
            ExtendedFloatingActionButton.this.setVisibility(0);
            ExtendedFloatingActionButton.access$902(ExtendedFloatingActionButton.this, 2);
        }

        @Override
        public void onChange(OnChangedCallback onChangedCallback) {
            if (onChangedCallback != null) {
                onChangedCallback.onShown(ExtendedFloatingActionButton.this);
            }
        }

        @Override
        public void performNow() {
            ExtendedFloatingActionButton.this.setVisibility(0);
            ExtendedFloatingActionButton.this.setAlpha(1.0f);
            ExtendedFloatingActionButton.this.setScaleY(1.0f);
            ExtendedFloatingActionButton.this.setScaleX(1.0f);
        }

        @Override
        public boolean shouldCancel() {
            return ExtendedFloatingActionButton.this.isOrWillBeShown();
        }
    }

    static interface Size {
        public int getHeight();

        public ViewGroup.LayoutParams getLayoutParams();

        public int getPaddingEnd();

        public int getPaddingStart();

        public int getWidth();
    }
}

