/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;

public class FlowLayout
extends ViewGroup {
    private int itemSpacing;
    private int lineSpacing;
    private int rowCount;
    private boolean singleLine = false;

    public FlowLayout(Context context) {
        this(context, null);
    }

    public FlowLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public FlowLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.loadFromAttributes(context, attributeSet);
    }

    public FlowLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.loadFromAttributes(context, attributeSet);
    }

    private static int getMeasuredDimension(int n, int n2, int n3) {
        if (n2 != Integer.MIN_VALUE) {
            if (n2 != 0x40000000) {
                return n3;
            }
            return n;
        }
        return Math.min(n3, n);
    }

    private void loadFromAttributes(Context context, AttributeSet attributeSet) {
        context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.FlowLayout, 0, 0);
        this.lineSpacing = context.getDimensionPixelSize(R.styleable.FlowLayout_lineSpacing, 0);
        this.itemSpacing = context.getDimensionPixelSize(R.styleable.FlowLayout_itemSpacing, 0);
        context.recycle();
    }

    protected int getItemSpacing() {
        return this.itemSpacing;
    }

    protected int getLineSpacing() {
        return this.lineSpacing;
    }

    protected int getRowCount() {
        return this.rowCount;
    }

    public int getRowIndex(View object) {
        if (!((object = object.getTag(R.id.row_index_key)) instanceof Integer)) {
            return -1;
        }
        return (Integer)object;
    }

    public boolean isSingleLine() {
        return this.singleLine;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.getChildCount() == 0) {
            this.rowCount = 0;
            return;
        }
        this.rowCount = 1;
        boolean bl2 = ViewCompat.getLayoutDirection((View)this) == 1;
        n2 = bl2 ? this.getPaddingRight() : this.getPaddingLeft();
        n4 = bl2 ? this.getPaddingLeft() : this.getPaddingRight();
        int n5 = this.getPaddingTop();
        int n6 = n3 - n - n4;
        n3 = n2;
        n = n5;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int n7;
            int n8;
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) {
                view.setTag(R.id.row_index_key, (Object)-1);
                continue;
            }
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                layoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                n8 = MarginLayoutParamsCompat.getMarginStart((ViewGroup.MarginLayoutParams)layoutParams);
                n7 = MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)layoutParams);
            } else {
                n7 = 0;
                n8 = 0;
            }
            int n9 = view.getMeasuredWidth();
            int n10 = n3;
            n4 = n;
            if (!this.singleLine) {
                n10 = n3;
                n4 = n;
                if (n3 + n8 + n9 > n6) {
                    n4 = this.lineSpacing + n5;
                    ++this.rowCount;
                    n10 = n2;
                }
            }
            view.setTag(R.id.row_index_key, (Object)(this.rowCount - 1));
            n3 = n10 + n8;
            n = view.getMeasuredWidth() + n3;
            n5 = view.getMeasuredHeight() + n4;
            if (bl2) {
                view.layout(n6 - n, n4, n6 - n10 - n8, n5);
            } else {
                view.layout(n3, n4, n, n5);
            }
            n3 = n10 + (n8 + n7 + view.getMeasuredWidth() + this.itemSpacing);
            n = n4;
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getMode((int)n);
        int n5 = View.MeasureSpec.getSize((int)n2);
        int n6 = View.MeasureSpec.getMode((int)n2);
        int n7 = n4 != Integer.MIN_VALUE && n4 != 0x40000000 ? Integer.MAX_VALUE : n3;
        int n8 = this.getPaddingLeft();
        int n9 = this.getPaddingTop();
        int n10 = this.getPaddingRight();
        int n11 = n9;
        int n12 = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int n13;
            int n14;
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            this.measureChild(view, n, n2);
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
                layoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
                n14 = layoutParams.leftMargin + 0;
                n13 = layoutParams.rightMargin + 0;
            } else {
                n14 = 0;
                n13 = 0;
            }
            if (n8 + n14 + view.getMeasuredWidth() > n7 - n10 && !this.isSingleLine()) {
                n11 = this.getPaddingLeft();
                n8 = this.lineSpacing + n9;
                n9 = n11;
                n11 = n8;
            } else {
                n9 = n8;
            }
            int n15 = n9 + n14 + view.getMeasuredWidth();
            int n16 = view.getMeasuredHeight();
            n8 = n12;
            if (n15 > n12) {
                n8 = n15;
            }
            n14 = n9 + (n14 + n13 + view.getMeasuredWidth() + this.itemSpacing);
            n12 = n8;
            if (i == this.getChildCount() - 1) {
                n12 = n8 + n13;
            }
            n9 = n11 + n16;
            n8 = n14;
        }
        n = this.getPaddingRight();
        n2 = this.getPaddingBottom();
        this.setMeasuredDimension(FlowLayout.getMeasuredDimension(n3, n4, n12 + n), FlowLayout.getMeasuredDimension(n5, n6, n9 + n2));
    }

    protected void setItemSpacing(int n) {
        this.itemSpacing = n;
    }

    protected void setLineSpacing(int n) {
        this.lineSpacing = n;
    }

    public void setSingleLine(boolean bl) {
        this.singleLine = bl;
    }
}

