/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.appcompat.view.menu.ActionMenuItemView;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.Toolbar;

public class ToolbarUtils {
    private ToolbarUtils() {
    }

    public static ActionMenuItemView getActionMenuItemView(Toolbar toolbar, int n) {
        if ((toolbar = ToolbarUtils.getActionMenuView(toolbar)) != null) {
            for (int i = 0; i < toolbar.getChildCount(); ++i) {
                View view = toolbar.getChildAt(i);
                if (!(view instanceof ActionMenuItemView) || (view = (ActionMenuItemView)view).getItemData().getItemId() != n) continue;
                return view;
            }
        }
        return null;
    }

    public static ActionMenuView getActionMenuView(Toolbar toolbar) {
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            View view = toolbar.getChildAt(i);
            if (!(view instanceof ActionMenuView)) continue;
            return (ActionMenuView)view;
        }
        return null;
    }

    public static ImageButton getNavigationIconButton(Toolbar toolbar) {
        Drawable drawable2 = toolbar.getNavigationIcon();
        if (drawable2 == null) {
            return null;
        }
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            View view = toolbar.getChildAt(i);
            if (!(view instanceof ImageButton) || (view = (ImageButton)view).getDrawable() != drawable2) continue;
            return view;
        }
        return null;
    }

    public static View getSecondaryActionMenuItemView(Toolbar toolbar) {
        if ((toolbar = ToolbarUtils.getActionMenuView(toolbar)) != null && toolbar.getChildCount() > 1) {
            return toolbar.getChildAt(0);
        }
        return null;
    }

    public static TextView getSubtitleTextView(Toolbar toolbar) {
        return ToolbarUtils.getTextView(toolbar, toolbar.getSubtitle());
    }

    private static TextView getTextView(Toolbar toolbar, CharSequence charSequence) {
        for (int i = 0; i < toolbar.getChildCount(); ++i) {
            View view = toolbar.getChildAt(i);
            if (!(view instanceof TextView) || !TextUtils.equals((CharSequence)(view = (TextView)view).getText(), (CharSequence)charSequence)) continue;
            return view;
        }
        return null;
    }

    public static TextView getTitleTextView(Toolbar toolbar) {
        return ToolbarUtils.getTextView(toolbar, toolbar.getTitle());
    }
}

