/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.motion;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Path;
import android.util.TypedValue;
import androidx.core.graphics.PathParser;
import androidx.core.view.animation.PathInterpolatorCompat;
import com.google.android.material.resources.MaterialAttributes;

public class MotionUtils {
    private static final String EASING_TYPE_CUBIC_BEZIER = "cubic-bezier";
    private static final String EASING_TYPE_FORMAT_END = ")";
    private static final String EASING_TYPE_FORMAT_START = "(";
    private static final String EASING_TYPE_PATH = "path";

    private MotionUtils() {
    }

    private static float getControlPoint(String[] object, int n) {
        float f = Float.parseFloat(object[n]);
        if (!(f < 0.0f) && !(f > 1.0f)) {
            return f;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Motion easing control point value must be between 0 and 1; instead got: ");
        ((StringBuilder)object).append(f);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    private static String getEasingContent(String string2, String string3) {
        return string2.substring(string3.length() + 1, string2.length() - 1);
    }

    private static boolean isEasingType(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(EASING_TYPE_FORMAT_START);
        boolean bl = string2.startsWith(stringBuilder.toString()) && string2.endsWith(EASING_TYPE_FORMAT_END);
        return bl;
    }

    public static int resolveThemeDuration(Context context, int n, int n2) {
        return MaterialAttributes.resolveInteger(context, n, n2);
    }

    public static TimeInterpolator resolveThemeInterpolator(Context object, int n, TimeInterpolator object2) {
        TypedValue typedValue = new TypedValue();
        if (object.getTheme().resolveAttribute(n, typedValue, true)) {
            if (typedValue.type == 3) {
                object2 = String.valueOf(typedValue.string);
                if (MotionUtils.isEasingType((String)object2, EASING_TYPE_CUBIC_BEZIER)) {
                    object = MotionUtils.getEasingContent((String)object2, EASING_TYPE_CUBIC_BEZIER).split(",");
                    if (((String[])object).length == 4) {
                        return PathInterpolatorCompat.create((float)MotionUtils.getControlPoint((String[])object, 0), (float)MotionUtils.getControlPoint((String[])object, 1), (float)MotionUtils.getControlPoint((String[])object, 2), (float)MotionUtils.getControlPoint((String[])object, 3));
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Motion easing theme attribute must have 4 control points if using bezier curve format; instead got: ");
                    ((StringBuilder)object2).append(((Object)object).length);
                    throw new IllegalArgumentException(((StringBuilder)object2).toString());
                }
                if (MotionUtils.isEasingType((String)object2, EASING_TYPE_PATH)) {
                    return PathInterpolatorCompat.create((Path)PathParser.createPathFromPathData((String)MotionUtils.getEasingContent((String)object2, EASING_TYPE_PATH)));
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid motion easing type: ");
                ((StringBuilder)object).append((String)object2);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            throw new IllegalArgumentException("Motion easing theme attribute must be a string");
        }
        return object2;
    }
}

