/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.view.menu.MenuView;
import androidx.appcompat.widget.TooltipCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.PointerIconCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.motion.MotionUtils;

public abstract class NavigationBarItemView
extends FrameLayout
implements MenuView.ItemView {
    private static final ActiveIndicatorTransform ACTIVE_INDICATOR_LABELED_TRANSFORM;
    private static final ActiveIndicatorTransform ACTIVE_INDICATOR_UNLABELED_TRANSFORM;
    private static final int[] CHECKED_STATE_SET;
    private static final int INVALID_ITEM_POSITION = -1;
    private ValueAnimator activeIndicatorAnimator;
    private int activeIndicatorDesiredHeight = 0;
    private int activeIndicatorDesiredWidth = 0;
    private boolean activeIndicatorEnabled = false;
    private int activeIndicatorMarginHorizontal = 0;
    private float activeIndicatorProgress = 0.0f;
    private boolean activeIndicatorResizeable = false;
    private ActiveIndicatorTransform activeIndicatorTransform = ACTIVE_INDICATOR_LABELED_TRANSFORM;
    private final View activeIndicatorView;
    private BadgeDrawable badgeDrawable;
    private final ImageView icon;
    private final FrameLayout iconContainer;
    private ColorStateList iconTint;
    private boolean initialized = false;
    private boolean isShifting;
    private MenuItemImpl itemData;
    private int itemPaddingBottom;
    private int itemPaddingTop;
    private int itemPosition = -1;
    private final ViewGroup labelGroup;
    private int labelVisibilityMode;
    private final TextView largeLabel;
    private Drawable originalIconDrawable;
    private float scaleDownFactor;
    private float scaleUpFactor;
    private float shiftAmount;
    private final TextView smallLabel;
    private Drawable wrappedIconDrawable;

    static {
        CHECKED_STATE_SET = new int[]{0x10100A0};
        ACTIVE_INDICATOR_LABELED_TRANSFORM = new ActiveIndicatorTransform();
        ACTIVE_INDICATOR_UNLABELED_TRANSFORM = new ActiveIndicatorUnlabeledTransform();
    }

    public NavigationBarItemView(Context context) {
        super(context);
        TextView textView;
        ViewGroup viewGroup;
        ImageView imageView;
        LayoutInflater.from((Context)context).inflate(this.getItemLayoutResId(), (ViewGroup)this, true);
        this.iconContainer = (FrameLayout)this.findViewById(R.id.navigation_bar_item_icon_container);
        this.activeIndicatorView = this.findViewById(R.id.navigation_bar_item_active_indicator_view);
        this.icon = imageView = (ImageView)this.findViewById(R.id.navigation_bar_item_icon_view);
        this.labelGroup = viewGroup = (ViewGroup)this.findViewById(R.id.navigation_bar_item_labels_group);
        this.smallLabel = textView = (TextView)this.findViewById(R.id.navigation_bar_item_small_label_view);
        context = (TextView)this.findViewById(R.id.navigation_bar_item_large_label_view);
        this.largeLabel = context;
        this.setBackgroundResource(this.getItemBackgroundResId());
        this.itemPaddingTop = this.getResources().getDimensionPixelSize(this.getItemDefaultMarginResId());
        this.itemPaddingBottom = viewGroup.getPaddingBottom();
        ViewCompat.setImportantForAccessibility((View)textView, (int)2);
        ViewCompat.setImportantForAccessibility((View)context, (int)2);
        this.setFocusable(true);
        this.calculateTextScaleFactors(textView.getTextSize(), context.getTextSize());
        if (imageView != null) {
            imageView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                    if (NavigationBarItemView.this.icon.getVisibility() == 0) {
                        object = NavigationBarItemView.this;
                        ((NavigationBarItemView)((Object)object)).tryUpdateBadgeBounds((View)((NavigationBarItemView)((Object)object)).icon);
                    }
                }
            });
        }
    }

    private void calculateTextScaleFactors(float f, float f2) {
        this.shiftAmount = f - f2;
        this.scaleUpFactor = f2 * 1.0f / f;
        this.scaleDownFactor = f * 1.0f / f2;
    }

    private FrameLayout getCustomParentForBadge(View view) {
        FrameLayout frameLayout;
        ImageView imageView = this.icon;
        FrameLayout frameLayout2 = frameLayout = null;
        if (view == imageView) {
            frameLayout2 = frameLayout;
            if (BadgeUtils.USE_COMPAT_PARENT) {
                frameLayout2 = (FrameLayout)this.icon.getParent();
            }
        }
        return frameLayout2;
    }

    private View getIconOrContainer() {
        FrameLayout frameLayout = this.iconContainer;
        if (frameLayout == null) {
            frameLayout = this.icon;
        }
        return frameLayout;
    }

    private int getItemVisiblePosition() {
        ViewGroup viewGroup = (ViewGroup)this.getParent();
        int n = viewGroup.indexOfChild((View)this);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            View view = viewGroup.getChildAt(i);
            int n3 = n2;
            if (view instanceof NavigationBarItemView) {
                n3 = n2;
                if (view.getVisibility() == 0) {
                    n3 = n2 + 1;
                }
            }
            n2 = n3;
        }
        return n2;
    }

    private int getSuggestedIconHeight() {
        BadgeDrawable badgeDrawable = this.badgeDrawable;
        int n = badgeDrawable != null ? badgeDrawable.getMinimumHeight() / 2 : 0;
        return Math.max(n, ((FrameLayout.LayoutParams)this.getIconOrContainer().getLayoutParams()).topMargin) + this.icon.getMeasuredWidth() + n;
    }

    private int getSuggestedIconWidth() {
        BadgeDrawable badgeDrawable = this.badgeDrawable;
        int n = badgeDrawable == null ? 0 : badgeDrawable.getMinimumWidth() - this.badgeDrawable.getHorizontalOffset();
        badgeDrawable = (FrameLayout.LayoutParams)this.getIconOrContainer().getLayoutParams();
        return Math.max(n, ((FrameLayout.LayoutParams)badgeDrawable).leftMargin) + this.icon.getMeasuredWidth() + Math.max(n, ((FrameLayout.LayoutParams)badgeDrawable).rightMargin);
    }

    private boolean hasBadge() {
        boolean bl = this.badgeDrawable != null;
        return bl;
    }

    private boolean isActiveIndicatorResizeableAndUnlabeled() {
        boolean bl = this.activeIndicatorResizeable && this.labelVisibilityMode == 2;
        return bl;
    }

    private void maybeAnimateActiveIndicatorToProgress(final float f) {
        if (this.activeIndicatorEnabled && this.initialized && ViewCompat.isAttachedToWindow((View)this)) {
            ValueAnimator valueAnimator = this.activeIndicatorAnimator;
            if (valueAnimator != null) {
                valueAnimator.cancel();
                this.activeIndicatorAnimator = null;
            }
            this.activeIndicatorAnimator = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.activeIndicatorProgress, f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float f2 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    NavigationBarItemView.this.setActiveIndicatorProgress(f2, f);
                }
            });
            this.activeIndicatorAnimator.setInterpolator(MotionUtils.resolveThemeInterpolator(this.getContext(), R.attr.motionEasingStandard, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR));
            this.activeIndicatorAnimator.setDuration((long)MotionUtils.resolveThemeDuration(this.getContext(), R.attr.motionDurationLong1, this.getResources().getInteger(R.integer.material_motion_duration_long_1)));
            this.activeIndicatorAnimator.start();
            return;
        }
        this.setActiveIndicatorProgress(f, f);
    }

    private void refreshChecked() {
        MenuItemImpl menuItemImpl = this.itemData;
        if (menuItemImpl != null) {
            this.setChecked(menuItemImpl.isChecked());
        }
    }

    private void setActiveIndicatorProgress(float f, float f2) {
        View view = this.activeIndicatorView;
        if (view != null) {
            this.activeIndicatorTransform.updateForProgress(f, f2, view);
        }
        this.activeIndicatorProgress = f;
    }

    private static void setViewScaleValues(View view, float f, float f2, int n) {
        view.setScaleX(f);
        view.setScaleY(f2);
        view.setVisibility(n);
    }

    private static void setViewTopMarginAndGravity(View view, int n, int n2) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.topMargin = n;
        layoutParams.bottomMargin = n;
        layoutParams.gravity = n2;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void tryAttachBadgeToAnchor(View view) {
        if (!this.hasBadge()) {
            return;
        }
        if (view != null) {
            this.setClipChildren(false);
            this.setClipToPadding(false);
            BadgeUtils.attachBadgeDrawable(this.badgeDrawable, view, this.getCustomParentForBadge(view));
        }
    }

    private void tryRemoveBadgeFromAnchor(View view) {
        if (!this.hasBadge()) {
            return;
        }
        if (view != null) {
            this.setClipChildren(true);
            this.setClipToPadding(true);
            BadgeUtils.detachBadgeDrawable(this.badgeDrawable, view);
        }
        this.badgeDrawable = null;
    }

    private void tryUpdateBadgeBounds(View view) {
        if (!this.hasBadge()) {
            return;
        }
        BadgeUtils.setBadgeDrawableBounds(this.badgeDrawable, view, this.getCustomParentForBadge(view));
    }

    private void updateActiveIndicatorLayoutParams(int n) {
        if (this.activeIndicatorView == null) {
            return;
        }
        int n2 = Math.min(this.activeIndicatorDesiredWidth, n - this.activeIndicatorMarginHorizontal * 2);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.activeIndicatorView.getLayoutParams();
        n = this.isActiveIndicatorResizeableAndUnlabeled() ? n2 : this.activeIndicatorDesiredHeight;
        layoutParams.height = n;
        layoutParams.width = n2;
        this.activeIndicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void updateActiveIndicatorTransform() {
        this.activeIndicatorTransform = this.isActiveIndicatorResizeableAndUnlabeled() ? ACTIVE_INDICATOR_UNLABELED_TRANSFORM : ACTIVE_INDICATOR_LABELED_TRANSFORM;
    }

    private static void updateViewPaddingBottom(View view, int n) {
        view.setPadding(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), n);
    }

    void clear() {
        this.removeBadge();
        this.itemData = null;
        this.activeIndicatorProgress = 0.0f;
        this.initialized = false;
    }

    public Drawable getActiveIndicatorDrawable() {
        View view = this.activeIndicatorView;
        if (view == null) {
            return null;
        }
        return view.getBackground();
    }

    public BadgeDrawable getBadge() {
        return this.badgeDrawable;
    }

    protected int getItemBackgroundResId() {
        return R.drawable.mtrl_navigation_bar_item_background;
    }

    public MenuItemImpl getItemData() {
        return this.itemData;
    }

    protected int getItemDefaultMarginResId() {
        return R.dimen.mtrl_navigation_bar_item_default_margin;
    }

    protected abstract int getItemLayoutResId();

    public int getItemPosition() {
        return this.itemPosition;
    }

    protected int getSuggestedMinimumHeight() {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.labelGroup.getLayoutParams();
        return this.getSuggestedIconHeight() + layoutParams.topMargin + this.labelGroup.getMeasuredHeight() + layoutParams.bottomMargin;
    }

    protected int getSuggestedMinimumWidth() {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.labelGroup.getLayoutParams();
        int n = layoutParams.leftMargin;
        int n2 = this.labelGroup.getMeasuredWidth();
        int n3 = layoutParams.rightMargin;
        return Math.max(this.getSuggestedIconWidth(), n + n2 + n3);
    }

    public void initialize(MenuItemImpl menuItemImpl, int n) {
        this.itemData = menuItemImpl;
        this.setCheckable(menuItemImpl.isCheckable());
        this.setChecked(menuItemImpl.isChecked());
        this.setEnabled(menuItemImpl.isEnabled());
        this.setIcon(menuItemImpl.getIcon());
        this.setTitle(menuItemImpl.getTitle());
        this.setId(menuItemImpl.getItemId());
        if (!TextUtils.isEmpty((CharSequence)menuItemImpl.getContentDescription())) {
            this.setContentDescription(menuItemImpl.getContentDescription());
        }
        CharSequence charSequence = !TextUtils.isEmpty((CharSequence)menuItemImpl.getTooltipText()) ? menuItemImpl.getTooltipText() : menuItemImpl.getTitle();
        if (Build.VERSION.SDK_INT < 21 || Build.VERSION.SDK_INT > 23) {
            TooltipCompat.setTooltipText((View)this, (CharSequence)charSequence);
        }
        n = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n);
        this.initialized = true;
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        MenuItemImpl menuItemImpl = this.itemData;
        if (menuItemImpl != null && menuItemImpl.isCheckable() && this.itemData.isChecked()) {
            NavigationBarItemView.mergeDrawableStates((int[])nArray, (int[])CHECKED_STATE_SET);
        }
        return nArray;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        Object object = this.badgeDrawable;
        if (object != null && object.isVisible()) {
            object = this.itemData.getTitle();
            if (!TextUtils.isEmpty((CharSequence)this.itemData.getContentDescription())) {
                object = this.itemData.getContentDescription();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object);
            stringBuilder.append(", ");
            stringBuilder.append((Object)this.badgeDrawable.getContentDescription());
            accessibilityNodeInfo.setContentDescription((CharSequence)stringBuilder.toString());
        }
        accessibilityNodeInfo = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)accessibilityNodeInfo);
        accessibilityNodeInfo.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)this.getItemVisiblePosition(), (int)1, (boolean)false, (boolean)this.isSelected()));
        if (this.isSelected()) {
            accessibilityNodeInfo.setClickable(false);
            accessibilityNodeInfo.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
        }
        accessibilityNodeInfo.setRoleDescription((CharSequence)this.getResources().getString(R.string.item_view_role_description));
    }

    protected void onSizeChanged(final int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.post(new Runnable(){

            @Override
            public void run() {
                NavigationBarItemView.this.updateActiveIndicatorLayoutParams(n);
            }
        });
    }

    public boolean prefersCondensedTitle() {
        return false;
    }

    void removeBadge() {
        this.tryRemoveBadgeFromAnchor((View)this.icon);
    }

    public void setActiveIndicatorDrawable(Drawable drawable2) {
        View view = this.activeIndicatorView;
        if (view == null) {
            return;
        }
        view.setBackgroundDrawable(drawable2);
    }

    public void setActiveIndicatorEnabled(boolean bl) {
        this.activeIndicatorEnabled = bl;
        View view = this.activeIndicatorView;
        if (view != null) {
            int n = bl ? 0 : 8;
            view.setVisibility(n);
            this.requestLayout();
        }
    }

    public void setActiveIndicatorHeight(int n) {
        this.activeIndicatorDesiredHeight = n;
        this.updateActiveIndicatorLayoutParams(this.getWidth());
    }

    public void setActiveIndicatorMarginHorizontal(int n) {
        this.activeIndicatorMarginHorizontal = n;
        this.updateActiveIndicatorLayoutParams(this.getWidth());
    }

    public void setActiveIndicatorResizeable(boolean bl) {
        this.activeIndicatorResizeable = bl;
    }

    public void setActiveIndicatorWidth(int n) {
        this.activeIndicatorDesiredWidth = n;
        this.updateActiveIndicatorLayoutParams(this.getWidth());
    }

    void setBadge(BadgeDrawable badgeDrawable) {
        this.badgeDrawable = badgeDrawable;
        badgeDrawable = this.icon;
        if (badgeDrawable != null) {
            this.tryAttachBadgeToAnchor((View)badgeDrawable);
        }
    }

    public void setCheckable(boolean bl) {
        this.refreshDrawableState();
    }

    public void setChecked(boolean bl) {
        TextView textView = this.largeLabel;
        textView.setPivotX((float)(textView.getWidth() / 2));
        textView = this.largeLabel;
        textView.setPivotY((float)textView.getBaseline());
        textView = this.smallLabel;
        textView.setPivotX((float)(textView.getWidth() / 2));
        textView = this.smallLabel;
        textView.setPivotY((float)textView.getBaseline());
        float f = bl ? 1.0f : 0.0f;
        this.maybeAnimateActiveIndicatorToProgress(f);
        int n = this.labelVisibilityMode;
        if (n != -1) {
            if (n != 0) {
                if (n != 1) {
                    if (n == 2) {
                        NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 17);
                        this.largeLabel.setVisibility(8);
                        this.smallLabel.setVisibility(8);
                    }
                } else {
                    NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, this.itemPaddingBottom);
                    if (bl) {
                        NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), (int)((float)this.itemPaddingTop + this.shiftAmount), 49);
                        NavigationBarItemView.setViewScaleValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                        textView = this.smallLabel;
                        f = this.scaleUpFactor;
                        NavigationBarItemView.setViewScaleValues((View)textView, f, f, 4);
                    } else {
                        NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 49);
                        textView = this.largeLabel;
                        f = this.scaleDownFactor;
                        NavigationBarItemView.setViewScaleValues((View)textView, f, f, 4);
                        NavigationBarItemView.setViewScaleValues((View)this.smallLabel, 1.0f, 1.0f, 0);
                    }
                }
            } else {
                if (bl) {
                    NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 49);
                    NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, this.itemPaddingBottom);
                    this.largeLabel.setVisibility(0);
                } else {
                    NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 17);
                    NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, 0);
                    this.largeLabel.setVisibility(4);
                }
                this.smallLabel.setVisibility(4);
            }
        } else if (this.isShifting) {
            if (bl) {
                NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 49);
                NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, this.itemPaddingBottom);
                this.largeLabel.setVisibility(0);
            } else {
                NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 17);
                NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, 0);
                this.largeLabel.setVisibility(4);
            }
            this.smallLabel.setVisibility(4);
        } else {
            NavigationBarItemView.updateViewPaddingBottom((View)this.labelGroup, this.itemPaddingBottom);
            if (bl) {
                NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), (int)((float)this.itemPaddingTop + this.shiftAmount), 49);
                NavigationBarItemView.setViewScaleValues((View)this.largeLabel, 1.0f, 1.0f, 0);
                textView = this.smallLabel;
                f = this.scaleUpFactor;
                NavigationBarItemView.setViewScaleValues((View)textView, f, f, 4);
            } else {
                NavigationBarItemView.setViewTopMarginAndGravity(this.getIconOrContainer(), this.itemPaddingTop, 49);
                textView = this.largeLabel;
                f = this.scaleDownFactor;
                NavigationBarItemView.setViewScaleValues((View)textView, f, f, 4);
                NavigationBarItemView.setViewScaleValues((View)this.smallLabel, 1.0f, 1.0f, 0);
            }
        }
        this.refreshDrawableState();
        this.setSelected(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.smallLabel.setEnabled(bl);
        this.largeLabel.setEnabled(bl);
        this.icon.setEnabled(bl);
        if (bl) {
            ViewCompat.setPointerIcon((View)this, (PointerIconCompat)PointerIconCompat.getSystemIcon((Context)this.getContext(), (int)1002));
        } else {
            ViewCompat.setPointerIcon((View)this, null);
        }
    }

    public void setIcon(Drawable drawable2) {
        if (drawable2 == this.originalIconDrawable) {
            return;
        }
        this.originalIconDrawable = drawable2;
        Drawable drawable3 = drawable2;
        if (drawable2 != null) {
            drawable3 = drawable2.getConstantState();
            if (drawable3 != null) {
                drawable2 = drawable3.newDrawable();
            }
            this.wrappedIconDrawable = drawable2 = DrawableCompat.wrap((Drawable)drawable2).mutate();
            ColorStateList colorStateList = this.iconTint;
            drawable3 = drawable2;
            if (colorStateList != null) {
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)colorStateList);
                drawable3 = drawable2;
            }
        }
        this.icon.setImageDrawable(drawable3);
    }

    public void setIconSize(int n) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.icon.getLayoutParams();
        layoutParams.width = n;
        layoutParams.height = n;
        this.icon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setIconTintList(ColorStateList colorStateList) {
        Drawable drawable2;
        this.iconTint = colorStateList;
        if (this.itemData != null && (drawable2 = this.wrappedIconDrawable) != null) {
            DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)colorStateList);
            this.wrappedIconDrawable.invalidateSelf();
        }
    }

    public void setItemBackground(int n) {
        Drawable drawable2 = n == 0 ? null : ContextCompat.getDrawable((Context)this.getContext(), (int)n);
        this.setItemBackground(drawable2);
    }

    public void setItemBackground(Drawable drawable2) {
        Drawable drawable3 = drawable2;
        if (drawable2 != null) {
            drawable3 = drawable2;
            if (drawable2.getConstantState() != null) {
                drawable3 = drawable2.getConstantState().newDrawable().mutate();
            }
        }
        ViewCompat.setBackground((View)this, (Drawable)drawable3);
    }

    public void setItemPaddingBottom(int n) {
        if (this.itemPaddingBottom != n) {
            this.itemPaddingBottom = n;
            this.refreshChecked();
        }
    }

    public void setItemPaddingTop(int n) {
        if (this.itemPaddingTop != n) {
            this.itemPaddingTop = n;
            this.refreshChecked();
        }
    }

    public void setItemPosition(int n) {
        this.itemPosition = n;
    }

    public void setLabelVisibilityMode(int n) {
        if (this.labelVisibilityMode != n) {
            this.labelVisibilityMode = n;
            this.updateActiveIndicatorTransform();
            this.updateActiveIndicatorLayoutParams(this.getWidth());
            this.refreshChecked();
        }
    }

    public void setShifting(boolean bl) {
        if (this.isShifting != bl) {
            this.isShifting = bl;
            this.refreshChecked();
        }
    }

    public void setShortcut(boolean bl, char c) {
    }

    public void setTextAppearanceActive(int n) {
        TextViewCompat.setTextAppearance((TextView)this.largeLabel, (int)n);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void setTextAppearanceInactive(int n) {
        TextViewCompat.setTextAppearance((TextView)this.smallLabel, (int)n);
        this.calculateTextScaleFactors(this.smallLabel.getTextSize(), this.largeLabel.getTextSize());
    }

    public void setTextColor(ColorStateList colorStateList) {
        if (colorStateList != null) {
            this.smallLabel.setTextColor(colorStateList);
            this.largeLabel.setTextColor(colorStateList);
        }
    }

    public void setTitle(CharSequence charSequence) {
        this.smallLabel.setText(charSequence);
        this.largeLabel.setText(charSequence);
        Object object = this.itemData;
        if (object == null || TextUtils.isEmpty((CharSequence)object.getContentDescription())) {
            this.setContentDescription(charSequence);
        }
        MenuItemImpl menuItemImpl = this.itemData;
        object = charSequence;
        if (menuItemImpl != null) {
            object = TextUtils.isEmpty((CharSequence)menuItemImpl.getTooltipText()) ? charSequence : this.itemData.getTooltipText();
        }
        if (Build.VERSION.SDK_INT < 21 || Build.VERSION.SDK_INT > 23) {
            TooltipCompat.setTooltipText((View)this, (CharSequence)object);
        }
    }

    public boolean showsIcon() {
        return true;
    }

    private static class ActiveIndicatorTransform {
        private static final float ALPHA_FRACTION = 0.2f;
        private static final float SCALE_X_HIDDEN = 0.4f;
        private static final float SCALE_X_SHOWN = 1.0f;

        private ActiveIndicatorTransform() {
        }

        protected float calculateAlpha(float f, float f2) {
            float f3 = f2 - 0.0f;
            float f4 = f3 == 0.0f ? 0 : (f3 > 0.0f ? 1 : -1);
            f2 = f4 == false ? 0.8f : 0.0f;
            float f5 = f4 == false ? 1.0f : 0.2f;
            return AnimationUtils.lerp(0.0f, 1.0f, f2, f5, f);
        }

        protected float calculateScaleX(float f, float f2) {
            return AnimationUtils.lerp(0.4f, 1.0f, f);
        }

        protected float calculateScaleY(float f, float f2) {
            return 1.0f;
        }

        public void updateForProgress(float f, float f2, View view) {
            view.setScaleX(this.calculateScaleX(f, f2));
            view.setScaleY(this.calculateScaleY(f, f2));
            view.setAlpha(this.calculateAlpha(f, f2));
        }
    }

    private static class ActiveIndicatorUnlabeledTransform
    extends ActiveIndicatorTransform {
        private ActiveIndicatorUnlabeledTransform() {
        }

        @Override
        protected float calculateScaleY(float f, float f2) {
            return this.calculateScaleX(f, f2);
        }
    }
}

