/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigation;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.view.SupportMenuInflater;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.appcompat.view.menu.MenuItemImpl;
import androidx.appcompat.widget.TintTypedArray;
import androidx.core.content.ContextCompat;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.customview.view.AbsSavedState;
import androidx.drawerlayout.widget.DrawerLayout;
import com.google.android.material.R;
import com.google.android.material.internal.ContextUtils;
import com.google.android.material.internal.NavigationMenu;
import com.google.android.material.internal.NavigationMenuPresenter;
import com.google.android.material.internal.ScrimInsetsFrameLayout;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeAppearancePathProvider;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class NavigationView
extends ScrimInsetsFrameLayout {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int DEF_STYLE_RES;
    private static final int[] DISABLED_STATE_SET;
    private static final int PRESENTER_NAVIGATION_VIEW_ID = 1;
    private boolean bottomInsetScrimEnabled;
    private int drawerLayoutCornerSize;
    private int layoutGravity;
    OnNavigationItemSelectedListener listener;
    private final int maxWidth;
    private final NavigationMenu menu;
    private MenuInflater menuInflater;
    private ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
    private final NavigationMenuPresenter presenter;
    private final RectF shapeClipBounds;
    private Path shapeClipPath;
    private final int[] tmpLocation;
    private boolean topInsetScrimEnabled;

    static {
        DISABLED_STATE_SET = new int[]{-16842910};
        DEF_STYLE_RES = R.style.Widget_Design_NavigationView;
    }

    public NavigationView(Context context) {
        this(context, null);
    }

    public NavigationView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.navigationViewStyle);
    }

    public NavigationView(Context object, AttributeSet object2, int n) {
        NavigationMenu navigationMenu;
        NavigationMenuPresenter navigationMenuPresenter;
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(object, (AttributeSet)object2, n, n2), (AttributeSet)object2, n);
        this.presenter = navigationMenuPresenter = new NavigationMenuPresenter();
        this.tmpLocation = new int[2];
        this.topInsetScrimEnabled = true;
        this.bottomInsetScrimEnabled = true;
        this.layoutGravity = 0;
        this.drawerLayoutCornerSize = 0;
        this.shapeClipBounds = new RectF();
        Context context = this.getContext();
        this.menu = navigationMenu = new NavigationMenu(context);
        TintTypedArray tintTypedArray = ThemeEnforcement.obtainTintedStyledAttributes(context, (AttributeSet)object2, R.styleable.NavigationView, n, n2, new int[0]);
        if (tintTypedArray.hasValue(R.styleable.NavigationView_android_background)) {
            ViewCompat.setBackground((View)this, (Drawable)tintTypedArray.getDrawable(R.styleable.NavigationView_android_background));
        }
        this.drawerLayoutCornerSize = tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_drawerLayoutCornerSize, 0);
        this.layoutGravity = tintTypedArray.getInt(R.styleable.NavigationView_android_layout_gravity, 0);
        if (this.getBackground() == null || this.getBackground() instanceof ColorDrawable) {
            object2 = ShapeAppearanceModel.builder(context, (AttributeSet)object2, n, n2).build();
            object = this.getBackground();
            object2 = new MaterialShapeDrawable((ShapeAppearanceModel)object2);
            if (object instanceof ColorDrawable) {
                ((MaterialShapeDrawable)object2).setFillColor(ColorStateList.valueOf((int)((ColorDrawable)object).getColor()));
            }
            ((MaterialShapeDrawable)object2).initializeElevationOverlay(context);
            ViewCompat.setBackground((View)this, (Drawable)object2);
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationView_elevation)) {
            this.setElevation(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_elevation, 0));
        }
        this.setFitsSystemWindows(tintTypedArray.getBoolean(R.styleable.NavigationView_android_fitsSystemWindows, false));
        this.maxWidth = tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_android_maxWidth, 0);
        boolean bl = tintTypedArray.hasValue(R.styleable.NavigationView_subheaderColor);
        Context context2 = null;
        object = bl ? tintTypedArray.getColorStateList(R.styleable.NavigationView_subheaderColor) : null;
        n = tintTypedArray.hasValue(R.styleable.NavigationView_subheaderTextAppearance) ? tintTypedArray.getResourceId(R.styleable.NavigationView_subheaderTextAppearance, 0) : 0;
        object2 = object;
        if (n == 0) {
            object2 = object;
            if (object == null) {
                object2 = this.createDefaultColorStateList(16842808);
            }
        }
        ColorStateList colorStateList = tintTypedArray.hasValue(R.styleable.NavigationView_itemIconTint) ? tintTypedArray.getColorStateList(R.styleable.NavigationView_itemIconTint) : this.createDefaultColorStateList(16842808);
        n2 = tintTypedArray.hasValue(R.styleable.NavigationView_itemTextAppearance) ? tintTypedArray.getResourceId(R.styleable.NavigationView_itemTextAppearance, 0) : 0;
        if (tintTypedArray.hasValue(R.styleable.NavigationView_itemIconSize)) {
            this.setItemIconSize(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_itemIconSize, 0));
        }
        object = context2;
        if (tintTypedArray.hasValue(R.styleable.NavigationView_itemTextColor)) {
            object = tintTypedArray.getColorStateList(R.styleable.NavigationView_itemTextColor);
        }
        context2 = object;
        if (n2 == 0) {
            context2 = object;
            if (object == null) {
                context2 = this.createDefaultColorStateList(16842806);
            }
        }
        Drawable drawable2 = tintTypedArray.getDrawable(R.styleable.NavigationView_itemBackground);
        object = drawable2;
        if (drawable2 == null) {
            object = drawable2;
            if (this.hasShapeAppearance(tintTypedArray)) {
                object = this.createDefaultItemBackground(tintTypedArray);
            }
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationView_itemHorizontalPadding)) {
            this.setItemHorizontalPadding(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_itemHorizontalPadding, 0));
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationView_itemVerticalPadding)) {
            this.setItemVerticalPadding(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_itemVerticalPadding, 0));
        }
        this.setDividerInsetStart(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_dividerInsetStart, 0));
        this.setDividerInsetEnd(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_dividerInsetEnd, 0));
        this.setSubheaderInsetStart(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_subheaderInsetStart, 0));
        this.setSubheaderInsetEnd(tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_subheaderInsetEnd, 0));
        this.setTopInsetScrimEnabled(tintTypedArray.getBoolean(R.styleable.NavigationView_topInsetScrimEnabled, this.topInsetScrimEnabled));
        this.setBottomInsetScrimEnabled(tintTypedArray.getBoolean(R.styleable.NavigationView_bottomInsetScrimEnabled, this.bottomInsetScrimEnabled));
        int n3 = tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_itemIconPadding, 0);
        this.setItemMaxLines(tintTypedArray.getInt(R.styleable.NavigationView_itemMaxLines, 1));
        navigationMenu.setCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
                boolean bl = NavigationView.this.listener != null && NavigationView.this.listener.onNavigationItemSelected(menuItem);
                return bl;
            }

            public void onMenuModeChange(MenuBuilder menuBuilder) {
            }
        });
        navigationMenuPresenter.setId(1);
        navigationMenuPresenter.initForMenu(context, navigationMenu);
        if (n != 0) {
            navigationMenuPresenter.setSubheaderTextAppearance(n);
        }
        navigationMenuPresenter.setSubheaderColor((ColorStateList)object2);
        navigationMenuPresenter.setItemIconTintList(colorStateList);
        navigationMenuPresenter.setOverScrollMode(this.getOverScrollMode());
        if (n2 != 0) {
            navigationMenuPresenter.setItemTextAppearance(n2);
        }
        navigationMenuPresenter.setItemTextColor((ColorStateList)context2);
        navigationMenuPresenter.setItemBackground((Drawable)object);
        navigationMenuPresenter.setItemIconPadding(n3);
        navigationMenu.addMenuPresenter(navigationMenuPresenter);
        this.addView((View)navigationMenuPresenter.getMenuView((ViewGroup)this));
        if (tintTypedArray.hasValue(R.styleable.NavigationView_menu)) {
            this.inflateMenu(tintTypedArray.getResourceId(R.styleable.NavigationView_menu, 0));
        }
        if (tintTypedArray.hasValue(R.styleable.NavigationView_headerLayout)) {
            this.inflateHeaderView(tintTypedArray.getResourceId(R.styleable.NavigationView_headerLayout, 0));
        }
        tintTypedArray.recycle();
        this.setupInsetScrimsListener();
    }

    private ColorStateList createDefaultColorStateList(int n) {
        Object object = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(n, object, true)) {
            return null;
        }
        ColorStateList colorStateList = AppCompatResources.getColorStateList((Context)this.getContext(), (int)object.resourceId);
        if (!this.getContext().getTheme().resolveAttribute(R.attr.colorPrimary, object, true)) {
            return null;
        }
        n = object.data;
        int n2 = colorStateList.getDefaultColor();
        object = DISABLED_STATE_SET;
        int[] nArray = CHECKED_STATE_SET;
        int[] nArray2 = EMPTY_STATE_SET;
        int n3 = colorStateList.getColorForState((int[])object, n2);
        return new ColorStateList((int[][])new int[][]{(int[])object, nArray, nArray2}, new int[]{n3, n, n2});
    }

    private final Drawable createDefaultItemBackground(TintTypedArray tintTypedArray) {
        int n = tintTypedArray.getResourceId(R.styleable.NavigationView_itemShapeAppearance, 0);
        int n2 = tintTypedArray.getResourceId(R.styleable.NavigationView_itemShapeAppearanceOverlay, 0);
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable(ShapeAppearanceModel.builder(this.getContext(), n, n2).build());
        materialShapeDrawable.setFillColor(MaterialResources.getColorStateList(this.getContext(), tintTypedArray, R.styleable.NavigationView_itemShapeFillColor));
        return new InsetDrawable((Drawable)materialShapeDrawable, tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_itemShapeInsetStart, 0), tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_itemShapeInsetTop, 0), tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_itemShapeInsetEnd, 0), tintTypedArray.getDimensionPixelSize(R.styleable.NavigationView_itemShapeInsetBottom, 0));
    }

    private MenuInflater getMenuInflater() {
        if (this.menuInflater == null) {
            this.menuInflater = new SupportMenuInflater(this.getContext());
        }
        return this.menuInflater;
    }

    private boolean hasShapeAppearance(TintTypedArray tintTypedArray) {
        boolean bl = tintTypedArray.hasValue(R.styleable.NavigationView_itemShapeAppearance) || tintTypedArray.hasValue(R.styleable.NavigationView_itemShapeAppearanceOverlay);
        return bl;
    }

    private void maybeUpdateCornerSizeForDrawerLayout(int n, int n2) {
        if (this.getParent() instanceof DrawerLayout && this.drawerLayoutCornerSize > 0 && this.getBackground() instanceof MaterialShapeDrawable) {
            MaterialShapeDrawable materialShapeDrawable = (MaterialShapeDrawable)this.getBackground();
            ShapeAppearanceModel.Builder builder = materialShapeDrawable.getShapeAppearanceModel().toBuilder();
            if (GravityCompat.getAbsoluteGravity((int)this.layoutGravity, (int)ViewCompat.getLayoutDirection((View)this)) == 3) {
                builder.setTopRightCornerSize(this.drawerLayoutCornerSize);
                builder.setBottomRightCornerSize(this.drawerLayoutCornerSize);
            } else {
                builder.setTopLeftCornerSize(this.drawerLayoutCornerSize);
                builder.setBottomLeftCornerSize(this.drawerLayoutCornerSize);
            }
            materialShapeDrawable.setShapeAppearanceModel(builder.build());
            if (this.shapeClipPath == null) {
                this.shapeClipPath = new Path();
            }
            this.shapeClipPath.reset();
            this.shapeClipBounds.set(0.0f, 0.0f, (float)n, (float)n2);
            ShapeAppearancePathProvider.getInstance().calculatePath(materialShapeDrawable.getShapeAppearanceModel(), materialShapeDrawable.getInterpolation(), this.shapeClipBounds, this.shapeClipPath);
            this.invalidate();
        } else {
            this.shapeClipPath = null;
            this.shapeClipBounds.setEmpty();
        }
    }

    private void setupInsetScrimsListener() {
        this.onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Object object = NavigationView.this;
                object.getLocationOnScreen(((NavigationView)((Object)object)).tmpLocation);
                object = NavigationView.this.tmpLocation;
                boolean bl = true;
                boolean bl2 = object[1] == false;
                NavigationView.this.presenter.setBehindStatusBar(bl2);
                object = NavigationView.this;
                bl2 = bl2 && ((NavigationView)((Object)object)).isTopInsetScrimEnabled();
                ((ScrimInsetsFrameLayout)((Object)object)).setDrawTopInsetForeground(bl2);
                object = ContextUtils.getActivity(NavigationView.this.getContext());
                if (object != null && Build.VERSION.SDK_INT >= 21) {
                    boolean bl3 = object.findViewById(0x1020002).getHeight() == NavigationView.this.getHeight();
                    boolean bl4 = Color.alpha((int)object.getWindow().getNavigationBarColor()) != 0;
                    object = NavigationView.this;
                    bl2 = bl3 && bl4 && ((NavigationView)((Object)object)).isBottomInsetScrimEnabled() ? bl : false;
                    ((ScrimInsetsFrameLayout)((Object)object)).setDrawBottomInsetForeground(bl2);
                }
            }
        };
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
    }

    public void addHeaderView(View view) {
        this.presenter.addHeaderView(view);
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.shapeClipPath == null) {
            super.dispatchDraw(canvas);
            return;
        }
        int n = canvas.save();
        canvas.clipPath(this.shapeClipPath);
        super.dispatchDraw(canvas);
        canvas.restoreToCount(n);
    }

    public MenuItem getCheckedItem() {
        return this.presenter.getCheckedItem();
    }

    public int getDividerInsetEnd() {
        return this.presenter.getDividerInsetEnd();
    }

    public int getDividerInsetStart() {
        return this.presenter.getDividerInsetStart();
    }

    public int getHeaderCount() {
        return this.presenter.getHeaderCount();
    }

    public View getHeaderView(int n) {
        return this.presenter.getHeaderView(n);
    }

    public Drawable getItemBackground() {
        return this.presenter.getItemBackground();
    }

    public int getItemHorizontalPadding() {
        return this.presenter.getItemHorizontalPadding();
    }

    public int getItemIconPadding() {
        return this.presenter.getItemIconPadding();
    }

    public ColorStateList getItemIconTintList() {
        return this.presenter.getItemTintList();
    }

    public int getItemMaxLines() {
        return this.presenter.getItemMaxLines();
    }

    public ColorStateList getItemTextColor() {
        return this.presenter.getItemTextColor();
    }

    public int getItemVerticalPadding() {
        return this.presenter.getItemVerticalPadding();
    }

    public Menu getMenu() {
        return this.menu;
    }

    public int getSubheaderInsetEnd() {
        return this.presenter.getSubheaderInsetEnd();
    }

    public int getSubheaderInsetStart() {
        return this.presenter.getSubheaderInsetStart();
    }

    public View inflateHeaderView(int n) {
        return this.presenter.inflateHeaderView(n);
    }

    public void inflateMenu(int n) {
        this.presenter.setUpdateSuspended(true);
        this.getMenuInflater().inflate(n, (Menu)this.menu);
        this.presenter.setUpdateSuspended(false);
        this.presenter.updateMenuView(false);
    }

    public boolean isBottomInsetScrimEnabled() {
        return this.bottomInsetScrimEnabled;
    }

    public boolean isTopInsetScrimEnabled() {
        return this.topInsetScrimEnabled;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (Build.VERSION.SDK_INT < 16) {
            this.getViewTreeObserver().removeGlobalOnLayoutListener(this.onGlobalLayoutListener);
        } else {
            this.getViewTreeObserver().removeOnGlobalLayoutListener(this.onGlobalLayoutListener);
        }
    }

    @Override
    protected void onInsetsChanged(WindowInsetsCompat windowInsetsCompat) {
        this.presenter.dispatchApplyWindowInsets(windowInsetsCompat);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n);
        if (n3 != Integer.MIN_VALUE) {
            if (n3 == 0) {
                n = View.MeasureSpec.makeMeasureSpec((int)this.maxWidth, (int)0x40000000);
            }
        } else {
            n = View.MeasureSpec.makeMeasureSpec((int)Math.min(View.MeasureSpec.getSize((int)n), this.maxWidth), (int)0x40000000);
        }
        super.onMeasure(n, n2);
    }

    protected void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.menu.restorePresenterStates(object.menuState);
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.menuState = new Bundle();
        this.menu.savePresenterStates(savedState.menuState);
        return savedState;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.maybeUpdateCornerSizeForDrawerLayout(n, n2);
    }

    public void removeHeaderView(View view) {
        this.presenter.removeHeaderView(view);
    }

    public void setBottomInsetScrimEnabled(boolean bl) {
        this.bottomInsetScrimEnabled = bl;
    }

    public void setCheckedItem(int n) {
        MenuItem menuItem = this.menu.findItem(n);
        if (menuItem != null) {
            this.presenter.setCheckedItem((MenuItemImpl)menuItem);
        }
    }

    public void setCheckedItem(MenuItem menuItem) {
        if ((menuItem = this.menu.findItem(menuItem.getItemId())) != null) {
            this.presenter.setCheckedItem((MenuItemImpl)menuItem);
            return;
        }
        throw new IllegalArgumentException("Called setCheckedItem(MenuItem) with an item that is not in the current menu.");
    }

    public void setDividerInsetEnd(int n) {
        this.presenter.setDividerInsetEnd(n);
    }

    public void setDividerInsetStart(int n) {
        this.presenter.setDividerInsetStart(n);
    }

    public void setElevation(float f) {
        if (Build.VERSION.SDK_INT >= 21) {
            super.setElevation(f);
        }
        MaterialShapeUtils.setElevation((View)this, f);
    }

    public void setItemBackground(Drawable drawable2) {
        this.presenter.setItemBackground(drawable2);
    }

    public void setItemBackgroundResource(int n) {
        this.setItemBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)n));
    }

    public void setItemHorizontalPadding(int n) {
        this.presenter.setItemHorizontalPadding(n);
    }

    public void setItemHorizontalPaddingResource(int n) {
        this.presenter.setItemHorizontalPadding(this.getResources().getDimensionPixelSize(n));
    }

    public void setItemIconPadding(int n) {
        this.presenter.setItemIconPadding(n);
    }

    public void setItemIconPaddingResource(int n) {
        this.presenter.setItemIconPadding(this.getResources().getDimensionPixelSize(n));
    }

    public void setItemIconSize(int n) {
        this.presenter.setItemIconSize(n);
    }

    public void setItemIconTintList(ColorStateList colorStateList) {
        this.presenter.setItemIconTintList(colorStateList);
    }

    public void setItemMaxLines(int n) {
        this.presenter.setItemMaxLines(n);
    }

    public void setItemTextAppearance(int n) {
        this.presenter.setItemTextAppearance(n);
    }

    public void setItemTextColor(ColorStateList colorStateList) {
        this.presenter.setItemTextColor(colorStateList);
    }

    public void setItemVerticalPadding(int n) {
        this.presenter.setItemVerticalPadding(n);
    }

    public void setItemVerticalPaddingResource(int n) {
        this.presenter.setItemVerticalPadding(this.getResources().getDimensionPixelSize(n));
    }

    public void setNavigationItemSelectedListener(OnNavigationItemSelectedListener onNavigationItemSelectedListener) {
        this.listener = onNavigationItemSelectedListener;
    }

    public void setOverScrollMode(int n) {
        super.setOverScrollMode(n);
        NavigationMenuPresenter navigationMenuPresenter = this.presenter;
        if (navigationMenuPresenter != null) {
            navigationMenuPresenter.setOverScrollMode(n);
        }
    }

    public void setSubheaderInsetEnd(int n) {
        this.presenter.setSubheaderInsetStart(n);
    }

    public void setSubheaderInsetStart(int n) {
        this.presenter.setSubheaderInsetStart(n);
    }

    public void setTopInsetScrimEnabled(boolean bl) {
        this.topInsetScrimEnabled = bl;
    }

    public static interface OnNavigationItemSelectedListener {
        public boolean onNavigationItemSelected(MenuItem var1);
    }

    public static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        public Bundle menuState;

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.menuState = parcel.readBundle(classLoader);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeBundle(this.menuState);
        }
    }
}

