/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigationrail;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.material.navigation.NavigationBarItemView;
import com.google.android.material.navigation.NavigationBarMenuView;
import com.google.android.material.navigationrail.NavigationRailItemView;

public class NavigationRailMenuView
extends NavigationBarMenuView {
    private int itemMinimumHeight = -1;
    private final FrameLayout.LayoutParams layoutParams;

    public NavigationRailMenuView(Context context) {
        super(context);
        context = new FrameLayout.LayoutParams(-1, -2);
        this.layoutParams = context;
        context.gravity = 49;
        this.setLayoutParams((ViewGroup.LayoutParams)context);
        this.setItemActiveIndicatorResizeable(true);
    }

    private int makeSharedHeightSpec(int n, int n2, int n3) {
        n3 = n2 / Math.max(1, n3);
        n2 = this.itemMinimumHeight;
        n = n2 != -1 ? n2 : View.MeasureSpec.getSize((int)n);
        return View.MeasureSpec.makeMeasureSpec((int)Math.min(n, n3), (int)0);
    }

    private int measureChildHeight(View view, int n, int n2) {
        if (view.getVisibility() != 8) {
            view.measure(n, n2);
            return view.getMeasuredHeight();
        }
        return 0;
    }

    private int measureSharedChildHeights(int n, int n2, int n3, View view) {
        this.makeSharedHeightSpec(n, n2, n3);
        n2 = view == null ? this.makeSharedHeightSpec(n, n2, n3) : View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0);
        int n4 = this.getChildCount();
        n3 = 0;
        for (int i = 0; i < n4; ++i) {
            View view2 = this.getChildAt(i);
            int n5 = n3;
            if (view2 != view) {
                n5 = n3 + this.measureChildHeight(view2, n, n2);
            }
            n3 = n5;
        }
        return n3;
    }

    private int measureShiftingChildHeights(int n, int n2, int n3) {
        int n4;
        View view = this.getChildAt(this.getSelectedItemPosition());
        if (view != null) {
            int n5 = this.measureChildHeight(view, n, this.makeSharedHeightSpec(n, n2, n3));
            n4 = n2 - n5;
            int n6 = n3 - 1;
            n2 = n5;
            n3 = n4;
            n4 = n6;
        } else {
            int n7 = 0;
            n4 = n3;
            n3 = n2;
            n2 = n7;
        }
        return n2 + this.measureSharedChildHeights(n, n3, n4, view);
    }

    @Override
    protected NavigationBarItemView createNavigationBarItemView(Context context) {
        return new NavigationRailItemView(context);
    }

    public int getItemMinimumHeight() {
        return this.itemMinimumHeight;
    }

    int getMenuGravity() {
        return this.layoutParams.gravity;
    }

    boolean isTopGravity() {
        boolean bl = (this.layoutParams.gravity & 0x70) == 48;
        return bl;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getChildCount();
        n2 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            View view = this.getChildAt(n4);
            int n6 = n2;
            if (view.getVisibility() != 8) {
                n6 = view.getMeasuredHeight() + n2;
                view.layout(0, n2, n3 - n, n6);
            }
            n2 = n6;
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n2);
        int n4 = this.getMenu().getVisibleItems().size();
        n4 = n4 > 1 && this.isShifting(this.getLabelVisibilityMode(), n4) ? this.measureShiftingChildHeights(n, n3, n4) : this.measureSharedChildHeights(n, n3, n4, null);
        this.setMeasuredDimension(View.resolveSizeAndState((int)View.MeasureSpec.getSize((int)n), (int)n, (int)0), View.resolveSizeAndState((int)n4, (int)n2, (int)0));
    }

    public void setItemMinimumHeight(int n) {
        if (this.itemMinimumHeight != n) {
            this.itemMinimumHeight = n;
            this.requestLayout();
        }
    }

    void setMenuGravity(int n) {
        if (this.layoutParams.gravity != n) {
            this.layoutParams.gravity = n;
            this.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
        }
    }
}

