/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ProgressBar;
import androidx.core.view.ViewCompat;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.progressindicator.AnimatorDurationScaleProvider;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.DeterminateDrawable;
import com.google.android.material.progressindicator.DrawableWithAnimatedVisibilityChange;
import com.google.android.material.progressindicator.DrawingDelegate;
import com.google.android.material.progressindicator.IndeterminateDrawable;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public abstract class BaseProgressIndicator<S extends BaseProgressIndicatorSpec>
extends ProgressBar {
    static final float DEFAULT_OPACITY = 0.2f;
    static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_ProgressIndicator;
    public static final int HIDE_INWARD = 2;
    public static final int HIDE_NONE = 0;
    public static final int HIDE_OUTWARD = 1;
    static final int MAX_ALPHA = 255;
    static final int MAX_HIDE_DELAY = 1000;
    public static final int SHOW_INWARD = 2;
    public static final int SHOW_NONE = 0;
    public static final int SHOW_OUTWARD = 1;
    AnimatorDurationScaleProvider animatorDurationScaleProvider;
    private final Runnable delayedHide;
    private final Runnable delayedShow = new Runnable(){

        @Override
        public void run() {
            BaseProgressIndicator.this.internalShow();
        }
    };
    private final Animatable2Compat.AnimationCallback hideAnimationCallback;
    private boolean isIndeterminateModeChangeRequested = false;
    private boolean isParentDoneInitializing;
    private long lastShowStartTime = -1L;
    private final int minHideDelay;
    private final int showDelay;
    S spec;
    private int storedProgress;
    private boolean storedProgressAnimated;
    private final Animatable2Compat.AnimationCallback switchIndeterminateModeCallback;
    private int visibilityAfterHide = 4;

    protected BaseProgressIndicator(Context context, AttributeSet attributeSet, int n, int n2) {
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, DEF_STYLE_RES), attributeSet, n);
        this.delayedHide = new Runnable(){

            @Override
            public void run() {
                BaseProgressIndicator.this.internalHide();
                BaseProgressIndicator.access$202(BaseProgressIndicator.this, -1L);
            }
        };
        this.switchIndeterminateModeCallback = new Animatable2Compat.AnimationCallback(){

            public void onAnimationEnd(Drawable object) {
                BaseProgressIndicator.this.setIndeterminate(false);
                object = BaseProgressIndicator.this;
                ((BaseProgressIndicator)((Object)object)).setProgressCompat(((BaseProgressIndicator)((Object)object)).storedProgress, BaseProgressIndicator.this.storedProgressAnimated);
            }
        };
        this.hideAnimationCallback = new Animatable2Compat.AnimationCallback(){

            public void onAnimationEnd(Drawable object) {
                super.onAnimationEnd(object);
                if (!BaseProgressIndicator.this.isIndeterminateModeChangeRequested) {
                    object = BaseProgressIndicator.this;
                    object.setVisibility(((BaseProgressIndicator)((Object)object)).visibilityAfterHide);
                }
            }
        };
        context = this.getContext();
        this.spec = this.createSpec(context, attributeSet);
        context = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.BaseProgressIndicator, n, n2, new int[0]);
        this.showDelay = context.getInt(R.styleable.BaseProgressIndicator_showDelay, -1);
        this.minHideDelay = Math.min(context.getInt(R.styleable.BaseProgressIndicator_minHideDelay, -1), 1000);
        context.recycle();
        this.animatorDurationScaleProvider = new AnimatorDurationScaleProvider();
        this.isParentDoneInitializing = true;
    }

    static /* synthetic */ long access$202(BaseProgressIndicator baseProgressIndicator, long l) {
        baseProgressIndicator.lastShowStartTime = l;
        return l;
    }

    private DrawingDelegate<S> getCurrentDrawingDelegate() {
        boolean bl = this.isIndeterminate();
        DrawingDelegate drawingDelegate = null;
        DrawingDelegate drawingDelegate2 = null;
        if (bl) {
            if (this.getIndeterminateDrawable() != null) {
                drawingDelegate2 = this.getIndeterminateDrawable().getDrawingDelegate();
            }
            return drawingDelegate2;
        }
        drawingDelegate2 = this.getProgressDrawable() == null ? drawingDelegate : this.getProgressDrawable().getDrawingDelegate();
        return drawingDelegate2;
    }

    private void internalHide() {
        ((DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable()).setVisible(false, false, true);
        if (this.isNoLongerNeedToBeVisible()) {
            this.setVisibility(4);
        }
    }

    private void internalShow() {
        if (this.minHideDelay > 0) {
            this.lastShowStartTime = SystemClock.uptimeMillis();
        }
        this.setVisibility(0);
    }

    private boolean isNoLongerNeedToBeVisible() {
        boolean bl = !(this.getProgressDrawable() != null && this.getProgressDrawable().isVisible() || this.getIndeterminateDrawable() != null && this.getIndeterminateDrawable().isVisible());
        return bl;
    }

    private void registerAnimationCallbacks() {
        if (this.getProgressDrawable() != null && this.getIndeterminateDrawable() != null) {
            this.getIndeterminateDrawable().getAnimatorDelegate().registerAnimatorsCompleteCallback(this.switchIndeterminateModeCallback);
        }
        if (this.getProgressDrawable() != null) {
            this.getProgressDrawable().registerAnimationCallback(this.hideAnimationCallback);
        }
        if (this.getIndeterminateDrawable() != null) {
            this.getIndeterminateDrawable().registerAnimationCallback(this.hideAnimationCallback);
        }
    }

    private void unregisterAnimationCallbacks() {
        if (this.getIndeterminateDrawable() != null) {
            this.getIndeterminateDrawable().unregisterAnimationCallback(this.hideAnimationCallback);
            this.getIndeterminateDrawable().getAnimatorDelegate().unregisterAnimatorsCompleteCallback();
        }
        if (this.getProgressDrawable() != null) {
            this.getProgressDrawable().unregisterAnimationCallback(this.hideAnimationCallback);
        }
    }

    protected void applyNewVisibility(boolean bl) {
        if (!this.isParentDoneInitializing) {
            return;
        }
        ((DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable()).setVisible(this.visibleToUser(), false, bl);
    }

    abstract S createSpec(Context var1, AttributeSet var2);

    public Drawable getCurrentDrawable() {
        Drawable drawable2 = this.isIndeterminate() ? this.getIndeterminateDrawable() : this.getProgressDrawable();
        return drawable2;
    }

    public int getHideAnimationBehavior() {
        return ((BaseProgressIndicatorSpec)this.spec).hideAnimationBehavior;
    }

    public IndeterminateDrawable<S> getIndeterminateDrawable() {
        return (IndeterminateDrawable)super.getIndeterminateDrawable();
    }

    public int[] getIndicatorColor() {
        return ((BaseProgressIndicatorSpec)this.spec).indicatorColors;
    }

    public DeterminateDrawable<S> getProgressDrawable() {
        return (DeterminateDrawable)super.getProgressDrawable();
    }

    public int getShowAnimationBehavior() {
        return ((BaseProgressIndicatorSpec)this.spec).showAnimationBehavior;
    }

    public int getTrackColor() {
        return ((BaseProgressIndicatorSpec)this.spec).trackColor;
    }

    public int getTrackCornerRadius() {
        return ((BaseProgressIndicatorSpec)this.spec).trackCornerRadius;
    }

    public int getTrackThickness() {
        return ((BaseProgressIndicatorSpec)this.spec).trackThickness;
    }

    public void hide() {
        if (this.getVisibility() != 0) {
            this.removeCallbacks(this.delayedShow);
            return;
        }
        this.removeCallbacks(this.delayedHide);
        long l = SystemClock.uptimeMillis() - this.lastShowStartTime;
        int n = this.minHideDelay;
        boolean bl = l >= (long)n;
        if (bl) {
            this.delayedHide.run();
            return;
        }
        this.postDelayed(this.delayedHide, (long)n - l);
    }

    public void invalidate() {
        super.invalidate();
        if (this.getCurrentDrawable() != null) {
            this.getCurrentDrawable().invalidateSelf();
        }
    }

    boolean isEffectivelyVisible() {
        BaseProgressIndicator baseProgressIndicator = this;
        while (true) {
            int n = baseProgressIndicator.getVisibility();
            boolean bl = false;
            if (n != 0) {
                return false;
            }
            if ((baseProgressIndicator = baseProgressIndicator.getParent()) == null) {
                if (this.getWindowVisibility() == 0) {
                    bl = true;
                }
                return bl;
            }
            if (!(baseProgressIndicator instanceof View)) {
                return true;
            }
            baseProgressIndicator = (View)baseProgressIndicator;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.registerAnimationCallbacks();
        if (this.visibleToUser()) {
            this.internalShow();
        }
    }

    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.delayedHide);
        this.removeCallbacks(this.delayedShow);
        ((DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable()).hideNow();
        this.unregisterAnimationCallbacks();
        super.onDetachedFromWindow();
    }

    protected void onDraw(Canvas canvas) {
        synchronized (this) {
            int n = canvas.save();
            if (this.getPaddingLeft() != 0 || this.getPaddingTop() != 0) {
                canvas.translate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            }
            if (this.getPaddingRight() != 0 || this.getPaddingBottom() != 0) {
                canvas.clipRect(0, 0, this.getWidth() - (this.getPaddingLeft() + this.getPaddingRight()), this.getHeight() - (this.getPaddingTop() + this.getPaddingBottom()));
            }
            this.getCurrentDrawable().draw(canvas);
            canvas.restoreToCount(n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onMeasure(int n, int n2) {
        synchronized (this) {
            super.onMeasure(n, n2);
            DrawingDelegate<S> drawingDelegate = this.getCurrentDrawingDelegate();
            if (drawingDelegate == null) {
                return;
            }
            n = drawingDelegate.getPreferredWidth();
            n2 = drawingDelegate.getPreferredHeight();
            n = n < 0 ? this.getMeasuredWidth() : n + this.getPaddingLeft() + this.getPaddingRight();
            n2 = n2 < 0 ? this.getMeasuredHeight() : n2 + this.getPaddingTop() + this.getPaddingBottom();
            this.setMeasuredDimension(n, n2);
            return;
        }
    }

    protected void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        boolean bl = n == 0;
        this.applyNewVisibility(bl);
    }

    protected void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        this.applyNewVisibility(false);
    }

    public void setAnimatorDurationScaleProvider(AnimatorDurationScaleProvider animatorDurationScaleProvider) {
        this.animatorDurationScaleProvider = animatorDurationScaleProvider;
        if (this.getProgressDrawable() != null) {
            this.getProgressDrawable().animatorDurationScaleProvider = animatorDurationScaleProvider;
        }
        if (this.getIndeterminateDrawable() != null) {
            this.getIndeterminateDrawable().animatorDurationScaleProvider = animatorDurationScaleProvider;
        }
    }

    public void setHideAnimationBehavior(int n) {
        ((BaseProgressIndicatorSpec)this.spec).hideAnimationBehavior = n;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIndeterminate(boolean bl) {
        synchronized (this) {
            boolean bl2 = this.isIndeterminate();
            if (bl == bl2) {
                return;
            }
            DrawableWithAnimatedVisibilityChange drawableWithAnimatedVisibilityChange = (DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable();
            if (drawableWithAnimatedVisibilityChange != null) {
                drawableWithAnimatedVisibilityChange.hideNow();
            }
            super.setIndeterminate(bl);
            drawableWithAnimatedVisibilityChange = (DrawableWithAnimatedVisibilityChange)this.getCurrentDrawable();
            if (drawableWithAnimatedVisibilityChange != null) {
                drawableWithAnimatedVisibilityChange.setVisible(this.visibleToUser(), false, false);
            }
            if (drawableWithAnimatedVisibilityChange instanceof IndeterminateDrawable && this.visibleToUser()) {
                ((IndeterminateDrawable)drawableWithAnimatedVisibilityChange).getAnimatorDelegate().startAnimator();
            }
            this.isIndeterminateModeChangeRequested = false;
            return;
        }
    }

    public void setIndeterminateDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            super.setIndeterminateDrawable(null);
            return;
        }
        if (drawable2 instanceof IndeterminateDrawable) {
            ((DrawableWithAnimatedVisibilityChange)drawable2).hideNow();
            super.setIndeterminateDrawable(drawable2);
            return;
        }
        throw new IllegalArgumentException("Cannot set framework drawable as indeterminate drawable.");
    }

    public void setIndicatorColor(int ... nArray) {
        int[] nArray2 = nArray;
        if (nArray.length == 0) {
            nArray2 = new int[]{MaterialColors.getColor(this.getContext(), R.attr.colorPrimary, -1)};
        }
        if (!Arrays.equals(this.getIndicatorColor(), nArray2)) {
            ((BaseProgressIndicatorSpec)this.spec).indicatorColors = nArray2;
            this.getIndeterminateDrawable().getAnimatorDelegate().invalidateSpecValues();
            this.invalidate();
        }
    }

    public void setProgress(int n) {
        synchronized (this) {
            block4: {
                boolean bl = this.isIndeterminate();
                if (!bl) break block4;
                return;
            }
            this.setProgressCompat(n, false);
            return;
        }
    }

    public void setProgressCompat(int n, boolean bl) {
        if (this.isIndeterminate()) {
            if (this.getProgressDrawable() != null) {
                this.storedProgress = n;
                this.storedProgressAnimated = bl;
                this.isIndeterminateModeChangeRequested = true;
                if (this.getIndeterminateDrawable().isVisible() && this.animatorDurationScaleProvider.getSystemAnimatorDurationScale(this.getContext().getContentResolver()) != 0.0f) {
                    this.getIndeterminateDrawable().getAnimatorDelegate().requestCancelAnimatorAfterCurrentCycle();
                } else {
                    this.switchIndeterminateModeCallback.onAnimationEnd(this.getIndeterminateDrawable());
                }
            }
        } else {
            super.setProgress(n);
            if (this.getProgressDrawable() != null && !bl) {
                this.getProgressDrawable().jumpToCurrentState();
            }
        }
    }

    public void setProgressDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            super.setProgressDrawable(null);
            return;
        }
        if (drawable2 instanceof DeterminateDrawable) {
            drawable2 = (DeterminateDrawable)drawable2;
            drawable2.hideNow();
            super.setProgressDrawable(drawable2);
            drawable2.setLevelByFraction((float)this.getProgress() / (float)this.getMax());
            return;
        }
        throw new IllegalArgumentException("Cannot set framework drawable as progress drawable.");
    }

    public void setShowAnimationBehavior(int n) {
        ((BaseProgressIndicatorSpec)this.spec).showAnimationBehavior = n;
        this.invalidate();
    }

    public void setTrackColor(int n) {
        if (((BaseProgressIndicatorSpec)this.spec).trackColor != n) {
            ((BaseProgressIndicatorSpec)this.spec).trackColor = n;
            this.invalidate();
        }
    }

    public void setTrackCornerRadius(int n) {
        if (((BaseProgressIndicatorSpec)this.spec).trackCornerRadius != n) {
            S s = this.spec;
            ((BaseProgressIndicatorSpec)s).trackCornerRadius = Math.min(n, ((BaseProgressIndicatorSpec)s).trackThickness / 2);
        }
    }

    public void setTrackThickness(int n) {
        if (((BaseProgressIndicatorSpec)this.spec).trackThickness != n) {
            ((BaseProgressIndicatorSpec)this.spec).trackThickness = n;
            this.requestLayout();
        }
    }

    public void setVisibilityAfterHide(int n) {
        if (n != 0 && n != 4 && n != 8) {
            throw new IllegalArgumentException("The component's visibility must be one of VISIBLE, INVISIBLE, and GONE defined in View.");
        }
        this.visibilityAfterHide = n;
    }

    public void show() {
        if (this.showDelay > 0) {
            this.removeCallbacks(this.delayedShow);
            this.postDelayed(this.delayedShow, this.showDelay);
        } else {
            this.delayedShow.run();
        }
    }

    boolean visibleToUser() {
        boolean bl = ViewCompat.isAttachedToWindow((View)this) && this.getWindowVisibility() == 0 && this.isEffectivelyVisible();
        return bl;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HideAnimationBehavior {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowAnimationBehavior {
    }
}

