/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.google.android.material.resources.MaterialResources;

public final class CircularProgressIndicatorSpec
extends BaseProgressIndicatorSpec {
    public int indicatorDirection;
    public int indicatorInset;
    public int indicatorSize;

    public CircularProgressIndicatorSpec(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.circularProgressIndicatorStyle);
    }

    public CircularProgressIndicatorSpec(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, CircularProgressIndicator.DEF_STYLE_RES);
    }

    public CircularProgressIndicatorSpec(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        int n3 = context.getResources().getDimensionPixelSize(R.dimen.mtrl_progress_circular_size_medium);
        int n4 = context.getResources().getDimensionPixelSize(R.dimen.mtrl_progress_circular_inset_medium);
        attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.CircularProgressIndicator, n, n2, new int[0]);
        this.indicatorSize = Math.max(MaterialResources.getDimensionPixelSize(context, (TypedArray)attributeSet, R.styleable.CircularProgressIndicator_indicatorSize, n3), this.trackThickness * 2);
        this.indicatorInset = MaterialResources.getDimensionPixelSize(context, (TypedArray)attributeSet, R.styleable.CircularProgressIndicator_indicatorInset, n4);
        this.indicatorDirection = attributeSet.getInt(R.styleable.CircularProgressIndicator_indicatorDirectionCircular, 0);
        attributeSet.recycle();
        this.validateSpec();
    }

    @Override
    void validateSpec() {
    }
}

