/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.progressindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Property;
import android.view.animation.Interpolator;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import androidx.vectordrawable.graphics.drawable.AnimationUtilsCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.progressindicator.BaseProgressIndicatorSpec;
import com.google.android.material.progressindicator.IndeterminateAnimatorDelegate;
import com.google.android.material.progressindicator.LinearProgressIndicatorSpec;
import java.util.Arrays;

final class LinearIndeterminateDisjointAnimatorDelegate
extends IndeterminateAnimatorDelegate<ObjectAnimator> {
    private static final Property<LinearIndeterminateDisjointAnimatorDelegate, Float> ANIMATION_FRACTION;
    private static final int[] DELAY_TO_MOVE_SEGMENT_ENDS;
    private static final int[] DURATION_TO_MOVE_SEGMENT_ENDS;
    private static final int TOTAL_DURATION_IN_MS = 1800;
    private float animationFraction;
    private ObjectAnimator animator;
    Animatable2Compat.AnimationCallback animatorCompleteCallback = null;
    private final BaseProgressIndicatorSpec baseSpec;
    private ObjectAnimator completeEndAnimator;
    private boolean dirtyColors;
    private int indicatorColorIndex = 0;
    private final Interpolator[] interpolatorArray;

    static {
        DURATION_TO_MOVE_SEGMENT_ENDS = new int[]{533, 567, 850, 750};
        DELAY_TO_MOVE_SEGMENT_ENDS = new int[]{1267, 1000, 333, 0};
        ANIMATION_FRACTION = new Property<LinearIndeterminateDisjointAnimatorDelegate, Float>(Float.class, "animationFraction"){

            public Float get(LinearIndeterminateDisjointAnimatorDelegate linearIndeterminateDisjointAnimatorDelegate) {
                return Float.valueOf(linearIndeterminateDisjointAnimatorDelegate.getAnimationFraction());
            }

            public void set(LinearIndeterminateDisjointAnimatorDelegate linearIndeterminateDisjointAnimatorDelegate, Float f) {
                linearIndeterminateDisjointAnimatorDelegate.setAnimationFraction(f.floatValue());
            }
        };
    }

    public LinearIndeterminateDisjointAnimatorDelegate(Context context, LinearProgressIndicatorSpec linearProgressIndicatorSpec) {
        super(2);
        this.baseSpec = linearProgressIndicatorSpec;
        this.interpolatorArray = new Interpolator[]{AnimationUtilsCompat.loadInterpolator((Context)context, (int)R.animator.linear_indeterminate_line1_head_interpolator), AnimationUtilsCompat.loadInterpolator((Context)context, (int)R.animator.linear_indeterminate_line1_tail_interpolator), AnimationUtilsCompat.loadInterpolator((Context)context, (int)R.animator.linear_indeterminate_line2_head_interpolator), AnimationUtilsCompat.loadInterpolator((Context)context, (int)R.animator.linear_indeterminate_line2_tail_interpolator)};
    }

    static /* synthetic */ int access$002(LinearIndeterminateDisjointAnimatorDelegate linearIndeterminateDisjointAnimatorDelegate, int n) {
        linearIndeterminateDisjointAnimatorDelegate.indicatorColorIndex = n;
        return n;
    }

    static /* synthetic */ boolean access$202(LinearIndeterminateDisjointAnimatorDelegate linearIndeterminateDisjointAnimatorDelegate, boolean bl) {
        linearIndeterminateDisjointAnimatorDelegate.dirtyColors = bl;
        return bl;
    }

    private float getAnimationFraction() {
        return this.animationFraction;
    }

    private void maybeInitializeAnimators() {
        ObjectAnimator objectAnimator;
        if (this.animator == null) {
            this.animator = objectAnimator = ObjectAnimator.ofFloat((Object)this, ANIMATION_FRACTION, (float[])new float[]{0.0f, 1.0f});
            objectAnimator.setDuration(1800L);
            this.animator.setInterpolator(null);
            this.animator.setRepeatCount(-1);
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator object) {
                    super.onAnimationRepeat(object);
                    object = LinearIndeterminateDisjointAnimatorDelegate.this;
                    LinearIndeterminateDisjointAnimatorDelegate.access$002((LinearIndeterminateDisjointAnimatorDelegate)object, (((LinearIndeterminateDisjointAnimatorDelegate)object).indicatorColorIndex + 1) % ((LinearIndeterminateDisjointAnimatorDelegate)LinearIndeterminateDisjointAnimatorDelegate.this).baseSpec.indicatorColors.length);
                    LinearIndeterminateDisjointAnimatorDelegate.access$202(LinearIndeterminateDisjointAnimatorDelegate.this, true);
                }
            });
        }
        if (this.completeEndAnimator == null) {
            this.completeEndAnimator = objectAnimator = ObjectAnimator.ofFloat((Object)this, ANIMATION_FRACTION, (float[])new float[]{1.0f});
            objectAnimator.setDuration(1800L);
            this.completeEndAnimator.setInterpolator(null);
            this.completeEndAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator2) {
                    super.onAnimationEnd(animator2);
                    LinearIndeterminateDisjointAnimatorDelegate.this.cancelAnimatorImmediately();
                    if (LinearIndeterminateDisjointAnimatorDelegate.this.animatorCompleteCallback != null) {
                        LinearIndeterminateDisjointAnimatorDelegate.this.animatorCompleteCallback.onAnimationEnd((Drawable)LinearIndeterminateDisjointAnimatorDelegate.this.drawable);
                    }
                }
            });
        }
    }

    private void maybeUpdateSegmentColors() {
        if (this.dirtyColors) {
            Arrays.fill(this.segmentColors, MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[this.indicatorColorIndex], this.drawable.getAlpha()));
            this.dirtyColors = false;
        }
    }

    private void updateSegmentPositions(int n) {
        for (int i = 0; i < 4; ++i) {
            float f = this.getFractionInRange(n, DELAY_TO_MOVE_SEGMENT_ENDS[i], DURATION_TO_MOVE_SEGMENT_ENDS[i]);
            f = this.interpolatorArray[i].getInterpolation(f);
            this.segmentPositions[i] = Math.max(0.0f, Math.min(1.0f, f));
        }
    }

    @Override
    public void cancelAnimatorImmediately() {
        ObjectAnimator objectAnimator = this.animator;
        if (objectAnimator != null) {
            objectAnimator.cancel();
        }
    }

    @Override
    public void invalidateSpecValues() {
        this.resetPropertiesForNewStart();
    }

    @Override
    public void registerAnimatorsCompleteCallback(Animatable2Compat.AnimationCallback animationCallback) {
        this.animatorCompleteCallback = animationCallback;
    }

    @Override
    public void requestCancelAnimatorAfterCurrentCycle() {
        ObjectAnimator objectAnimator = this.completeEndAnimator;
        if (objectAnimator != null && !objectAnimator.isRunning()) {
            this.cancelAnimatorImmediately();
            if (this.drawable.isVisible()) {
                this.completeEndAnimator.setFloatValues(new float[]{this.animationFraction, 1.0f});
                this.completeEndAnimator.setDuration((long)((1.0f - this.animationFraction) * 1800.0f));
                this.completeEndAnimator.start();
            }
        }
    }

    void resetPropertiesForNewStart() {
        int n;
        this.indicatorColorIndex = 0;
        this.segmentColors[0] = n = MaterialColors.compositeARGBWithAlpha(this.baseSpec.indicatorColors[0], this.drawable.getAlpha());
        this.segmentColors[1] = n;
    }

    void setAnimationFraction(float f) {
        this.animationFraction = f;
        this.updateSegmentPositions((int)(f * 1800.0f));
        this.maybeUpdateSegmentColors();
        this.drawable.invalidateSelf();
    }

    @Override
    public void startAnimator() {
        this.maybeInitializeAnimators();
        this.resetPropertiesForNewStart();
        this.animator.start();
    }

    @Override
    public void unregisterAnimatorsCompleteCallback() {
        this.animatorCompleteCallback = null;
    }
}

