/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.resources;

import android.content.Context;
import android.util.TypedValue;
import android.view.View;
import com.google.android.material.R;

public class MaterialAttributes {
    public static TypedValue resolve(Context context, int n) {
        TypedValue typedValue = new TypedValue();
        if (context.getTheme().resolveAttribute(n, typedValue, true)) {
            return typedValue;
        }
        return null;
    }

    public static boolean resolveBoolean(Context context, int n, boolean bl) {
        context = MaterialAttributes.resolve(context, n);
        boolean bl2 = bl;
        if (context != null) {
            bl2 = bl;
            if (context.type == 18) {
                bl2 = context.data != 0;
            }
        }
        return bl2;
    }

    public static boolean resolveBooleanOrThrow(Context context, int n, String string2) {
        boolean bl = MaterialAttributes.resolveOrThrow(context, n, string2) != 0;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int resolveDimension(Context context, int n, int n2) {
        float f;
        TypedValue typedValue = MaterialAttributes.resolve(context, n);
        if (typedValue != null && typedValue.type == 5) {
            f = typedValue.getDimension(context.getResources().getDisplayMetrics());
            return (int)f;
        }
        f = context.getResources().getDimension(n2);
        return (int)f;
    }

    public static int resolveInteger(Context context, int n, int n2) {
        context = MaterialAttributes.resolve(context, n);
        n = n2;
        if (context != null) {
            n = n2;
            if (context.type == 16) {
                n = context.data;
            }
        }
        return n;
    }

    public static int resolveMinimumAccessibleTouchTarget(Context context) {
        return MaterialAttributes.resolveDimension(context, R.attr.minTouchTargetSize, R.dimen.mtrl_min_touch_target_size);
    }

    public static int resolveOrThrow(Context context, int n, String string2) {
        TypedValue typedValue = MaterialAttributes.resolve(context, n);
        if (typedValue != null) {
            return typedValue.data;
        }
        throw new IllegalArgumentException(String.format("%1$s requires a value for the %2$s attribute to be set in your app theme. You can either set the attribute in your theme or update your theme to inherit from Theme.MaterialComponents (or a descendant).", string2, context.getResources().getResourceName(n)));
    }

    public static int resolveOrThrow(View view, int n) {
        return MaterialAttributes.resolveOrThrow(view.getContext(), n, view.getClass().getCanonicalName());
    }
}

