/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.slider;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.AbsSavedState;
import com.google.android.material.R;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.slider.BaseOnChangeListener;
import com.google.android.material.slider.BaseOnSliderTouchListener;
import com.google.android.material.slider.BaseSlider;
import java.util.ArrayList;
import java.util.List;

public class RangeSlider
extends BaseSlider<RangeSlider, OnChangeListener, OnSliderTouchListener> {
    private float minSeparation;
    private int separationUnit;

    public RangeSlider(Context context) {
        this(context, null);
    }

    public RangeSlider(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.sliderStyle);
    }

    public RangeSlider(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        context = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.RangeSlider, n, DEF_STYLE_RES, new int[0]);
        if (context.hasValue(R.styleable.RangeSlider_values)) {
            n = context.getResourceId(R.styleable.RangeSlider_values, 0);
            this.setValues(RangeSlider.convertToFloat(context.getResources().obtainTypedArray(n)));
        }
        this.minSeparation = context.getDimension(R.styleable.RangeSlider_minSeparation, 0.0f);
        context.recycle();
    }

    private static List<Float> convertToFloat(TypedArray typedArray) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (int i = 0; i < typedArray.length(); ++i) {
            arrayList.add(Float.valueOf(typedArray.getFloat(i, -1.0f)));
        }
        return arrayList;
    }

    @Override
    public float getMinSeparation() {
        return this.minSeparation;
    }

    @Override
    public List<Float> getValues() {
        return super.getValues();
    }

    @Override
    protected void onRestoreInstanceState(Parcelable object) {
        int n;
        object = (RangeSliderState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.minSeparation = ((RangeSliderState)((Object)object)).minSeparation;
        this.separationUnit = n = ((RangeSliderState)((Object)object)).separationUnit;
        this.setSeparationUnit(n);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        RangeSliderState rangeSliderState = new RangeSliderState(super.onSaveInstanceState());
        RangeSliderState.access$002(rangeSliderState, this.minSeparation);
        RangeSliderState.access$102(rangeSliderState, this.separationUnit);
        return rangeSliderState;
    }

    public void setMinSeparation(float f) {
        this.minSeparation = f;
        this.separationUnit = 0;
        this.setSeparationUnit(0);
    }

    public void setMinSeparationValue(float f) {
        this.minSeparation = f;
        this.separationUnit = 1;
        this.setSeparationUnit(1);
    }

    @Override
    public void setValues(List<Float> list) {
        super.setValues(list);
    }

    @Override
    public void setValues(Float ... floatArray) {
        super.setValues(floatArray);
    }

    public static interface OnChangeListener
    extends BaseOnChangeListener<RangeSlider> {
    }

    public static interface OnSliderTouchListener
    extends BaseOnSliderTouchListener<RangeSlider> {
    }

    static class RangeSliderState
    extends AbsSavedState {
        public static final Parcelable.Creator<RangeSliderState> CREATOR = new Parcelable.Creator<RangeSliderState>(){

            public RangeSliderState createFromParcel(Parcel parcel) {
                return new RangeSliderState(parcel);
            }

            public RangeSliderState[] newArray(int n) {
                return new RangeSliderState[n];
            }
        };
        private float minSeparation;
        private int separationUnit;

        private RangeSliderState(Parcel parcel) {
            super(parcel.readParcelable(RangeSliderState.class.getClassLoader()));
            this.minSeparation = parcel.readFloat();
            this.separationUnit = parcel.readInt();
        }

        RangeSliderState(Parcelable parcelable) {
            super(parcelable);
        }

        static /* synthetic */ float access$002(RangeSliderState rangeSliderState, float f) {
            rangeSliderState.minSeparation = f;
            return f;
        }

        static /* synthetic */ int access$102(RangeSliderState rangeSliderState, int n) {
            rangeSliderState.separationUnit = n;
            return n;
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeFloat(this.minSeparation);
            parcel.writeInt(this.separationUnit);
        }
    }
}

