/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.switchmaterial;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.SwitchCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.elevation.ElevationOverlayProvider;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;

public class SwitchMaterial
extends SwitchCompat {
    private static final int DEF_STYLE_RES = R.style.Widget_MaterialComponents_CompoundButton_Switch;
    private static final int[][] ENABLED_CHECKED_STATES = new int[][]{{16842910, 0x10100A0}, {16842910, -16842912}, {-16842910, 0x10100A0}, {-16842910, -16842912}};
    private final ElevationOverlayProvider elevationOverlayProvider;
    private ColorStateList materialThemeColorsThumbTintList;
    private ColorStateList materialThemeColorsTrackTintList;
    private boolean useMaterialThemeColors;

    public SwitchMaterial(Context context) {
        this(context, null);
    }

    public SwitchMaterial(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.switchStyle);
    }

    public SwitchMaterial(Context context, AttributeSet attributeSet, int n) {
        int n2 = DEF_STYLE_RES;
        super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
        context = this.getContext();
        this.elevationOverlayProvider = new ElevationOverlayProvider(context);
        context = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.SwitchMaterial, n, n2, new int[0]);
        this.useMaterialThemeColors = context.getBoolean(R.styleable.SwitchMaterial_useMaterialThemeColors, false);
        context.recycle();
    }

    private ColorStateList getMaterialThemeColorsThumbTintList() {
        if (this.materialThemeColorsThumbTintList == null) {
            float f;
            int n = MaterialColors.getColor((View)this, R.attr.colorSurface);
            int n2 = MaterialColors.getColor((View)this, R.attr.colorControlActivated);
            float f2 = f = this.getResources().getDimension(R.dimen.mtrl_switch_thumb_elevation);
            if (this.elevationOverlayProvider.isThemeElevationOverlayEnabled()) {
                f2 = f + ViewUtils.getParentAbsoluteElevation((View)this);
            }
            int n3 = this.elevationOverlayProvider.compositeOverlayIfNeeded(n, f2);
            int[][] nArray = ENABLED_CHECKED_STATES;
            int[] nArray2 = new int[nArray.length];
            nArray2[0] = MaterialColors.layer(n, n2, 1.0f);
            nArray2[1] = n3;
            nArray2[2] = MaterialColors.layer(n, n2, 0.38f);
            nArray2[3] = n3;
            this.materialThemeColorsThumbTintList = new ColorStateList(nArray, nArray2);
        }
        return this.materialThemeColorsThumbTintList;
    }

    private ColorStateList getMaterialThemeColorsTrackTintList() {
        if (this.materialThemeColorsTrackTintList == null) {
            int[][] nArray = ENABLED_CHECKED_STATES;
            int[] nArray2 = new int[nArray.length];
            int n = MaterialColors.getColor((View)this, R.attr.colorSurface);
            int n2 = MaterialColors.getColor((View)this, R.attr.colorControlActivated);
            int n3 = MaterialColors.getColor((View)this, R.attr.colorOnSurface);
            nArray2[0] = MaterialColors.layer(n, n2, 0.54f);
            nArray2[1] = MaterialColors.layer(n, n3, 0.32f);
            nArray2[2] = MaterialColors.layer(n, n2, 0.12f);
            nArray2[3] = MaterialColors.layer(n, n3, 0.12f);
            this.materialThemeColorsTrackTintList = new ColorStateList(nArray, nArray2);
        }
        return this.materialThemeColorsTrackTintList;
    }

    public boolean isUseMaterialThemeColors() {
        return this.useMaterialThemeColors;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.useMaterialThemeColors && this.getThumbTintList() == null) {
            this.setThumbTintList(this.getMaterialThemeColorsThumbTintList());
        }
        if (this.useMaterialThemeColors && this.getTrackTintList() == null) {
            this.setTrackTintList(this.getMaterialThemeColorsTrackTintList());
        }
    }

    public void setUseMaterialThemeColors(boolean bl) {
        this.useMaterialThemeColors = bl;
        if (bl) {
            this.setThumbTintList(this.getMaterialThemeColorsThumbTintList());
            this.setTrackTintList(this.getMaterialThemeColorsTrackTintList());
        } else {
            this.setThumbTintList(null);
            this.setTrackTintList(null);
        }
    }
}

