/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tabs;

import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.tabs.TabIndicatorInterpolator;
import com.google.android.material.tabs.TabLayout;

class ElasticTabIndicatorInterpolator
extends TabIndicatorInterpolator {
    ElasticTabIndicatorInterpolator() {
    }

    private static float accInterp(float f) {
        return (float)(1.0 - Math.cos((double)f * Math.PI / 2.0));
    }

    private static float decInterp(float f) {
        return (float)Math.sin((double)f * Math.PI / 2.0);
    }

    @Override
    void setIndicatorBoundsForOffset(TabLayout tabLayout, View view, View view2, float f, Drawable drawable2) {
        float f2;
        view = ElasticTabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, view);
        tabLayout = ElasticTabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, view2);
        boolean bl = view.left < ((RectF)tabLayout).left;
        if (bl) {
            float f3 = ElasticTabIndicatorInterpolator.accInterp(f);
            f2 = ElasticTabIndicatorInterpolator.decInterp(f);
            f = f3;
        } else {
            float f4 = ElasticTabIndicatorInterpolator.decInterp(f);
            f2 = ElasticTabIndicatorInterpolator.accInterp(f);
            f = f4;
        }
        drawable2.setBounds(AnimationUtils.lerp((int)view.left, (int)((RectF)tabLayout).left, f), drawable2.getBounds().top, AnimationUtils.lerp((int)view.right, (int)((RectF)tabLayout).right, f2), drawable2.getBounds().bottom);
    }
}

