/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tabs;

import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.tabs.TabLayout;

class TabIndicatorInterpolator {
    private static final int MIN_INDICATOR_WIDTH = 24;

    TabIndicatorInterpolator() {
    }

    static RectF calculateIndicatorWidthForTab(TabLayout tabLayout, View view) {
        if (view == null) {
            return new RectF();
        }
        if (!tabLayout.isTabIndicatorFullWidth() && view instanceof TabLayout.TabView) {
            return TabIndicatorInterpolator.calculateTabViewContentBounds((TabLayout.TabView)view, 24);
        }
        return new RectF((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
    }

    static RectF calculateTabViewContentBounds(TabLayout.TabView tabView, int n) {
        int n2 = tabView.getContentWidth();
        int n3 = tabView.getContentHeight();
        int n4 = (int)ViewUtils.dpToPx(tabView.getContext(), n);
        n = n2;
        if (n2 < n4) {
            n = n4;
        }
        n2 = (tabView.getLeft() + tabView.getRight()) / 2;
        n4 = (tabView.getTop() + tabView.getBottom()) / 2;
        int n5 = n3 / 2;
        n3 = n2 / 2;
        return new RectF((float)(n2 - (n /= 2)), (float)(n4 - n5), (float)(n + n2), (float)(n4 + n3));
    }

    void setIndicatorBoundsForOffset(TabLayout tabLayout, View view, View view2, float f, Drawable drawable2) {
        view = TabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, view);
        tabLayout = TabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, view2);
        drawable2.setBounds(AnimationUtils.lerp((int)view.left, (int)((RectF)tabLayout).left, f), drawable2.getBounds().top, AnimationUtils.lerp((int)view.right, (int)((RectF)tabLayout).right, f), drawable2.getBounds().bottom);
    }

    void setIndicatorBoundsForTab(TabLayout tabLayout, View view, Drawable drawable2) {
        tabLayout = TabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, view);
        drawable2.setBounds((int)((RectF)tabLayout).left, drawable2.getBounds().top, (int)((RectF)tabLayout).right, drawable2.getBounds().bottom);
    }
}

