/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tabs;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.R;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.TooltipCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.Pools;
import androidx.core.view.MarginLayoutParamsCompat;
import androidx.core.view.PointerIconCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.widget.TextViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.badge.BadgeUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.ripple.RippleUtils;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.MaterialShapeUtils;
import com.google.android.material.tabs.ElasticTabIndicatorInterpolator;
import com.google.android.material.tabs.TabIndicatorInterpolator;
import com.google.android.material.tabs.TabItem;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

@ViewPager.DecorView
public class TabLayout
extends HorizontalScrollView {
    private static final int ANIMATION_DURATION = 300;
    static final int DEFAULT_GAP_TEXT_ICON = 8;
    private static final int DEFAULT_HEIGHT = 48;
    private static final int DEFAULT_HEIGHT_WITH_TEXT_ICON = 72;
    private static final int DEF_STYLE_RES = R.style.Widget_Design_TabLayout;
    static final int FIXED_WRAP_GUTTER_MIN = 16;
    public static final int GRAVITY_CENTER = 1;
    public static final int GRAVITY_FILL = 0;
    public static final int GRAVITY_START = 2;
    public static final int INDICATOR_ANIMATION_MODE_ELASTIC = 1;
    public static final int INDICATOR_ANIMATION_MODE_LINEAR = 0;
    public static final int INDICATOR_GRAVITY_BOTTOM = 0;
    public static final int INDICATOR_GRAVITY_CENTER = 1;
    public static final int INDICATOR_GRAVITY_STRETCH = 3;
    public static final int INDICATOR_GRAVITY_TOP = 2;
    private static final int INVALID_WIDTH = -1;
    private static final String LOG_TAG = "TabLayout";
    public static final int MODE_AUTO = 2;
    public static final int MODE_FIXED = 1;
    public static final int MODE_SCROLLABLE = 0;
    public static final int TAB_LABEL_VISIBILITY_LABELED = 1;
    public static final int TAB_LABEL_VISIBILITY_UNLABELED = 0;
    private static final int TAB_MIN_WIDTH_MARGIN = 56;
    private static final Pools.Pool<Tab> tabPool = new Pools.SynchronizedPool(16);
    private AdapterChangeListener adapterChangeListener;
    private int contentInsetStart;
    private BaseOnTabSelectedListener currentVpSelectedListener;
    boolean inlineLabel;
    int mode;
    private TabLayoutOnPageChangeListener pageChangeListener;
    private PagerAdapter pagerAdapter;
    private DataSetObserver pagerAdapterObserver;
    private final int requestedTabMaxWidth;
    private final int requestedTabMinWidth;
    private ValueAnimator scrollAnimator;
    private final int scrollableTabMinWidth;
    private BaseOnTabSelectedListener selectedListener;
    private final ArrayList<BaseOnTabSelectedListener> selectedListeners;
    private Tab selectedTab;
    private boolean setupViewPagerImplicitly;
    final SlidingTabIndicator slidingTabIndicator;
    final int tabBackgroundResId;
    int tabGravity;
    ColorStateList tabIconTint;
    PorterDuff.Mode tabIconTintMode;
    int tabIndicatorAnimationDuration;
    int tabIndicatorAnimationMode;
    boolean tabIndicatorFullWidth;
    int tabIndicatorGravity;
    int tabIndicatorHeight;
    private TabIndicatorInterpolator tabIndicatorInterpolator;
    int tabMaxWidth;
    int tabPaddingBottom;
    int tabPaddingEnd;
    int tabPaddingStart;
    int tabPaddingTop;
    ColorStateList tabRippleColorStateList;
    Drawable tabSelectedIndicator;
    private int tabSelectedIndicatorColor;
    int tabTextAppearance;
    ColorStateList tabTextColors;
    float tabTextMultiLineSize;
    float tabTextSize;
    private final Pools.Pool<TabView> tabViewPool;
    private final ArrayList<Tab> tabs;
    boolean unboundedRipple;
    ViewPager viewPager;

    public TabLayout(Context context) {
        this(context, null);
    }

    public TabLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.tabStyle);
    }

    public TabLayout(Context context, AttributeSet attributeSet, int n) {
        SlidingTabIndicator slidingTabIndicator;
        block5: {
            int n2 = DEF_STYLE_RES;
            super(MaterialThemeOverlay.wrap(context, attributeSet, n, n2), attributeSet, n);
            this.tabs = new ArrayList();
            this.tabSelectedIndicator = new GradientDrawable();
            this.tabSelectedIndicatorColor = 0;
            this.tabMaxWidth = Integer.MAX_VALUE;
            this.tabIndicatorHeight = -1;
            this.selectedListeners = new ArrayList();
            this.tabViewPool = new Pools.SimplePool(12);
            context = this.getContext();
            this.setHorizontalScrollBarEnabled(false);
            this.slidingTabIndicator = slidingTabIndicator = new SlidingTabIndicator(context);
            super.addView((View)slidingTabIndicator, 0, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1));
            attributeSet = ThemeEnforcement.obtainStyledAttributes(context, attributeSet, R.styleable.TabLayout, n, n2, R.styleable.TabLayout_tabTextAppearance);
            if (this.getBackground() instanceof ColorDrawable) {
                ColorDrawable colorDrawable = (ColorDrawable)this.getBackground();
                MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable();
                materialShapeDrawable.setFillColor(ColorStateList.valueOf((int)colorDrawable.getColor()));
                materialShapeDrawable.initializeElevationOverlay(context);
                materialShapeDrawable.setElevation(ViewCompat.getElevation((View)this));
                ViewCompat.setBackground((View)this, (Drawable)materialShapeDrawable);
            }
            this.setSelectedTabIndicator(MaterialResources.getDrawable(context, (TypedArray)attributeSet, R.styleable.TabLayout_tabIndicator));
            this.setSelectedTabIndicatorColor(attributeSet.getColor(R.styleable.TabLayout_tabIndicatorColor, 0));
            slidingTabIndicator.setSelectedIndicatorHeight(attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabIndicatorHeight, -1));
            this.setSelectedTabIndicatorGravity(attributeSet.getInt(R.styleable.TabLayout_tabIndicatorGravity, 0));
            this.setTabIndicatorAnimationMode(attributeSet.getInt(R.styleable.TabLayout_tabIndicatorAnimationMode, 0));
            this.setTabIndicatorFullWidth(attributeSet.getBoolean(R.styleable.TabLayout_tabIndicatorFullWidth, true));
            this.tabPaddingBottom = n = attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabPadding, 0);
            this.tabPaddingEnd = n;
            this.tabPaddingTop = n;
            this.tabPaddingStart = n;
            this.tabPaddingStart = attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingStart, this.tabPaddingStart);
            this.tabPaddingTop = attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingTop, this.tabPaddingTop);
            this.tabPaddingEnd = attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingEnd, this.tabPaddingEnd);
            this.tabPaddingBottom = attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingBottom, this.tabPaddingBottom);
            this.tabTextAppearance = n = attributeSet.getResourceId(R.styleable.TabLayout_tabTextAppearance, R.style.TextAppearance_Design_Tab);
            slidingTabIndicator = context.obtainStyledAttributes(n, R.styleable.TextAppearance);
            this.tabTextSize = slidingTabIndicator.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
            this.tabTextColors = MaterialResources.getColorStateList(context, (TypedArray)slidingTabIndicator, R.styleable.TextAppearance_android_textColor);
            if (!attributeSet.hasValue(R.styleable.TabLayout_tabTextColor)) break block5;
            this.tabTextColors = MaterialResources.getColorStateList(context, (TypedArray)attributeSet, R.styleable.TabLayout_tabTextColor);
        }
        if (attributeSet.hasValue(R.styleable.TabLayout_tabSelectedTextColor)) {
            n = attributeSet.getColor(R.styleable.TabLayout_tabSelectedTextColor, 0);
            this.tabTextColors = TabLayout.createColorStateList(this.tabTextColors.getDefaultColor(), n);
        }
        this.tabIconTint = MaterialResources.getColorStateList(context, (TypedArray)attributeSet, R.styleable.TabLayout_tabIconTint);
        this.tabIconTintMode = ViewUtils.parseTintMode(attributeSet.getInt(R.styleable.TabLayout_tabIconTintMode, -1), null);
        this.tabRippleColorStateList = MaterialResources.getColorStateList(context, (TypedArray)attributeSet, R.styleable.TabLayout_tabRippleColor);
        this.tabIndicatorAnimationDuration = attributeSet.getInt(R.styleable.TabLayout_tabIndicatorAnimationDuration, 300);
        this.requestedTabMinWidth = attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabMinWidth, -1);
        this.requestedTabMaxWidth = attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabMaxWidth, -1);
        this.tabBackgroundResId = attributeSet.getResourceId(R.styleable.TabLayout_tabBackground, 0);
        this.contentInsetStart = attributeSet.getDimensionPixelSize(R.styleable.TabLayout_tabContentStart, 0);
        this.mode = attributeSet.getInt(R.styleable.TabLayout_tabMode, 1);
        this.tabGravity = attributeSet.getInt(R.styleable.TabLayout_tabGravity, 0);
        this.inlineLabel = attributeSet.getBoolean(R.styleable.TabLayout_tabInlineLabel, false);
        this.unboundedRipple = attributeSet.getBoolean(R.styleable.TabLayout_tabUnboundedRipple, false);
        attributeSet.recycle();
        context = this.getResources();
        this.tabTextMultiLineSize = context.getDimensionPixelSize(R.dimen.design_tab_text_size_2line);
        this.scrollableTabMinWidth = context.getDimensionPixelSize(R.dimen.design_tab_scrollable_min_width);
        this.applyModeAndGravity();
        return;
        finally {
            slidingTabIndicator.recycle();
        }
    }

    private void addTabFromItemView(TabItem tabItem) {
        Tab tab = this.newTab();
        if (tabItem.text != null) {
            tab.setText(tabItem.text);
        }
        if (tabItem.icon != null) {
            tab.setIcon(tabItem.icon);
        }
        if (tabItem.customLayout != 0) {
            tab.setCustomView(tabItem.customLayout);
        }
        if (!TextUtils.isEmpty((CharSequence)tabItem.getContentDescription())) {
            tab.setContentDescription(tabItem.getContentDescription());
        }
        this.addTab(tab);
    }

    private void addTabView(Tab tab) {
        TabView tabView = tab.view;
        tabView.setSelected(false);
        tabView.setActivated(false);
        this.slidingTabIndicator.addView((View)tabView, tab.getPosition(), (ViewGroup.LayoutParams)this.createLayoutParamsForTabs());
    }

    private void addViewInternal(View view) {
        if (view instanceof TabItem) {
            this.addTabFromItemView((TabItem)view);
            return;
        }
        throw new IllegalArgumentException("Only TabItem instances can be added to TabLayout");
    }

    private void animateToTab(int n) {
        if (n == -1) {
            return;
        }
        if (this.getWindowToken() != null && ViewCompat.isLaidOut((View)this) && !this.slidingTabIndicator.childrenNeedLayout()) {
            int n2;
            int n3 = this.getScrollX();
            if (n3 != (n2 = this.calculateScrollXForTab(n, 0.0f))) {
                this.ensureScrollAnimator();
                this.scrollAnimator.setIntValues(new int[]{n3, n2});
                this.scrollAnimator.start();
            }
            this.slidingTabIndicator.animateIndicatorToPosition(n, this.tabIndicatorAnimationDuration);
            return;
        }
        this.setScrollPosition(n, 0.0f, true);
    }

    private void applyGravityForModeScrollable(int n) {
        block3: {
            block2: {
                block0: {
                    block1: {
                        if (n == 0) break block0;
                        if (n == 1) break block1;
                        if (n == 2) break block2;
                        break block3;
                    }
                    this.slidingTabIndicator.setGravity(1);
                    break block3;
                }
                Log.w((String)LOG_TAG, (String)"MODE_SCROLLABLE + GRAVITY_FILL is not supported, GRAVITY_START will be used instead");
            }
            this.slidingTabIndicator.setGravity(0x800003);
        }
    }

    private void applyModeAndGravity() {
        int n = this.mode;
        n = n != 0 && n != 2 ? 0 : Math.max(0, this.contentInsetStart - this.tabPaddingStart);
        ViewCompat.setPaddingRelative((View)this.slidingTabIndicator, (int)n, (int)0, (int)0, (int)0);
        n = this.mode;
        if (n != 0) {
            if (n == 1 || n == 2) {
                if (this.tabGravity == 2) {
                    Log.w((String)LOG_TAG, (String)"GRAVITY_START is not supported with the current tab mode, GRAVITY_CENTER will be used instead");
                }
                this.slidingTabIndicator.setGravity(1);
            }
        } else {
            this.applyGravityForModeScrollable(this.tabGravity);
        }
        this.updateTabViews(true);
    }

    private int calculateScrollXForTab(int n, float f) {
        int n2 = this.mode;
        int n3 = 0;
        if (n2 != 0 && n2 != 2) {
            return 0;
        }
        View view = this.slidingTabIndicator.getChildAt(n);
        if (view == null) {
            return 0;
        }
        View view2 = ++n < this.slidingTabIndicator.getChildCount() ? this.slidingTabIndicator.getChildAt(n) : null;
        n2 = view.getWidth();
        n = n3;
        if (view2 != null) {
            n = view2.getWidth();
        }
        n3 = view.getLeft() + n2 / 2 - this.getWidth() / 2;
        n = (int)((float)(n2 + n) * 0.5f * f);
        n = ViewCompat.getLayoutDirection((View)this) == 0 ? n3 + n : n3 - n;
        return n;
    }

    private void configureTab(Tab tab, int n) {
        tab.setPosition(n);
        this.tabs.add(n, tab);
        int n2 = this.tabs.size();
        while (++n < n2) {
            this.tabs.get(n).setPosition(n);
        }
    }

    private static ColorStateList createColorStateList(int n, int n2) {
        return new ColorStateList((int[][])new int[][]{SELECTED_STATE_SET, EMPTY_STATE_SET}, new int[]{n2, n});
    }

    private LinearLayout.LayoutParams createLayoutParamsForTabs() {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
        this.updateTabViewLayoutParams(layoutParams);
        return layoutParams;
    }

    private TabView createTabView(Tab tab) {
        Object object = this.tabViewPool;
        object = object != null ? (TabView)((Object)object.acquire()) : null;
        Object object2 = object;
        if (object == null) {
            object2 = new TabView(this.getContext());
        }
        object2.setTab(tab);
        object2.setFocusable(true);
        object2.setMinimumWidth(this.getTabMinWidth());
        if (TextUtils.isEmpty((CharSequence)tab.contentDesc)) {
            object2.setContentDescription(tab.text);
        } else {
            object2.setContentDescription(tab.contentDesc);
        }
        return object2;
    }

    private void dispatchTabReselected(Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabReselected(tab);
        }
    }

    private void dispatchTabSelected(Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabSelected(tab);
        }
    }

    private void dispatchTabUnselected(Tab tab) {
        for (int i = this.selectedListeners.size() - 1; i >= 0; --i) {
            this.selectedListeners.get(i).onTabUnselected(tab);
        }
    }

    private void ensureScrollAnimator() {
        if (this.scrollAnimator == null) {
            ValueAnimator valueAnimator;
            this.scrollAnimator = valueAnimator = new ValueAnimator();
            valueAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.scrollAnimator.setDuration((long)this.tabIndicatorAnimationDuration);
            this.scrollAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    TabLayout.this.scrollTo((Integer)valueAnimator.getAnimatedValue(), 0);
                }
            });
        }
    }

    private int getDefaultHeight() {
        int n;
        int n2 = this.tabs.size();
        int n3 = 0;
        int n4 = 0;
        while (true) {
            n = n3;
            if (n4 >= n2) break;
            Tab tab = this.tabs.get(n4);
            if (tab != null && tab.getIcon() != null && !TextUtils.isEmpty((CharSequence)tab.getText())) {
                n = 1;
                break;
            }
            ++n4;
        }
        n = n != 0 && !this.inlineLabel ? 72 : 48;
        return n;
    }

    private int getTabMinWidth() {
        int n = this.requestedTabMinWidth;
        if (n != -1) {
            return n;
        }
        n = this.mode;
        n = n != 0 && n != 2 ? 0 : this.scrollableTabMinWidth;
        return n;
    }

    private int getTabScrollRange() {
        return Math.max(0, this.slidingTabIndicator.getWidth() - this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
    }

    private void removeTabViewAt(int n) {
        TabView tabView = (TabView)this.slidingTabIndicator.getChildAt(n);
        this.slidingTabIndicator.removeViewAt(n);
        if (tabView != null) {
            tabView.reset();
            this.tabViewPool.release((Object)tabView);
        }
        this.requestLayout();
    }

    private void setSelectedTabView(int n) {
        int n2 = this.slidingTabIndicator.getChildCount();
        if (n < n2) {
            for (int i = 0; i < n2; ++i) {
                View view = this.slidingTabIndicator.getChildAt(i);
                boolean bl = true;
                boolean bl2 = i == n;
                view.setSelected(bl2);
                bl2 = i == n ? bl : false;
                view.setActivated(bl2);
            }
        }
    }

    private void setupWithViewPager(ViewPager viewPager, boolean bl, boolean bl2) {
        Object object = this.viewPager;
        if (object != null) {
            TabLayoutOnPageChangeListener tabLayoutOnPageChangeListener = this.pageChangeListener;
            if (tabLayoutOnPageChangeListener != null) {
                object.removeOnPageChangeListener((ViewPager.OnPageChangeListener)tabLayoutOnPageChangeListener);
            }
            if ((object = this.adapterChangeListener) != null) {
                this.viewPager.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)object);
            }
        }
        if ((object = this.currentVpSelectedListener) != null) {
            this.removeOnTabSelectedListener((BaseOnTabSelectedListener)object);
            this.currentVpSelectedListener = null;
        }
        if (viewPager != null) {
            this.viewPager = viewPager;
            if (this.pageChangeListener == null) {
                this.pageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            this.pageChangeListener.reset();
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageChangeListener);
            object = new ViewPagerOnTabSelectedListener(viewPager);
            this.currentVpSelectedListener = object;
            this.addOnTabSelectedListener((BaseOnTabSelectedListener)object);
            object = viewPager.getAdapter();
            if (object != null) {
                this.setPagerAdapter((PagerAdapter)object, bl);
            }
            if (this.adapterChangeListener == null) {
                this.adapterChangeListener = new AdapterChangeListener();
            }
            this.adapterChangeListener.setAutoRefresh(bl);
            viewPager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.adapterChangeListener);
            this.setScrollPosition(viewPager.getCurrentItem(), 0.0f, true);
        } else {
            this.viewPager = null;
            this.setPagerAdapter(null, false);
        }
        this.setupViewPagerImplicitly = bl2;
    }

    private void updateAllTabs() {
        int n = this.tabs.size();
        for (int i = 0; i < n; ++i) {
            this.tabs.get(i).updateView();
        }
    }

    private void updateTabViewLayoutParams(LinearLayout.LayoutParams layoutParams) {
        if (this.mode == 1 && this.tabGravity == 0) {
            layoutParams.width = 0;
            layoutParams.weight = 1.0f;
        } else {
            layoutParams.width = -2;
            layoutParams.weight = 0.0f;
        }
    }

    @Deprecated
    public void addOnTabSelectedListener(BaseOnTabSelectedListener baseOnTabSelectedListener) {
        if (!this.selectedListeners.contains(baseOnTabSelectedListener)) {
            this.selectedListeners.add(baseOnTabSelectedListener);
        }
    }

    public void addOnTabSelectedListener(OnTabSelectedListener onTabSelectedListener) {
        this.addOnTabSelectedListener((BaseOnTabSelectedListener)onTabSelectedListener);
    }

    public void addTab(Tab tab) {
        this.addTab(tab, this.tabs.isEmpty());
    }

    public void addTab(Tab tab, int n) {
        this.addTab(tab, n, this.tabs.isEmpty());
    }

    public void addTab(Tab tab, int n, boolean bl) {
        if (tab.parent == this) {
            this.configureTab(tab, n);
            this.addTabView(tab);
            if (bl) {
                tab.select();
            }
            return;
        }
        throw new IllegalArgumentException("Tab belongs to a different TabLayout.");
    }

    public void addTab(Tab tab, boolean bl) {
        this.addTab(tab, this.tabs.size(), bl);
    }

    public void addView(View view) {
        this.addViewInternal(view);
    }

    public void addView(View view, int n) {
        this.addViewInternal(view);
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        this.addViewInternal(view);
    }

    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        this.addViewInternal(view);
    }

    public void clearOnTabSelectedListeners() {
        this.selectedListeners.clear();
    }

    protected Tab createTabFromPool() {
        Tab tab;
        Tab tab2 = tab = (Tab)tabPool.acquire();
        if (tab == null) {
            tab2 = new Tab();
        }
        return tab2;
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return this.generateDefaultLayoutParams();
    }

    public int getSelectedTabPosition() {
        Tab tab = this.selectedTab;
        int n = tab != null ? tab.getPosition() : -1;
        return n;
    }

    public Tab getTabAt(int n) {
        Tab tab = n >= 0 && n < this.getTabCount() ? this.tabs.get(n) : null;
        return tab;
    }

    public int getTabCount() {
        return this.tabs.size();
    }

    public int getTabGravity() {
        return this.tabGravity;
    }

    public ColorStateList getTabIconTint() {
        return this.tabIconTint;
    }

    public int getTabIndicatorAnimationMode() {
        return this.tabIndicatorAnimationMode;
    }

    public int getTabIndicatorGravity() {
        return this.tabIndicatorGravity;
    }

    int getTabMaxWidth() {
        return this.tabMaxWidth;
    }

    public int getTabMode() {
        return this.mode;
    }

    public ColorStateList getTabRippleColor() {
        return this.tabRippleColorStateList;
    }

    public Drawable getTabSelectedIndicator() {
        return this.tabSelectedIndicator;
    }

    public ColorStateList getTabTextColors() {
        return this.tabTextColors;
    }

    public boolean hasUnboundedRipple() {
        return this.unboundedRipple;
    }

    public boolean isInlineLabel() {
        return this.inlineLabel;
    }

    public boolean isTabIndicatorFullWidth() {
        return this.tabIndicatorFullWidth;
    }

    public Tab newTab() {
        Tab tab = this.createTabFromPool();
        tab.parent = this;
        tab.view = this.createTabView(tab);
        if (tab.id != -1) {
            tab.view.setId(tab.id);
        }
        return tab;
    }

    protected void onAttachedToWindow() {
        ViewParent viewParent;
        super.onAttachedToWindow();
        MaterialShapeUtils.setParentAbsoluteElevation((View)this);
        if (this.viewPager == null && (viewParent = this.getParent()) instanceof ViewPager) {
            this.setupWithViewPager((ViewPager)viewParent, true, true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.setupViewPagerImplicitly) {
            this.setupWithViewPager(null);
            this.setupViewPagerImplicitly = false;
        }
    }

    protected void onDraw(Canvas canvas) {
        for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
            View view = this.slidingTabIndicator.getChildAt(i);
            if (!(view instanceof TabView)) continue;
            ((TabView)view).drawBackground(canvas);
        }
        super.onDraw(canvas);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)accessibilityNodeInfo).setCollectionInfo((Object)AccessibilityNodeInfoCompat.CollectionInfoCompat.obtain((int)1, (int)this.getTabCount(), (boolean)false, (int)1));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n, int n2) {
        block10: {
            View view;
            int n3;
            block13: {
                block14: {
                    int n4;
                    block11: {
                        block12: {
                            int n5 = Math.round(ViewUtils.dpToPx(this.getContext(), this.getDefaultHeight()));
                            n3 = View.MeasureSpec.getMode((int)n2);
                            n4 = 0;
                            if (n3 != Integer.MIN_VALUE) {
                                n3 = n3 != 0 ? n2 : View.MeasureSpec.makeMeasureSpec((int)(n5 + this.getPaddingTop() + this.getPaddingBottom()), (int)0x40000000);
                            } else {
                                n3 = n2;
                                if (this.getChildCount() == 1) {
                                    n3 = n2;
                                    if (View.MeasureSpec.getSize((int)n2) >= n5) {
                                        this.getChildAt(0).setMinimumHeight(n5);
                                        n3 = n2;
                                    }
                                }
                            }
                            n5 = View.MeasureSpec.getSize((int)n);
                            if (View.MeasureSpec.getMode((int)n) != 0) {
                                n2 = this.requestedTabMaxWidth;
                                if (n2 <= 0) {
                                    n2 = (int)((float)n5 - ViewUtils.dpToPx(this.getContext(), 56));
                                }
                                this.tabMaxWidth = n2;
                            }
                            super.onMeasure(n, n3);
                            if (this.getChildCount() != 1) break block10;
                            view = this.getChildAt(0);
                            n = this.mode;
                            if (n == 0) break block11;
                            if (n == 1) break block12;
                            if (n == 2) break block11;
                            n = n4;
                            break block13;
                        }
                        n = n4;
                        if (view.getMeasuredWidth() == this.getMeasuredWidth()) break block13;
                        break block14;
                    }
                    n = n4;
                    if (view.getMeasuredWidth() >= this.getMeasuredWidth()) break block13;
                }
                n = 1;
            }
            if (n != 0) {
                n = TabLayout.getChildMeasureSpec((int)n3, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)view.getLayoutParams().height);
                view.measure(View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000), n);
            }
        }
    }

    void populateFromPagerAdapter() {
        this.removeAllTabs();
        PagerAdapter pagerAdapter = this.pagerAdapter;
        if (pagerAdapter != null) {
            int n;
            int n2 = pagerAdapter.getCount();
            for (n = 0; n < n2; ++n) {
                this.addTab(this.newTab().setText(this.pagerAdapter.getPageTitle(n)), false);
            }
            pagerAdapter = this.viewPager;
            if (pagerAdapter != null && n2 > 0 && (n = pagerAdapter.getCurrentItem()) != this.getSelectedTabPosition() && n < this.getTabCount()) {
                this.selectTab(this.getTabAt(n));
            }
        }
    }

    protected boolean releaseFromTabPool(Tab tab) {
        return tabPool.release((Object)tab);
    }

    public void removeAllTabs() {
        for (int i = this.slidingTabIndicator.getChildCount() - 1; i >= 0; --i) {
            this.removeTabViewAt(i);
        }
        Iterator<Tab> iterator2 = this.tabs.iterator();
        while (iterator2.hasNext()) {
            Tab tab = iterator2.next();
            iterator2.remove();
            tab.reset();
            this.releaseFromTabPool(tab);
        }
        this.selectedTab = null;
    }

    @Deprecated
    public void removeOnTabSelectedListener(BaseOnTabSelectedListener baseOnTabSelectedListener) {
        this.selectedListeners.remove(baseOnTabSelectedListener);
    }

    public void removeOnTabSelectedListener(OnTabSelectedListener onTabSelectedListener) {
        this.removeOnTabSelectedListener((BaseOnTabSelectedListener)onTabSelectedListener);
    }

    public void removeTab(Tab tab) {
        if (tab.parent == this) {
            this.removeTabAt(tab.getPosition());
            return;
        }
        throw new IllegalArgumentException("Tab does not belong to this TabLayout.");
    }

    public void removeTabAt(int n) {
        Tab tab = this.selectedTab;
        int n2 = tab != null ? tab.getPosition() : 0;
        this.removeTabViewAt(n);
        tab = this.tabs.remove(n);
        if (tab != null) {
            tab.reset();
            this.releaseFromTabPool(tab);
        }
        int n3 = this.tabs.size();
        for (int i = n; i < n3; ++i) {
            this.tabs.get(i).setPosition(i);
        }
        if (n2 == n) {
            tab = this.tabs.isEmpty() ? null : this.tabs.get(Math.max(0, n - 1));
            this.selectTab(tab);
        }
    }

    public void selectTab(Tab tab) {
        this.selectTab(tab, true);
    }

    public void selectTab(Tab tab, boolean bl) {
        Tab tab2 = this.selectedTab;
        if (tab2 == tab) {
            if (tab2 != null) {
                this.dispatchTabReselected(tab);
                this.animateToTab(tab.getPosition());
            }
        } else {
            int n = tab != null ? tab.getPosition() : -1;
            if (bl) {
                if ((tab2 == null || tab2.getPosition() == -1) && n != -1) {
                    this.setScrollPosition(n, 0.0f, true);
                } else {
                    this.animateToTab(n);
                }
                if (n != -1) {
                    this.setSelectedTabView(n);
                }
            }
            this.selectedTab = tab;
            if (tab2 != null) {
                this.dispatchTabUnselected(tab2);
            }
            if (tab != null) {
                this.dispatchTabSelected(tab);
            }
        }
    }

    public void setElevation(float f) {
        super.setElevation(f);
        MaterialShapeUtils.setElevation((View)this, f);
    }

    public void setInlineLabel(boolean bl) {
        if (this.inlineLabel != bl) {
            this.inlineLabel = bl;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                View view = this.slidingTabIndicator.getChildAt(i);
                if (!(view instanceof TabView)) continue;
                ((TabView)view).updateOrientation();
            }
            this.applyModeAndGravity();
        }
    }

    public void setInlineLabelResource(int n) {
        this.setInlineLabel(this.getResources().getBoolean(n));
    }

    @Deprecated
    public void setOnTabSelectedListener(BaseOnTabSelectedListener baseOnTabSelectedListener) {
        BaseOnTabSelectedListener baseOnTabSelectedListener2 = this.selectedListener;
        if (baseOnTabSelectedListener2 != null) {
            this.removeOnTabSelectedListener(baseOnTabSelectedListener2);
        }
        this.selectedListener = baseOnTabSelectedListener;
        if (baseOnTabSelectedListener != null) {
            this.addOnTabSelectedListener(baseOnTabSelectedListener);
        }
    }

    @Deprecated
    public void setOnTabSelectedListener(OnTabSelectedListener onTabSelectedListener) {
        this.setOnTabSelectedListener((BaseOnTabSelectedListener)onTabSelectedListener);
    }

    void setPagerAdapter(PagerAdapter pagerAdapter, boolean bl) {
        DataSetObserver dataSetObserver;
        PagerAdapter pagerAdapter2 = this.pagerAdapter;
        if (pagerAdapter2 != null && (dataSetObserver = this.pagerAdapterObserver) != null) {
            pagerAdapter2.unregisterDataSetObserver(dataSetObserver);
        }
        this.pagerAdapter = pagerAdapter;
        if (bl && pagerAdapter != null) {
            if (this.pagerAdapterObserver == null) {
                this.pagerAdapterObserver = new PagerAdapterObserver();
            }
            pagerAdapter.registerDataSetObserver(this.pagerAdapterObserver);
        }
        this.populateFromPagerAdapter();
    }

    void setScrollAnimatorListener(Animator.AnimatorListener animatorListener) {
        this.ensureScrollAnimator();
        this.scrollAnimator.addListener(animatorListener);
    }

    public void setScrollPosition(int n, float f, boolean bl) {
        this.setScrollPosition(n, f, bl, true);
    }

    public void setScrollPosition(int n, float f, boolean bl, boolean bl2) {
        int n2 = Math.round((float)n + f);
        if (n2 >= 0 && n2 < this.slidingTabIndicator.getChildCount()) {
            ValueAnimator valueAnimator;
            if (bl2) {
                this.slidingTabIndicator.setIndicatorPositionFromTabPosition(n, f);
            }
            if ((valueAnimator = this.scrollAnimator) != null && valueAnimator.isRunning()) {
                this.scrollAnimator.cancel();
            }
            n = n < 0 ? 0 : this.calculateScrollXForTab(n, f);
            this.scrollTo(n, 0);
            if (bl) {
                this.setSelectedTabView(n2);
            }
        }
    }

    public void setSelectedTabIndicator(int n) {
        if (n != 0) {
            this.setSelectedTabIndicator(AppCompatResources.getDrawable((Context)this.getContext(), (int)n));
        } else {
            this.setSelectedTabIndicator(null);
        }
    }

    public void setSelectedTabIndicator(Drawable drawable2) {
        if (this.tabSelectedIndicator != drawable2) {
            if (drawable2 == null) {
                drawable2 = new GradientDrawable();
            }
            this.tabSelectedIndicator = drawable2;
            int n = this.tabIndicatorHeight;
            if (n == -1) {
                n = drawable2.getIntrinsicHeight();
            }
            this.slidingTabIndicator.setSelectedIndicatorHeight(n);
        }
    }

    public void setSelectedTabIndicatorColor(int n) {
        this.tabSelectedIndicatorColor = n;
        this.updateTabViews(false);
    }

    public void setSelectedTabIndicatorGravity(int n) {
        if (this.tabIndicatorGravity != n) {
            this.tabIndicatorGravity = n;
            ViewCompat.postInvalidateOnAnimation((View)this.slidingTabIndicator);
        }
    }

    @Deprecated
    public void setSelectedTabIndicatorHeight(int n) {
        this.tabIndicatorHeight = n;
        this.slidingTabIndicator.setSelectedIndicatorHeight(n);
    }

    public void setTabGravity(int n) {
        if (this.tabGravity != n) {
            this.tabGravity = n;
            this.applyModeAndGravity();
        }
    }

    public void setTabIconTint(ColorStateList colorStateList) {
        if (this.tabIconTint != colorStateList) {
            this.tabIconTint = colorStateList;
            this.updateAllTabs();
        }
    }

    public void setTabIconTintResource(int n) {
        this.setTabIconTint(AppCompatResources.getColorStateList((Context)this.getContext(), (int)n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTabIndicatorAnimationMode(int n) {
        this.tabIndicatorAnimationMode = n;
        if (n == 0) {
            this.tabIndicatorInterpolator = new TabIndicatorInterpolator();
            return;
        }
        if (n == 1) {
            this.tabIndicatorInterpolator = new ElasticTabIndicatorInterpolator();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(" is not a valid TabIndicatorAnimationMode");
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void setTabIndicatorFullWidth(boolean bl) {
        this.tabIndicatorFullWidth = bl;
        this.slidingTabIndicator.jumpIndicatorToSelectedPosition();
        ViewCompat.postInvalidateOnAnimation((View)this.slidingTabIndicator);
    }

    public void setTabMode(int n) {
        if (n != this.mode) {
            this.mode = n;
            this.applyModeAndGravity();
        }
    }

    public void setTabRippleColor(ColorStateList colorStateList) {
        if (this.tabRippleColorStateList != colorStateList) {
            this.tabRippleColorStateList = colorStateList;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                colorStateList = this.slidingTabIndicator.getChildAt(i);
                if (!(colorStateList instanceof TabView)) continue;
                ((TabView)colorStateList).updateBackgroundDrawable(this.getContext());
            }
        }
    }

    public void setTabRippleColorResource(int n) {
        this.setTabRippleColor(AppCompatResources.getColorStateList((Context)this.getContext(), (int)n));
    }

    public void setTabTextColors(int n, int n2) {
        this.setTabTextColors(TabLayout.createColorStateList(n, n2));
    }

    public void setTabTextColors(ColorStateList colorStateList) {
        if (this.tabTextColors != colorStateList) {
            this.tabTextColors = colorStateList;
            this.updateAllTabs();
        }
    }

    @Deprecated
    public void setTabsFromPagerAdapter(PagerAdapter pagerAdapter) {
        this.setPagerAdapter(pagerAdapter, false);
    }

    public void setUnboundedRipple(boolean bl) {
        if (this.unboundedRipple != bl) {
            this.unboundedRipple = bl;
            for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
                View view = this.slidingTabIndicator.getChildAt(i);
                if (!(view instanceof TabView)) continue;
                ((TabView)view).updateBackgroundDrawable(this.getContext());
            }
        }
    }

    public void setUnboundedRippleResource(int n) {
        this.setUnboundedRipple(this.getResources().getBoolean(n));
    }

    public void setupWithViewPager(ViewPager viewPager) {
        this.setupWithViewPager(viewPager, true);
    }

    public void setupWithViewPager(ViewPager viewPager, boolean bl) {
        this.setupWithViewPager(viewPager, bl, false);
    }

    public boolean shouldDelayChildPressedState() {
        boolean bl = this.getTabScrollRange() > 0;
        return bl;
    }

    void updateTabViews(boolean bl) {
        for (int i = 0; i < this.slidingTabIndicator.getChildCount(); ++i) {
            View view = this.slidingTabIndicator.getChildAt(i);
            view.setMinimumWidth(this.getTabMinWidth());
            this.updateTabViewLayoutParams((LinearLayout.LayoutParams)view.getLayoutParams());
            if (!bl) continue;
            view.requestLayout();
        }
    }

    private class AdapterChangeListener
    implements ViewPager.OnAdapterChangeListener {
        private boolean autoRefresh;

        AdapterChangeListener() {
        }

        public void onAdapterChanged(ViewPager viewPager, PagerAdapter pagerAdapter, PagerAdapter pagerAdapter2) {
            if (TabLayout.this.viewPager == viewPager) {
                TabLayout.this.setPagerAdapter(pagerAdapter2, this.autoRefresh);
            }
        }

        void setAutoRefresh(boolean bl) {
            this.autoRefresh = bl;
        }
    }

    @Deprecated
    public static interface BaseOnTabSelectedListener<T extends Tab> {
        public void onTabReselected(T var1);

        public void onTabSelected(T var1);

        public void onTabUnselected(T var1);
    }

    public static @interface LabelVisibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }

    public static interface OnTabSelectedListener
    extends BaseOnTabSelectedListener<Tab> {
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        PagerAdapterObserver() {
        }

        public void onChanged() {
            TabLayout.this.populateFromPagerAdapter();
        }

        public void onInvalidated() {
            TabLayout.this.populateFromPagerAdapter();
        }
    }

    class SlidingTabIndicator
    extends LinearLayout {
        ValueAnimator indicatorAnimator;
        private int layoutDirection;
        int selectedPosition;
        float selectionOffset;

        SlidingTabIndicator(Context context) {
            super(context);
            this.selectedPosition = -1;
            this.layoutDirection = -1;
            this.setWillNotDraw(false);
        }

        private void jumpIndicatorToSelectedPosition() {
            View view = this.getChildAt(this.selectedPosition);
            TabIndicatorInterpolator tabIndicatorInterpolator = TabLayout.this.tabIndicatorInterpolator;
            TabLayout tabLayout = TabLayout.this;
            tabIndicatorInterpolator.setIndicatorBoundsForTab(tabLayout, view, tabLayout.tabSelectedIndicator);
        }

        private void tweenIndicatorPosition(View view, View view2, float f) {
            boolean bl = view != null && view.getWidth() > 0;
            if (bl) {
                TabIndicatorInterpolator tabIndicatorInterpolator = TabLayout.this.tabIndicatorInterpolator;
                TabLayout tabLayout = TabLayout.this;
                tabIndicatorInterpolator.setIndicatorBoundsForOffset(tabLayout, view, view2, f, tabLayout.tabSelectedIndicator);
            } else {
                TabLayout.this.tabSelectedIndicator.setBounds(-1, TabLayout.this.tabSelectedIndicator.getBounds().top, -1, TabLayout.this.tabSelectedIndicator.getBounds().bottom);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }

        private void updateOrRecreateIndicatorAnimation(boolean bl, final int n, int n2) {
            final View view = this.getChildAt(this.selectedPosition);
            Object object = this.getChildAt(n);
            if (object == null) {
                this.jumpIndicatorToSelectedPosition();
                return;
            }
            object = new ValueAnimator.AnimatorUpdateListener((View)object){
                final /* synthetic */ View val$targetView;
                {
                    this.val$targetView = view2;
                }

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    SlidingTabIndicator.this.tweenIndicatorPosition(view, this.val$targetView, valueAnimator.getAnimatedFraction());
                }
            };
            if (bl) {
                view = new ValueAnimator();
                this.indicatorAnimator = view;
                view.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                view.setDuration((long)n2);
                view.setFloatValues(new float[]{0.0f, 1.0f});
                view.addUpdateListener((ValueAnimator.AnimatorUpdateListener)object);
                view.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animator2) {
                        SlidingTabIndicator.this.selectedPosition = n;
                    }

                    public void onAnimationStart(Animator animator2) {
                        SlidingTabIndicator.this.selectedPosition = n;
                    }
                });
                view.start();
            } else {
                this.indicatorAnimator.removeAllUpdateListeners();
                this.indicatorAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)object);
            }
        }

        void animateIndicatorToPosition(int n, int n2) {
            ValueAnimator valueAnimator = this.indicatorAnimator;
            if (valueAnimator != null && valueAnimator.isRunning()) {
                this.indicatorAnimator.cancel();
            }
            this.updateOrRecreateIndicatorAnimation(true, n, n2);
        }

        boolean childrenNeedLayout() {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (this.getChildAt(i).getWidth() > 0) continue;
                return true;
            }
            return false;
        }

        public void draw(Canvas canvas) {
            int n;
            int n2 = n = TabLayout.this.tabSelectedIndicator.getBounds().height();
            if (n < 0) {
                n2 = TabLayout.this.tabSelectedIndicator.getIntrinsicHeight();
            }
            int n3 = TabLayout.this.tabIndicatorGravity;
            int n4 = 0;
            if (n3 != 0) {
                if (n3 != 1) {
                    n = n4;
                    if (n3 != 2) {
                        if (n3 != 3) {
                            n2 = 0;
                            n = n4;
                        } else {
                            n2 = this.getHeight();
                            n = n4;
                        }
                    }
                } else {
                    n = (this.getHeight() - n2) / 2;
                    n2 = (this.getHeight() + n2) / 2;
                }
            } else {
                n = this.getHeight() - n2;
                n2 = this.getHeight();
            }
            if (TabLayout.this.tabSelectedIndicator.getBounds().width() > 0) {
                Rect rect = TabLayout.this.tabSelectedIndicator.getBounds();
                TabLayout.this.tabSelectedIndicator.setBounds(rect.left, n, rect.right, n2);
                rect = TabLayout.this.tabSelectedIndicator;
                if (TabLayout.this.tabSelectedIndicatorColor != 0) {
                    rect = DrawableCompat.wrap((Drawable)rect);
                    if (Build.VERSION.SDK_INT == 21) {
                        rect.setColorFilter(TabLayout.this.tabSelectedIndicatorColor, PorterDuff.Mode.SRC_IN);
                    } else {
                        DrawableCompat.setTint((Drawable)rect, (int)TabLayout.this.tabSelectedIndicatorColor);
                    }
                } else if (Build.VERSION.SDK_INT == 21) {
                    rect.setColorFilter(null);
                } else {
                    DrawableCompat.setTintList((Drawable)rect, null);
                }
                rect.draw(canvas);
            }
            super.draw(canvas);
        }

        float getIndicatorPosition() {
            return (float)this.selectedPosition + this.selectionOffset;
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            super.onLayout(bl, n, n2, n3, n4);
            ValueAnimator valueAnimator = this.indicatorAnimator;
            if (valueAnimator != null && valueAnimator.isRunning()) {
                this.updateOrRecreateIndicatorAnimation(false, this.selectedPosition, -1);
            } else {
                this.jumpIndicatorToSelectedPosition();
            }
        }

        protected void onMeasure(int n, int n2) {
            super.onMeasure(n, n2);
            if (View.MeasureSpec.getMode((int)n) != 0x40000000) {
                return;
            }
            int n3 = TabLayout.this.tabGravity;
            int n4 = 1;
            if (n3 == 1 || TabLayout.this.mode == 2) {
                int n5;
                View view;
                int n6 = this.getChildCount();
                int n7 = 0;
                int n8 = 0;
                for (n3 = 0; n3 < n6; ++n3) {
                    view = this.getChildAt(n3);
                    n5 = n8;
                    if (view.getVisibility() == 0) {
                        n5 = Math.max(n8, view.getMeasuredWidth());
                    }
                    n8 = n5;
                }
                if (n8 <= 0) {
                    return;
                }
                n3 = (int)ViewUtils.dpToPx(this.getContext(), 16);
                if (n8 * n6 <= this.getMeasuredWidth() - n3 * 2) {
                    n3 = 0;
                    for (n5 = n7; n5 < n6; ++n5) {
                        view = (LinearLayout.LayoutParams)this.getChildAt(n5).getLayoutParams();
                        if (view.width == n8 && view.weight == 0.0f) continue;
                        view.width = n8;
                        view.weight = 0.0f;
                        n3 = 1;
                    }
                } else {
                    TabLayout.this.tabGravity = 0;
                    TabLayout.this.updateTabViews(false);
                    n3 = n4;
                }
                if (n3 != 0) {
                    super.onMeasure(n, n2);
                }
            }
        }

        public void onRtlPropertiesChanged(int n) {
            super.onRtlPropertiesChanged(n);
            if (Build.VERSION.SDK_INT < 23 && this.layoutDirection != n) {
                this.requestLayout();
                this.layoutDirection = n;
            }
        }

        void setIndicatorPositionFromTabPosition(int n, float f) {
            ValueAnimator valueAnimator = this.indicatorAnimator;
            if (valueAnimator != null && valueAnimator.isRunning()) {
                this.indicatorAnimator.cancel();
            }
            this.selectedPosition = n;
            this.selectionOffset = f;
            this.tweenIndicatorPosition(this.getChildAt(n), this.getChildAt(this.selectedPosition + 1), this.selectionOffset);
        }

        void setSelectedIndicatorHeight(int n) {
            Rect rect = TabLayout.this.tabSelectedIndicator.getBounds();
            TabLayout.this.tabSelectedIndicator.setBounds(rect.left, 0, rect.right, n);
            this.requestLayout();
        }
    }

    public static class Tab {
        public static final int INVALID_POSITION = -1;
        private CharSequence contentDesc;
        private View customView;
        private Drawable icon;
        private int id = -1;
        private int labelVisibilityMode = 1;
        public TabLayout parent;
        private int position = -1;
        private Object tag;
        private CharSequence text;
        public TabView view;

        public BadgeDrawable getBadge() {
            return this.view.getBadge();
        }

        public CharSequence getContentDescription() {
            Object object = this.view;
            object = object == null ? null : object.getContentDescription();
            return object;
        }

        public View getCustomView() {
            return this.customView;
        }

        public Drawable getIcon() {
            return this.icon;
        }

        public int getId() {
            return this.id;
        }

        public BadgeDrawable getOrCreateBadge() {
            return this.view.getOrCreateBadge();
        }

        public int getPosition() {
            return this.position;
        }

        public int getTabLabelVisibility() {
            return this.labelVisibilityMode;
        }

        public Object getTag() {
            return this.tag;
        }

        public CharSequence getText() {
            return this.text;
        }

        public boolean isSelected() {
            TabLayout tabLayout = this.parent;
            if (tabLayout != null) {
                int n = tabLayout.getSelectedTabPosition();
                boolean bl = n != -1 && n == this.position;
                return bl;
            }
            throw new IllegalArgumentException("Tab not attached to a TabLayout");
        }

        public void removeBadge() {
            this.view.removeBadge();
        }

        void reset() {
            this.parent = null;
            this.view = null;
            this.tag = null;
            this.icon = null;
            this.id = -1;
            this.text = null;
            this.contentDesc = null;
            this.position = -1;
            this.customView = null;
        }

        public void select() {
            TabLayout tabLayout = this.parent;
            if (tabLayout != null) {
                tabLayout.selectTab(this);
                return;
            }
            throw new IllegalArgumentException("Tab not attached to a TabLayout");
        }

        public Tab setContentDescription(int n) {
            TabLayout tabLayout = this.parent;
            if (tabLayout != null) {
                return this.setContentDescription(tabLayout.getResources().getText(n));
            }
            throw new IllegalArgumentException("Tab not attached to a TabLayout");
        }

        public Tab setContentDescription(CharSequence charSequence) {
            this.contentDesc = charSequence;
            this.updateView();
            return this;
        }

        public Tab setCustomView(int n) {
            return this.setCustomView(LayoutInflater.from((Context)this.view.getContext()).inflate(n, (ViewGroup)this.view, false));
        }

        public Tab setCustomView(View view) {
            this.customView = view;
            this.updateView();
            return this;
        }

        public Tab setIcon(int n) {
            TabLayout tabLayout = this.parent;
            if (tabLayout != null) {
                return this.setIcon(AppCompatResources.getDrawable((Context)tabLayout.getContext(), (int)n));
            }
            throw new IllegalArgumentException("Tab not attached to a TabLayout");
        }

        public Tab setIcon(Drawable drawable2) {
            this.icon = drawable2;
            if (this.parent.tabGravity == 1 || this.parent.mode == 2) {
                this.parent.updateTabViews(true);
            }
            this.updateView();
            if (BadgeUtils.USE_COMPAT_PARENT && this.view.hasBadgeDrawable() && this.view.badgeDrawable.isVisible()) {
                this.view.invalidate();
            }
            return this;
        }

        public Tab setId(int n) {
            this.id = n;
            TabView tabView = this.view;
            if (tabView != null) {
                tabView.setId(n);
            }
            return this;
        }

        void setPosition(int n) {
            this.position = n;
        }

        public Tab setTabLabelVisibility(int n) {
            this.labelVisibilityMode = n;
            if (this.parent.tabGravity == 1 || this.parent.mode == 2) {
                this.parent.updateTabViews(true);
            }
            this.updateView();
            if (BadgeUtils.USE_COMPAT_PARENT && this.view.hasBadgeDrawable() && this.view.badgeDrawable.isVisible()) {
                this.view.invalidate();
            }
            return this;
        }

        public Tab setTag(Object object) {
            this.tag = object;
            return this;
        }

        public Tab setText(int n) {
            TabLayout tabLayout = this.parent;
            if (tabLayout != null) {
                return this.setText(tabLayout.getResources().getText(n));
            }
            throw new IllegalArgumentException("Tab not attached to a TabLayout");
        }

        public Tab setText(CharSequence charSequence) {
            if (TextUtils.isEmpty((CharSequence)this.contentDesc) && !TextUtils.isEmpty((CharSequence)charSequence)) {
                this.view.setContentDescription(charSequence);
            }
            this.text = charSequence;
            this.updateView();
            return this;
        }

        void updateView() {
            TabView tabView = this.view;
            if (tabView != null) {
                tabView.update();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabGravity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabIndicatorAnimationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabIndicatorGravity {
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private int previousScrollState;
        private int scrollState;
        private final WeakReference<TabLayout> tabLayoutRef;

        public TabLayoutOnPageChangeListener(TabLayout tabLayout) {
            this.tabLayoutRef = new WeakReference<TabLayout>(tabLayout);
        }

        public void onPageScrollStateChanged(int n) {
            this.previousScrollState = this.scrollState;
            this.scrollState = n;
        }

        public void onPageScrolled(int n, float f, int n2) {
            TabLayout tabLayout = (TabLayout)((Object)this.tabLayoutRef.get());
            if (tabLayout != null) {
                n2 = this.scrollState;
                boolean bl = false;
                boolean bl2 = n2 != 2 || this.previousScrollState == 1;
                if (n2 != 2 || this.previousScrollState != 0) {
                    bl = true;
                }
                tabLayout.setScrollPosition(n, f, bl2, bl);
            }
        }

        public void onPageSelected(int n) {
            TabLayout tabLayout = (TabLayout)((Object)this.tabLayoutRef.get());
            if (tabLayout != null && tabLayout.getSelectedTabPosition() != n && n < tabLayout.getTabCount()) {
                int n2 = this.scrollState;
                boolean bl = n2 == 0 || n2 == 2 && this.previousScrollState == 0;
                tabLayout.selectTab(tabLayout.getTabAt(n), bl);
            }
        }

        void reset() {
            this.scrollState = 0;
            this.previousScrollState = 0;
        }
    }

    public final class TabView
    extends LinearLayout {
        private View badgeAnchorView;
        private BadgeDrawable badgeDrawable;
        private Drawable baseBackgroundDrawable;
        private ImageView customIconView;
        private TextView customTextView;
        private View customView;
        private int defaultMaxLines;
        private ImageView iconView;
        private Tab tab;
        private TextView textView;

        public TabView(Context context) {
            super(context);
            this.defaultMaxLines = 2;
            this.updateBackgroundDrawable(context);
            ViewCompat.setPaddingRelative((View)this, (int)TabLayout.this.tabPaddingStart, (int)TabLayout.this.tabPaddingTop, (int)TabLayout.this.tabPaddingEnd, (int)TabLayout.this.tabPaddingBottom);
            this.setGravity(17);
            this.setOrientation(TabLayout.this.inlineLabel ^ 1);
            this.setClickable(true);
            ViewCompat.setPointerIcon((View)this, (PointerIconCompat)PointerIconCompat.getSystemIcon((Context)this.getContext(), (int)1002));
        }

        private void addOnLayoutChangeListener(final View view) {
            if (view == null) {
                return;
            }
            view.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View view2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                    if (view.getVisibility() == 0) {
                        TabView.this.tryUpdateBadgeDrawableBounds(view);
                    }
                }
            });
        }

        private float approximateLineWidth(Layout layout2, int n, float f) {
            return layout2.getLineWidth(n) * (f / layout2.getPaint().getTextSize());
        }

        private void clipViewToPaddingForBadge(boolean bl) {
            this.setClipChildren(bl);
            this.setClipToPadding(bl);
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            if (viewGroup != null) {
                viewGroup.setClipChildren(bl);
                viewGroup.setClipToPadding(bl);
            }
        }

        private FrameLayout createPreApi18BadgeAnchorRoot() {
            FrameLayout frameLayout = new FrameLayout(this.getContext());
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            return frameLayout;
        }

        private void drawBackground(Canvas canvas) {
            Drawable drawable2 = this.baseBackgroundDrawable;
            if (drawable2 != null) {
                drawable2.setBounds(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
                this.baseBackgroundDrawable.draw(canvas);
            }
        }

        private BadgeDrawable getBadge() {
            return this.badgeDrawable;
        }

        private FrameLayout getCustomParentForBadge(View view) {
            ImageView imageView = this.iconView;
            FrameLayout frameLayout = null;
            if (view != imageView && view != this.textView) {
                return null;
            }
            if (BadgeUtils.USE_COMPAT_PARENT) {
                frameLayout = (FrameLayout)view.getParent();
            }
            return frameLayout;
        }

        private BadgeDrawable getOrCreateBadge() {
            if (this.badgeDrawable == null) {
                this.badgeDrawable = BadgeDrawable.create(this.getContext());
            }
            this.tryUpdateBadgeAnchor();
            BadgeDrawable badgeDrawable = this.badgeDrawable;
            if (badgeDrawable != null) {
                return badgeDrawable;
            }
            throw new IllegalStateException("Unable to create badge");
        }

        private boolean hasBadgeDrawable() {
            boolean bl = this.badgeDrawable != null;
            return bl;
        }

        private void inflateAndAddDefaultIconView() {
            ImageView imageView;
            TabView tabView;
            if (BadgeUtils.USE_COMPAT_PARENT) {
                tabView = this.createPreApi18BadgeAnchorRoot();
                this.addView((View)tabView, 0);
            } else {
                tabView = this;
            }
            this.iconView = imageView = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_icon, (ViewGroup)tabView, false);
            tabView.addView((View)imageView, 0);
        }

        private void inflateAndAddDefaultTextView() {
            TextView textView;
            TabView tabView;
            if (BadgeUtils.USE_COMPAT_PARENT) {
                tabView = this.createPreApi18BadgeAnchorRoot();
                this.addView((View)tabView);
            } else {
                tabView = this;
            }
            this.textView = textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_text, (ViewGroup)tabView, false);
            tabView.addView((View)textView);
        }

        private void removeBadge() {
            if (this.badgeAnchorView != null) {
                this.tryRemoveBadgeFromAnchor();
            }
            this.badgeDrawable = null;
        }

        private void tryAttachBadgeToAnchor(View view) {
            if (!this.hasBadgeDrawable()) {
                return;
            }
            if (view != null) {
                this.clipViewToPaddingForBadge(false);
                BadgeUtils.attachBadgeDrawable(this.badgeDrawable, view, this.getCustomParentForBadge(view));
                this.badgeAnchorView = view;
            }
        }

        private void tryRemoveBadgeFromAnchor() {
            if (!this.hasBadgeDrawable()) {
                return;
            }
            this.clipViewToPaddingForBadge(true);
            View view = this.badgeAnchorView;
            if (view != null) {
                BadgeUtils.detachBadgeDrawable(this.badgeDrawable, view);
                this.badgeAnchorView = null;
            }
        }

        private void tryUpdateBadgeAnchor() {
            Tab tab;
            if (!this.hasBadgeDrawable()) {
                return;
            }
            if (this.customView != null) {
                this.tryRemoveBadgeFromAnchor();
            } else if (this.iconView != null && (tab = this.tab) != null && tab.getIcon() != null) {
                tab = this.badgeAnchorView;
                ImageView imageView = this.iconView;
                if (tab != imageView) {
                    this.tryRemoveBadgeFromAnchor();
                    this.tryAttachBadgeToAnchor((View)this.iconView);
                } else {
                    this.tryUpdateBadgeDrawableBounds((View)imageView);
                }
            } else if (this.textView != null && (tab = this.tab) != null && tab.getTabLabelVisibility() == 1) {
                View view = this.badgeAnchorView;
                tab = this.textView;
                if (view != tab) {
                    this.tryRemoveBadgeFromAnchor();
                    this.tryAttachBadgeToAnchor((View)this.textView);
                } else {
                    this.tryUpdateBadgeDrawableBounds((View)tab);
                }
            } else {
                this.tryRemoveBadgeFromAnchor();
            }
        }

        private void tryUpdateBadgeDrawableBounds(View view) {
            if (this.hasBadgeDrawable() && view == this.badgeAnchorView) {
                BadgeUtils.setBadgeDrawableBounds(this.badgeDrawable, view, this.getCustomParentForBadge(view));
            }
        }

        private void updateBackgroundDrawable(Context context) {
            int n = TabLayout.this.tabBackgroundResId;
            Object var3_3 = null;
            if (n != 0) {
                context = AppCompatResources.getDrawable((Context)context, (int)TabLayout.this.tabBackgroundResId);
                this.baseBackgroundDrawable = context;
                if (context != null && context.isStateful()) {
                    this.baseBackgroundDrawable.setState(this.getDrawableState());
                }
            } else {
                this.baseBackgroundDrawable = null;
            }
            GradientDrawable gradientDrawable = new GradientDrawable();
            context = gradientDrawable;
            gradientDrawable.setColor(0);
            context = gradientDrawable;
            if (TabLayout.this.tabRippleColorStateList != null) {
                context = new GradientDrawable();
                context.setCornerRadius(1.0E-5f);
                context.setColor(-1);
                ColorStateList colorStateList = RippleUtils.convertToRippleDrawableColor(TabLayout.this.tabRippleColorStateList);
                if (Build.VERSION.SDK_INT >= 21) {
                    if (TabLayout.this.unboundedRipple) {
                        gradientDrawable = null;
                    }
                    if (TabLayout.this.unboundedRipple) {
                        context = var3_3;
                    }
                    context = new RippleDrawable(colorStateList, (Drawable)gradientDrawable, (Drawable)context);
                } else {
                    context = DrawableCompat.wrap((Drawable)context);
                    DrawableCompat.setTintList((Drawable)context, (ColorStateList)colorStateList);
                    context = new LayerDrawable(new Drawable[]{gradientDrawable, context});
                }
            }
            ViewCompat.setBackground((View)this, (Drawable)context);
            TabLayout.this.invalidate();
        }

        private void updateTextAndIcon(TextView object, ImageView object2) {
            Object object3 = this.tab;
            Object var4_4 = null;
            Drawable drawable2 = object3 != null && ((Tab)object3).getIcon() != null ? DrawableCompat.wrap((Drawable)this.tab.getIcon()).mutate() : null;
            if (drawable2 != null) {
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)TabLayout.this.tabIconTint);
                if (TabLayout.this.tabIconTintMode != null) {
                    DrawableCompat.setTintMode((Drawable)drawable2, (PorterDuff.Mode)TabLayout.this.tabIconTintMode);
                }
            }
            object3 = (object3 = this.tab) != null ? ((Tab)object3).getText() : null;
            if (object2 != null) {
                if (drawable2 != null) {
                    object2.setImageDrawable(drawable2);
                    object2.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    object2.setVisibility(8);
                    object2.setImageDrawable(null);
                }
            }
            boolean bl = TextUtils.isEmpty((CharSequence)object3) ^ true;
            if (object != null) {
                if (bl) {
                    object.setText((CharSequence)object3);
                    if (this.tab.labelVisibilityMode == 1) {
                        object.setVisibility(0);
                    } else {
                        object.setVisibility(8);
                    }
                    this.setVisibility(0);
                } else {
                    object.setVisibility(8);
                    object.setText(null);
                }
            }
            if (object2 != null) {
                object = (ViewGroup.MarginLayoutParams)object2.getLayoutParams();
                int n = bl && object2.getVisibility() == 0 ? (int)ViewUtils.dpToPx(this.getContext(), 8) : 0;
                if (TabLayout.this.inlineLabel) {
                    if (n != MarginLayoutParamsCompat.getMarginEnd((ViewGroup.MarginLayoutParams)object)) {
                        MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)object, (int)n);
                        object.bottomMargin = 0;
                        object2.setLayoutParams((ViewGroup.LayoutParams)object);
                        object2.requestLayout();
                    }
                } else if (n != object.bottomMargin) {
                    object.bottomMargin = n;
                    MarginLayoutParamsCompat.setMarginEnd((ViewGroup.MarginLayoutParams)object, (int)0);
                    object2.setLayoutParams((ViewGroup.LayoutParams)object);
                    object2.requestLayout();
                }
            }
            object2 = this.tab;
            object = var4_4;
            if (object2 != null) {
                object = ((Tab)object2).contentDesc;
            }
            if (Build.VERSION.SDK_INT < 21 || Build.VERSION.SDK_INT > 23) {
                if (!bl) {
                    object3 = object;
                }
                TooltipCompat.setTooltipText((View)this, (CharSequence)object3);
            }
        }

        protected void drawableStateChanged() {
            boolean bl;
            super.drawableStateChanged();
            int[] nArray = this.getDrawableState();
            Drawable drawable2 = this.baseBackgroundDrawable;
            boolean bl2 = bl = false;
            if (drawable2 != null) {
                bl2 = bl;
                if (drawable2.isStateful()) {
                    bl2 = false | this.baseBackgroundDrawable.setState(nArray);
                }
            }
            if (bl2) {
                this.invalidate();
                TabLayout.this.invalidate();
            }
        }

        int getContentHeight() {
            TextView textView = this.textView;
            ImageView imageView = this.iconView;
            View view = this.customView;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < 3; ++i) {
                View view2 = (new View[]{textView, imageView, view})[i];
                int n4 = n;
                int n5 = n2;
                int n6 = n3;
                if (view2 != null) {
                    n4 = n;
                    n5 = n2;
                    n6 = n3;
                    if (view2.getVisibility() == 0) {
                        n2 = n3 != 0 ? Math.min(n2, view2.getTop()) : view2.getTop();
                        n3 = n3 != 0 ? Math.max(n, view2.getBottom()) : view2.getBottom();
                        n6 = 1;
                        n5 = n2;
                        n4 = n3;
                    }
                }
                n = n4;
                n2 = n5;
                n3 = n6;
            }
            return n - n2;
        }

        int getContentWidth() {
            TextView textView = this.textView;
            ImageView imageView = this.iconView;
            View view = this.customView;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < 3; ++i) {
                View view2 = (new View[]{textView, imageView, view})[i];
                int n4 = n;
                int n5 = n2;
                int n6 = n3;
                if (view2 != null) {
                    n4 = n;
                    n5 = n2;
                    n6 = n3;
                    if (view2.getVisibility() == 0) {
                        n2 = n3 != 0 ? Math.min(n2, view2.getLeft()) : view2.getLeft();
                        n3 = n3 != 0 ? Math.max(n, view2.getRight()) : view2.getRight();
                        n6 = 1;
                        n5 = n2;
                        n4 = n3;
                    }
                }
                n = n4;
                n2 = n5;
                n3 = n6;
            }
            return n - n2;
        }

        public Tab getTab() {
            return this.tab;
        }

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
            Object object = this.badgeDrawable;
            if (object != null && object.isVisible()) {
                object = this.getContentDescription();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(object);
                stringBuilder.append(", ");
                stringBuilder.append((Object)this.badgeDrawable.getContentDescription());
                accessibilityNodeInfo.setContentDescription((CharSequence)stringBuilder.toString());
            }
            accessibilityNodeInfo = AccessibilityNodeInfoCompat.wrap((AccessibilityNodeInfo)accessibilityNodeInfo);
            accessibilityNodeInfo.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)0, (int)1, (int)this.tab.getPosition(), (int)1, (boolean)false, (boolean)this.isSelected()));
            if (this.isSelected()) {
                accessibilityNodeInfo.setClickable(false);
                accessibilityNodeInfo.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
            }
            accessibilityNodeInfo.setRoleDescription((CharSequence)this.getResources().getString(R.string.item_view_role_description));
        }

        public void onMeasure(int n, int n2) {
            block13: {
                float f;
                int n3;
                int n4;
                block14: {
                    block15: {
                        int n5;
                        int n6;
                        block11: {
                            block12: {
                                n4 = View.MeasureSpec.getSize((int)n);
                                n6 = View.MeasureSpec.getMode((int)n);
                                n5 = TabLayout.this.getTabMaxWidth();
                                n3 = n;
                                if (n5 <= 0) break block11;
                                if (n6 == 0) break block12;
                                n3 = n;
                                if (n4 <= n5) break block11;
                            }
                            n3 = View.MeasureSpec.makeMeasureSpec((int)TabLayout.this.tabMaxWidth, (int)Integer.MIN_VALUE);
                        }
                        super.onMeasure(n3, n2);
                        if (this.textView == null) break block13;
                        float f2 = TabLayout.this.tabTextSize;
                        n4 = this.defaultMaxLines;
                        ImageView imageView = this.iconView;
                        n6 = 1;
                        if (imageView != null && imageView.getVisibility() == 0) {
                            n = 1;
                            f = f2;
                        } else {
                            imageView = this.textView;
                            f = f2;
                            n = n4;
                            if (imageView != null) {
                                f = f2;
                                n = n4;
                                if (imageView.getLineCount() > 1) {
                                    f = TabLayout.this.tabTextMultiLineSize;
                                    n = n4;
                                }
                            }
                        }
                        f2 = this.textView.getTextSize();
                        n5 = this.textView.getLineCount();
                        n4 = TextViewCompat.getMaxLines((TextView)this.textView);
                        float f3 = f == f2 ? 0 : (f > f2 ? 1 : -1);
                        if (f3 == false && (n4 < 0 || n == n4)) break block13;
                        n4 = n6;
                        if (TabLayout.this.mode != 1) break block14;
                        n4 = n6;
                        if (f3 <= 0) break block14;
                        n4 = n6;
                        if (n5 != 1) break block14;
                        imageView = this.textView.getLayout();
                        if (imageView == null) break block15;
                        n4 = n6;
                        if (!(this.approximateLineWidth((Layout)imageView, 0, f) > (float)(this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight()))) break block14;
                    }
                    n4 = 0;
                }
                if (n4 != 0) {
                    this.textView.setTextSize(0, f);
                    this.textView.setMaxLines(n);
                    super.onMeasure(n3, n2);
                }
            }
        }

        public boolean performClick() {
            boolean bl;
            boolean bl2 = bl = super.performClick();
            if (this.tab != null) {
                if (!bl) {
                    this.playSoundEffect(0);
                }
                this.tab.select();
                bl2 = true;
            }
            return bl2;
        }

        void reset() {
            this.setTab(null);
            this.setSelected(false);
        }

        public void setSelected(boolean bl) {
            TextView textView;
            boolean bl2 = this.isSelected() != bl;
            super.setSelected(bl);
            if (bl2 && bl && Build.VERSION.SDK_INT < 16) {
                this.sendAccessibilityEvent(4);
            }
            if ((textView = this.textView) != null) {
                textView.setSelected(bl);
            }
            if ((textView = this.iconView) != null) {
                textView.setSelected(bl);
            }
            if ((textView = this.customView) != null) {
                textView.setSelected(bl);
            }
        }

        void setTab(Tab tab) {
            if (tab != this.tab) {
                this.tab = tab;
                this.update();
            }
        }

        final void update() {
            Tab tab = this.tab;
            View view = tab != null ? tab.getCustomView() : null;
            if (view != null) {
                ViewParent viewParent = view.getParent();
                if (viewParent != this) {
                    if (viewParent != null) {
                        ((ViewGroup)viewParent).removeView(view);
                    }
                    this.addView(view);
                }
                this.customView = view;
                viewParent = this.textView;
                if (viewParent != null) {
                    viewParent.setVisibility(8);
                }
                if ((viewParent = this.iconView) != null) {
                    viewParent.setVisibility(8);
                    this.iconView.setImageDrawable(null);
                }
                viewParent = (TextView)view.findViewById(16908308);
                this.customTextView = viewParent;
                if (viewParent != null) {
                    this.defaultMaxLines = TextViewCompat.getMaxLines((TextView)viewParent);
                }
                this.customIconView = (ImageView)view.findViewById(16908294);
            } else {
                view = this.customView;
                if (view != null) {
                    this.removeView(view);
                    this.customView = null;
                }
                this.customTextView = null;
                this.customIconView = null;
            }
            if (this.customView == null) {
                if (this.iconView == null) {
                    this.inflateAndAddDefaultIconView();
                }
                if (this.textView == null) {
                    this.inflateAndAddDefaultTextView();
                    this.defaultMaxLines = TextViewCompat.getMaxLines((TextView)this.textView);
                }
                TextViewCompat.setTextAppearance((TextView)this.textView, (int)TabLayout.this.tabTextAppearance);
                if (TabLayout.this.tabTextColors != null) {
                    this.textView.setTextColor(TabLayout.this.tabTextColors);
                }
                this.updateTextAndIcon(this.textView, this.iconView);
                this.tryUpdateBadgeAnchor();
                this.addOnLayoutChangeListener((View)this.iconView);
                this.addOnLayoutChangeListener((View)this.textView);
            } else {
                view = this.customTextView;
                if (view != null || this.customIconView != null) {
                    this.updateTextAndIcon((TextView)view, this.customIconView);
                }
            }
            if (tab != null && !TextUtils.isEmpty((CharSequence)tab.contentDesc)) {
                this.setContentDescription(tab.contentDesc);
            }
            boolean bl = tab != null && tab.isSelected();
            this.setSelected(bl);
        }

        final void updateOrientation() {
            this.setOrientation(TabLayout.this.inlineLabel ^ 1);
            TextView textView = this.customTextView;
            if (textView == null && this.customIconView == null) {
                this.updateTextAndIcon(this.textView, this.iconView);
            } else {
                this.updateTextAndIcon(textView, this.customIconView);
            }
        }
    }

    public static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager viewPager;

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.viewPager = viewPager;
        }

        @Override
        public void onTabReselected(Tab tab) {
        }

        @Override
        public void onTabSelected(Tab tab) {
            this.viewPager.setCurrentItem(tab.getPosition());
        }

        @Override
        public void onTabUnselected(Tab tab) {
        }
    }
}

