/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.textfield.EndIconDelegate;
import com.google.android.material.textfield.TextInputLayout;

class ClearTextEndIconDelegate
extends EndIconDelegate {
    private static final int ANIMATION_FADE_DURATION = 100;
    private static final int ANIMATION_SCALE_DURATION = 150;
    private static final float ANIMATION_SCALE_FROM_VALUE = 0.8f;
    private final TextWatcher clearTextEndIconTextWatcher = new TextWatcher(){

        public void afterTextChanged(Editable object) {
            if (ClearTextEndIconDelegate.this.textInputLayout.getSuffixText() != null) {
                return;
            }
            object = ClearTextEndIconDelegate.this;
            ((ClearTextEndIconDelegate)object).animateIcon(((ClearTextEndIconDelegate)object).shouldBeVisible());
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    };
    private final TextInputLayout.OnEditTextAttachedListener clearTextOnEditTextAttachedListener;
    private final TextInputLayout.OnEndIconChangedListener endIconChangedListener;
    private AnimatorSet iconInAnim;
    private ValueAnimator iconOutAnim;
    private final View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

        public void onFocusChange(View object, boolean bl) {
            object = ClearTextEndIconDelegate.this;
            ((ClearTextEndIconDelegate)object).animateIcon(((ClearTextEndIconDelegate)object).shouldBeVisible());
        }
    };

    ClearTextEndIconDelegate(TextInputLayout textInputLayout, int n) {
        super(textInputLayout, n);
        this.clearTextOnEditTextAttachedListener = new TextInputLayout.OnEditTextAttachedListener(){

            @Override
            public void onEditTextAttached(TextInputLayout textInputLayout) {
                EditText editText = textInputLayout.getEditText();
                textInputLayout.setEndIconVisible(ClearTextEndIconDelegate.this.shouldBeVisible());
                textInputLayout.setEndIconCheckable(false);
                editText.setOnFocusChangeListener(ClearTextEndIconDelegate.this.onFocusChangeListener);
                ClearTextEndIconDelegate.this.endIconView.setOnFocusChangeListener(ClearTextEndIconDelegate.this.onFocusChangeListener);
                editText.removeTextChangedListener(ClearTextEndIconDelegate.this.clearTextEndIconTextWatcher);
                editText.addTextChangedListener(ClearTextEndIconDelegate.this.clearTextEndIconTextWatcher);
            }
        };
        this.endIconChangedListener = new TextInputLayout.OnEndIconChangedListener(){

            @Override
            public void onEndIconChanged(TextInputLayout textInputLayout, int n) {
                if ((textInputLayout = textInputLayout.getEditText()) != null && n == 2) {
                    textInputLayout.post(new Runnable((EditText)textInputLayout){
                        final /* synthetic */ EditText val$editText;
                        {
                            this.val$editText = editText;
                        }

                        @Override
                        public void run() {
                            this.val$editText.removeTextChangedListener(ClearTextEndIconDelegate.this.clearTextEndIconTextWatcher);
                        }
                    });
                    if (textInputLayout.getOnFocusChangeListener() == ClearTextEndIconDelegate.this.onFocusChangeListener) {
                        textInputLayout.setOnFocusChangeListener(null);
                    }
                    if (ClearTextEndIconDelegate.this.endIconView.getOnFocusChangeListener() == ClearTextEndIconDelegate.this.onFocusChangeListener) {
                        ClearTextEndIconDelegate.this.endIconView.setOnFocusChangeListener(null);
                    }
                }
            }
        };
    }

    private void animateIcon(boolean bl) {
        boolean bl2 = this.textInputLayout.isEndIconVisible() == bl;
        if (bl && !this.iconInAnim.isRunning()) {
            this.iconOutAnim.cancel();
            this.iconInAnim.start();
            if (bl2) {
                this.iconInAnim.end();
            }
        } else if (!bl) {
            this.iconInAnim.cancel();
            this.iconOutAnim.start();
            if (bl2) {
                this.iconOutAnim.end();
            }
        }
    }

    private ValueAnimator getAlphaAnimator(float ... object) {
        object = ValueAnimator.ofFloat((float[])object);
        object.setInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        object.setDuration(100L);
        object.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ClearTextEndIconDelegate.this.endIconView.setAlpha(f);
            }
        });
        return object;
    }

    private ValueAnimator getScaleAnimator() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.8f, 1.0f});
        valueAnimator.setInterpolator(AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
        valueAnimator.setDuration(150L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                ClearTextEndIconDelegate.this.endIconView.setScaleX(f);
                ClearTextEndIconDelegate.this.endIconView.setScaleY(f);
            }
        });
        return valueAnimator;
    }

    private void initAnimators() {
        AnimatorSet animatorSet;
        ValueAnimator valueAnimator = this.getScaleAnimator();
        ValueAnimator valueAnimator2 = this.getAlphaAnimator(0.0f, 1.0f);
        this.iconInAnim = animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{valueAnimator, valueAnimator2});
        this.iconInAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator2) {
                ClearTextEndIconDelegate.this.textInputLayout.setEndIconVisible(true);
            }
        });
        this.iconOutAnim = valueAnimator = this.getAlphaAnimator(1.0f, 0.0f);
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                ClearTextEndIconDelegate.this.textInputLayout.setEndIconVisible(false);
            }
        });
    }

    private boolean shouldBeVisible() {
        EditText editText = this.textInputLayout.getEditText();
        boolean bl = editText != null && (editText.hasFocus() || this.endIconView.hasFocus()) && editText.getText().length() > 0;
        return bl;
    }

    @Override
    void initialize() {
        TextInputLayout textInputLayout = this.textInputLayout;
        int n = this.customEndIcon == 0 ? R.drawable.mtrl_ic_cancel : this.customEndIcon;
        textInputLayout.setEndIconDrawable(n);
        this.textInputLayout.setEndIconContentDescription(this.textInputLayout.getResources().getText(R.string.clear_text_end_icon_content_description));
        this.textInputLayout.setEndIconOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                view = ClearTextEndIconDelegate.this.textInputLayout.getEditText().getText();
                if (view != null) {
                    view.clear();
                }
                ClearTextEndIconDelegate.this.textInputLayout.refreshEndIconDrawableState();
            }
        });
        this.textInputLayout.addOnEditTextAttachedListener(this.clearTextOnEditTextAttachedListener);
        this.textInputLayout.addOnEndIconChangedListener(this.endIconChangedListener);
        this.initAnimators();
    }

    @Override
    void onSuffixVisibilityChanged(boolean bl) {
        if (this.textInputLayout.getSuffixText() == null) {
            return;
        }
        this.animateIcon(bl);
    }
}

